/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.Manager;
import hec.io.AsciiSerializable;
import hec.io.AsciiSerializerFormatter;
import hec.lang.NamedType;
import hec.map.MapGlyph;
import hec.map.MapObjectInterface;
import hec.map.MapPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTableSorter;
import rma.swing.SerializerEditDlg;
import rma.swing.table.RmaTableModelInterface;

public class MapInfoDialog
extends RmaJDialog {
    private RmaJTable _managerInfoTable;
    private RmaJTable _backgroundManagerInfoTable;
    private MapPanel _mapPanel;

    public MapInfoDialog(Frame parent, MapPanel mapPanel) {
        super(parent, false);
        this._mapPanel = mapPanel;
        this.buildControls();
        this.fillForm();
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this._managerInfoTable = new RmaJTable((Component)((Object)this), new String[]{"Name", "Description", "Path", "Type", "Index", "Modified Time", "Modified", "HashCode"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 200;
                d.width = ClientApp.frame().getWidth() - 70;
                return d;
            }
        };
        RmaJTableSorter sorter = new RmaJTableSorter((RmaTableModelInterface)this._managerInfoTable.getModel());
        this._managerInfoTable.setModel((TableModel)sorter);
        sorter.addMouseListenerToHeaderInTable((JTable)this._managerInfoTable);
        this._managerInfoTable.setEditable(false);
        this._managerInfoTable.setHorizontalAlignment(4, 4);
        this._managerInfoTable.setHorizontalAlignment(4, 7);
        this._managerInfoTable.setAutoResizeMode(0);
        this._managerInfoTable.setColumnWidths(new int[]{150, 150, 200, 200, 50, 150, 50, 50});
        this._managerInfoTable.setCellSelectionEnabled(false);
        this._managerInfoTable.setColumnSelectionAllowed(false);
        this._managerInfoTable.setRowSelectionAllowed(true);
        this._managerInfoTable.setCheckBoxCellEditor(6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 2.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._managerInfoTable.getScrollPane(), gbc);
        this._backgroundManagerInfoTable = new RmaJTable((Component)((Object)this), new String[]{"Name", "Description", "Path", "Type", "Index", "Modified Time", "Modified", "HashCode"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                d.width = ClientApp.frame().getWidth() - 70;
                return d;
            }
        };
        sorter = new RmaJTableSorter((RmaTableModelInterface)this._backgroundManagerInfoTable.getModel());
        this._backgroundManagerInfoTable.setModel((TableModel)sorter);
        sorter.addMouseListenerToHeaderInTable((JTable)this._backgroundManagerInfoTable);
        this._backgroundManagerInfoTable.setEditable(false);
        this._backgroundManagerInfoTable.setHorizontalAlignment(4, 4);
        this._backgroundManagerInfoTable.setHorizontalAlignment(4, 7);
        this._backgroundManagerInfoTable.setAutoResizeMode(0);
        this._backgroundManagerInfoTable.setColumnWidths(new int[]{150, 150, 200, 200, 50, 150, 50, 50});
        this._backgroundManagerInfoTable.setCellSelectionEnabled(false);
        this._backgroundManagerInfoTable.setColumnSelectionAllowed(false);
        this._backgroundManagerInfoTable.setRowSelectionAllowed(true);
        this._backgroundManagerInfoTable.setCheckBoxCellEditor(6);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._backgroundManagerInfoTable.getScrollPane(), gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)panel, gbc);
        JButton closeButton = new JButton("Close");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 14;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)closeButton, gbc);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapInfoDialog.this.setVisible(false);
                MapInfoDialog.this.dispose();
            }
        });
        this._managerInfoTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block8: {
                    block7: {
                        if (e.getClickCount() != 1) break block7;
                        int[] rows = MapInfoDialog.this._managerInfoTable.getSelectedRows();
                        if (rows == null || rows.length == 0) {
                            return;
                        }
                        for (int i = 0; i < rows.length; ++i) {
                            if (!"true".equalsIgnoreCase(MapInfoDialog.this._managerInfoTable.getValueAt(rows[i], 7).toString())) continue;
                            return;
                        }
                        break block8;
                    }
                    if (e.getClickCount() != 2) break block8;
                    int row = MapInfoDialog.this._managerInfoTable.rowAtPoint(e.getPoint());
                    if (row == -1) {
                        return;
                    }
                    Manager mgr = (Manager)((Object)MapInfoDialog.this._managerInfoTable.getValueAt(row, 0));
                    if (mgr == null) {
                        JOptionPane.showMessageDialog((Component)((Object)MapInfoDialog.this), "This ManagerProxy's manager hasn't been instantiated.");
                        return;
                    }
                    if (mgr instanceof AsciiSerializable) {
                        try {
                            StringWriter strWriter = new StringWriter();
                            BufferedWriter buffWriter = new BufferedWriter(strWriter);
                            HecAsciiSerializer serializer = new HecAsciiSerializer(buffWriter);
                            serializer.serializeObject((Object)mgr);
                            buffWriter.flush();
                            SerializerEditDlg chooserDialog = new SerializerEditDlg((Dialog)((Object)MapInfoDialog.this), "Serialized Object " + mgr.getName(), false);
                            AsciiSerializerFormatter formatter = new AsciiSerializerFormatter();
                            String serObject = strWriter.getBuffer().toString();
                            String text = formatter.format(serObject);
                            chooserDialog.setText(text);
                            chooserDialog.setEditable(false);
                            chooserDialog.setVisible(true);
                        }
                        catch (IOException ioe) {
                            System.out.println("IOException: Error deserializing Manager " + ioe);
                        }
                    }
                }
            }
        });
        this.pack();
        this.setLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillForm() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int c;
            Vector childGlyphs;
            MapGlyph glyph;
            int i;
            if (this._managerInfoTable.getRowCount() > 0) {
                this._managerInfoTable.deleteCells();
            }
            if (this._backgroundManagerInfoTable.getRowCount() > 0) {
                this._backgroundManagerInfoTable.deleteCells();
            }
            if (this._mapPanel == null) {
                return;
            }
            List list = this._mapPanel.managerGlyphList();
            for (i = 0; i < list.size(); ++i) {
                glyph = (MapGlyph)list.get(i);
                this.addGlyph(glyph, this._managerInfoTable);
                childGlyphs = glyph.glyphVector();
                if (!glyph.hasChildGlyphs()) continue;
                for (c = 0; c < childGlyphs.size(); ++c) {
                    glyph = (MapGlyph)childGlyphs.get(c);
                    this.addGlyph(glyph, this._managerInfoTable);
                }
            }
            list = this._mapPanel.backGroundGlyphList();
            this._backgroundManagerInfoTable.getScrollPane().setVisible(list != null && list.size() > 0);
            for (i = 0; i < list.size(); ++i) {
                glyph = (MapGlyph)list.get(i);
                this.addGlyph(glyph, this._backgroundManagerInfoTable);
                childGlyphs = glyph.glyphVector();
                if (!glyph.hasChildGlyphs()) continue;
                for (c = 0; c < childGlyphs.size(); ++c) {
                    glyph = (MapGlyph)childGlyphs.get(c);
                    this.addGlyph(glyph, this._backgroundManagerInfoTable);
                }
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void addGlyph(MapGlyph glyph, RmaJTable table) {
        if (glyph == null) {
            return;
        }
        Date dt = new Date();
        MapObjectInterface mapObject = glyph.getMap();
        Vector<Object> row = new Vector<Object>(6);
        row.add(mapObject);
        if (mapObject instanceof Manager) {
            Manager manager = (Manager)mapObject;
            row.add(manager.getDescription());
            row.add(manager.getIdentifier().getPath());
            row.add(mapObject.getClass().getName());
            row.add(new Integer(manager.getIndex()));
            dt.setTime(manager.getLastModifiedTime());
            row.add(dt.toString().substring(4));
            row.add(String.valueOf(manager.isModified()));
        } else {
            NamedType nt = null;
            if (mapObject instanceof NamedType) {
                nt = (NamedType)mapObject;
                row.add(nt.getDescription());
            }
            row.add(mapObject.getMapIdentifier().getPath());
            row.add(mapObject.getClass().getName());
            if (nt == null) {
                row.add("");
                row.add("Unknown");
                row.add("");
            } else {
                row.add(String.valueOf(nt.getIndex()));
                row.add("Unknown");
                row.add(String.valueOf(nt.isModified()));
            }
        }
        row.add(String.valueOf(mapObject.hashCode()));
        table.appendRow(row);
    }

    public void setVisible(boolean b) {
        if (!b) {
            this._managerInfoTable.deleteCells();
        }
        super.setVisible(b);
    }

    class TableMouseListener
    extends MouseAdapter {
        private RmaJTable _table;

        TableMouseListener(RmaJTable table) {
            this._table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            block8: {
                block7: {
                    if (e.getClickCount() != 1) break block7;
                    int[] rows = this._table.getSelectedRows();
                    if (rows == null || rows.length == 0) {
                        return;
                    }
                    for (int i = 0; i < rows.length; ++i) {
                        if (!"true".equalsIgnoreCase(this._table.getValueAt(rows[i], 7).toString())) continue;
                        return;
                    }
                    break block8;
                }
                if (e.getClickCount() != 2) break block8;
                int row = this._table.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return;
                }
                Manager mgr = (Manager)((Object)this._table.getValueAt(row, 0));
                if (mgr == null) {
                    JOptionPane.showMessageDialog((Component)((Object)MapInfoDialog.this), "This ManagerProxy's manager hasn't been instantiated.");
                    return;
                }
                if (mgr instanceof AsciiSerializable) {
                    try {
                        StringWriter strWriter = new StringWriter();
                        BufferedWriter buffWriter = new BufferedWriter(strWriter);
                        HecAsciiSerializer serializer = new HecAsciiSerializer(buffWriter);
                        serializer.serializeObject((Object)mgr);
                        buffWriter.flush();
                        SerializerEditDlg chooserDialog = new SerializerEditDlg((Dialog)((Object)MapInfoDialog.this), "Serialized Object " + mgr.getName(), false);
                        AsciiSerializerFormatter formatter = new AsciiSerializerFormatter();
                        String serObject = strWriter.getBuffer().toString();
                        String text = formatter.format(serObject);
                        chooserDialog.setText(text);
                        chooserDialog.setEditable(false);
                        chooserDialog.setVisible(true);
                    }
                    catch (IOException ioe) {
                        System.out.println("IOException: Error deserializing Manager " + ioe);
                    }
                }
            }
        }
    }
}

