/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.client.PanelEditor;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ShortcutsAccessory;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.gui.AbstractEditorPanel;
import hec.gui.NameDescriptionPanel;
import hec.gui.TimeZonePanel;
import hec.io.Identifier;
import hec.lang.NamedType;
import hec.model.WatershedLocation;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.Document;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJDialog;
import rma.swing.list.RmaListModel;
import rma.swing.text.DssPathnamePartDocument;
import rma.util.RMAIO;

public class NewWorkspaceDlg
extends RmaJDialog {
    static final String DEFAULT_TZ_BUTTON_TEXT = "Time Zones...";
    String[] timeZones = null;
    int[] gmtOffsets = new int[]{-9, -8, -7, -6, -5, -4, 0};
    NameDescriptionPanel nameDescPanel;
    JLabel unitsLabel;
    JLabel timeZoneLabel;
    JLabel _locationsLabel;
    JRadioButton englishRadio;
    JRadioButton siRadio;
    TimeZoneButton timeZoneButton;
    RmaJComboBox _availableLocations;
    ButtonCmdPanel cmdPanel;
    boolean fComponentsAdjusted = false;
    private boolean _controlsCreated = false;
    private boolean _canceled = false;
    PanelEditor _timeZoneEditor;
    private JPanel _accessoriesPanel;
    private JButton _selectLocationBtn;
    private List<DefaultJPanel> _accPanels = new ArrayList<DefaultJPanel>();

    public NewWorkspaceDlg(Frame parent, boolean modal) {
        super(parent, modal);
        this.setTitle("New Workspace");
        this.createControls();
    }

    public NewWorkspaceDlg(Dialog parent, boolean modal) {
        super(parent, modal);
        this.setTitle("New Workspace");
        this.createControls();
    }

    public NewWorkspaceDlg(Dialog parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public NewWorkspaceDlg(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public NewWorkspaceDlg(Frame parent) {
        this(parent, false);
    }

    public NewWorkspaceDlg(Dialog parent) {
        this(parent, false);
    }

    public NewWorkspaceDlg(String title) {
        this();
        this.setTitle(title);
    }

    public NewWorkspaceDlg() {
        this((Frame)null);
    }

    public void setWatershedLocations(Vector locations) {
        if (this._availableLocations != null) {
            ((RmaListModel)this._availableLocations.getModel()).clear();
            if (locations != null) {
                ((RmaListModel)this._availableLocations.getModel()).addAll((Collection)locations);
                if (this._availableLocations.getItemCount() > 0) {
                    this._availableLocations.setSelectedIndex(0);
                }
            }
        }
    }

    public int getUnitSystemId() {
        if (this.englishRadio.isSelected()) {
            return 1;
        }
        return 2;
    }

    public int getGmtOffset() {
        return this.timeZoneButton.getTimeZoneOffset();
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public String getDescription() {
        return this.nameDescPanel.getDescription();
    }

    public String getName() {
        return this.nameDescPanel.getName();
    }

    public String getWatershedLocation() {
        if (this._availableLocations != null) {
            Object obj = this._availableLocations.getSelectedItem();
            if (obj instanceof WatershedLocation) {
                String dir = ((WatershedLocation)obj).getDirectory();
                while (dir.endsWith("/")) {
                    dir = dir.substring(0, dir.length() - 1);
                }
                return dir;
            }
        } else {
            return this._selectLocationBtn.getName();
        }
        return null;
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    protected void createControls() {
        if (this._controlsCreated) {
            return;
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.nameDescPanel = new NameDescriptionPanel();
        this.getContentPane().add((Component)this.nameDescPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)0, (int)5, (int)0, (int)5), 0, 0));
        this.nameDescPanel.setNameDocument((Document)new DssPathnamePartDocument());
        this.timeZones = new String[]{"(GMT -09:00) Alaska", "(GMT -08:00) Pacific Time", "(GMT -07:00) Mountain Time", "(GMT -06:00) Central Time", "(GMT -05:00) Eastern Time", "(GMT -04:00) Atlantic Time", "(GMT -00:00) Greenwich Mean Time"};
        this.unitsLabel = new JLabel("Units:");
        this.siRadio = new JRadioButton("SI");
        this.englishRadio = new JRadioButton("English");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.siRadio);
        bg.add(this.englishRadio);
        this.timeZoneLabel = new JLabel("          ");
        this.timeZoneButton = new TimeZoneButton();
        this.timeZoneLabel.setLabelFor(this.timeZoneButton);
        this._locationsLabel = new JLabel("Location:");
        this.getContentPane().add((Component)this._locationsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)10, (int)0, (int)0), 0, 0));
        if (Boolean.getBoolean("NO_PREDEFINED_WKSP")) {
            this._selectLocationBtn = new JButton("Select Location");
            this._selectLocationBtn.setMnemonic('S');
            this.getContentPane().add((Component)this._selectLocationBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)10, (int)0, (int)10), 0, 0));
        } else {
            this._availableLocations = new RmaJComboBox((ComboBoxModel)new RmaListModel(true)){

                public String getToolTipText() {
                    Object obj = this.getSelectedItem();
                    if (obj instanceof WatershedLocation) {
                        return ((WatershedLocation)obj).getDirectory();
                    }
                    return null;
                }
            };
            this._availableLocations.setToolTipText("");
            this.getContentPane().add((Component)this._availableLocations, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)10, (int)0, (int)10), 0, 0));
            this._locationsLabel.setLabelFor((Component)this._availableLocations);
        }
        this.getContentPane().add((Component)this.unitsLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)5, (int)10, (int)0, (int)0), 0, 0));
        JPanel unitsRadioButtons = new JPanel(new GridBagLayout());
        this.englishRadio.setMargin(RmaInsets.INSETS0000);
        this.siRadio.setMargin(RmaInsets.INSETS0000);
        unitsRadioButtons.add((Component)this.englishRadio, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, RmaInsets.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        unitsRadioButtons.add((Component)this.siRadio, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, RmaInsets.insets((int)5, (int)5, (int)0, (int)5), 0, 0));
        this.getContentPane().add((Component)unitsRadioButtons, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 0, 0));
        this.getContentPane().add((Component)this.timeZoneLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, RmaInsets.insets((int)5, (int)5, (int)0, (int)0), 35, 0));
        this.getContentPane().add((Component)this.timeZoneButton, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, RmaInsets.insets((int)5, (int)8, (int)0, (int)10), 0, 0));
        this._controlsCreated = true;
        this._accessoriesPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)this._accessoriesPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 16, 2, RmaInsets.insets((int)0, (int)0, (int)0, (int)0), 0, 0));
        this.cmdPanel = new ButtonCmdPanel(12);
        this.getContentPane().add((Component)this.cmdPanel, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 16, 2, RmaInsets.insets((int)5, (int)5, (int)10, (int)10), 0, 0));
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        if (!NewWorkspaceDlg.this.isValidForm()) break;
                        NewWorkspaceDlg.this._canceled = false;
                        NewWorkspaceDlg.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        NewWorkspaceDlg.this._canceled = true;
                        NewWorkspaceDlg.this.setVisible(false);
                    }
                }
            }
        });
        this._locationsLabel.setDisplayedMnemonic('L');
        this.unitsLabel.setLabelFor(this.englishRadio);
        this.unitsLabel.setDisplayedMnemonic('U');
        this.timeZoneLabel.setLabelFor(this.timeZoneButton);
        this.timeZoneLabel.setDisplayedMnemonic('T');
        this.pack();
        Dimension d = this.getPreferredSize();
        if (d.width < 400) {
            d.width = 400;
        }
        this.setDefaultSize(d.width, d.height);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewWorkspaceDlg.this._canceled = true;
            }
        });
        this.timeZoneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewWorkspaceDlg.this.selectTimeZone();
            }
        });
        if (this._selectLocationBtn != null) {
            this._selectLocationBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewWorkspaceDlg.this.selectWatershedDirectory();
                }
            });
        }
    }

    protected void selectWatershedDirectory() {
        JFileChooser chooser = new JFileChooser();
        FileSystemView fsv = FileSystemView.getFileSystemView();
        ShortcutsAccessory shortcuts = new ShortcutsAccessory(chooser, "demo");
        chooser.setAccessory(shortcuts);
        chooser.setCurrentDirectory(ClientApp.app().getDefaultWatershedFolder());
        shortcuts.setFileShortcutAllowed(false);
        Object path = this._selectLocationBtn.getName();
        if (!"Select Location".equals(path)) {
            path = (String)path + "/x";
            chooser.setSelectedFile(new File((String)path));
        }
        Dimension d = new Dimension(600, 400);
        chooser.setMinimumSize(d);
        chooser.setPreferredSize(d);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select Watershed Folder");
        int opt = chooser.showOpenDialog((Component)((Object)ClientApp.frame()));
        if (opt == 0) {
            File wkspFile = chooser.getSelectedFile();
            int width = this._selectLocationBtn.getWidth();
            Font f = this._selectLocationBtn.getFont();
            FontMetrics fm = this._selectLocationBtn.getFontMetrics(f);
            Object str = "WWWWWWWW";
            int maxWidth = 50;
            path = wkspFile.getAbsolutePath().replace('\\', "/".charAt(0));
            if (fm.stringWidth((String)path) > width - 5) {
                for (int i = 0; i < 100; ++i) {
                    if (fm.stringWidth((String)str) > width - 5) {
                        maxWidth = ((String)str).length();
                        break;
                    }
                    str = (String)str + "W";
                }
                this._selectLocationBtn.setText(RMAIO.getShortenedPathname((String)path, (int)maxWidth));
            } else {
                this._selectLocationBtn.setText((String)path);
            }
            this._selectLocationBtn.setMnemonic(-1);
            this._selectLocationBtn.setName((String)path);
            this._selectLocationBtn.setToolTipText((String)path);
        }
    }

    void NewWorkspaceDlg_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    private boolean isValidForm() {
        Object c = null;
        String msg = null;
        if (this.nameDescPanel.getName().length() == 0) {
            msg = "Please enter a Watershed name";
            c = this.nameDescPanel;
        } else if (!this.englishRadio.isSelected() && !this.siRadio.isSelected()) {
            msg = "Please select the Watershed Units";
            c = this.englishRadio;
        } else if (this.timeZoneButton.getText().equals(DEFAULT_TZ_BUTTON_TEXT)) {
            msg = "Please select the Watershed Timezone";
            c = this.timeZoneButton;
        } else if (this._availableLocations != null) {
            if (this._availableLocations.getSelectedItem() == null) {
                msg = "Please select a Watershed location";
                c = this._availableLocations;
            }
        } else if ("Select Location".equals(this._selectLocationBtn.getText())) {
            msg = "Please select the Watershed's Location";
            c = this._selectLocationBtn;
        }
        if (c != null) {
            c.requestFocus();
        }
        if (msg != null) {
            JOptionPane.showMessageDialog((Component)((Object)this), msg, "Incomplete Information", 1);
            return false;
        }
        RmiApp rmiApp = ClientApp.app().getAppServer();
        if (rmiApp != null) {
            try {
                String dir = this.getWatershedLocation();
                String baseDir = ClientApp.app().getBaseWkspDirectory();
                if (baseDir != null) {
                    dir = dir.concat(baseDir);
                }
                Identifier id = new Identifier();
                id.setName(RMAIO.userNameToFileName((String)this.nameDescPanel.getName()));
                if (rmiApp.workspaceExists(id, dir)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Watershed '" + this.nameDescPanel.getName() + "' already exists at\n" + dir, "Watershed already Exists", 2);
                    return false;
                }
            }
            catch (RemoteException re) {
                System.out.println("RMI Error checking for existing workspace " + re);
            }
        }
        return true;
    }

    public boolean setDefaultTimeZone(TimeZone tz) {
        if (tz == null) {
            this.timeZoneButton.setTimeZone(null, -1);
        } else {
            int offset = tz.getRawOffset() / 3600000;
            this.timeZoneButton.setTimeZone(tz.toString(), offset);
        }
        return false;
    }

    public boolean setDefaultUnits(int units) {
        switch (units) {
            case 1: {
                this.englishRadio.setSelected(true);
                break;
            }
            case 2: {
                this.siRadio.setSelected(true);
                break;
            }
            default: {
                this.siRadio.setSelected(false);
                this.englishRadio.setSelected(false);
                return false;
            }
        }
        return true;
    }

    public void setUnitsComboBoxVisible(boolean b) {
        this.siRadio.setVisible(b);
        this.englishRadio.setVisible(b);
        this.unitsLabel.setVisible(b);
    }

    public void setTimeZoneComboBoxVisible(boolean b) {
        this.timeZoneButton.setVisible(b);
        this.timeZoneLabel.setVisible(b);
    }

    public void setVisible(boolean b) {
        if (b) {
            // empty if block
        }
        super.setVisible(b);
    }

    private void selectTimeZone() {
        if (this._timeZoneEditor == null) {
            this._timeZoneEditor = new PanelEditor((Dialog)((Object)this), false);
            TimeZonePanel tzp = new TimeZonePanel(){

                public boolean savePanel(NamedType nt) {
                    if (!super.savePanel(nt)) {
                        return false;
                    }
                    NewWorkspaceDlg.this.timeZoneButton.setTimeZone(this.timeZoneCombo.getSelectedItem().toString(), this.getHoursOffset());
                    return true;
                }
            };
            this._timeZoneEditor.setLocationRelativeTo((Component)ClientApp.frame().getMapPanel());
            this._timeZoneEditor.setTitle("Select a Time Zone");
            this._timeZoneEditor.addPanel((AbstractEditorPanel)tzp);
            this._timeZoneEditor.fillForm(null);
            this._timeZoneEditor.pack();
        }
        this._timeZoneEditor.setVisible(true);
    }

    public String getTimeZoneText() {
        return this.timeZoneButton.getText();
    }

    public void addAccessoryPanel(DefaultJPanel accessoryPanel) {
        if (accessoryPanel == null) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        this._accessoriesPanel.add((Component)accessoryPanel, gbc);
        this._accPanels.add(accessoryPanel);
        this.pack();
        Dimension d = this.getPreferredSize();
        if (d.width < 400) {
            d.width = 400;
        }
        this.setDefaultSize(d.width, d.height);
        this.pack();
    }

    class TimeZoneButton
    extends JButton {
        private int _timeZoneOffset;

        TimeZoneButton() {
            super(NewWorkspaceDlg.DEFAULT_TZ_BUTTON_TEXT);
            this._timeZoneOffset = -1;
        }

        void setTimeZone(String label, int offset) {
            this.setText(label);
            this._timeZoneOffset = offset;
            if (label == null || offset == -1) {
                this.setText(NewWorkspaceDlg.DEFAULT_TZ_BUTTON_TEXT);
                this._timeZoneOffset = -1;
            }
        }

        int getTimeZoneOffset() {
            return this._timeZoneOffset;
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == NewWorkspaceDlg.this) {
                NewWorkspaceDlg.this.NewWorkspaceDlg_WindowClosing(event);
            }
        }
    }
}

