/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.client.ObjectChooserTableModel;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.gui.NameDescriptionPanel;
import hec.io.Identifier;
import hec.lang.NamedType;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.util.RMAIO;
import rma.util.RMASort;

public class ObjectChooser
extends RmaJDialog
implements ButtonCmdPanelListener {
    boolean _ok = false;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static final int DELETE = 2;
    public static final int NEW = 3;
    public static final int OPEN = 4;
    public static final int SAVEAS = 5;
    public static final int RENAME = 6;
    public static final long USES_TABLE = 1L;
    public static final long UNIQUE_NAME = 4L;
    String _model;
    int _mode;
    ClientWorkspace _Workspace;
    String _className;
    String _typeName;
    String _extension = "dat";
    int _selection = -1;
    long _flags;
    protected NameDescriptionPanel _namePanel;
    ObjectChooserTableModel _idTableModel;
    RmaJTable _idTable;
    Vector _objectList;
    JLabel label1;
    JTextField textFieldSelectManager;
    JLabel labelWorkspace;
    JLabel labelType;
    JScrollPane _existingMangersScrollPane;
    ButtonCmdPanel panelButtons;

    public ObjectChooser(Frame parent, boolean modal, int mode, long flags) {
        super(parent, modal);
        this._mode = mode;
        this._flags = flags;
        this.buildDefaultComponents(2);
        this.setLocation();
    }

    public ObjectChooser(Dialog parent, boolean modal, int mode, long flags) {
        super(parent, modal);
        this._mode = mode;
        this._flags = flags;
        this.buildDefaultComponents(2);
        this.setLocation();
    }

    public ObjectChooser(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildDefaultComponents(1);
    }

    public ObjectChooser(Dialog parent, boolean modal) {
        super(parent, modal);
        this.buildDefaultComponents(1);
    }

    public void setObjectList(Vector list) {
        this._objectList = list;
        if (list == null) {
            return;
        }
        RMASort.quickSort((List)list);
        if (this._idTableModel != null) {
            this._idTableModel.setObjectList(list);
        }
    }

    void buildDefaultComponents(int mode) {
        this.setSize(this.getInsets().left + this.getInsets().right + 360, this.getInsets().top + this.getInsets().bottom + 318);
        this.setDefaultSize(this.getInsets().left + this.getInsets().right + 360, this.getInsets().top + this.getInsets().bottom + 318);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this._idTableModel = new ObjectChooserTableModel(null, mode);
        this._idTable = new RmaJTable(){

            public String getToolTipText(MouseEvent e) {
                int row = ObjectChooser.this._idTable.rowAtPoint(e.getPoint());
                if (row == -1) {
                    return null;
                }
                int column = ObjectChooser.this._idTable.columnAtPoint(e.getPoint());
                if (column == -1) {
                    return null;
                }
                Object id = ObjectChooser.this._idTableModel.getObjectAt(row);
                if (id == null) {
                    return null;
                }
                if (id instanceof NamedType) {
                    if (column == 0) {
                        return ((NamedType)id).getName();
                    }
                    if (column == 1) {
                        return ((NamedType)id).getDescription();
                    }
                } else {
                    return id.toString();
                }
                return null;
            }

            public Rectangle getCellRect(int row, int column, boolean includeSpacing) {
                return super.getCellRect(row, column, true);
            }
        };
        this._idTable.setModel((TableModel)this._idTableModel);
        this._idTable.setRowSelectionAllowed(true);
        this._idTable.setColumnSelectionAllowed(false);
        this._idTable.setSelectionMode(0);
        this._idTable.setPopupMenuEnabled(false);
        this._idTable.setShowGrid(false);
        this._idTable.setRowHeight(20);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 5, 0, 5);
        this._existingMangersScrollPane = this._idTable.getScrollPane();
        this._existingMangersScrollPane.setVerticalScrollBarPolicy(22);
        this._existingMangersScrollPane.setHorizontalScrollBarPolicy(30);
        this._existingMangersScrollPane.setBorder(BorderFactory.createTitledBorder(""));
        this.getContentPane().add((Component)this._existingMangersScrollPane, gbc);
        this.label1 = new JLabel("Watershed:");
        this.label1.setBounds(this.getInsets().left + 10, this.getInsets().top + 10, 76, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.label1, gbc);
        this.label1.setVisible(false);
        this.textFieldSelectManager = new JTextField();
        this.textFieldSelectManager.setBounds(this.getInsets().left + 10, this.getInsets().top + 252, 340, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.labelWorkspace = new JLabel("Watershed name");
        this.labelWorkspace.setBounds(this.getInsets().left + 91, this.getInsets().top + 10, 259, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.labelWorkspace, gbc);
        this.labelWorkspace.setVisible(false);
        this.labelType = new JLabel("manager type");
        this.labelType.setBounds(this.getInsets().left + 91, this.getInsets().top + 38, 259, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        long namepanelflags = this.getNamePanelFlags();
        this._namePanel = this.buildDescriptionPanel(namepanelflags);
        this._namePanel.setBorder(this.getNamePanelBorder(null));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this._namePanel, gbc);
        this.setTitle("ManagerChooser");
        SymText lSymText = new SymText();
        SymItem lSymItem = new SymItem();
        this._idTable.getSelectionModel().addListSelectionListener(lSymItem);
        this._idTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int row = ObjectChooser.this._idTable.getSelectedRow();
                if (event.getClickCount() == 2 && row > -1) {
                    switch (ObjectChooser.this._mode) {
                        case 6: {
                            ObjectChooser.this.panelButtons.doButtonClick(1024);
                            break;
                        }
                        case 1: 
                        case 5: {
                            ObjectChooser.this.panelButtons.doButtonClick(16);
                            break;
                        }
                        case 0: 
                        case 4: {
                            ObjectChooser.this.panelButtons.doButtonClick(32);
                            break;
                        }
                        case 2: {
                            ObjectChooser.this.panelButtons.doButtonClick(64);
                            break;
                        }
                        case 3: {
                            ObjectChooser.this.panelButtons.doButtonClick(8);
                        }
                    }
                } else if (row == -1) {
                    ObjectChooser.this._idTable.clearSelection();
                }
            }
        });
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this.setMode(this._mode);
        this.setResizable(false);
    }

    protected NameDescriptionPanel buildDescriptionPanel(long namepanelflags) {
        return new NameDescriptionPanel(namepanelflags);
    }

    protected long getNamePanelFlags() {
        return 1L;
    }

    public Border getNamePanelBorder(String typename) {
        String title = "";
        switch (this._mode) {
            case 4: {
                title = "Open";
                break;
            }
            case 0: {
                title = "Load";
                break;
            }
            case 1: {
                title = "Save";
                break;
            }
            case 2: {
                title = "Delete";
                break;
            }
            case 3: {
                title = "New";
                break;
            }
            case 5: {
                title = "Save As";
                break;
            }
            case 6: {
                title = "Rename";
            }
        }
        if (typename != null && typename.length() > 0) {
            title = title.concat(" ").concat(typename);
            return BorderFactory.createTitledBorder(title);
        }
        return BorderFactory.createTitledBorder(title);
    }

    public void buttonCmdActionPerformed(ActionEvent event) {
        switch (event.getID()) {
            case 32: {
                this.buttonOpen_Action(event);
                break;
            }
            case 16: {
                this.buttonOpen_Action(event);
                break;
            }
            case 64: {
                this.buttonOpen_Action(event);
                break;
            }
            case 512: {
                this.buttonNew_Action(event);
                break;
            }
            case 4: {
                this.buttonCancel_Action(event);
                break;
            }
            case 1024: {
                this.buttonOpen_Action(event);
            }
        }
    }

    void buttonOpen_Action(ActionEvent event) {
        this._ok = true;
        Object id = this._idTableModel.getObjectAt(this._selection);
        if (id == null && this._mode != 5 && this._mode != 6) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select an item.", "Warning", 2);
            return;
        }
        if (this._mode == 2) {
            if (this._selection < 0) {
                return;
            }
            int retValue = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)("Do you really want to delete\n" + this._namePanel.getName() + "?"));
            if (retValue == 2) {
                return;
            }
            this._ok = retValue != 1;
        } else if (this._mode == 5 || this._mode == 6) {
            Vector idList = this._objectList;
            String name = this._namePanel.getName();
            for (int i = 0; i < idList.size(); ++i) {
                Object obj = idList.elementAt(i);
                if (!(obj instanceof NamedType)) {
                    JOptionPane.showMessageDialog((Component)((Object)this), " Object cannot be renamed ", "Warning", 2);
                    return;
                }
                if (!((NamedType)obj).getName().equals(name)) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), "A " + this.labelType.getText() + " already exists with the name selected", "Warning", 2);
                return;
            }
        }
        this.setVisible(false);
    }

    void buttonNew_Action(ActionEvent event) {
        this._ok = true;
        String name = this._namePanel.getName();
        if (name == null || name.length() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a name.", "Warning", 2);
            return;
        }
        if (!this.nameIsUnique(name)) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a unique name.", "Warning", 2);
            return;
        }
        this.setVisible(false);
    }

    boolean nameIsUnique(String name) {
        if (this._idTableModel == null) {
            return true;
        }
        int rowcount = this._idTableModel.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            String str = (String)this._idTableModel.getValueAt(i, 0);
            if (!name.equalsIgnoreCase(str)) continue;
            return false;
        }
        return true;
    }

    void buttonCancel_Action(ActionEvent event) {
        this._ok = false;
        this.setVisible(false);
    }

    void textFieldSelectManager_TextValueChanged(TextEvent event) {
    }

    void idTable_ItemStateChanged() {
        if (this._idTable.getSelectionModel().getSelectionMode() == 0) {
            this._selection = this._idTable.getSelectedRow();
            if (this._selection >= 0) {
                Object obj = this._idTableModel.getObjectAt(this._selection);
                NamedType id = null;
                if (obj instanceof NamedType) {
                    id = (NamedType)obj;
                }
                if (id != null) {
                    this._namePanel.setName(id.getName());
                    if (id.getDescription().equalsIgnoreCase("description")) {
                        this._namePanel.setDescription("");
                    } else {
                        this._namePanel.setDescription(id.getDescription());
                    }
                } else {
                    this._namePanel.setName(obj.toString());
                    this._namePanel.setDescription("");
                }
            }
        } else {
            int[] rows = this._idTable.getSelectedRows();
            if (rows == null || rows.length == 0) {
                this._selection = -1;
            } else {
                this._selection = rows[0];
                String names = "";
                for (int i = 0; i < rows.length; ++i) {
                    Object obj = this._idTableModel.getObjectAt(this._selection);
                    NamedType id = null;
                    if (obj instanceof NamedType) {
                        id = (NamedType)obj;
                    }
                    if (id == null) continue;
                    names = names.concat(id.getName());
                    if (i >= rows.length - 1) continue;
                    names = names.concat(", ");
                }
                this._namePanel.setName(names);
            }
        }
        int button = -1;
        boolean enableButtons = this._selection != -1;
        switch (this._mode) {
            case 1: {
                button = 16;
                break;
            }
            case 0: {
                button = 32;
                break;
            }
            case 2: {
                button = 64;
            }
        }
        if (button != -1) {
            this.panelButtons.setButtonEnable(button, enableButtons);
        }
    }

    public boolean ok() {
        return this._ok;
    }

    public void setMode(int mode) {
        this._mode = mode;
        if (this.panelButtons != null) {
            this.getContentPane().remove((Component)this.panelButtons);
            this.panelButtons.removeCmdPanelListener((ButtonCmdPanelListener)this);
        }
        Border border = this.getNamePanelBorder(this._typeName);
        this._namePanel.setBorder(border);
        switch (this._mode) {
            case 6: {
                this._idTable.setIsEditable(false);
                this.panelButtons = new ButtonCmdPanel(1028);
                this.setOKButtonSearchString("Rename");
                this._namePanel.setPanelEditable(true);
                break;
            }
            case 5: {
                this._idTable.setIsEditable(false);
            }
            case 1: {
                this.panelButtons = new ButtonCmdPanel(20);
                this.setOKButtonSearchString("Save");
                this._namePanel.setPanelEditable(true);
                break;
            }
            case 0: 
            case 4: {
                this.panelButtons = new ButtonCmdPanel(36);
                this.setOKButtonSearchString("Open");
                this._namePanel.setPanelEditable(false);
                break;
            }
            case 2: {
                this.panelButtons = new ButtonCmdPanel(68);
                this.setOKButtonSearchString("Delete");
                this._namePanel.setPanelEditable(false);
                break;
            }
            case 3: {
                this.panelButtons = new ButtonCmdPanel(516);
                this.setOKButtonSearchString("New");
                this._namePanel.setPanelEditable(true);
            }
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.panelButtons, gbc);
        this.panelButtons.addCmdPanelListener((ButtonCmdPanelListener)this);
    }

    public void setMultipleSelectionsAllowed(boolean multiplesAllowed) {
        if (multiplesAllowed) {
            this._idTable.setSelectionMode(2);
        } else {
            this._idTable.setSelectionMode(0);
        }
    }

    public void setNamePanelBorderTitle(String title) {
        this._namePanel.setBorder((Border)BorderFactory.createTitledBorder(title));
    }

    public void setTypeName(String typename) {
        if (this._existingMangersScrollPane != null) {
            Object title = "Existing ";
            if (typename != null && typename.length() > 0) {
                title = (String)title + typename + "s";
                ((TitledBorder)this._existingMangersScrollPane.getBorder()).setTitle((String)title);
            }
        }
        if (this._namePanel != null) {
            this._namePanel.setBorder(this.getNamePanelBorder(typename));
        }
    }

    public void setTitleLabel(String labelstr) {
        if (this.label1 != null && labelstr != null) {
            this.label1.setText(labelstr);
            this.label1.setVisible(true);
        }
    }

    public String getName() {
        return this._namePanel.getName();
    }

    public String getDescription() {
        return this._namePanel.getDescription();
    }

    public Object getSelectedObject() {
        switch (this._mode) {
            case 0: 
            case 2: {
                if (this._selection < 0) break;
                return this._idTableModel.getObjectAt(this._selection);
            }
            case 3: {
                Identifier newid = new Identifier();
                newid.setName(this._namePanel.getName());
                newid.setDescription(this._namePanel.getDescription());
                return newid;
            }
            case 4: {
                if (this._selection >= 0) {
                    return this._idTableModel.getObjectAt(this._selection);
                }
                return null;
            }
            case 1: {
                String name = this.textFieldSelectManager.getText();
                if (name == null || name.length() <= 0) {
                    return null;
                }
                return ClientApp.Workspace().getManagerIdentifier(this._model, this._className, name, this._extension);
            }
            case 6: {
                String name = this._namePanel.getName();
                if (name == null || name.length() <= 0) {
                    return null;
                }
                ClientApp.app();
                Identifier newId = ClientApp.Workspace().getManagerIdentifier(this._model, this._className, name, this._extension);
                newId.setDescription(this._namePanel.getDescription());
                return newId;
            }
        }
        return null;
    }

    public Object getIdentifier() {
        return null;
    }

    public Vector getObjectList() {
        return this.getSelectedObjects();
    }

    public Vector getSelectedObjects() {
        Vector<Object> idList = new Vector<Object>();
        if (this._idTable.getSelectionModel().getSelectionMode() == 0) {
            Object id = this.getIdentifier();
            if (id != null) {
                idList.add(id);
            }
        } else {
            int[] rows = this._idTable.getSelectedRows();
            if (rows != null && rows.length > 0) {
                for (int i = 0; i < rows.length; ++i) {
                    idList.add(this._idTableModel.getObjectAt(rows[i]));
                }
            }
        }
        return idList;
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocation();
            if ((this._mode == 0 || this._mode == 4) && this._idTable.getRowCount() > 0) {
                this._idTable.updateSelection(0, 0, false, false);
            }
        }
        super.setVisible(b);
    }

    protected long getFlags() {
        return this._flags;
    }

    protected RmaJTable getIdTable() {
        return this._idTable;
    }

    protected int getMode() {
        return this._mode;
    }

    class SymText
    implements TextListener {
        SymText() {
        }

        @Override
        public void textValueChanged(TextEvent event) {
            Object object = event.getSource();
            if (object == ObjectChooser.this.textFieldSelectManager) {
                ObjectChooser.this.textFieldSelectManager_TextValueChanged(event);
            }
        }
    }

    class SymItem
    implements ListSelectionListener {
        SymItem() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            Object object = event.getSource();
            if (ObjectChooser.this._idTable != null && object == ObjectChooser.this._idTable.getSelectionModel()) {
                ObjectChooser.this.idTable_ItemStateChanged();
            }
        }
    }
}

