/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.client.OptionsFontPanel;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientCache;
import hec.clientapp.client.ComputeOptionsPanel;
import hec.clientapp.client.OptionsCachePanel;
import hec.clientapp.client.OptionsCwmsHomePanel;
import hec.clientapp.client.OptionsDirectoryPanel;
import hec.clientapp.client.OptionsGeneralPanel;
import hec.clientapp.client.OptionsLogPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaJDialog;

public class OptionDialog
extends RmaJDialog {
    private boolean _canceled = false;
    private OptionsDirectoryPanel jDirPanel;
    private OptionsCachePanel jCachePanel;
    private OptionsCwmsHomePanel jCwmsHomePanel;
    private ComputeOptionsPanel jComputePanel;
    private OptionsLogPanel jLogPanel;
    private OptionsGeneralPanel jGeneralPanel;
    private OptionsFontPanel jFontPanel;
    private static int MODEL_TAB_INDEX = 6;
    private boolean _modelTabsLoaded = false;
    private Frame _owner;
    boolean _dirPanelEnabled;
    private ButtonCmdPanel cmdPanel;
    private JPanel jPanel1;
    private JTabbedPane optionsTabPane;
    private boolean _showCWMS_HOME = true;
    boolean fComponentsAdjusted = false;

    public OptionDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this._owner = owner;
        this.buildControls();
    }

    public OptionDialog(Frame owner, boolean modal, boolean showCWMS_HOME) {
        super(owner, modal);
        this._owner = owner;
        this._showCWMS_HOME = showCWMS_HOME;
        this.buildControls();
    }

    private void buildControls() {
        this.setTitle("Options");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setVisible(false);
        this.setSize(520, 200);
        this.setDefaultSize(520, 200);
        this.jPanel1 = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.jPanel1.setLayout(gridBagLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.ipady = 0;
        this.getContentPane().add((Component)this.jPanel1, gbc);
        this.optionsTabPane = new JTabbedPane(1);
        ImageIcon icon = new ImageIcon("images/middle.gif");
        this.jDirPanel = new OptionsDirectoryPanel();
        this.jCachePanel = new OptionsCachePanel();
        this.jCwmsHomePanel = new OptionsCwmsHomePanel();
        this.jComputePanel = new ComputeOptionsPanel();
        this.jLogPanel = new OptionsLogPanel();
        this.jGeneralPanel = new OptionsGeneralPanel();
        this.jFontPanel = new OptionsFontPanel();
        this.optionsTabPane.addTab(this.jDirPanel.getTabName(), icon, (Component)((Object)this.jDirPanel), "Define Directories");
        String cwmshomeDir = System.getProperty("CWMS_HOME");
        this._dirPanelEnabled = cwmshomeDir != null ? !ClientApp.app().networked : true;
        this.optionsTabPane.setEnabledAt(0, this._dirPanelEnabled);
        this.jDirPanel.setEnabled(this._dirPanelEnabled);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.ipady = 315;
        ((GridBagLayout)this.jPanel1.getLayout()).setConstraints(this.optionsTabPane, gbc);
        this.jPanel1.add(this.optionsTabPane);
        int cacheMode = ClientApp.getCacheMode();
        if (cacheMode != 5 && cacheMode != ClientCache.NO_CACHE) {
            this.optionsTabPane.addTab("Cache Directory", icon, (Component)((Object)this.jCachePanel), "Define Cache Directory");
        }
        if (this._showCWMS_HOME) {
            this.optionsTabPane.addTab("CWMS_HOME Directory", icon, (Component)((Object)this.jCwmsHomePanel), "Define Local CWMS_HOME Directory");
        }
        this.optionsTabPane.addTab("Compute Display", icon, (Component)((Object)this.jComputePanel), "Compute Display Options");
        this.optionsTabPane.addTab("Debug Levels", icon, (Component)((Object)this.jLogPanel), "Set debug levels");
        this.optionsTabPane.addTab("General", icon, (Component)((Object)this.jGeneralPanel), "General Options");
        this.optionsTabPane.addTab("Fonts", icon, (Component)this.jFontPanel, "Font Options");
        this.optionsTabPane.setSelectedIndex(this._dirPanelEnabled ? 0 : 1);
        if (this._dirPanelEnabled) {
            this.jDirPanel.fillForm(ClientApp.app().getAppServer());
        }
        this.cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.cmdPanel, gbc);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        OptionDialog.this.jBok_actionPerformed();
                        break;
                    }
                    case 4: {
                        OptionDialog.this.jBcancel_actionPerformed();
                    }
                }
            }
        });
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    void JDialog1_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    public OptionsDirectoryPanel getDirPanel() {
        return this.jDirPanel;
    }

    private void jBok_actionPerformed() {
        this.setCanceled(false);
        int numModelTabs = this.optionsTabPane.getTabCount();
        for (int i = 0; i < numModelTabs; ++i) {
            DefaultJPanel panel = (DefaultJPanel)this.optionsTabPane.getComponentAt(i);
            if (panel.savePanel()) continue;
            this.optionsTabPane.setSelectedComponent((Component)panel);
            return;
        }
        if (this.jCwmsHomePanel != null) {
            this.jCwmsHomePanel.cwmsDirsModified();
        }
        this.setVisible(false);
    }

    private void jBcancel_actionPerformed() {
        this.setCanceled(true);
        this.setVisible(false);
    }

    private void enterPressed() {
        JButton b = this.getRootPane().getDefaultButton();
        if (b == null) {
            return;
        }
        b.doClick();
    }

    private void setCanceled(boolean canceled) {
        this._canceled = canceled;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setVisible(boolean b) {
        if (b) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            int numModelTabs = this.optionsTabPane.getTabCount();
            for (int i = 1; i < numModelTabs; ++i) {
                DefaultJPanel panel = (DefaultJPanel)this.optionsTabPane.getComponentAt(i);
                panel.fillPanel();
            }
        }
        super.setVisible(b);
    }

    public void addModelSpecificPanel(DefaultJPanel panel) {
        if (panel == null) {
            return;
        }
        this.optionsTabPane.addTab(panel.getName(), (Component)panel);
        this._modelTabsLoaded = true;
    }

    public void removeModelSpecificPanels() {
        int numModelTabs = this.optionsTabPane.getTabCount();
        for (int i = MODEL_TAB_INDEX; i < numModelTabs; ++i) {
            this.optionsTabPane.removeTabAt(MODEL_TAB_INDEX);
        }
    }

    public boolean modelPanelsLoaded() {
        return this._modelTabsLoaded;
    }

    public void setSelectedTab(Class tabClassToSelect) {
        if (tabClassToSelect == null) {
            return;
        }
        int cnt = this.optionsTabPane.getTabCount();
        for (int i = 0; i < cnt; ++i) {
            Component tab = this.optionsTabPane.getComponentAt(i);
            if (!tabClassToSelect.isInstance(tab)) continue;
            this.optionsTabPane.setSelectedIndex(i);
            break;
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == OptionDialog.this) {
                OptionDialog.this.JDialog1_WindowClosing(event);
            }
        }
    }
}

