/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientCache;
import hec.util.FileUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class OptionsCachePanel
extends DefaultJPanel {
    EnablablePanel _tabPanel;
    RmaJTextField _cacheDir;
    JButton _clearCache;
    JButton _defaultDir;
    JLabel _cacheModeFld;
    JButton browse;

    public OptionsCachePanel() {
        this.setLayout(new GridBagLayout());
        this._tabPanel = new EnablablePanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this._tabPanel, gbc);
        this._cacheModeFld = new JLabel("Cache Mode:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(20, 5, 0, 0);
        this._tabPanel.add((Component)this._cacheModeFld, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 5, 0, 0);
        this._tabPanel.add((Component)panel, gbc);
        JLabel label = new JLabel("Cache Directory:");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(3, 0, 0, 5);
        panel.add((Component)label, gbc);
        this._cacheDir = new RmaJTextField();
        label.setLabelFor((Component)this._cacheDir);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0505;
        panel.add((Component)this._cacheDir, gbc);
        this.browse = new JButton("Browse...");
        this.browse.setMnemonic('b');
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS0505;
        panel.add((Component)this.browse, gbc);
        this._defaultDir = new JButton("Default Cache Directory");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(12, 5, 0, 0);
        this._tabPanel.add((Component)this._defaultDir, gbc);
        this._clearCache = new JButton("Clear Cache");
        this._clearCache.setMnemonic('c');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(12, 5, 0, 0);
        this._tabPanel.add((Component)this._clearCache, gbc);
        if (ClientApp.Workspace() != null) {
            this._clearCache.setEnabled(false);
        }
        this._defaultDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCachePanel.this.setDefaultDirAction();
            }
        });
        this._clearCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCachePanel.this.clearCacheAction();
            }
        });
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCachePanel.this.browseAction();
            }
        });
    }

    public void fillPanel() {
        String dir = ClientApp.app().getCache().getCacheDirectory();
        if (dir != null) {
            this._cacheDir.setText(dir);
        } else {
            this._cacheDir.setText("");
        }
        int cacheMode = ClientApp.getCacheMode();
        if (cacheMode != 5) {
            String mode = ClientCache.CACHE_MODES[cacheMode];
            this._cacheModeFld.setText("Cache Mode:  " + mode);
            this._cacheModeFld.setToolTipText(ClientCache.CACHE_TOOL_TIPS[cacheMode]);
        } else {
            this._cacheModeFld.setText("Cache Mode:  Local - No caching");
        }
    }

    public void refresh() {
        this.setEnabled(true);
    }

    public boolean savePanel() {
        ClientApp.app();
        int cacheMode = ClientApp.getCacheMode();
        if (cacheMode == 5) {
            return true;
        }
        if (cacheMode == ClientCache.NO_CACHE) {
            return true;
        }
        if (this._cacheDir.getText().length() < 1) {
            return true;
        }
        if (this._cacheDir.getText().indexOf("CWMS_HOME") < 0) {
            File dir = new File(RMAIO.parsePathName((String)this._cacheDir.getText()));
            if (!dir.exists()) {
                int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Cache Directory\n" + this._cacheDir.getText() + "\ndoes not exist. Would you like to create it?.", "Confirm Selection", 0);
                if (opt == 1) {
                    return true;
                }
                if (!dir.mkdirs()) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Failed to create " + this._cacheDir.getText());
                    return false;
                }
            }
            if (!dir.isDirectory()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Specified Cache Directory is not a directory");
                return false;
            }
        }
        ClientApp.app().setCachingEnabled(true, this._cacheDir.getText());
        return true;
    }

    private void setDefaultDirAction() {
        String defaultDir = ClientApp.app().getCache().getDefaultCacheDirectory();
        int opt = JOptionPane.showConfirmDialog(null, "Do you want to set the cache directory to the default?\n" + defaultDir, "Set Cache Directory", 0, 3);
        if (opt == 1) {
            return;
        }
        File file = new File(defaultDir);
        if (!file.exists() && !(file = new File(defaultDir)).exists()) {
            file.mkdirs();
        }
        if ((opt = JOptionPane.showConfirmDialog(null, "Program must exit to set cache directory.\nDo you want to exit now?", "Set Cache Directory", 0, 3)) == 1) {
            JOptionPane.showMessageDialog(null, "Cannot set cache without being able to exit.\nCache Directory not changed");
            return;
        }
        ClientApp.app().setCachingEnabled(true, defaultDir);
        ClientApp.frame().exitApplication();
    }

    private void clearCacheAction() {
        String directory = this._cacheDir.getText();
        File file = new File(directory);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, "Cache directory does not exist:\n" + directory, "Directory does not exist", 2);
            return;
        }
        if (!file.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Cache location is not a valid directory:\n" + directory, "Directory does not exist", 2);
            return;
        }
        int opt = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete all files in the local cache?\n" + directory, "Clear Local Cache", 0, 3);
        if (opt == 0) {
            boolean cdir = false;
            if (directory.toLowerCase().indexOf("cache") > 0) {
                cdir = true;
            }
            if (directory.toLowerCase().indexOf("temp") > 0) {
                cdir = true;
            }
            if (directory.toLowerCase().indexOf("tmp") > 0) {
                cdir = true;
            }
            if (!cdir && (opt = JOptionPane.showConfirmDialog(null, "Directory is not recognized as a cache location:\n" + directory + "\nAre you sure you want to delete this area?", "Unrecognized Directory", 0, 2)) == 1) {
                JOptionPane.showMessageDialog(null, "Delete canceled.", "", 1);
                return;
            }
            boolean b = FileUtilities.deleteDirectory((File)file);
            if (b) {
                file.mkdirs();
                JOptionPane.showMessageDialog(null, "Cache deleted:\n" + directory, "", 1);
            } else {
                JOptionPane.showMessageDialog(null, "Unable to delete cache:\n" + directory + "\nTry deleting the cache directory before opening a watershed, or delete it manually", "Unable to delete", 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Delete canceled.", "", 1);
        }
        opt = JOptionPane.showConfirmDialog(null, "Program must exit to complete operation.\nDo you want to exit now?", "Clear Cache", 0, 3);
        if (opt == 1) {
            JOptionPane.showMessageDialog(null, "Caution - not exiting leaves program in an unstable state\nSave your work and exit.", "Exit Program", 2);
            return;
        }
        ClientApp.frame().exitApplication();
    }

    private void browseAction() {
        String startDir = null;
        String defaultDir = ClientApp.app().getCache().getDefaultCacheDirectory();
        startDir = this._cacheDir.getText().length() > 0 ? this._cacheDir.getText() : defaultDir;
        File file = new File(startDir);
        if (!file.exists() && !(file = new File(startDir = defaultDir)).exists()) {
            file.mkdirs();
        }
        JFileChooser chooser = new JFileChooser(startDir);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonText("OK");
        chooser.showOpenDialog((Component)((Object)this));
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        String dir = selectedFile.getAbsolutePath().replace('\\', '/');
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        this._cacheDir.setText(dir);
        int opt = JOptionPane.showConfirmDialog(null, "Cache directory set to " + this._cacheDir.getText() + "\nProgram must exit to set cache directory.\nDo you want to exit now?", "Set Cache Directory", 0, 3);
        if (opt == 1) {
            JOptionPane.showMessageDialog(null, "Cannot set cache without being able to exit.\nCache Directory not changed");
            return;
        }
        ClientApp.app().setCachingEnabled(true, dir);
        ClientApp.frame().exitApplication();
    }

    class EnablablePanel
    extends JPanel {
        public EnablablePanel() {
            this.setLayout(new GridBagLayout());
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            if (ClientApp.Workspace() != null) {
                OptionsCachePanel.this._clearCache.setEnabled(false);
                OptionsCachePanel.this.browse.setEnabled(false);
                OptionsCachePanel.this._cacheDir.setEnabled(false);
            }
        }
    }
}

