/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJTextField;

public class OptionsCwmsHomePanel
extends DefaultJPanel {
    EnablablePanel _tabPanel;
    JCheckBox _setCwmsHomeLocal;
    RmaJTextField _cwmsHomeLocal;
    JButton _browseCwmsHome;
    RmaJTextField _cwmsExeLocal;
    JButton _browseCwmsExe;
    String _cwmsHomeDir = null;
    boolean _cwmsHomeDirModified = false;
    String _cwmsExeDir = null;
    boolean _cwmsExeDirModified = false;

    public OptionsCwmsHomePanel() {
        this.setLayout(new GridBagLayout());
        this._tabPanel = new EnablablePanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this._tabPanel, gbc);
        this._setCwmsHomeLocal = new JCheckBox("Override local CWMS_HOME directory environment setting");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 5, 0, 0);
        this._tabPanel.add((Component)this._setCwmsHomeLocal, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 7, 0, 0);
        this._tabPanel.add((Component)panel, gbc);
        JLabel label = new JLabel("Local CWMS_HOME:");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(17, 5, 0, 0);
        panel.add((Component)label, gbc);
        this._cwmsHomeLocal = new RmaJTextField();
        label.setLabelFor((Component)this._cwmsHomeLocal);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 5, 0, 0);
        panel.add((Component)this._cwmsHomeLocal, gbc);
        this._browseCwmsHome = new JButton("Browse...");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(12, 5, 0, 0);
        panel.add((Component)this._browseCwmsHome, gbc);
        panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = new Insets(20, 7, 0, 0);
        this._tabPanel.add((Component)panel, gbc);
        label = new JLabel("Local CWMS_EXE:");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        panel.add((Component)label, gbc);
        this._cwmsExeLocal = new RmaJTextField();
        label.setLabelFor((Component)this._cwmsExeLocal);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0505;
        panel.add((Component)this._cwmsExeLocal, gbc);
        this._browseCwmsExe = new JButton("Browse...");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS0505;
        panel.add((Component)this._browseCwmsExe, gbc);
        this._cwmsHomeLocal.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                OptionsCwmsHomePanel.this.cwmsHomeChanged();
            }
        });
        this._setCwmsHomeLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCwmsHomePanel.this.overrideCwmsHomeLocalAction();
            }
        });
        this._browseCwmsHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCwmsHomePanel.this.browseCwmsHome();
            }
        });
        this._cwmsExeLocal.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                OptionsCwmsHomePanel.this.cwmsExeChanged();
            }
        });
        this._browseCwmsExe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsCwmsHomePanel.this.browseCwmsExe();
            }
        });
    }

    protected void cwmsHomeChanged() {
        Preferences preferences = ClientApp.app().getAppPreferences();
        String cwmsHome = preferences.get("CWMS_HOME", null);
        if (cwmsHome != null && this._cwmsHomeLocal.getText().equals(cwmsHome)) {
            return;
        }
        this.setCwmsHomeLocal(this._cwmsHomeLocal.getText());
    }

    protected void cwmsExeChanged() {
        Preferences preferences = ClientApp.app().getAppPreferences();
        String cwmsExe = preferences.get("CWMS_EXE", null);
        if (cwmsExe != null && this._cwmsExeLocal.getText().equals(cwmsExe)) {
            return;
        }
        this.setCwmsExeLocal(this._cwmsExeLocal.getText());
    }

    public void fillPanel() {
        Preferences preferences = ClientApp.app().getAppPreferences();
        String cwmsHome = preferences.get("CWMS_HOME", null);
        if (cwmsHome != null && cwmsHome.length() == 0) {
            cwmsHome = null;
        }
        if (cwmsHome == null) {
            this._setCwmsHomeLocal.setSelected(false);
            this._cwmsHomeLocal.setEnabled(false);
            cwmsHome = System.getProperty("CWMS_HOME");
        } else {
            this._setCwmsHomeLocal.setSelected(true);
        }
        if (cwmsHome != null) {
            this._cwmsHomeLocal.setText(cwmsHome);
        }
        this._browseCwmsHome.setEnabled(this._setCwmsHomeLocal.isSelected());
        String cwmsExe = preferences.get("CWMS_EXE", null);
        if (cwmsExe != null && cwmsExe.length() == 0) {
            cwmsExe = null;
        }
        if (cwmsExe == null) {
            cwmsExe = System.getProperty("CWMS_EXE");
        }
        if (cwmsExe != null) {
            this._cwmsExeLocal.setText(cwmsExe);
        }
    }

    protected void setCwmsHomeLocal(String dir) {
        this._cwmsHomeDir = dir != null && dir.trim().length() > 0 ? dir : null;
        this._cwmsHomeDirModified = true;
    }

    protected void setCwmsExeLocal(String dir) {
        this._cwmsExeDir = dir != null && dir.trim().length() > 0 ? dir : null;
        this._cwmsExeDirModified = true;
    }

    public boolean cwmsDirsModified() {
        if (!this._cwmsHomeDirModified && !this._cwmsExeDirModified) {
            return false;
        }
        StringBuffer message = new StringBuffer();
        if (this._cwmsHomeDirModified) {
            if (this._cwmsHomeDir == null) {
                message.append("Reset local CWMS_HOME directory set to default?");
            } else {
                message.append("Local CWMS_HOME directory set to ");
                message.append(this._cwmsHomeDir);
            }
            message.append("\n");
        }
        if (this._cwmsExeDirModified) {
            if (this._cwmsExeDir == null) {
                message.append("Reset local CWMS_EXE directory set to default?");
            } else {
                message.append("Local CWMS_EXE directory set to ");
                message.append(this._cwmsExeDir);
            }
            message.append("\n");
        }
        message.append("Program must exit to complete operation.\nDo you want to exit now?");
        int opt = JOptionPane.showConfirmDialog(null, message.toString(), "Set CWMS Directory", 1, 3);
        if (opt == 2) {
            JOptionPane.showMessageDialog(null, "NO Directory Changes Made.");
            return false;
        }
        Preferences preferences = ClientApp.app().getAppPreferences();
        if (this._cwmsHomeDirModified) {
            if (this._cwmsHomeDir == null) {
                System.clearProperty("CWMS_HOME");
                preferences.remove("CWMS_HOME");
            } else {
                System.setProperty("CWMS_HOME", this._cwmsHomeDir);
                preferences.put("CWMS_HOME", this._cwmsHomeDir);
            }
        }
        if (this._cwmsExeDirModified) {
            if (this._cwmsExeDir == null) {
                System.clearProperty("CWMS_EXE");
                preferences.remove("CWMS_EXE");
            } else {
                System.setProperty("CWMS_EXE", this._cwmsExeDir);
                preferences.put("CWMS_EXE", this._cwmsExeDir);
            }
        }
        if (opt == 0) {
            ClientApp.frame().exitApplication();
        }
        return true;
    }

    protected void overrideCwmsHomeLocalAction() {
        if (this._setCwmsHomeLocal.isSelected()) {
            this._cwmsHomeLocal.setEnabled(true);
            this.browseCwmsHome();
        } else {
            this._cwmsHomeLocal.setEnabled(false);
            this.setCwmsHomeLocal(null);
        }
    }

    protected void browseCwmsHome() {
        String startDir = this._cwmsHomeLocal.getText();
        JFileChooser chooser = new JFileChooser(startDir);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonText("OK");
        chooser.showOpenDialog((Component)((Object)this));
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        String dir = selectedFile.getAbsolutePath().replace('\\', '/');
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        this._cwmsHomeLocal.setText(dir);
        this.setCwmsHomeLocal(dir);
    }

    protected void browseCwmsExe() {
        String startDir = this._cwmsExeLocal.getText();
        JFileChooser chooser = new JFileChooser(startDir);
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonText("OK");
        chooser.showOpenDialog((Component)((Object)this));
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        String dir = selectedFile.getAbsolutePath().replace('\\', '/');
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
        this._cwmsExeLocal.setText(dir);
        this.setCwmsExeLocal(dir);
    }

    public void refresh() {
        this.setEnabled(true);
    }

    class EnablablePanel
    extends JPanel {
        public EnablablePanel() {
            this.setLayout(new GridBagLayout());
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            OptionsCwmsHomePanel.this.fillPanel();
        }
    }
}

