/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.appInterface.FileOpener;
import hec.clientapp.client.ClientApp;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.io.FileLock;
import hec.io.Identifier;
import hec.lang.ApplicationProperties;
import hec.lang.ClientAppCheck;
import hec.lang.UserId;
import hec.model.WatershedLocation;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextField;
import rma.swing.event.ReflectMultiListener;
import rma.util.RMAIO;

public class OptionsDirectoryPanel
extends DefaultJPanel
implements FileOpener {
    protected RmaJTable _locationTable;
    protected JButton _removeButton;
    protected JButton _addButton;
    protected JButton _editButton;
    protected boolean _canceled;
    protected RmiApp _app;
    protected JPanel _topPanel;
    ReflectMultiListener _listener;
    private boolean _useShortCuts;

    public OptionsDirectoryPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this._listener = new ReflectMultiListener();
        this.setLayout(new GridBagLayout());
        this._topPanel = new JPanel(new GridBagLayout());
        this._useShortCuts = Boolean.getBoolean("NO_PREDEFINED_WKSP");
        String title = this._useShortCuts ? "Shortcuts" : "Watershed Locations";
        this._topPanel.setBorder(new TitledBorder(title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add(this._topPanel, gbc);
        this._locationTable = new RmaJTable((Component)((Object)this), new String[]{"Name", "Location"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 11 * this.getRowHeight();
                return d;
            }
        };
        this._locationTable.setCellSelectionEnabled(false);
        this._locationTable.setColumnSelectionAllowed(false);
        this._locationTable.setRowSelectionAllowed(true);
        this._locationTable.setEditable(false);
        this._locationTable.setPopupMenuEnabled(false);
        this._locationTable.setSelectionMode(0);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this._topPanel.add((Component)this._locationTable.getScrollPane(), gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._topPanel.add((Component)buttonPanel, gbc);
        this._addButton = new JButton(this._useShortCuts ? "Add Shortcut" : "Add Location ...");
        this._addButton.setMnemonic('A');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        buttonPanel.add((Component)this._addButton, gbc);
        this._removeButton = new JButton(this._useShortCuts ? "Remove Shortcut" : "Remove Location");
        this._removeButton.setMnemonic('R');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        buttonPanel.add((Component)this._removeButton, gbc);
        this._editButton = new JButton(this._useShortCuts ? "Edit Shortcut" : "Edit Location ...");
        this._editButton.setMnemonic('E');
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        buttonPanel.add((Component)this._editButton, gbc);
        this._addButton.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._addButton, "addLocation"));
        this._removeButton.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._removeButton, "deleteLocation"));
        this._editButton.addActionListener((ActionListener)this._listener.add((Object)this, (Object)this._editButton, "editLocation"));
        this._locationTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                int row = OptionsDirectoryPanel.this._locationTable.getSelectedRow();
                if (row < 0) {
                    return;
                }
                OptionsDirectoryPanel.this.editLocation();
            }
        });
    }

    public void fillForm(RmiApp app) {
        this._app = app;
        this._locationTable.deleteCells();
        Vector locations = null;
        if (ClientAppCheck.haveClientApp()) {
            locations = ClientApp.app().getWatershedLocations(false);
        } else {
            try {
                locations = this._app.getWatershedLocations(false);
            }
            catch (RemoteException re) {
                System.out.println("fillForm: RMI Error getting locations from Server " + re);
                JOptionPane.showMessageDialog((Component)((Object)this), "Communications error retrieving locations from Server", "Load Failed", 0);
            }
        }
        if (locations == null) {
            return;
        }
        int size = locations.size();
        for (int i = 0; i < size; ++i) {
            Object obj = locations.get(i);
            if (!(obj instanceof WatershedLocation)) continue;
            WatershedLocation wl = (WatershedLocation)obj;
            this.addLocation(wl);
        }
    }

    public boolean addLocation(WatershedLocation wl) {
        if (wl == null) {
            return false;
        }
        Vector<String> row = new Vector<String>(2);
        String name = wl.getName();
        for (int i = 0; i < this._locationTable.getRowCount(); ++i) {
            if (!this._locationTable.getCell(i, 0).equals(name)) continue;
            JOptionPane.showMessageDialog((Component)((Object)this), (this._useShortCuts ? "Shortcut" : "Location ") + name + " already exists.", "Duplicate Name", 2);
            this._locationTable.updateSelection(i, 0, false, false);
            return false;
        }
        row = new Vector(2);
        row.add(name);
        row.add(wl.getDirectory());
        this._locationTable.appendRow(row);
        return true;
    }

    public boolean savePanel() {
        if (!this.isEnabled()) {
            return true;
        }
        this._locationTable.commitEdit(true);
        if (this._app == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No Rmi App", "Save Failed", 0);
            return false;
        }
        Vector locations = this.getWatershedLocations();
        if (ClientAppCheck.haveClientApp()) {
            ClientApp.app().setWatershedLocations(locations);
        } else {
            try {
                this._app.setWatershedLocations(locations);
            }
            catch (RemoteException re) {
                System.out.println("saveForm: RMI Error saving locations " + re);
                JOptionPane.showMessageDialog((Component)((Object)this), "Communications error saving locations to Server", "Save Failed", 0);
                return false;
            }
        }
        return true;
    }

    public Vector getWatershedLocations() {
        int rows = this._locationTable.getRowCount();
        Vector<WatershedLocation> locations = new Vector<WatershedLocation>(rows);
        for (int i = 0; i < rows; ++i) {
            String name = (String)this._locationTable.getCell(i, 0);
            String location = (String)this._locationTable.getCell(i, 1);
            locations.add(new WatershedLocation(name, location));
        }
        return locations;
    }

    public boolean addLocation() {
        AddLocationDialog dialog = new AddLocationDialog((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)));
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return false;
        }
        WatershedLocation wl = dialog.getWatershedLocation();
        boolean b = this.addLocation(wl);
        return b;
    }

    public WatershedLocation newLocation(String locationName) {
        AddLocationDialog dialog = new AddLocationDialog((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)));
        dialog.fillForm(locationName, "");
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return null;
        }
        WatershedLocation wl = dialog.getWatershedLocation();
        return wl;
    }

    public void editLocation() {
        int row = this._locationTable.getSelectedRow();
        if (row < 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please Select a " + (this._useShortCuts ? "Shortcut" : "Location") + " to Edit", "No Row Selected", 1);
            return;
        }
        AddLocationDialog dialog = new AddLocationDialog((Dialog)SwingUtilities.windowForComponent((Component)((Object)this)));
        dialog.fillForm((String)this._locationTable.getCell(row, 0), (String)this._locationTable.getCell(row, 1));
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        WatershedLocation wl = dialog.getWatershedLocation();
        this._locationTable.setCell((Object)wl.getName(), row, 0);
        this._locationTable.setCell((Object)wl.getDirectory(), row, 1);
    }

    public void deleteLocation() {
        int[] rows = this._locationTable.getSelectedRows();
        if (rows.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select the rows in the table that you want to remove", "No rows selected", 1);
            return;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < rows.length; ++i) {
            buf.append(this._locationTable.getCell(rows[i], 0));
            if (i == rows.length - 1) continue;
            buf.append("\n");
        }
        int opt = JOptionPane.showConfirmDialog((Component)((Object)this), "Confirm remove of the following " + (this._useShortCuts ? "Shortcuts:" : "Locations:") + "\n" + buf.toString(), "Confirm Removal", 0);
        if (opt == 1) {
            return;
        }
        this._locationTable.deleteRow();
        this.setModified(true);
    }

    public void fillPanel() {
    }

    public void refresh() {
    }

    public Identifier openFile(Identifier fileToOpenId, boolean useCache) {
        if (ClientAppCheck.haveClientApp()) {
            return ClientApp.app().openFile(fileToOpenId, useCache);
        }
        if (this._app != null) {
            try {
                return this._app.getFileManager().openFile(UserId.getUserId(), fileToOpenId);
            }
            catch (RemoteException e) {
                System.out.println("openFile:RMI Error occurred trying to open " + fileToOpenId.getPath() + " Error:" + e);
            }
        }
        return null;
    }

    public Identifier createFile(Identifier fileToCreateId) {
        if (ClientAppCheck.haveClientApp()) {
            return ClientApp.app().createFile(fileToCreateId);
        }
        if (this._app != null) {
            try {
                return this._app.getFileManager().newFile(UserId.getUserId(), fileToCreateId);
            }
            catch (RemoteException e) {
                System.out.println("createFile:RMI Error occurred trying to create " + fileToCreateId.getPath() + " Error:" + e);
            }
        }
        return null;
    }

    public boolean lockFile(Identifier id, FileLock flock) {
        if (ClientAppCheck.haveClientApp()) {
            return ClientApp.app().lockFile(id, flock);
        }
        if (this._app != null) {
            try {
                return this._app.getFileManager().lockFile(id, flock);
            }
            catch (RemoteException e) {
                System.out.println("lockFile:RMI Error occurred trying to lock " + id.getPath() + " Error:" + e);
            }
        }
        return false;
    }

    public boolean unlockFile(Identifier id, FileLock flock) {
        if (ClientAppCheck.haveClientApp()) {
            return ClientApp.app().unlockFile(id, flock);
        }
        if (this._app != null) {
            try {
                return this._app.getFileManager().unlockFile(id, flock);
            }
            catch (RemoteException e) {
                System.out.println("unlockFile:RMI Error occurred trying to unlock " + id.getPath() + " Error:" + e);
            }
        }
        return false;
    }

    public List getFileList(String path, String filter) {
        if (ClientAppCheck.haveClientApp()) {
            return ClientApp.app().getFileList(path, filter);
        }
        if (this._app != null) {
            try {
                return this._app.getFileManager().getRemoteFileIDList(UserId.getUserId(), path, filter);
            }
            catch (RemoteException e) {
                System.out.println("getFileList:RMI Error occurred trying to get File list " + path + " Error:" + e);
            }
        }
        return new ArrayList(0);
    }

    public List getDriveList() {
        if (ClientAppCheck.haveClientApp()) {
            return ClientApp.app().getDriveList();
        }
        if (this._app != null) {
            try {
                return this._app.getFileManager().getRemoteDriveIDList(UserId.getUserId());
            }
            catch (RemoteException e) {
                System.out.println("getDriveList:RMI Error occurred trying to get Drive list  Error:" + e);
            }
        }
        return new ArrayList(0);
    }

    public String getTabName() {
        return this._useShortCuts ? "Shortcuts" : "Model Directories";
    }

    class AddLocationDialog
    extends RmaJDialog {
        private RmaJTextField _nameTxt;
        private RmaJTextField _dirTxt;
        private ButtonCmdPanel _cmdPanel;
        private JButton _browseButton;

        AddLocationDialog(Dialog parent) {
            super(parent, true);
            this.setTitle("Add " + (OptionsDirectoryPanel.this._useShortCuts ? "Shortcut" : "Watershed Location"));
            this.getContentPane().setLayout(new GridBagLayout());
            JLabel label = new JLabel("Name:", 2);
            label.setDisplayedMnemonic('N');
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)label, gbc);
            this._nameTxt = new RmaJTextField(10);
            label.setLabelFor((Component)this._nameTxt);
            this._nameTxt.setTrimWhiteSpace(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)this._nameTxt, gbc);
            label = new JLabel("                     ", 4);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)label, gbc);
            label = new JLabel("Location:", 2);
            label.setDisplayedMnemonic('L');
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)label, gbc);
            this._dirTxt = new RmaJTextField(30);
            label.setLabelFor((Component)this._dirTxt);
            this._dirTxt.setTrimWhiteSpace(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)this._dirTxt, gbc);
            this._browseButton = new JButton("Browse ...");
            this._browseButton.setMnemonic('B');
            gbc = new GridBagConstraints();
            gbc.gridx = 3;
            gbc.gridy = 1;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = RmaInsets.insets((int)3, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)this._browseButton, gbc);
            this._cmdPanel = new ButtonCmdPanel(12);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 4;
            gbc.anchor = 16;
            gbc.fill = 2;
            gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
            this.getContentPane().add((Component)this._cmdPanel, gbc);
            this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

                public void buttonCmdActionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 8: {
                            if (!AddLocationDialog.this.validForm()) break;
                            OptionsDirectoryPanel.this._canceled = false;
                            AddLocationDialog.this.setVisible(false);
                            break;
                        }
                        case 4: {
                            OptionsDirectoryPanel.this._canceled = true;
                            AddLocationDialog.this.setVisible(false);
                        }
                    }
                }
            });
            this._browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddLocationDialog.this.browseAction();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    OptionsDirectoryPanel.this._canceled = true;
                }
            });
            this.pack();
            this.setLocation();
            this.setResizable(false);
        }

        public void fillForm(String name, String dir) {
            this._nameTxt.setText(name);
            this._dirTxt.setText(dir);
            this.setTitle("Edit " + (OptionsDirectoryPanel.this._useShortCuts ? "Shortcut" : "Watershed Location"));
        }

        public boolean validForm() {
            String name = this._nameTxt.getText();
            if (name.length() <= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a name");
                this._nameTxt.requestFocus();
                return false;
            }
            if (this._dirTxt.getText().length() <= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Please enter or select a location");
                this._dirTxt.requestFocus();
                return false;
            }
            String origDir = this._dirTxt.getText().replace('\\', '/');
            String dir = RMAIO.parsePathName((String)origDir);
            if (!dir.equals(origDir)) {
                return true;
            }
            if (OptionsDirectoryPanel.this._app != null) {
                try {
                    RmiFileManager fm = OptionsDirectoryPanel.this._app.getFileManager();
                    if (!fm.fileExists(dir)) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "Directory " + dir + " does not exist.", "Error", 0);
                        return false;
                    }
                }
                catch (RemoteException re) {
                    System.out.println("validForm: RMI Error checking if dir exists " + re);
                    return true;
                }
            }
            return true;
        }

        boolean isCanceled() {
            return OptionsDirectoryPanel.this._canceled;
        }

        WatershedLocation getWatershedLocation() {
            return new WatershedLocation(this._nameTxt.getText(), this._dirTxt.getText().replace('\\', '/'));
        }

        void browseAction() {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Vector<String> v = new Vector<String>();
            v.addElement("*.*");
            String startDir = this._dirTxt.getText();
            if (startDir.length() == 0) {
                try {
                    startDir = OptionsDirectoryPanel.this._app.getServerProperty(ApplicationProperties.getAppHomeVariable());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            if (startDir == null || startDir.equals(".")) {
                startDir = System.getProperty("user.dir");
            }
            RmiFileDialog fd = new RmiFileDialog((Dialog)((Object)this), true, startDir, v);
            fd.setOpenDirectory();
            if (ClientAppCheck.haveClientApp()) {
                fd.setFileOpener((FileOpener)ClientApp.app());
            } else {
                fd.setFileOpener((FileOpener)OptionsDirectoryPanel.this);
            }
            fd.setStartDir(startDir);
            this.setCursor(Cursor.getDefaultCursor());
            fd.setVisible(true);
            if (fd.isCanceled()) {
                return;
            }
            Identifier id = fd.getIdentifier();
            this._dirTxt.setText(id.getPath());
        }
    }
}

