/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.properties.HECGlobalProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJIntegerField;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class OptionsGeneralPanel
extends DefaultJPanel {
    RmaJCheckBox showConfirmExitCB;
    RmaJCheckBox openLastWatershedCB;
    private RmaJDecimalField _tooltipDelayFld;
    private RmaJIntegerField _watershedMenuCntFld;

    public OptionsGeneralPanel() {
        this.buildControls();
    }

    private void buildControls() {
        this.setLayout(new BorderLayout());
        JPanel tempPanel = new JPanel(new GridBagLayout());
        tempPanel.setBorder(BorderFactory.createTitledBorder("Settings:"));
        this.add(tempPanel, "Center");
        this.showConfirmExitCB = new RmaJCheckBox("Show Confirm On Exit");
        this.showConfirmExitCB.setMnemonic('S');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        tempPanel.add((Component)this.showConfirmExitCB, gbc);
        this.openLastWatershedCB = new RmaJCheckBox("Reload last Watershed at Startup");
        this.openLastWatershedCB.setMnemonic('R');
        gbc = new GridBagConstraints();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        tempPanel.add((Component)this.openLastWatershedCB, gbc);
        JLabel label = new JLabel("Recent Watershed Menu Count:");
        label.setDisplayedMnemonic('W');
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        tempPanel.add((Component)label, gbc);
        this._watershedMenuCntFld = new RmaJIntegerField();
        this._watershedMenuCntFld.setToolTipText("This setting specifies the number of recent watersheds that will be listed at the bottom of the File menu. Valid values are 0 - 20. Blank will return the setting to the default of 5");
        this._watershedMenuCntFld.setColumns(10);
        this._watershedMenuCntFld.setMinValue(0);
        label.setLabelFor((Component)this._watershedMenuCntFld);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        tempPanel.add((Component)this._watershedMenuCntFld, gbc);
        label = new JLabel("Tooltip Display Time (msec):");
        label.setDisplayedMnemonic('T');
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        tempPanel.add((Component)label, gbc);
        this._tooltipDelayFld = new RmaJDecimalField();
        this._tooltipDelayFld.setColumns(10);
        this._tooltipDelayFld.setMinValue(0.0);
        this._tooltipDelayFld.setToolTipText("This is how long a tool tip will display unless you move the cursor away.");
        label.setLabelFor((Component)this._tooltipDelayFld);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        tempPanel.add((Component)this._tooltipDelayFld, gbc);
        label = new JLabel();
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.01;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        tempPanel.add((Component)label, gbc);
    }

    public void fillPanel() {
        int delay;
        this.showConfirmExitCB.setSelected(ClientApp.app().getShowConfirmOnExit());
        this.openLastWatershedCB.setSelected(ClientApp.app().getOpenLastWatershed());
        this._watershedMenuCntFld.setValue(ClientApp.app().getWorkspaceSaveNumber());
        HECGlobalProperties properties = ClientApp.app().getGlobalProperties();
        String delayStr = properties.getProp("client.tooltip.delay");
        if (delayStr != null && RMAConst.isValidValue((int)(delay = RMAIO.parseInt((String)delayStr)))) {
            this._tooltipDelayFld.setValue((double)delay / 1000.0);
            return;
        }
        delay = ToolTipManager.sharedInstance().getDismissDelay();
        this._tooltipDelayFld.setValue(delay);
    }

    public void refresh() {
    }

    public boolean savePanel() {
        ClientApp.app().setShowConfirmOnExit(this.showConfirmExitCB.isSelected());
        ClientApp.app().setOpenLastWatershed(this.openLastWatershedCB.isSelected());
        ClientApp.app().setWorkspaceSaveNumber(this._watershedMenuCntFld.getValueUndefined());
        double val = this._tooltipDelayFld.getValue();
        if (RMAConst.isValidValue((double)val)) {
            int msVal = (int)(val * 1000.0);
            ToolTipManager.sharedInstance().setDismissDelay(msVal);
            HECGlobalProperties properties = ClientApp.app().getGlobalProperties();
            properties.setProp("client.tooltip.delay", String.valueOf(msVal));
        }
        return true;
    }
}

