/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.PropertyJTabbedPanel;
import hec.clientapp.model.SimulationRun;
import hec.map.MapGlyph;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTabbedPane;
import rma.util.RMAIO;

public class PropertyJDialog
extends RmaJDialog
implements ButtonCmdPanelListener {
    private SimulationRun alt;
    private ButtonCmdPanel _btnPanel = new ButtonCmdPanel(14);
    private RmaJTabbedPane _propTabPane = new RmaJTabbedPane();

    public PropertyJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.setSize(400, 400);
        this.setDefaultSize(400, 400);
        this.setLocation();
        this.setTitle("Schematic Display Properties");
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel jPNL_propTabPane = new JPanel(new GridBagLayout());
        jPNL_propTabPane.add((Component)this._propTabPane, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)new JSeparator(), new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jPNL_propTabPane, new RmaGridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this._btnPanel, new RmaGridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._btnPanel.addCmdPanelListener((ButtonCmdPanelListener)this);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public void buttonCmdActionPerformed(ActionEvent e) {
        if (e.getID() == 8) {
            this.cmdOK_Action();
        } else if (e.getID() == 2) {
            this.cmdApply_Action();
        } else if (e.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public void cmdOK_Action() {
        if (this._propTabPane.isModified()) {
            this.saveForm();
        }
        this.window_Closing();
    }

    public void cmdApply_Action() {
        if (this._propTabPane.isModified()) {
            this.saveForm();
        }
        ClientApp.app();
        ClientApp.frame().getMapPanel().paintMap();
    }

    public void cmdCancel_Action() {
        if (this._propTabPane.isModified()) {
            int retValue = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Schematic Display Properties Has Changed! Save before closing?");
            if (retValue == 2) {
                return;
            }
            if (retValue == 0) {
                this.saveForm();
            } else if (retValue == 1) {
                // empty if block
            }
        }
        this.window_Closing();
    }

    public void window_Closing() {
        Component[] c = this._propTabPane.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof PropertyJTabbedPanel)) continue;
            ((PropertyJTabbedPanel)((Object)c[i])).setListener(null, false);
        }
        this.setVisible(false);
    }

    public boolean fillForm() {
        boolean built = false;
        built = this.createDefaultTabbedPane();
        if (this.createOtherTabbedPanes() || built) {
            this._propTabPane.setModified(false);
            built = true;
        }
        return built;
    }

    private boolean createDefaultTabbedPane() {
        boolean built = false;
        boolean addrss = false;
        boolean addras = false;
        boolean addfia = false;
        List v = ClientApp.frame().getMapPanel().managerGlyphList();
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Object glyph = v.get(i);
            if (this.glyphInstanceof(glyph, "hec.rss.client.RssSystemGlyph")) {
                addrss = true;
                continue;
            }
            if (this.glyphInstanceof(glyph, "hec.ras.client.RasSystemGlyph")) {
                addras = true;
                continue;
            }
            if (this.glyphInstanceof(glyph, "hec.fia.client.FiaSystemGlyph")) {
                addfia = true;
                continue;
            }
            if (!this.glyphInstanceof(glyph, "wcds.cavi.client.ForecastAltGlyph")) continue;
            Vector v2 = ((MapGlyph)glyph).glyphVector();
            size = v2.size();
            for (int j = 0; j < size; ++j) {
                glyph = v2.get(j);
                if (this.glyphInstanceof(glyph, "hec.rss.client.RssSystemGlyph")) {
                    addrss = true;
                    continue;
                }
                if (this.glyphInstanceof(glyph, "hec.ras.client.RasSystemGlyph")) {
                    addras = true;
                    continue;
                }
                if (!this.glyphInstanceof(glyph, "hec.fia.client.FiaSystemGlyph")) continue;
                addfia = true;
            }
        }
        if (addrss) {
            PropertyJTabbedPanel panel = new PropertyJTabbedPanel("ResSim");
            if (panel != null) {
                this._propTabPane.addTab("ResSim", null, (Component)((Object)panel));
                panel.setListener("ResSim", true);
            } else {
                addrss = false;
            }
        }
        if (addras) {
            PropertyJTabbedPanel panel = new PropertyJTabbedPanel("RAS");
            if (panel != null) {
                this._propTabPane.addTab("RAS", null, (Component)((Object)panel));
                panel.setListener("RAS", true);
            } else {
                addras = false;
            }
        }
        if (addfia) {
            PropertyJTabbedPanel panel = new PropertyJTabbedPanel("FIA");
            if (panel != null) {
                this._propTabPane.addTab("FIA", null, (Component)((Object)panel));
                panel.setListener("FIA", true);
            } else {
                addfia = false;
            }
        }
        if (addrss || addras || addfia) {
            built = true;
        }
        return built;
    }

    private boolean glyphInstanceof(Object glyph, String glyphClass) {
        Class<?> cls;
        try {
            cls = Class.forName(glyphClass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("glyphInstanceof: ClassNotFoundException " + e);
            return false;
        }
        return cls.isInstance(glyph);
    }

    private boolean createOtherTabbedPanes() {
        ClientApp.app();
        ModeDrawingAttributeSet modeDas = ModeDrawingAttributeSet.getModeAttributeSet((String)ClientApp.frame().getCurrentMode().toString());
        ModelDrawingAttributeSet[] modelDas = modeDas.getAttributeSets();
        boolean haveNonDefaultTab = false;
        if (modelDas.length < 1) {
            return haveNonDefaultTab;
        }
        for (int i = 0; i < modelDas.length; ++i) {
            PropertyJTabbedPanel panel;
            String name = modelDas[i].getName();
            if (name.equals("ResSim") || name.equals("FIA") || name.equals("RAS") || (panel = new PropertyJTabbedPanel(name)) == null) continue;
            this._propTabPane.addTab(name, null, (Component)((Object)panel));
            panel.setListener(name, true);
            haveNonDefaultTab = true;
        }
        return haveNonDefaultTab;
    }

    public void addTabbedPane(String tabName) {
        this._propTabPane.addTab(tabName, null, (Component)((Object)new PropertyJTabbedPanel(tabName)));
    }

    private void saveForm() {
        Component[] c = this._propTabPane.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof PropertyJTabbedPanel)) continue;
            ((PropertyJTabbedPanel)((Object)c[i])).savePanel();
        }
        this._propTabPane.setModified(false);
    }

    public static void main(String[] args) {
        PropertyJDialog dlg = new PropertyJDialog(null, true);
        dlg.fillForm();
        dlg.setVisible(true);
        System.exit(0);
    }
}

