/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.event.AttributeChangedListener;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import rma.swing.RmaGridBagConstraints;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJCompTitledPanel;
import rma.swing.RmaJDialog;

public class PropertyJTabbedPanel
extends RmaJCompTitledPanel
implements AttributeChangedListener {
    private String _modeName;
    private String _drawPropDialogClassName;
    private Vector _mnemonicVector = new Vector();
    private TPanel _tabPanel;
    ModelDrawingAttributeSet _modelDas;

    public PropertyJTabbedPanel(String tabName) {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setName(tabName);
        JButton drawProp_Button = new JButton("Drawing Properties");
        this._tabPanel = new TPanel();
        ClientApp.app();
        ClientMode mode = ClientApp.frame().getCurrentMode();
        this._modeName = mode.toString();
        ModeDrawingAttributeSet modeDas = ModeDrawingAttributeSet.getModeAttributeSet((String)this._modeName);
        this._modelDas = modeDas.getModelAttributeSet(tabName);
        if (this._modelDas == null) {
            System.out.println("ModelDrawingAttributeSet is null");
        }
        Hashtable h = this._modelDas.getAttributes();
        int y_pos = 0;
        int x_pos = 0;
        int width = 1;
        int colCap = 5;
        if (h.size() > 0) {
            String[] list = new String[h.size()];
            Enumeration e = h.keys();
            list[0] = e.nextElement().toString();
            Object tmp2 = null;
            int j = 0;
            for (int i = 1; i < h.size(); ++i) {
                String tmp1 = e.nextElement().toString();
                for (j = 0; j < i && tmp1.compareTo(list[j]) >= 0; ++j) {
                }
                if (j < i) {
                    for (int k = i; k > j; --k) {
                        list[k] = list[k - 1];
                    }
                }
                list[j] = tmp1;
            }
            for (int x = 0; x < h.size(); ++x) {
                String key = list[x];
                Boolean shown = (Boolean)h.get(key);
                RmaJCheckBox ckb = new RmaJCheckBox(key.toString(), shown.booleanValue());
                this._tabPanel.add((Component)ckb, new RmaGridBagConstraints(x_pos, y_pos++, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
                if (y_pos <= colCap - 1) continue;
                y_pos = 0;
                ++x_pos;
                ++width;
            }
        }
        if (this._modelDas.getDrawPropDialogClassname() != null) {
            this._tabPanel.add((Component)drawProp_Button, new RmaGridBagConstraints(0, colCap, width, 1, 0.0, 1.0, 15, 0, new Insets(5, 5, 5, 5), 0, 0));
        } else {
            this._tabPanel.add((Component)new JLabel(), new RmaGridBagConstraints(0, colCap, width, 1, 0.0, 1.0, 15, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.getContentPane().add((Component)this._tabPanel, new RmaGridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 0, 5), 0, 0));
        RmaJCheckBox model_CKB = new RmaJCheckBox(tabName, this._modelDas.isShown());
        this.setTitleComponent((JComponent)model_CKB);
        this.setTransmittingAllowed(true);
        this.setTransmitter(this._tabPanel);
        drawProp_Button.setMnemonic('D');
        this._tabPanel.setEnabled(this._modelDas.isShown());
        this._modelDas.addAttributeChangedListener((AttributeChangedListener)this);
        model_CKB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PropertyJTabbedPanel.this._tabPanel.setEnabled(e.getStateChange() == 1);
            }
        });
        String dpdName = this._modelDas.getDrawPropDialogClassname();
        if (dpdName == null) {
            drawProp_Button.setEnabled(false);
        } else {
            drawProp_Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertyJTabbedPanel.this.drawProp_Button_Action(PropertyJTabbedPanel.this.getName());
                }
            });
        }
    }

    public boolean savePanel() {
        JComponent tc = this.getTitleComponent();
        System.out.println("Save model Attributes " + this._modelDas.getName());
        if (this._modelDas == null) {
            return false;
        }
        if (tc instanceof RmaJCheckBox) {
            this._modelDas.setShown(((RmaJCheckBox)tc).isSelected());
        }
        Component[] c = this._tabPanel.getComponents();
        RmaJCheckBox propCB = null;
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof JCheckBox)) continue;
            propCB = (RmaJCheckBox)c[i];
            System.out.println(propCB.getText() + " " + propCB.isSelected());
            this._modelDas.setAttribute(propCB.getText(), propCB.isSelected());
        }
        return true;
    }

    public void attributeChanged(String model, String attrName, boolean shown) {
        if (!model.equals(this._modelDas.getName())) {
            return;
        }
        JCheckBox ckb = null;
        if (attrName.equals("shown")) {
            ckb = (JCheckBox)this.getTitleComponent();
        } else {
            Component[] c = this._tabPanel.getComponents();
            for (int i = 0; i < c.length; ++i) {
                if (!(c[i] instanceof JCheckBox) || !((JCheckBox)c[i]).getText().equals(attrName)) continue;
                ckb = (JCheckBox)c[i];
                break;
            }
        }
        if (ckb != null && shown != ckb.isSelected()) {
            RmaJDialog dlg = (RmaJDialog)SwingUtilities.windowForComponent((Component)((Object)this));
            boolean modified = dlg.isModified();
            ckb.doClick();
            if (!modified) {
                dlg.setModified(false);
            }
        }
    }

    public void setListener(String model, boolean state) {
        if (state) {
            this._modelDas.addAttributeChangedListener((AttributeChangedListener)this);
            System.out.println("AttributeChangeListener Added");
        } else {
            this._modelDas.removeAttributeChangeListener((AttributeChangedListener)this);
            System.out.println("AttributeChangeListener Removed");
        }
    }

    private void drawProp_Button_Action(String model) {
        System.out.println("Drawing Properties Dialog Class Name " + this._modelDas.getDrawPropDialogClassname());
        ClientApp.app();
        this._modelDas.displayDrawPropDialogClass((Frame)((Object)ClientApp.frame()), false);
    }

    class TPanel
    extends JPanel {
        TPanel() {
            this.setLayout(new GridBagLayout());
        }

        @Override
        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            Component[] c = this.getComponents();
            for (int i = 0; i < c.length; ++i) {
                c[i].setEnabled(enable);
            }
        }
    }
}

