/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.io.RmiProgessLogFileWriter;
import hec.io.HecFile;
import hec.lang.HtmlAttributes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import mil.army.usace.hec.rmi.client.RMIProgressDisplay;
import mil.army.usace.hec.rmi.csinterface.RMIComputeCanceledCallback;
import rma.swing.RmaJFrame;
import rma.text.ColorFormatter;
import rma.util.RMAIO;

public class RMIProgressDialog
extends RmaJFrame
implements RMIProgressDisplay {
    public static final String CANCEL_COMPUTE_BUTTON_TEXT = "Stop Compute";
    Runnable _run = null;
    int _factor = 1;
    protected RmiProgessLogFileWriter _logWriter;
    Frame _parent;
    protected boolean _computeCanceled;
    protected String _backgroundColorString = "gray";
    String _warningColorString = "magenta";
    String _errorColorString = "red";
    String _textColorString = "black";
    Color _backgroundColor = UIManager.getColor("TextField.disabledBackground");
    Color _warningColor = Color.magenta;
    Color _errorColor = Color.red;
    Color _textColor = Color.black;
    Font _textAreaFont = null;
    JPopupMenu _popupMenu;
    SymAction lSymAction = new SymAction();
    private RMIComputeCanceledCallback _callback;
    protected int _numberTasks;
    protected int _currentTaskNumber = 0;
    JPanel _textAreaPanel;
    JPanel _bottomPanel;
    JButton _closeButton;
    JButton _button2;
    protected JTextPane _textAreaMessage;
    JLabel _label1;
    JProgressBar _taskProgressBar;
    JProgressBar _overAllProgressBar;
    protected JTextField _textFieldStatus;
    boolean fComponentsAdjusted = false;
    transient Thread _rmiThread = null;
    boolean _canceled = false;

    public RMIProgressDialog(Frame parent, String title, int numberTasks, boolean modal) {
        this(parent, modal);
        this._parent = parent;
        this.initDialog(title, numberTasks);
    }

    public RMIProgressDialog(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this._parent = parent;
        this.initDialog(title, 1);
    }

    public RMIProgressDialog(Frame parent, boolean modal) {
        this._parent = parent;
        this.initDialog("", 1);
    }

    protected void initDialog(String title, int numberTasks) {
        this._numberTasks = numberTasks;
        this.setDefaultCloseOperation(0);
        this.setTitle(title);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setSize(this.getInsets().left + this.getInsets().right + 430, this.getInsets().top + this.getInsets().bottom + 318);
        this._label1 = new JLabel("Message Output");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this._label1, gbc);
        this._textAreaPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        this._textAreaPanel.setLayout(gridBagLayout);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridheight = 2;
        gbc.weighty = 5.0;
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this._textAreaPanel, gbc);
        JScrollPane scrollPane = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, 300);
            }

            @Override
            public float getAlignmentX() {
                return 0.0f;
            }
        };
        scrollPane.setViewportBorder(new BevelBorder(1));
        this._textAreaMessage = new JTextPane();
        this._textAreaMessage.setEditable(false);
        this._textAreaMessage.setBackground(this._backgroundColor);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridheight = 2;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.insets = new Insets(0, 0, 0, 0);
        scrollPane.getViewport().add(this._textAreaMessage);
        this._textAreaPanel.add((Component)scrollPane, gbc);
        this._bottomPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        this._bottomPanel.setLayout(gridBagLayout);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 15;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this._bottomPanel, gbc);
        this._textFieldStatus = new JTextField();
        this._textFieldStatus.setEditable(false);
        this._textFieldStatus.setText("Status");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 15;
        gbc.insets = new Insets(5, 0, 0, 0);
        this._bottomPanel.add((Component)this._textFieldStatus, gbc);
        this._taskProgressBar = new JProgressBar(){

            @Override
            public void setValue(int val) {
                super.setValue(val == this.getMinimum() ? this.getMinimum() + 1 : val);
            }
        };
        this._taskProgressBar.setStringPainted(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.5;
        gbc.fill = 1;
        gbc.anchor = 15;
        gbc.insets = new Insets(5, 0, 0, 0);
        this._bottomPanel.add((Component)this._taskProgressBar, gbc);
        this._taskProgressBar.setMinimum(0);
        this._taskProgressBar.setValue(this._taskProgressBar.getMinimum() + 1);
        this._overAllProgressBar = new JProgressBar(){

            @Override
            public void setValue(int val) {
                super.setValue(val == this.getMinimum() ? this.getMinimum() + 1 : val);
            }
        };
        int gridy = 3;
        this._overAllProgressBar.setStringPainted(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.5;
        gbc.fill = 1;
        gbc.anchor = 15;
        gbc.insets = new Insets(5, 0, 0, 0);
        this._bottomPanel.add((Component)this._overAllProgressBar, gbc);
        this._overAllProgressBar.setMinimum(0);
        this._overAllProgressBar.setValue(this._overAllProgressBar.getMinimum() + 1);
        if (this._numberTasks == 1) {
            this._overAllProgressBar.setVisible(false);
        }
        this._closeButton = new JButton("Close");
        this._closeButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 15;
        gbc.insets = new Insets(0, 0, 10, 0);
        this._bottomPanel.add((Component)this._closeButton, gbc);
        this._button2 = new JButton("Save Compute Messages");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = gridy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 15;
        gbc.insets = new Insets(0, 0, 10, 0);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._closeButton.addActionListener(this.lSymAction);
        this._button2.addActionListener(this.lSymAction);
        this._closeButton.setFocusable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (!RMIProgressDialog.this.isVisible()) {
                    return;
                }
                if (RMAIO.getOSType() != 2) {
                    RMIProgressDialog.this.toFront();
                }
            }
        });
        this._textAreaMessage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    RMIProgressDialog.this.popupMenu(e.getPoint());
                }
            }
        });
        this.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    RMIProgressDialog.this.rootPopupMenu(e.getPoint());
                }
            }
        });
    }

    public void setRmiCall(Runnable run) {
        this._run = run;
    }

    public void setTextAreaFont(Font f) {
        this._textAreaFont = f;
    }

    public Font getTextAreaFont(Font f) {
        return this._textAreaFont;
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public void startRun(boolean b) {
        this.setVisible(b);
    }

    public void setVisible(boolean b) {
        if (b) {
            this._computeCanceled = false;
            ClientApp.frame().setCursor(new Cursor(3));
            if (!this.isVisible()) {
                this.setLocationRelativeTo(this._parent);
            }
            this._textAreaMessage.setText("");
            super.setVisible(true);
            if (this._run != null) {
                this._canceled = false;
                if (this._rmiThread != null) {
                    this._rmiThread.stop();
                    this._rmiThread = null;
                }
                this._rmiThread = new Thread(this._run);
                String threadname = this._rmiThread.getName();
                this._rmiThread.setName("RMIProgressDialog " + threadname);
                this._rmiThread.setPriority(4);
                this._rmiThread.start();
                if (this._numberTasks < 2) {
                    this._closeButton.setText("Close");
                }
                this._closeButton.requestFocus();
                ClientApp.frame().setCursor(new Cursor(0));
            }
        } else {
            this.cleanUp();
            super.setVisible(false);
        }
    }

    protected void cleanUp() {
        this._textAreaMessage.setText("");
        this._run = null;
        this._callback = null;
        this._rmiThread = null;
        if (this._logWriter != null) {
            this._logWriter.close();
            this._logWriter = null;
        }
    }

    void RMIProgressDialog_WindowClosing(WindowEvent event) {
        this.closeButtonAction();
    }

    public void setButton2Label(String label) {
        this._button2.setLabel(label);
    }

    public void buttonIsVisible(boolean visible) {
        this._closeButton.setVisible(visible);
        this._button2.setVisible(visible);
    }

    public void printMessage(String s) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setForeground(attrs, this._textColor);
        StyleConstants.setBackground(attrs, this._backgroundColor);
        this.displayMessage(s, attrs, this._textAreaMessage.getDocument());
    }

    public void printErrorMessage(String s) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setForeground(attrs, this._errorColor);
        StyleConstants.setBackground(attrs, this._backgroundColor);
        this.displayMessage(s, attrs, this._textAreaMessage.getDocument());
        if (!this._closeButton.isVisible()) {
            this._closeButton.setVisible(true);
        }
        System.out.println("ERROR:" + s);
    }

    public void printWarningMessage(String s) {
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        StyleConstants.setForeground(attrs, this._warningColor);
        StyleConstants.setBackground(attrs, this._backgroundColor);
        StyleConstants.setBold(attrs, true);
        this.displayMessage(s, attrs, this._textAreaMessage.getDocument());
        if (!this._closeButton.isVisible()) {
            this._closeButton.setVisible(true);
        }
        System.out.println("WARNING:" + s);
    }

    public void printLogMessage(String s) {
        this.write2log(s, null);
    }

    protected void displayMessage(String msg, SimpleAttributeSet attrs, Document doc) {
        Font f = this._textAreaFont != null ? this._textAreaFont : (Font)UIManager.get("TextField.font");
        StyleConstants.setFontFamily(attrs, f.getFamily());
        StyleConstants.setFontSize(attrs, f.getSize() + 1);
        boolean overWrite = false;
        SimpleAttributeSet sAttrs = attrs;
        if (msg == null || ((String)msg).length() == 0) {
            msg = "\n";
        } else if (((String)msg).charAt(((String)msg).length() - 1) != '\n') {
            msg = (String)msg + "\n";
        }
        if (((String)msg).charAt(0) == '\b') {
            msg = ((String)msg).substring(1);
            overWrite = true;
        }
        if (doc == null) {
            doc = this._textAreaMessage.getDocument();
        }
        final Document fDoc = doc;
        boolean foverWrite = overWrite;
        Object sMsg = msg;
        this.write2log((String)msg, attrs);
        Runnable run = new Runnable(){
            final /* synthetic */ String val$sMsg;
            final /* synthetic */ AttributeSet val$sAttrs;
            {
                this.val$sMsg = string;
                this.val$sAttrs = attributeSet;
            }

            @Override
            public void run() {
                try {
                    int len = fDoc.getLength();
                    fDoc.insertString(len, this.val$sMsg, this.val$sAttrs);
                }
                catch (BadLocationException ex) {
                    System.out.println(this.val$sMsg);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void printStatus(String s) {
        final String text = s;
        this.write2log(s, null);
        if (this._computeCanceled) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RMIProgressDialog.this._textFieldStatus.setText(text);
            }
        });
    }

    public void setProgressFactor(int i) {
        if (i == 0) {
            i = 1;
        }
        this._factor = i;
    }

    public void setProgress(int i) {
        final int p = i;
        if (i < 0) {
            i = 0;
        }
        if (i > 100) {
            i = 100;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (RMIProgressDialog.this._factor == 1) {
                        int progress = p;
                        if (progress > 100) {
                            progress = 100;
                        }
                        RMIProgressDialog.this._taskProgressBar.setValue(p);
                    } else {
                        int progress = RMIProgressDialog.this._taskProgressBar.getValue();
                        int increment = p / RMIProgressDialog.this._factor;
                        if (increment == 0) {
                            increment = 1;
                        }
                        RMIProgressDialog.this._taskProgressBar.setValue(progress += increment);
                        if (RMIProgressDialog.this._numberTasks > 1 && RMIProgressDialog.this._currentTaskNumber > 0) {
                            int currentProgress = (progress + (RMIProgressDialog.this._currentTaskNumber - 1) * 100) / RMIProgressDialog.this._numberTasks;
                            RMIProgressDialog.this._overAllProgressBar.setValue(currentProgress);
                            RMIProgressDialog.this._overAllProgressBar.setString(currentProgress + "% Overall");
                            RMIProgressDialog.this._taskProgressBar.setString(progress + "% Task");
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void setNumberTasks(int numberTasks) {
        this._numberTasks = numberTasks;
        if (this._numberTasks == 1) {
            this._overAllProgressBar.setVisible(false);
        } else if (this._numberTasks > 1) {
            this._overAllProgressBar.setVisible(true);
            this._closeButton.setText("Cancel Compute");
            this._closeButton.setEnabled(true);
        }
    }

    public void setTaskNumber(int taskNumber) {
        this._currentTaskNumber = taskNumber;
        if (taskNumber >= this._overAllProgressBar.getMaximum() && this._numberTasks > 1) {
            this._overAllProgressBar.setValue(100);
            if (this._numberTasks <= 100) {
                this._overAllProgressBar.setString("100% Overall");
            }
        } else if (this._numberTasks > 1) {
            this.updateOverallProgress();
        }
        if (this._numberTasks > 1 && this._currentTaskNumber > 0) {
            EventQueue.invokeLater(() -> this.updateOverallProgress());
        }
    }

    private void updateOverallProgress() {
        this._overAllProgressBar.setValue(this._currentTaskNumber);
        if (this._numberTasks <= 100 && this._numberTasks > 1) {
            double percent = (double)this._currentTaskNumber / (double)this._overAllProgressBar.getMaximum();
            System.out.println("--->overall progress " + this._currentTaskNumber + " " + (percent *= 100.0) + "%");
            this._overAllProgressBar.setString((int)percent + "% Overall");
        }
    }

    public void setLineAttributes(HtmlAttributes a) {
        if (this._logWriter != null) {
            this._logWriter.setLineAttributes(a);
        }
    }

    public void printTableRow(boolean isHeader, String tableRow) {
        if (this._logWriter != null) {
            this._logWriter.printTableRow(isHeader, tableRow);
        }
    }

    public void printSeparator() {
        if (this._logWriter != null) {
            this._logWriter.printSeparator();
        }
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void workComplete() {
        this._rmiThread = null;
        if (this._closeButton.isVisible()) {
            this._closeButton.setText("Close");
            if (this._computeCanceled) {
                this._computeCanceled = false;
                this.printStatus("Compute Canceled");
            }
            this._closeButton.setEnabled(true);
        } else {
            this.setVisible(false);
        }
        if (this._logWriter != null) {
            this._logWriter.close();
            this._logWriter = null;
        }
    }

    void closeButtonAction() {
        String text = this._closeButton.getText();
        if ((text.equals(CANCEL_COMPUTE_BUTTON_TEXT) || text.equalsIgnoreCase("Cancel Compute")) && this._callback != null) {
            try {
                this._callback.setComputeCanceled(true);
                this.printStatus("Waiting for compute to cancel...");
                this._computeCanceled = true;
                this._closeButton.setEnabled(false);
            }
            catch (RemoteException re) {
                System.out.println("closeButton_Action: RMI Error notifing compute cancel callback to cancel " + re);
            }
            this._closeButton.setText("Close");
        } else if (text.equals("Close") && !this._computeCanceled) {
            this.setVisible(false);
        } else {
            ClientApp.frame().setCursor(new Cursor(0));
            this._canceled = true;
        }
    }

    void button2_Action(ActionEvent event) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int retval = chooser.showSaveDialog((Component)((Object)this));
        if (retval == 0) {
            File theFile = chooser.getSelectedFile();
            if (theFile == null) {
                return;
            }
            this.saveFile(theFile);
        }
    }

    boolean saveFile(File theFile) {
        if (theFile == null) {
            return false;
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(theFile));
            out.write(this._textAreaMessage.getText());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println("Failed to save file " + theFile.getName() + " " + e);
            JOptionPane.showMessageDialog(null, "Failed to save file", "Save Error", 0);
        }
        return true;
    }

    public void setLogFile(HecFile logFile) {
        if (this._logWriter != null) {
            this._logWriter.close();
        }
        this._logWriter = new RmiProgessLogFileWriter(logFile, this._backgroundColorString);
    }

    protected void write2log(String msg, SimpleAttributeSet attrs) {
        this.write2Log(msg, attrs, this._logWriter);
    }

    protected void write2Log(String msg, SimpleAttributeSet attrs, RmiProgessLogFileWriter logWriter) {
        if (logWriter != null) {
            if (attrs != null && logWriter.usingHtmlForLogging()) {
                HtmlAttributes ha = logWriter.getLineAttributes();
                String color = ha.getLineColor();
                int size = ha.getFontSize();
                Color c = StyleConstants.getForeground(attrs);
                if (!c.equals(this._textColor)) {
                    if (c.equals(this._errorColor)) {
                        ha.setLineColor(this._errorColorString);
                        ha.setFontSize(size + 2);
                    } else if (c.equals(this._warningColor)) {
                        ha.setLineColor(this._warningColorString);
                        ha.setFontSize(size + 1);
                    }
                    logWriter.setLineAttributes(ha);
                    logWriter.write(msg);
                    ha.setLineColor(color);
                    ha.setFontSize(size);
                    logWriter.setLineAttributes(ha);
                } else {
                    ha.setLineColor(this._textColorString);
                    logWriter.setLineAttributes(ha);
                    logWriter.write(msg);
                }
            } else {
                logWriter.write(msg);
            }
        }
    }

    public void setBackground(String color) {
        this._backgroundColorString = color;
        Color c = ColorFormatter.colorForName((String)color);
        if (c != null) {
            this._backgroundColor = c;
        }
        if (this._backgroundColor == Color.gray) {
            this._backgroundColor = Color.lightGray;
        }
        this._textAreaMessage.setBackground(this._backgroundColor);
    }

    public void setWarningColor(String color) {
        this._warningColorString = color;
        Color c = ColorFormatter.colorForName((String)color);
        if (c != null) {
            this._warningColor = c;
        }
    }

    public void setErrorColor(String color) {
        this._errorColorString = color;
        Color c = ColorFormatter.colorForName((String)color);
        if (c != null) {
            this._errorColor = c;
        }
    }

    public void setTextColor(String color) {
        this._textColorString = color;
        Color c = ColorFormatter.colorForName((String)color);
        if (c != null) {
            this._textColor = c;
        }
    }

    protected void popupMenu(Point p) {
        if (this._popupMenu == null) {
            this._popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Select All");
            menuItem.addActionListener(this.lSymAction);
            this._popupMenu.add(menuItem);
            menuItem = new JMenuItem("Copy");
            menuItem.addActionListener(this.lSymAction);
            this._popupMenu.add(menuItem);
            menuItem = new JMenuItem("Save Compute Messages");
            menuItem.addActionListener(this.lSymAction);
            this._popupMenu.add(menuItem);
        }
        this._popupMenu.show(this._textAreaMessage, (int)p.getX(), (int)p.getY());
    }

    protected void rootPopupMenu(Point p) {
        if (!this.isAlwaysOnTopSupported()) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("Always On Top", this.isAlwaysOnTop());
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)obj;
                RMIProgressDialog.this.setAlwaysOnTop(menuItem.isSelected());
            }
        });
        popupMenu.add(menuItem);
        popupMenu.show(this.getContentPane(), (int)p.getX(), (int)p.getY());
    }

    public void setComputeCanceledCallback(RMIComputeCanceledCallback callback) {
        if (callback != null) {
            this._closeButton.setText(CANCEL_COMPUTE_BUTTON_TEXT);
            this._closeButton.setEnabled(true);
        } else if (this._numberTasks > 1) {
            this._closeButton.setText("Cancel Compute");
            this._closeButton.setEnabled(true);
        } else {
            this._closeButton.setText("Close");
            this._closeButton.setEnabled(false);
        }
        this._callback = callback;
    }

    public void setCanceledComputeFinished(boolean success) {
        if (success) {
            this._computeCanceled = false;
            this.printStatus("Compute Canceled");
            this._closeButton.setEnabled(true);
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == RMIProgressDialog.this._closeButton) {
                RMIProgressDialog.this.closeButtonAction();
            } else if (object == RMIProgressDialog.this._button2) {
                RMIProgressDialog.this.button2_Action(event);
            } else if (object instanceof JMenuItem) {
                JMenuItem menu = (JMenuItem)object;
                if ("Select All".equals(menu.getText())) {
                    RMIProgressDialog.this._textAreaMessage.selectAll();
                } else if ("Copy".equals(menu.getText())) {
                    RMIProgressDialog.this._textAreaMessage.copy();
                } else if ("Save Compute Messages".equals(menu.getText())) {
                    RMIProgressDialog.this.button2_Action(event);
                }
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == RMIProgressDialog.this) {
                RMIProgressDialog.this.RMIProgressDialog_WindowClosing(event);
            }
        }
    }
}

