/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.io.RmiProgessLogFileWriter;
import hec.io.HecFile;
import hec.lang.HtmlAttributes;
import java.awt.Color;
import mil.army.usace.hec.rmi.client.RMIProgressDisplay;
import mil.army.usace.hec.rmi.csinterface.RMIComputeCanceledCallback;
import rma.text.ColorFormatter;

public class RMIProgressFile
implements RMIProgressDisplay {
    Runnable _run = null;
    int _factor = 1;
    RmiProgessLogFileWriter _logWriter;
    transient Thread _rmiThread = null;
    String _backgroundColorString = "gray";
    String _warningColorString = "yellow";
    String _errorColorString = "red";
    String _textColorString = "black";
    Color _warningColor = Color.yellow;
    Color _errorColor = Color.red;
    Color _textColor = Color.black;

    public void setProgress(int i) {
        this.write2log("Progress " + i + "%", true, this._textColorString);
    }

    public void printMessage(String s) {
        this.write2log(s, true, this._textColorString);
    }

    public void setProgressFactor(int i) {
    }

    public void setNumberTasks(int numberTasks) {
    }

    public void setTaskNumber(int taskNumber) {
    }

    public void printStatus(String s) {
        this.write2log("Status : " + s, true, this._textColorString);
    }

    public void printErrorMessage(String s) {
        this.write2log("ERROR: " + s, true, this._errorColorString);
    }

    public void printWarningMessage(String s) {
        this.write2log("WARNING: " + s, true, this._warningColorString);
    }

    public void printLogMessage(String s) {
        this.write2log(s, false, this._textColorString);
    }

    public void workComplete() {
        if (this._logWriter != null) {
            this._logWriter.close();
            this._logWriter = null;
        }
    }

    public void setRmiCall(Runnable run) {
        this._run = run;
    }

    public void startRun(boolean b) {
        if (b) {
            try {
                if (this._run != null) {
                    this._run.run();
                }
            }
            catch (Exception e) {
                System.out.println("startRun:exception " + e);
                e.printStackTrace();
            }
        }
    }

    public void setLineAttributes(HtmlAttributes a) {
        if (this._logWriter != null) {
            this._logWriter.setLineAttributes(a);
        }
    }

    public void printTableRow(boolean isHeader, String tableRow) {
        if (this._logWriter != null) {
            this._logWriter.printTableRow(isHeader, tableRow);
        }
    }

    public void printSeparator() {
        if (this._logWriter != null) {
            this._logWriter.printSeparator();
        }
    }

    public void setLogFile(HecFile logFile) {
        if (this._logWriter != null) {
            this._logWriter.close();
        }
        this._logWriter = new RmiProgessLogFileWriter(logFile, this._backgroundColorString);
    }

    private void write2log(String msg, boolean echo2StdOut, String color) {
        if (this._logWriter != null) {
            if (this._logWriter.usingHtmlForLogging()) {
                HtmlAttributes ha = this._logWriter.getLineAttributes();
                String saveColor = ha.getLineColor();
                ha.setLineColor(color);
                this._logWriter.setLineAttributes(ha);
                this._logWriter.write(msg);
                ha.setLineColor(saveColor);
                this._logWriter.setLineAttributes(ha);
            } else {
                this._logWriter.write(msg);
            }
        } else {
            System.out.println(msg);
        }
    }

    public void setBackground(String color) {
        this._backgroundColorString = color;
    }

    public void setWarningColor(String color) {
        this._warningColorString = color;
        Color c = ColorFormatter.colorForName((String)color);
        if (c != null) {
            this._warningColor = c;
        }
    }

    public void setErrorColor(String color) {
        this._errorColorString = color;
        Color c = ColorFormatter.colorForName((String)color);
        if (c != null) {
            this._errorColor = c;
        }
    }

    public void setTextColor(String color) {
        this._textColorString = color;
        Color c = ColorFormatter.colorForName((String)color);
        if (c != null) {
            this._textColor = c;
        }
    }

    @Deprecated
    public Thread getThread() {
        return this._rmiThread;
    }

    public void setComputeCanceledCallback(RMIComputeCanceledCallback callback) {
    }

    public void setCanceledComputeFinished(boolean success) {
    }
}

