/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import hec.lang.UserId;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTextField;
import rma.swing.list.RmaListModel;

public class RemoteFileChooser
extends RmaJDialog {
    public static final int OPEN = 0;
    public static final int SAVE = 1;
    public static String sep = "/";
    protected boolean _ok = false;
    protected int _mode;
    protected Vector _idVector = new Vector();
    protected ClientWorkspace _Workspace = null;
    protected RmiFileManager _fmi = null;
    protected String _stringFilter = null;
    protected String _startingPath = "";
    protected Identifier _chosenId = null;
    protected boolean _isRemote = true;
    JLabel labelWorkspace;
    RmaJTextField textFieldWorkspace;
    JPanel panelLists;
    JList listFiles;
    RmaJTextField textFieldSelectFile;
    JPanel panelButtons;
    JButton buttonOpen;
    JButton buttonCancel;

    public RemoteFileChooser(Dialog parent) {
        this(parent, true);
    }

    public RemoteFileChooser(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initControls();
    }

    public RemoteFileChooser(Frame parent) {
        this(parent, true);
    }

    public RemoteFileChooser(Frame parent, boolean modal) {
        super(parent, modal);
        this.initControls();
    }

    private void initControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(this.getInsets().left + this.getInsets().right + 464, this.getInsets().top + this.getInsets().bottom + 425);
        this.labelWorkspace = new JLabel("Workspace Name", 4);
        this.labelWorkspace.setDisplayedMnemonic('W');
        this.labelWorkspace.setBounds(this.getInsets().left + 2, this.getInsets().top + 2, 113, 23);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.labelWorkspace, gbc);
        this.textFieldWorkspace = new RmaJTextField();
        this.labelWorkspace.setLabelFor((Component)this.textFieldWorkspace);
        this.textFieldWorkspace.setEditable(false);
        this.textFieldWorkspace.setText("name of Workspace");
        this.textFieldWorkspace.setBounds(this.getInsets().left + 119, this.getInsets().top + 2, 343, 23);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.textFieldWorkspace, gbc);
        this.panelLists = new JPanel(new GridBagLayout());
        this.panelLists.setBounds(this.getInsets().left + 2, this.getInsets().top + 29, 460, 336);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.panelLists, gbc);
        this.listFiles = new JList(new RmaListModel(true));
        this.listFiles.setSelectionMode(0);
        this.listFiles.setBounds(2, 2, 456, 332);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        JScrollPane sp = new JScrollPane(this.listFiles);
        this.panelLists.add((Component)sp, gbc);
        this.textFieldSelectFile = new RmaJTextField();
        this.textFieldSelectFile.setBounds(this.getInsets().left + 2, this.getInsets().top + 369, 460, 23);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.textFieldSelectFile, gbc);
        this.panelButtons = new JPanel(new GridBagLayout());
        this.panelButtons.setBounds(this.getInsets().left + 2, this.getInsets().top + 396, 460, 27);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.panelButtons, gbc);
        this.buttonOpen = new JButton("Open");
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.panelButtons.add((Component)this.buttonOpen, gbc);
        this.buttonCancel = new JButton("Cancel");
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.panelButtons.add((Component)this.buttonCancel, gbc);
        this.setTitle("RemoteFileChooser");
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this.setOKButtonSearchString(this.buttonOpen.getText());
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        SymAction lSymAction = new SymAction();
        this.buttonOpen.addActionListener(lSymAction);
        this.buttonCancel.addActionListener(lSymAction);
        this.textFieldSelectFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RemoteFileChooser.this.textFieldSelectManager_TextValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RemoteFileChooser.this.textFieldSelectManager_TextValueChanged();
            }
        });
        SymItem lSymItem = new SymItem();
        this.listFiles.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                RemoteFileChooser.this.listManagers_ItemStateChanged();
            }
        });
        SymMouse aSymMouse = new SymMouse();
        this.listFiles.addMouseListener(aSymMouse);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.fillDialog();
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        }
        super.setVisible(b);
    }

    void RemoteFileChooser_WindowClosing(WindowEvent event) {
        this.setVisible(false);
    }

    void buttonOpen_Action(ActionEvent event) {
        String idName = this.textFieldSelectFile.getText();
        if (idName.equals("")) {
            idName = (String)this.listFiles.getSelectedValue();
        }
        if (idName != null && !idName.equals("")) {
            this._chosenId = this.findId(idName);
        }
        if (this._chosenId != null) {
            this._ok = true;
            this.dispose();
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), "You must choose a File first.", "File Dialog Warning", 2);
        }
    }

    void buttonCancel_Action(ActionEvent event) {
        this._ok = false;
        this.dispose();
    }

    void textFieldSelectManager_TextValueChanged() {
    }

    void listManagers_ItemStateChanged() {
    }

    public boolean ok() {
        return this._ok;
    }

    public void setMode(int mode) {
        this._mode = mode;
        if (mode != 1) {
            this.textFieldSelectFile.setEditable(false);
        }
    }

    public void setWorkspace(ClientWorkspace wksp) {
        this._Workspace = wksp;
    }

    public Identifier getIdentifier() {
        return this._chosenId;
    }

    public void setFile(String stringFilter) {
        this._stringFilter = stringFilter;
    }

    public void setPath(String startingPath) {
        this._startingPath = startingPath;
    }

    public void fillDialog() {
        if (this._Workspace != null) {
            this.textFieldWorkspace.setText(this._Workspace.getName());
        } else {
            this.labelWorkspace.setVisible(false);
            this.textFieldWorkspace.setVisible(false);
        }
        this.textFieldSelectFile.setText("");
        StringTokenizer tokenizer = new StringTokenizer(this._stringFilter, ",");
        this._idVector.removeAllElements();
        RmiFileManager fm = this.getFileManager();
        while (tokenizer.hasMoreTokens()) {
            Vector v;
            String s = tokenizer.nextToken();
            if (this._Workspace != null) {
                v = this._isRemote ? this._Workspace.getRemoteFileIDList(this._startingPath, s) : this._Workspace.getLocalFileIDList(this._startingPath, s);
            } else {
                try {
                    if (fm != null) {
                        v = fm.getRemoteFileIDList(UserId.getUserId(), this._startingPath, s);
                    } else {
                        System.out.println("filLDialog: no FileManager!");
                        v = new Vector();
                    }
                }
                catch (RemoteException re) {
                    System.out.println("fillDialog: RMI Error getting RemoteFileID List from FileManager " + re);
                    v = new Vector();
                }
            }
            int nsiz = v.size();
            for (int i = 0; i < nsiz; ++i) {
                Identifier id = (Identifier)v.elementAt(i);
                if (id._directory) continue;
                this._idVector.add(id);
            }
        }
        ((RmaListModel)this.listFiles.getModel()).removeAllElements();
        for (int ii = 0; ii < this._idVector.size(); ++ii) {
            Identifier id = (Identifier)this._idVector.elementAt(ii);
            ((RmaListModel)this.listFiles.getModel()).addElement((Object)id.getName());
        }
    }

    public void setFileManager(RmiFileManager fmi) {
        this._fmi = fmi;
    }

    protected Identifier findId(String name) {
        RmiFileManager fm = this.getFileManager();
        if (fm == null) {
            System.out.println("findId; No FileManager");
            return null;
        }
        for (int ii = 0; ii < this._idVector.size(); ++ii) {
            Identifier id = (Identifier)this._idVector.elementAt(ii);
            Identifier id2 = null;
            if (!id.getName().equals(name)) continue;
            if (id.getFile() == null) {
                try {
                    id2 = fm.openFile(UserId.getUserId(), id);
                    if (id2 == null) {
                        id2 = fm.newFile(UserId.getUserId(), id);
                    }
                }
                catch (RemoteException re) {
                    System.out.println("findId:Caught remoteException on opening " + id.getName() + " " + re);
                    return id;
                }
            }
            return id2;
        }
        return null;
    }

    private RmiFileManager getFileManager() {
        if (this._fmi != null) {
            return this._fmi;
        }
        if (ClientAppCheck.haveClientApp()) {
            return (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        }
        return null;
    }

    void listFiles_DblClicked() {
        String idName = (String)this.listFiles.getSelectedValue();
        this._chosenId = this.findId(idName);
        this._ok = true;
        this.dispose();
    }

    void listFiles_MouseClick() {
        String idName = (String)this.listFiles.getSelectedValue();
        this.textFieldSelectFile.setText(idName);
    }

    public void setIsRemote(boolean remote) {
        this._isRemote = remote;
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == RemoteFileChooser.this) {
                RemoteFileChooser.this.RemoteFileChooser_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == RemoteFileChooser.this.buttonOpen) {
                RemoteFileChooser.this.buttonOpen_Action(event);
            } else if (object == RemoteFileChooser.this.buttonCancel) {
                RemoteFileChooser.this.buttonCancel_Action(event);
            } else if (object == RemoteFileChooser.this.listFiles) {
                RemoteFileChooser.this.listFiles_DblClicked();
            }
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            Object object = event.getSource();
            if (object == RemoteFileChooser.this.listFiles) {
                RemoteFileChooser.this.listManagers_ItemStateChanged();
            }
        }
    }

    class SymMouse
    extends MouseAdapter {
        SymMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Object object = event.getSource();
            if (object == RemoteFileChooser.this.listFiles) {
                if (event.getClickCount() > 1) {
                    RemoteFileChooser.this.listFiles_DblClicked();
                } else {
                    RemoteFileChooser.this.listFiles_MouseClick();
                }
            }
        }
    }
}

