/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientWorkspace;
import hec.clientapp.client.HecClientFrame;
import hec.clientapp.client.RMIProgressDialog;
import hec.clientapp.client.RmiProgressImpl;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.Identifier;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.text.MessageFormat;
import mil.army.usace.hec.rmi.client.RMIProgressDisplay;
import mil.army.usace.hec.rmi.msgsystem.Msg;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.WorkspaceLoadTimeLoggingMarker;

public class RmiCall
implements Runnable {
    private static final MarkingClassLogger WORKSPACE_LOAD_TIME_LOGGER = MarkingClassLogger.forMarkingClass(WorkspaceLoadTimeLoggingMarker.class);
    public static final int OPEN_WORKSPACE = 1;
    Identifier _wkspId;
    String _chosenBindingSite;
    boolean _local;
    RmiWorkspace _rmiwksp = null;
    RmiApp _server = null;
    RmiProgressImpl _parent = null;
    RMIProgressDisplay _pDialog = null;
    int _callType = 0;
    RemoteWrapper _wrapper = null;

    public RmiCall(RmiProgressImpl parent) {
        this._parent = parent;
        this._pDialog = parent.getDisplay();
    }

    public void setOpenWorkspace(Identifier id, String chosenBindingSite, boolean local, RmiApp server, RemoteWrapper wrapper) {
        this._wkspId = id;
        this._chosenBindingSite = chosenBindingSite;
        this._local = local;
        this._server = server;
        this._callType = 1;
        this._wrapper = wrapper;
    }

    @Override
    public void run() {
        HecClientFrame frame = ClientApp.frame();
        if (frame != null) {
            frame.setCursor(new Cursor(3));
        }
        switch (this._callType) {
            case 1: {
                this.openWorkspace();
                break;
            }
            default: {
                System.out.println("Unknown call type to process");
            }
        }
        this._pDialog.workComplete();
        if (frame != null) {
            frame.setCursor(new Cursor(0));
        }
    }

    private boolean openWorkspace() {
        long t2;
        long t1;
        long start = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("RmiCall Thread=%s", (Object)Thread.currentThread().toString());
        if (this._pDialog instanceof RMIProgressDialog) {
            ((RMIProgressDialog)this._pDialog).setSystemClosable(false);
        }
        if (ClientApp.Workspace() != null) {
            this._pDialog.printMessage("Closing previous workspace\n");
            t1 = System.currentTimeMillis();
            if (!ClientApp.frame().closeWorkspace()) {
                return false;
            }
            t2 = System.currentTimeMillis();
            ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("time to close previous watershed %s ms", t2 - t1);
        }
        if (this._pDialog instanceof RMIProgressDialog) {
            ((RMIProgressDialog)this._pDialog).setTitle("Opening Workspace " + this._wkspId.getName());
        }
        t1 = System.currentTimeMillis();
        try {
            if (!this._local) {
                throw new IllegalStateException("Remote workspaces are not supported");
            }
            this._rmiwksp = this._server.openWorkspace(ClientApp.app().getUser(), this._wkspId, null, this._wrapper);
        }
        catch (RuntimeException rte) {
            this._pDialog.setProgress(100);
            this._pDialog.workComplete();
            String msg = rte.getMessage();
            MessageFormat fmt = new MessageFormat(msg);
            String msg2 = fmt.format(new Object[]{"watershed", "Watershed"});
            ClientApp.app().errMsgBox(new Msg("Error opening Watershed  " + msg2, 1));
            return false;
        }
        catch (Exception re) {
            ClientApp.app().errMsgBox(new Msg("Error opening Watershed  " + re, 1));
            re.printStackTrace();
            return false;
        }
        t2 = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("time create RmiWorkspace %s ms", t2 - t1);
        if (this._rmiwksp == null) {
            System.out.println("openWorkspace:failed to get RmiWorkspace from server");
            return false;
        }
        this._pDialog.printMessage("Creating Client Workspace\n");
        t1 = System.currentTimeMillis();
        ClientWorkspace clwksp = new ClientWorkspace(ClientApp.app(), this._rmiwksp);
        ClientApp.setWorkspace(clwksp);
        t2 = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("time time create ClientWorkspace %s ms", t2 - t1);
        this._pDialog.setProgress(30);
        final HecClientFrame frame = ClientApp.frame();
        t1 = System.currentTimeMillis();
        if (frame != null) {
            frame.updateTitle();
            frame.resetWorkspace();
            frame.printMessage((this._local ? "\nLocal " : "\nRemote ") + "Workspace " + this._wkspId.getName() + " opened");
        }
        t2 = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("time to resetWorkspace %s ms", t2 - t1);
        this._pDialog.setProgress(100);
        long end = System.currentTimeMillis();
        ((MarkingClassLogger.Api)WORKSPACE_LOAD_TIME_LOGGER.atFine()).log("total time to openWorkspace %s ms", end - start);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.toFront();
            }
        });
        return true;
    }

    public RmiWorkspace getRmiWorkspace() {
        return this._rmiwksp;
    }

    public void finalize() {
    }
}

