/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.client.RunObserver;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.RMIProgressDialog;
import hec.clientapp.client.RMIProgressFile;
import hec.clientapp.client.RmiCall;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import hec.lang.HtmlAttributes;
import hec.properties.HECProperties;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.Vector;
import mil.army.usace.hec.rmi.client.RMIProgressDisplay;
import mil.army.usace.hec.rmi.csinterface.RMIComputeCanceledCallback;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import mil.army.usace.hec.rmi.server.RemoteWrapper;

public class RmiProgressImpl
extends PortableRmiObject
implements RmiProgress {
    protected Frame _parent = null;
    protected RMIProgressDisplay _pd = null;
    protected Vector _ro = new Vector();

    public RmiProgressImpl(Frame parent) throws RemoteException {
        this._parent = parent;
        this.createProgressDisplay();
        if (ClientAppCheck.haveClientApp()) {
            HECProperties prop = ClientApp.app().getProperties();
            if (prop == null) {
                return;
            }
            this._pd.setBackground(prop.getProp("client.html.background", "gray"));
            this._pd.setWarningColor(prop.getProp("client.compute.warningColor", "yellow"));
            this._pd.setErrorColor(prop.getProp("client.compute.errorColor", "red"));
            this._pd.setTextColor(prop.getProp("client.compute.textColor", "black"));
        }
    }

    private void createProgressDisplay() {
        this._pd = this._parent != null ? this.createProgressDialog() : this.createProgressFile();
    }

    protected RMIProgressDisplay createProgressFile() {
        return new RMIProgressFile();
    }

    protected RMIProgressDisplay createProgressDialog() {
        return new RMIProgressDialog(this._parent, false){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (!visible && this.isVisible()) {
                    RmiProgressImpl.this._pd = null;
                }
            }
        };
    }

    public void openWorkspace(Identifier id, String chosenBindingSite, boolean local, RmiApp server, RemoteWrapper wrapper) {
        RmiCall call = new RmiCall(this);
        call.setOpenWorkspace(id, chosenBindingSite, local, server, wrapper);
        this._pd.setRmiCall((Runnable)call);
        if (this._pd instanceof RMIProgressDialog) {
            ((RMIProgressDialog)this._pd).buttonIsVisible(false);
        }
    }

    public void setConversion(Runnable run) {
        this._pd.setRmiCall(run);
        if (this._pd instanceof RMIProgressDialog) {
            ((RMIProgressDialog)this._pd).buttonIsVisible(true);
            ((RMIProgressDialog)this._pd).setTitle("Conversion");
            ((RMIProgressDialog)this._pd).setButton2Label("Save Conversion Messages");
        }
    }

    public void setCompute(Runnable run) {
        this._pd.setRmiCall(run);
        if (this._pd instanceof RMIProgressDialog) {
            ((RMIProgressDialog)this._pd).buttonIsVisible(true);
            ((RMIProgressDialog)this._pd).setTitle("Compute");
        }
    }

    public void setCompute(Runnable run, String title) {
        this._pd.setRmiCall(run);
        if (this._pd instanceof RMIProgressDialog) {
            ((RMIProgressDialog)this._pd).buttonIsVisible(true);
            ((RMIProgressDialog)this._pd).setTitle(title);
        }
    }

    public RMIProgressDialog getDialog() {
        if (this._pd instanceof RMIProgressDialog) {
            return (RMIProgressDialog)this._pd;
        }
        return null;
    }

    public RMIProgressDisplay getDisplay() {
        return this._pd;
    }

    public void makeCall() {
        this.makeCall(false);
    }

    public void makeCall(boolean waitForComplete) {
        this._pd.startRun(true);
        if (waitForComplete) {
            // empty if block
        }
    }

    public void setProgress(int progress) throws RemoteException {
        this._pd.setProgress(progress);
    }

    public void printMessage(String s) throws RemoteException {
        this._pd.printMessage(s);
    }

    public void printLogMessage(String s) throws RemoteException {
        this._pd.printLogMessage(s);
    }

    public void setProgressFactor(int i) throws RemoteException {
        this._pd.setProgressFactor(i);
    }

    public void setNumberTasks(int numberTasks) throws RemoteException {
        this._pd.setNumberTasks(numberTasks);
    }

    public void setTaskNumber(int taskNumber) throws RemoteException {
        this._pd.setTaskNumber(taskNumber);
    }

    public void printStatus(String s) throws RemoteException {
        this._pd.printStatus(s);
    }

    public void printErrorMessage(String s) throws RemoteException {
        this._pd.printErrorMessage(s);
    }

    public void printWarningMessage(String s) throws RemoteException {
        this._pd.printWarningMessage(s);
    }

    public void setRunObserver(RunObserver ro) {
        this.addRunObserver(ro);
    }

    public void addRunObserver(RunObserver ro) {
        if (ro == null) {
            return;
        }
        this._ro.add(ro);
    }

    public void removeRunObserver(RunObserver ro) {
        if (ro == null) {
            return;
        }
        this._ro.remove(ro);
    }

    public void runComplete(Object obj) throws RemoteException {
        this._pd.workComplete();
        for (int i = this._ro.size() - 1; i >= 0; --i) {
            ((RunObserver)this._ro.get(i)).runComplete(obj);
        }
    }

    public void setLineAttributes(HtmlAttributes a) throws RemoteException {
        this._pd.setLineAttributes(a);
    }

    public void printTableRow(boolean isHeader, String tableRow) throws RemoteException {
        this._pd.printTableRow(isHeader, tableRow);
    }

    public void printSeparator() throws RemoteException {
        this._pd.printSeparator();
    }

    public void setComputeCanceledCallback(RMIComputeCanceledCallback callback) {
        this._pd.setComputeCanceledCallback(callback);
    }

    public void setCanceledComputeFinished(boolean success) {
        this._pd.setCanceledComputeFinished(success);
    }
}

