/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.SimTrialRunTreeNode;
import hec.clientapp.client.SimulationRunTreeNode;
import hec.clientapp.client.SimulationTree;
import hec.clientapp.client.SimulationTreeNode;
import hec.clientapp.model.Simulation;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;

public class SelectActiveRunDialog
extends RmaJDialog {
    protected JTree _tree;
    private ButtonCmdPanel _cmdPanel;
    protected Simulation _simulation;
    private boolean _canceled = false;

    public SelectActiveRunDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.buildControls();
    }

    private void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Select Active Alternative");
        this._tree = this.createTree();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)new JScrollPane(this._tree), gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 8: {
                        SelectActiveRunDialog.this._canceled = false;
                        SelectActiveRunDialog.this.setVisible(false);
                        break;
                    }
                    case 4: {
                        SelectActiveRunDialog.this._canceled = true;
                        SelectActiveRunDialog.this.setVisible(false);
                    }
                }
            }
        });
        this._tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SelectActiveRunDialog.this._tree.getSelectionPath() != null) {
                    SelectActiveRunDialog.this._cmdPanel.doButtonClick(8);
                }
            }
        });
        this._tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
                throw new ExpandVetoException(e);
            }
        });
        this.pack();
        this.setLocation();
    }

    protected JTree createTree() {
        SimulationTreeNode rootNode = new SimulationTreeNode();
        SimulationTree tree = new SimulationTree(rootNode){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 200;
                return d;
            }
        };
        ((DefaultTreeCellRenderer)tree.getCellRenderer()).setLeafIcon(null);
        ((DefaultTreeCellRenderer)tree.getCellRenderer()).setOpenIcon(null);
        tree.setRootVisible(false);
        rootNode.setTree(tree);
        return tree;
    }

    protected void expandAllNodes(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            this.expandAllNodes(child);
            this._tree.expandPath(new TreePath(child.getPath()));
        }
    }

    public void setActiveRun(SimulationRun activeSimRun) {
        if (activeSimRun == null) {
            return;
        }
    }

    public void setSimulation(Simulation sim) {
        this._simulation = sim;
        Object root = this._tree.getModel().getRoot();
        if (root instanceof SimulationTreeNode && sim instanceof SimulationPeriod) {
            SimulationTreeNode rootNode = (SimulationTreeNode)root;
            SimulationPeriod simPeriod = (SimulationPeriod)sim;
            rootNode.setSimulation(simPeriod);
            DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
            model.nodeChanged((TreeNode)this._tree.getModel().getRoot());
            model.nodeStructureChanged((TreeNode)this._tree.getModel().getRoot());
            this._tree.revalidate();
            this.expandAllNodes(rootNode);
        }
    }

    public SimulationRun getSelectedSimulationRun() {
        if (this._tree == null) {
            return null;
        }
        TreePath path = this._tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node instanceof SimTrialRunTreeNode) {
            SimTrialRunTreeNode trialnode = (SimTrialRunTreeNode)node;
            return trialnode.getTrialSimulationRun();
        }
        if (node instanceof SimulationRunTreeNode) {
            SimulationRunTreeNode runNode = (SimulationRunTreeNode)node;
            return runNode.getSimulationRun();
        }
        return null;
    }

    public boolean isCanceled() {
        return this._canceled;
    }
}

