/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.client.Shortcut;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ShortcutCellRenderer;
import hec.lang.ClientAppCheck;
import hec.model.WatershedLocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.RmaInsets;
import rma.util.RMAIO;

public class ShortcutsAccessory
extends JPanel {
    private static final int TOOLTIP_DISMISS_DELAY = 2000;
    private static final int TOOLTIP_INITIAL_DELAY = 300;
    private JFileChooser _chooser;
    private String _initialTitle;
    private String _applicationName;
    private int _originalInitialDelay;
    private int _originalDismissDelay;
    private JButton _addButton;
    private JButton _deleteButton;
    private JButton _aliasButton;
    private JList _list;
    private JScrollPane _listScrollPane;
    private JTextField _aliasField;
    private DefaultListModel _model;
    private boolean _shortcutsChanged;
    private boolean _fileShortcutAllowed = false;
    private boolean _settingSelection;

    public ShortcutsAccessory(JFileChooser chooser, String applicationName) {
        this._chooser = chooser;
        this._applicationName = applicationName;
        this.updateTitle();
        this.setGUI();
        this.addListeners();
    }

    private void setGUI() {
        this.setBorder(new TitledBorder(" Shortcuts "));
        this.setLayout(new GridBagLayout());
        this._model = this.createModel();
        this._list = new JList(this._model){

            @Override
            public String getToolTipText(MouseEvent me) {
                if (ShortcutsAccessory.this._model.size() == 0) {
                    return null;
                }
                Point p = me.getPoint();
                Rectangle bounds = ShortcutsAccessory.this._list.getCellBounds(ShortcutsAccessory.this._model.size() - 1, ShortcutsAccessory.this._model.size() - 1);
                int lastElementBaseline = bounds.y + bounds.height;
                if (lastElementBaseline < p.y) {
                    return null;
                }
                int index = ShortcutsAccessory.this._list.locationToIndex(p);
                if (index == -1) {
                    return null;
                }
                Shortcut shortcut = (Shortcut)ShortcutsAccessory.this._model.get(index);
                String path = shortcut.getPath();
                if (shortcut.hasAlias()) {
                    return path;
                }
                FontMetrics fm = ShortcutsAccessory.this._list.getFontMetrics(ShortcutsAccessory.this._list.getFont());
                int textWidth = SwingUtilities.computeStringWidth(fm, path);
                if (textWidth <= ShortcutsAccessory.this._listScrollPane.getSize().width) {
                    return null;
                }
                return path;
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = 100;
                return d;
            }
        };
        this._list.setCellRenderer(new ShortcutCellRenderer());
        this._listScrollPane = new JScrollPane(this._list);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this._listScrollPane, gbc);
        this._originalInitialDelay = ToolTipManager.sharedInstance().getInitialDelay();
        this._originalDismissDelay = ToolTipManager.sharedInstance().getDismissDelay();
        ToolTipManager.sharedInstance().setDismissDelay(2000);
        ToolTipManager.sharedInstance().setInitialDelay(300);
        ToolTipManager.sharedInstance().registerComponent(this._list);
        this._addButton = new JButton("Add");
        this._addButton.setToolTipText("Add the current directory/file to Shortcuts");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)this._addButton, gbc);
        this._deleteButton = new JButton("Delete");
        this._deleteButton.setToolTipText("Delete a shortcut");
        this._deleteButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)this._deleteButton, gbc);
        this._aliasButton = new JButton("Set");
        this._aliasButton.setToolTipText("Set an alias for a shortcut");
        this._aliasField = new JTextField(10);
    }

    private void addListeners() {
        this._chooser.addPropertyChangeListener("directoryChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName.equals("directoryChanged")) {
                    ShortcutsAccessory.this.updateTitle();
                    ShortcutsAccessory.this.selectShortCut();
                }
            }
        });
        this._chooser.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent e) {
                ToolTipManager.sharedInstance().setDismissDelay(ShortcutsAccessory.this._originalDismissDelay);
                ToolTipManager.sharedInstance().setInitialDelay(ShortcutsAccessory.this._originalInitialDelay);
                if (ShortcutsAccessory.this._shortcutsChanged) {
                    ShortcutsAccessory.this.saveShortcuts();
                }
            }

            @Override
            public void ancestorAdded(AncestorEvent e) {
            }

            @Override
            public void ancestorMoved(AncestorEvent e) {
            }
        });
        this._list.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ShortcutsAccessory.this._settingSelection) {
                    return;
                }
                ShortcutsAccessory.this._settingSelection = true;
                try {
                    int selectedIndex = ShortcutsAccessory.this._list.getSelectedIndex();
                    if (selectedIndex == -1) {
                        ShortcutsAccessory.this._deleteButton.setEnabled(false);
                        return;
                    }
                    ShortcutsAccessory.this._deleteButton.setEnabled(true);
                    Shortcut shortcut = (Shortcut)ShortcutsAccessory.this._model.get(selectedIndex);
                    String alias = shortcut.getAlias();
                    String path = shortcut.getPath();
                    String color = shortcut.getColorString();
                    Object aliasText = alias;
                    if (!"black".equals(color)) {
                        aliasText = color + "#" + alias;
                    }
                    ShortcutsAccessory.this._aliasField.setText((String)aliasText);
                    File file = new File(path);
                    if (file.isFile()) {
                        ShortcutsAccessory.this._chooser.setSelectedFile(file);
                    } else {
                        ShortcutsAccessory.this._chooser.setCurrentDirectory(file);
                        ShortcutsAccessory.this._chooser.setSelectedFile(null);
                    }
                }
                finally {
                    ShortcutsAccessory.this._settingSelection = false;
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                if (command.equals("Delete")) {
                    int ind = ShortcutsAccessory.this._list.getSelectedIndex();
                    if (ind == -1) {
                        return;
                    }
                    ShortcutsAccessory.this._aliasField.setText("");
                    ShortcutsAccessory.this._model.remove(ind);
                }
                if (command.equals("Add")) {
                    String path;
                    File file = ShortcutsAccessory.this._chooser.getSelectedFile();
                    boolean isDir = false;
                    if (file != null) {
                        if (!ShortcutsAccessory.this._fileShortcutAllowed && !file.isDirectory()) {
                            file = file.getParentFile();
                        }
                        path = file.getAbsolutePath();
                        isDir = file.isDirectory();
                    } else {
                        File dir = ShortcutsAccessory.this._chooser.getCurrentDirectory();
                        path = dir.getAbsolutePath();
                        isDir = true;
                    }
                    String alias = JOptionPane.showInputDialog(ShortcutsAccessory.this, "Enter an alias for " + path, "Enter Alias", 1);
                    if (alias == null) {
                        return;
                    }
                    ShortcutsAccessory.this.insertShortcut(new Shortcut(alias, path, "black", isDir));
                }
                if (command.equals("Set")) {
                    ShortcutsAccessory.this.setAlias();
                }
                ShortcutsAccessory.this._list.clearSelection();
                ShortcutsAccessory.this._chooser.setSelectedFile(null);
                ShortcutsAccessory.this._shortcutsChanged = true;
            }
        };
        this._addButton.addActionListener(actionListener);
        this._deleteButton.addActionListener(actionListener);
        this._aliasButton.addActionListener(actionListener);
        this._aliasField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ShortcutsAccessory.this.setAlias();
                    ShortcutsAccessory.this._shortcutsChanged = true;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectShortCut() {
        if (this._settingSelection) {
            return;
        }
        File f = this._chooser.getCurrentDirectory();
        if (f == null) {
            this._list.clearSelection();
            return;
        }
        if (!f.isDirectory()) {
            f = f.getParentFile();
        }
        String path = f.getAbsolutePath();
        this._settingSelection = true;
        try {
            for (int i = 0; i < this._model.size(); ++i) {
                Shortcut shortCut = (Shortcut)this._model.get(i);
                if (!RMAIO.pathsEqual((String)path, (String)shortCut.getDirectory())) continue;
                this._list.setSelectedValue(shortCut, true);
                return;
            }
            this._list.clearSelection();
        }
        finally {
            this._settingSelection = false;
        }
    }

    public void setFileShortcutAllowed(boolean b) {
        this._fileShortcutAllowed = b;
    }

    private void setAlias() {
        int ind = this._list.getSelectedIndex();
        if (ind == -1) {
            this._list.requestFocus();
            return;
        }
        Shortcut shortcut = (Shortcut)this._model.get(ind);
        String text = this._aliasField.getText().trim();
        if (text.length() == 0) {
            shortcut.setAlias("");
            shortcut.setColor("black");
            this._model.remove(ind);
            this.insertShortcut(new Shortcut("", shortcut.getPath(), "", shortcut.isDirectory()));
            return;
        }
        String color = "black";
        String alias = text;
        int hashIndex = text.indexOf("#");
        if (hashIndex != -1) {
            alias = text.substring(hashIndex + 1);
            color = text.substring(0, hashIndex);
        }
        shortcut.setAlias(alias);
        shortcut.setColor(color);
        this._aliasField.setText("");
        this._model.remove(ind);
        this.insertShortcut(new Shortcut(alias, shortcut.getPath(), color, shortcut.isDirectory()));
    }

    private void insertShortcut(Shortcut newShortcut) {
        Shortcut shortcut;
        String name;
        if (this._model.getSize() == 0) {
            this._model.addElement(newShortcut);
            return;
        }
        for (int i = 0; i < this._model.getSize(); ++i) {
            Shortcut shortcut2 = (Shortcut)this._model.get(i);
            if (!shortcut2.getPath().equalsIgnoreCase(newShortcut.getPath())) continue;
            JOptionPane.showMessageDialog(this, "Shortcut already exists for " + newShortcut.getPath(), "Duplicate Shortcut", 2);
            return;
        }
        int insertIndex = 0;
        String newName = newShortcut.getName();
        for (int i = 0; i < this._model.getSize() && (name = (shortcut = (Shortcut)this._model.get(i)).getName()).compareToIgnoreCase(newName) <= 0; ++i) {
            insertIndex = i + 1;
        }
        this._model.insertElementAt(newShortcut, insertIndex);
    }

    private DefaultListModel<WatershedLocation> createModel() {
        DefaultListModel<WatershedLocation> listModel = new DefaultListModel<WatershedLocation>();
        List<WatershedLocation> shortCuts = ShortcutsAccessory.loadShortcuts(this._applicationName);
        if (shortCuts != null) {
            for (int i = 0; i < shortCuts.size(); ++i) {
                listModel.addElement(shortCuts.get(i));
            }
        }
        return listModel;
    }

    public static List<WatershedLocation> loadShortcuts(String appName) {
        ArrayList<WatershedLocation> shortCuts = new ArrayList<WatershedLocation>();
        if (ClientAppCheck.haveClientApp()) {
            Vector v = ClientApp.app().getWatershedLocations(false);
            for (int i = 0; i < v.size(); ++i) {
                WatershedLocation wl = (WatershedLocation)v.get(i);
                Shortcut shortcut = new Shortcut(wl.getName(), wl.getDirectory(), wl.getColorString(), wl.isDirectory());
                shortCuts.add((WatershedLocation)shortcut);
            }
        }
        try {
            String filePath = System.getProperty("user.home") + System.getProperty("file.separator") + appName + ".accessory.dirs";
            File file = new File(filePath);
            if (!file.exists()) {
                return shortCuts;
            }
            BufferedReader in = new BufferedReader(new FileReader(file));
            String buf = null;
            while ((buf = in.readLine()) != null) {
                boolean isDir;
                String color;
                String alias;
                if (buf.startsWith("//")) continue;
                int commaIndex = buf.indexOf(",");
                if (commaIndex == -1) {
                    throw new IOException("Incorrect format of a " + file.getPath() + " file");
                }
                String colorAndAlias = buf.substring(0, commaIndex).trim();
                int hashIndex = colorAndAlias.indexOf("#");
                if (hashIndex != -1) {
                    alias = colorAndAlias.substring(hashIndex + 1);
                    color = colorAndAlias.substring(0, hashIndex);
                } else {
                    alias = colorAndAlias;
                    color = "black";
                }
                String path = buf.substring(commaIndex + 1).trim();
                commaIndex = path.indexOf(",");
                if (commaIndex > -1) {
                    isDir = "true".equalsIgnoreCase(path.substring(commaIndex + 1).trim());
                    path = path.substring(0, commaIndex);
                } else {
                    isDir = true;
                }
                Shortcut shortcut = new Shortcut(alias, path, color, isDir);
                shortCuts.add((WatershedLocation)shortcut);
            }
            in.close();
            return shortCuts;
        }
        catch (IOException e) {
            e.printStackTrace();
            return shortCuts;
        }
    }

    private void saveShortcuts() {
        if (ClientAppCheck.haveClientApp()) {
            Vector v = new Vector(this._model.getSize());
            for (int i = 0; i < this._model.size(); ++i) {
                v.add(this._model.get(i));
            }
            try {
                ClientApp.app().setWatershedLocations(v);
            }
            catch (Exception re) {
                System.out.println("saveShortcuts: Error setting shortcuts " + re);
            }
            return;
        }
        try {
            String filePath = System.getProperty("user.home") + System.getProperty("file.separator") + this._applicationName + ".accessory.dirs";
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            out.println("//Directory Shortcuts for " + this._applicationName + " [" + new Date().toString() + "]");
            for (int i = 0; i < this._model.size(); ++i) {
                Shortcut shortcut = (Shortcut)this._model.get(i);
                String alias = shortcut.getAlias();
                String path = shortcut.getPath();
                String color = shortcut.getColorString();
                boolean isDir = shortcut.isDirectory();
                out.println(color + "#" + alias + "," + path + "," + isDir);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void updateTitle() {
        if (this._initialTitle == null) {
            this._initialTitle = this._chooser.getUI().getDialogTitle(this._chooser);
        }
        this._chooser.setDialogTitle(this._initialTitle + " (" + this._chooser.getCurrentDirectory().getPath() + ")");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog(null, "After JFileChooser starts, please click Add,\nthen select a new shortcut and type red#shortcut in the Alias field\nand press Enter or click Set to see how to set an alias and color.", "Demo of ShortcutsAccessory", 1);
        JFileChooser chooser = new JFileChooser();
        ShortcutsAccessory shortcuts = new ShortcutsAccessory(chooser, "demo");
        chooser.setAccessory(shortcuts);
        shortcuts.setFileShortcutAllowed(false);
        Dimension d = new Dimension(600, 400);
        chooser.setMinimumSize(d);
        chooser.setPreferredSize(d);
        chooser.showOpenDialog(null);
    }
}

