/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.properties.HECProperties;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Properties;
import rma.swing.DefaultJPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;

public class SimModeOptionsPanel
extends DefaultJPanel {
    public static final String SHOW_EXTRACT_ERRORS_PROP = "NoShowExtractErrors";
    private RmaJCheckBox _reloadLastSimulation;
    private RmaJCheckBox _saveSimTreeState;
    private RmaJCheckBox _alwaysRecompute;
    private RmaJCheckBox _reuseComputeDialog;
    private RmaJCheckBox _showExtractErrorsDialog;
    private Properties _props;
    private String _simType;

    public SimModeOptionsPanel(String simType) {
        this._simType = simType;
        this.buildControls();
    }

    public SimModeOptionsPanel() {
        this("Simulation");
    }

    protected void buildControls() {
        this.setLayout(new GridBagLayout());
        this._reloadLastSimulation = new RmaJCheckBox("Reload Last " + this._simType + " on Startup");
        this._reloadLastSimulation.setMnemonic('R');
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)this._reloadLastSimulation, gbc);
        this._saveSimTreeState = new RmaJCheckBox("Restore " + this._simType + " Tree State");
        this._saveSimTreeState.setMnemonic('S');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        this.add((Component)this._saveSimTreeState, gbc);
        this._alwaysRecompute = new RmaJCheckBox("Compute Button Forces Recompute");
        this._alwaysRecompute.setMnemonic('F');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weighty = 0.0;
        this.add((Component)this._alwaysRecompute, gbc);
        this._reuseComputeDialog = new RmaJCheckBox("Re-Use Compute Dialog");
        this._reuseComputeDialog.setMnemonic('U');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weighty = 0.0;
        this.add((Component)this._reuseComputeDialog, gbc);
        this._showExtractErrorsDialog = new RmaJCheckBox("Don't Show Extract Errors Window");
        this._showExtractErrorsDialog.setMnemonic('E');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        gbc.weighty = 1.0;
        this.add((Component)this._showExtractErrorsDialog, gbc);
    }

    public String getName() {
        return this._simType;
    }

    public void setProperties(Properties props) {
        this._props = props;
    }

    public void refresh() {
    }

    public void fillPanel() {
        HECProperties props = ClientApp.app().getProperties();
        if (props == null) {
            this._reloadLastSimulation.setSelected(false);
            this._saveSimTreeState.setSelected(false);
            this._alwaysRecompute.setSelected(false);
            this._reuseComputeDialog.setSelected(false);
            this._showExtractErrorsDialog.setSelected(false);
            return;
        }
        ClientMode mode = ClientApp.frame().getCurrentMode();
        String s = props.getProp("SimulationModule.reloadLastSim");
        this._reloadLastSimulation.setSelected("true".equalsIgnoreCase(s));
        s = props.getProp("SimulationModule.dontSaveTreeState");
        this._saveSimTreeState.setSelected(s == null || "false".equalsIgnoreCase(s));
        s = props.getProp("SimulationModule.forceRecompute");
        this._alwaysRecompute.setSelected("true".equalsIgnoreCase(s));
        s = props.getProp("SimulationModule.reuseComputeDialog");
        this._reuseComputeDialog.setSelected("true".equalsIgnoreCase(s));
        s = props.getProp(SHOW_EXTRACT_ERRORS_PROP);
        this._showExtractErrorsDialog.setSelected("true".equalsIgnoreCase(s));
    }

    public boolean savePanel() {
        HECProperties props = ClientApp.app().getProperties();
        if (props == null) {
            return true;
        }
        props.setProp("SimulationModule.reloadLastSim", String.valueOf(this._reloadLastSimulation.isSelected()));
        props.setProp("SimulationModule.dontSaveTreeState", String.valueOf(!this._saveSimTreeState.isSelected()));
        props.setProp("SimulationModule.forceRecompute", String.valueOf(this._alwaysRecompute.isSelected()));
        props.setProp("SimulationModule.reuseComputeDialog", String.valueOf(this._reuseComputeDialog.isSelected()));
        props.setProp(SHOW_EXTRACT_ERRORS_PROP, String.valueOf(this._showExtractErrorsDialog.isSelected()));
        props.saveProperties();
        return true;
    }
}

