/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.client.RunObserver;
import hec.clientapp.client.AbstractSimulationMode;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.model.AltItem;
import hec.model.RunTimeWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDescriptionField;
import rma.swing.RmaJFrame;
import rma.swing.RmaJTable;
import rma.util.RMAIO;

public class SimRunManagerWindow
extends RmaJFrame
implements RunObserver {
    private static final String SELECT_ALL = "Select All";
    private static final String UNSELECT_ALL = "Unselect All";
    private static final String CANCEL_ALL = "Cancel All";
    private String _type;
    private JPanel _infoPanel;
    private JLabel _simNameFld;
    private RmaJDescriptionField _descriptionFld;
    private JLabel _startTimeFld;
    private JLabel _lookbackTimeFld;
    private JLabel _endTimeFld;
    private JPanel _tablePanel;
    private RmaJTable _simRunTable;
    private JPanel _bottomPanel;
    private JButton _selectButton;
    private RmaJCheckBox _forceComputeCheck;
    private RmaJCheckBox _closeOnCompletionCheck;
    private ButtonCmdPanel _cmdPanel;
    private AbstractSimulationMode _mode;
    private SimulationPeriod _simulation;
    private SimulationRun[] _runs;
    private JButton _viewLogsButton;

    public SimRunManagerWindow(String type) {
        this._type = type;
        this.buildControls();
        this.addListeners();
        this.pack();
        this.setSize(600, 500);
        this.setLocationRelativeTo((Component)((Object)ClientApp.frame()));
    }

    protected void buildControls() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Run Manager");
        this._infoPanel = new JPanel(new GridBagLayout());
        this._infoPanel.setBorder(BorderFactory.createTitledBorder(this._type + " Information"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._infoPanel, gbc);
        this.buildInfoPanel();
        this._tablePanel = new JPanel(new GridBagLayout());
        this._tablePanel.setBorder(BorderFactory.createTitledBorder("Alternatives"));
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this.getContentPane().add((Component)this._tablePanel, gbc);
        this.buildTablePanel();
        this._bottomPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)this._bottomPanel, gbc);
        this.buildBottomPanel();
    }

    protected void buildInfoPanel() {
        JLabel label = new JLabel("Name:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._infoPanel.add((Component)label, gbc);
        this._simNameFld = new JLabel();
        label.setLabelFor(this._simNameFld);
        this._simNameFld.setBorder(null);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._infoPanel.add((Component)this._simNameFld, gbc);
        label = new JLabel("Description:");
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        this._infoPanel.add((Component)label, gbc);
        this._descriptionFld = new RmaJDescriptionField();
        this._descriptionFld.setEditable(false);
        label.setLabelFor(this._startTimeFld);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0505;
        this._infoPanel.add((Component)this._descriptionFld, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._infoPanel.add((Component)new JSeparator(), gbc);
        label = new JLabel("Start:");
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        this._infoPanel.add((Component)label, gbc);
        this._startTimeFld = new JLabel();
        label.setLabelFor(this._startTimeFld);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        this._infoPanel.add((Component)this._startTimeFld, gbc);
        label = new JLabel("Lookback:");
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        this._infoPanel.add((Component)label, gbc);
        this._lookbackTimeFld = new JLabel();
        label.setLabelFor(this._lookbackTimeFld);
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        this._infoPanel.add((Component)this._lookbackTimeFld, gbc);
        label = new JLabel("End:");
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        this._infoPanel.add((Component)label, gbc);
        this._endTimeFld = new JLabel();
        label.setLabelFor(this._endTimeFld);
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0E-4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS0505;
        this._infoPanel.add((Component)this._endTimeFld, gbc);
    }

    protected void buildTablePanel() {
        Object[] headers = new String[]{"Compute", "Name", "Description", "Computed"};
        this._simRunTable = new RmaJTable((Component)((Object)this), headers);
        this._simRunTable.setCheckBoxCellEditor(0);
        this._simRunTable.setColumnEnabled(false, 1);
        this._simRunTable.setColumnEnabled(false, 2);
        this._simRunTable.setColumnEnabled(false, 3);
        this._simRunTable.setRowHeight(this._simRunTable.getRowHeight() + 5);
        this._simRunTable.setColumnWidths(new int[]{75, 130, 130, 130});
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS5505;
        this._tablePanel.add((Component)this._simRunTable.getScrollPane(), gbc);
    }

    protected void buildBottomPanel() {
        this._selectButton = new JButton(SELECT_ALL);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._bottomPanel.add((Component)this._selectButton, gbc);
        this._viewLogsButton = new JButton("View Log");
        this._viewLogsButton.setToolTipText("Highlight row in table to view the run's compute log");
        this._viewLogsButton.setEnabled(false);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._bottomPanel.add((Component)this._viewLogsButton, gbc);
        this._forceComputeCheck = new RmaJCheckBox("Force Recompute");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.INSETS5505;
        this._bottomPanel.add((Component)this._forceComputeCheck, gbc);
        this._closeOnCompletionCheck = new RmaJCheckBox("Close on Completion", false);
        this._cmdPanel = new ButtonCmdPanel(4352);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5505;
        this._bottomPanel.add((Component)this._cmdPanel, gbc);
    }

    protected void addListeners() {
        this._selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimRunManagerWindow.this.selectButtonAction();
            }
        });
        this._cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                switch (e.getID()) {
                    case 4096: {
                        SimRunManagerWindow.this.saveForm();
                        break;
                    }
                    case 256: {
                        SimRunManagerWindow.this.setVisible(false);
                    }
                }
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    SimRunManagerWindow.this.displayTimeWindowPopup(e);
                }
            }
        };
        this._infoPanel.addMouseListener(ml);
        this._startTimeFld.addMouseListener(ml);
        this._endTimeFld.addMouseListener(ml);
        this._lookbackTimeFld.addMouseListener(ml);
        this._viewLogsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimRunManagerWindow.this.viewLogFileAction();
            }
        });
        this._simRunTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SimRunManagerWindow.this.tableRowSelectedAction();
            }
        });
    }

    protected void tableRowSelectedAction() {
        int row = this._simRunTable.getSelectedRow();
        this._viewLogsButton.setEnabled(row != -1);
    }

    protected void viewLogFileAction() {
        int[] rows = this._simRunTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            SimulationRun run = (SimulationRun)((Object)this._simRunTable.getValueAt(rows[i], 1));
            String name = run.getName();
            String logfile = this._simulation.getSimulationPath() + "/" + ClientApp.app().getAppType() + "/" + RMAIO.userNameToFileName((String)name) + ".log";
            this._mode.viewLog(logfile);
        }
    }

    protected void displayTimeWindowPopup(MouseEvent e) {
        if (this._simulation == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Copy TimeWindow");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimRunManagerWindow.this.copyTimeWindow();
            }
        });
        popup.add(mi);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void copyTimeWindow() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection s = null;
        StringBuffer buf = new StringBuffer();
        buf.append("TimeWindow:");
        buf.append("\n");
        buf.append(RMAIO.removeChar((String)this._lookbackTimeFld.getText(), (char)' '));
        buf.append("\n");
        buf.append(RMAIO.removeChar((String)this._startTimeFld.getText(), (char)' '));
        buf.append("\n");
        buf.append(RMAIO.removeChar((String)this._endTimeFld.getText(), (char)' '));
        buf.append("\n");
        s = new StringSelection(buf.toString());
        cb.setContents(s, s);
    }

    private List<String> getSelectedRunNames() {
        Vector cells = this._simRunTable.getCells();
        ArrayList<String> selections = new ArrayList<String>();
        for (int i = 0; i < cells.size(); ++i) {
            Vector row = (Vector)cells.get(i);
            Object obj = row.elementAt(1);
            if (!(obj instanceof SimulationRun)) continue;
            SimulationRun run = (SimulationRun)((Object)obj);
            selections.add(run.getName());
            System.out.println("selected run is " + run.getName());
        }
        return selections;
    }

    protected void saveForm() {
        if (this._simulation == null) {
            return;
        }
        JButton button = this._cmdPanel.getButton(4096);
        if (CANCEL_ALL.equals(button.getText())) {
            this._mode.stopSimRunComputes();
            button.setText("Compute");
            return;
        }
        List<String> runNames = this.getSelectedRunNames();
        if (runNames.size() == 0) {
            return;
        }
        ClientApp.Workspace().saveManager(ClientApp.app().getAppType(), this._simulation);
        SimulationRun[] runs = this.getRunsToExecute();
        if (runs != null && runs.length > 1) {
            button.setText(CANCEL_ALL);
        }
        this._mode.addRunObserver(this);
        this._simRunTable.clearColors();
        this._simRunTable.repaint();
        this._mode.computeRuns(runs, -1, this._forceComputeCheck.isSelected(), this);
        ClientMode curMode = ClientApp.frame().getCurrentMode();
    }

    public void fillForm(AbstractSimulationMode mode) {
        this._simRunTable.deleteCells();
        this._mode = mode;
        this._simulation = this._mode.getSimulation();
        if (this._simulation == null) {
            this._simNameFld.setText("");
            this._descriptionFld.setText("");
            this._startTimeFld.setText("");
            this._endTimeFld.setText("");
            this._lookbackTimeFld.setText("");
            this._runs = null;
            return;
        }
        this._simNameFld.setText(this._simulation.getName());
        this._descriptionFld.setText(this._simulation.getDescription());
        RunTimeWindow rtw = this._simulation.getRunTimeWindow();
        this._startTimeFld.setText(rtw.getStartTime().dateAndTime(104));
        this._endTimeFld.setText(rtw.getEndTime().dateAndTime(104));
        this._lookbackTimeFld.setText(rtw.getLookbackTime().dateAndTime(104));
        this._runs = this._mode.getSimulationRuns();
        for (int i = 0; i < this._runs.length; ++i) {
            SimulationRun run = this._runs[i];
            if (run == null || run instanceof SimulationTrialRun) continue;
            this.addTableRow(run);
            this.addTrials(run.getTrials());
        }
        if (this.getRunsToExecute().length == this._simRunTable.getRowCount()) {
            this._selectButton.setText(UNSELECT_ALL);
        }
    }

    private void addTrials(Vector trials) {
        for (int i = 0; i < trials.size(); ++i) {
            SimulationRun run = (SimulationRun)((Object)trials.get(i));
            this.addTableRow(run);
        }
    }

    private void addTableRow(SimulationRun run) {
        Vector<Object> row = new Vector<Object>(4);
        long dt = this.getLastComputeTime(run);
        if (dt == 0L || run.getLastModifiedTime() > dt) {
            row.add(Boolean.TRUE);
        } else {
            row.add(Boolean.FALSE);
        }
        row.add((Object)run);
        row.add(run.getDescription());
        String s = dt == 0L ? "Hasn't Been Computed" : this.getDateString(dt);
        row.add(s);
        row.add(run.getLastModifiedTimeString());
        this._simRunTable.appendRow(row);
    }

    private String getDateString(long dt) {
        return new Date(dt).toString().substring(4);
    }

    private AltItem getAltItem(SimulationRun run) {
        Vector<AltItem> aiList = run.getAltItems(ClientApp.app().getAppType());
        long dt = 0L;
        if (aiList != null && aiList.size() > 0) {
            AltItem ai = aiList.get(0);
            return ai;
        }
        return null;
    }

    public long getLastComputeTime(SimulationRun run) {
        AltItem ai = this.getAltItem(run);
        if (ai != null) {
            long dt = this._simulation.getAltComputeTime(ai.getAltName() + ai.getAltIndex(), ai.getProgram());
            if (dt == 0L) {
                dt = this._simulation.getLastComputeTime(run.getIndex());
            }
            return dt;
        }
        return 0L;
    }

    protected void selectButtonAction() {
        String txt = this._selectButton.getText();
        Boolean b = Boolean.TRUE;
        if (UNSELECT_ALL.equalsIgnoreCase(txt)) {
            b = Boolean.FALSE;
        }
        int rowCnt = this._simRunTable.getRowCount();
        for (int i = 0; i < rowCnt; ++i) {
            this._simRunTable.setValueAt((Object)b, i, 0);
        }
        if (b.booleanValue()) {
            this._selectButton.setText(UNSELECT_ALL);
        } else {
            this._selectButton.setText(SELECT_ALL);
        }
    }

    public SimulationRun[] getRunsToExecute() {
        Vector cells = this._simRunTable.getCells();
        ArrayList<SimulationRun> selections = new ArrayList<SimulationRun>();
        for (int i = 0; i < cells.size(); ++i) {
            Vector row = (Vector)cells.elementAt(i);
            String obj = row.elementAt(0).toString();
            if (!"true".equalsIgnoreCase(obj.toString()) || !((obj = row.elementAt(1)) instanceof SimulationRun)) continue;
            SimulationRun cell = (SimulationRun)((Object)obj);
            selections.add(cell);
            System.out.println("executing alt " + cell);
        }
        SimulationRun[] runs = new SimulationRun[selections.size()];
        selections.toArray(runs);
        return runs;
    }

    public void runComplete(Object obj) {
        ClientMode curMode;
        if (obj == null) {
            this._cmdPanel.getButton(4096).setText("Compute");
            return;
        }
        System.out.println("SimRunManagerWindow(): run complete " + obj);
        if ("Compute Complete".equals(obj) && this._simulation != null) {
            SimulationRun[] runs = this.getRunsToExecute();
            Vector cells = this._simRunTable.getCells();
            for (int ii = 0; ii < runs.length; ++ii) {
                long dt;
                AltItem ai = this.getAltItem(runs[ii]);
                String s = "";
                if (ai != null && (dt = this._simulation.getAltComputeTime(ai.getAltName() + ai.getAltIndex(), ai.getProgram())) != 0L) {
                    s = this.getDateString(dt);
                }
                for (int jj = 0; jj < cells.size(); ++jj) {
                    Vector row = (Vector)cells.get(jj);
                    if (!row.get(1).equals((Object)runs[ii])) continue;
                    this._simRunTable.setCell((Object)s, jj, 3);
                    break;
                }
                System.out.println("computed time for " + runs[ii] + " is " + s);
            }
        } else if ("Compute Failed".equals(obj) && this._simulation != null) {
            SimulationRun currentRun = this._simulation.getCurrentComputingRun();
            SimulationRun[] runs = this.getRunsToExecute();
            Vector cells = this._simRunTable.getCells();
            for (int i = 0; i < this._simRunTable.getRowCount(); ++i) {
                if (this._simRunTable.getValueAt(i, 1) != currentRun) continue;
                this._simRunTable.setRowForeground(i, Color.RED);
                this._simRunTable.setValueAt((Object)"Compute Failed", i, 3);
                this._simRunTable.repaint();
                break;
            }
        }
        if ((curMode = ClientApp.frame().getCurrentMode()) instanceof RunObserver) {
            ((RunObserver)curMode).runComplete(obj);
        }
        if (this._closeOnCompletionCheck.isSelected()) {
            this.setVisible(false);
        } else {
            this.toFront();
        }
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            this._mode.removeRunObserver(this);
            this._simulation = null;
            this._runs = null;
            this._simRunTable.deleteCells();
        }
        super.setVisible(visible);
        if (!visible) {
            this.dispose();
        }
    }
}

