/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.client.RenameDlg;
import hec.clientapp.client.AbstractSimRunTreeNode;
import hec.clientapp.client.AbstractSimulationMode;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.CreateTrialRunDialog;
import hec.clientapp.client.SimulationMode;
import hec.clientapp.client.SimulationRunTreeNode;
import hec.clientapp.client.SimulationTreeNode;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.clientapp.model.TrialRun;
import hec.lang.LockFailedException;
import hec.model.AltItem;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import rma.swing.RmaJMenuLabel;
import rma.util.RMAIO;

public class SimTrialRunTreeNode
extends SimulationRunTreeNode {
    private static final String RENAME_TRIAL = "Rename";
    private int _position;
    private String _posStr;

    public SimTrialRunTreeNode(SimulationTrialRun run, JTree tree) {
        super(run, tree);
    }

    public void setPosition(int pos) {
        this._position = pos;
        this._posStr = pos + ": ";
    }

    @Override
    public String toString() {
        if (this.getParent() instanceof SimulationRunTreeNode) {
            SimulationRunTreeNode parent = (SimulationRunTreeNode)this.getParent();
            int idx = parent.getIndex(this) + 1;
            return String.valueOf(idx) + ": " + this.m_simulationRun.toString();
        }
        return this._posStr + this.m_simulationRun.toString();
    }

    @Override
    public SimulationRun getActiveTrial() {
        if (this.getTrialSimulationRun().isActiveTrial()) {
            return this.getTrialSimulationRun();
        }
        return null;
    }

    public SimulationTrialRun getTrialSimulationRun() {
        return (SimulationTrialRun)super.getSimulationRun();
    }

    @Override
    public SimulationRun getSimulationRun() {
        return this.getTrialSimulationRun().getRunParent();
    }

    public boolean isCurrentTrial() {
        return this.getTrialSimulationRun().isCurrentTrial();
    }

    public boolean isBaseTrial() {
        return this.getTrialSimulationRun().isBaseTrial();
    }

    public int getPosition() {
        return this._position;
    }

    public boolean isActiveTrial() {
        return this.getTrialSimulationRun().isActiveTrial();
    }

    public void setCurrentTrial(boolean current) {
        this.getTrialSimulationRun().setCurrentTrial(current);
        if (this.m_tree != null) {
            ((DefaultTreeModel)this.m_tree.getModel()).nodeChanged(this);
        }
        if (current) {
            SimulationRunTreeNode parent = (SimulationRunTreeNode)this.getParent();
            parent.setCurrentTrial(this);
        }
    }

    public void setActiveTrial(boolean active) {
        if (active) {
            try {
                if (!this.getTrialSimulationRun().setModelsLocked(4)) {
                    JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), "Failed to get write lock for " + this.toString(), "Set Active Failed", 2);
                    return;
                }
            }
            catch (LockFailedException lfe) {
                JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), "Failed to get write lock for " + this.toString() + "\n" + lfe.getMessage(), "Set Active Failed", 2);
            }
            SimulationRunTreeNode parent = (SimulationRunTreeNode)this.getParent();
            parent.setActiveTrial(this);
            this.setCurrentTrial(active);
            this.setSelected(true);
        } else {
            try {
                this.getTrialSimulationRun().setModelsLocked(5);
            }
            catch (LockFailedException lfe) {
                System.out.println("setActiveTrial:" + lfe);
            }
        }
        this.getTrialSimulationRun().setActiveTrial(active);
        this.setRunModifiedIfOptionSet();
        if (this._tree != null) {
            ((DefaultTreeModel)this._tree.getModel()).nodeChanged(this);
        }
    }

    @Override
    protected void setRunModifiedIfOptionSet() {
        AbstractSimulationMode simMode;
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (mode instanceof AbstractSimulationMode && (simMode = (AbstractSimulationMode)mode).getSaveSimTreeState()) {
            this.getTrialSimulationRun().setModified(true);
        }
    }

    @Override
    public void setSelected(boolean b) {
        boolean prevSelectedState = this.m_simulationRun.isSelected();
        this.getTrialSimulationRun().setSelected(b);
        if (prevSelectedState != b) {
            this.setRunModifiedIfOptionSet();
        }
    }

    @Override
    public boolean isSelected() {
        return this.getTrialSimulationRun().isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)obj;
            String mName = menuItem.getName();
            if (mName == null) {
                return;
            }
            super.actionPerformed(e);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (!(mode instanceof SimulationMode)) {
            System.out.println("-----------------------------------------------------------------------");
            System.out.println("Current Mode does not Implement hec.clientapp.client.SimulationMode.  Can't");
            System.out.println("Continue!");
            System.out.println("-----------------------------------------------------------------------");
            return null;
        }
        JPopupMenu popup = new JPopupMenu();
        RmaJMenuLabel label = new RmaJMenuLabel("Trial : " + this.m_simulationRun.toString());
        popup.add((JMenuItem)label);
        popup.addSeparator();
        SimulationPeriod simPeriod = this.getSimulation();
        JMenuItem menuItem = new JMenuItem("Compute");
        menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "onComputeMenuItem"));
        popup.add(menuItem);
        if (this.isActiveTrial()) {
            Vector<AltItem> altList = this.getTrialSimulationRun().getAltList();
            if (altList.size() > 2) {
                boolean writePermission = mode.checkModePermission(3);
                JMenu menu = new JMenu(writePermission ? "Edit" : "View");
                this.buildModelMenus(this.getTrialSimulationRun(), writePermission ? "editModel" : "viewModel", menu);
                popup.add(menu);
            } else if (altList.size() == 1) {
                String txt = mode.checkModePermission(3) ? "editModel" : "viewModel";
                AltItem ai = altList.get(0);
                AbstractSimRunTreeNode.AltItemJMenuItem aitem = new AbstractSimRunTreeNode.AltItemJMenuItem("Edit Run", ai);
                aitem.setName(txt);
                String programName = ai.getProgram();
                if (programName != null) {
                    String upperCaseProgramName = programName.toUpperCase();
                    if (ProgramOrderItem.isStandardModel((String)programName)) {
                        if ("RSS".equalsIgnoreCase(upperCaseProgramName)) {
                            upperCaseProgramName = "ResSim";
                        } else if (programName.toLowerCase().startsWith("hfp")) {
                            upperCaseProgramName = "HMS";
                        }
                    } else {
                        upperCaseProgramName = ai.getProgram();
                    }
                    aitem.setActionCommand(upperCaseProgramName);
                }
                aitem.setToolTipText(this.getToolTipText(this.getTrialSimulationRun(), aitem));
                aitem.addActionListener(this);
                popup.add(aitem);
            }
        }
        if (!this.isActiveTrial()) {
            menuItem = new JMenuItem("Set As Active");
            menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "onSetActiveMenuItem"));
            popup.add(menuItem);
        }
        if (mode.checkModePermission(3)) {
            popup.addSeparator();
            menuItem = new JMenuItem("New Trial");
            menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "onNewTrialMenuItem"));
            popup.add(menuItem);
        }
        if (this.isActiveTrial()) {
            menuItem = new JMenuItem("Accept " + this.getTrialSimulationRun().getName());
            menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "acceptTrial"));
            popup.add(menuItem);
        }
        if (mode.checkModePermission(3)) {
            menuItem = new JMenuItem("Restore from Original Alternative");
            menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "onRestoreFromOriginalMenuItem"));
            popup.add(menuItem);
        }
        if (mode.checkModePermission(3)) {
            popup.addSeparator();
            menuItem = new JMenuItem("Rename Trial");
            menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "renameTrial"));
            menuItem.setName(RENAME_TRIAL);
            popup.add(menuItem);
        }
        if (mode.checkModePermission(3)) {
            popup.addSeparator();
            menuItem = new JMenuItem("Delete Trial");
            menuItem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)menuItem, "onDeleteTrialMenuItem"));
            popup.add(menuItem);
        }
        return popup;
    }

    @Override
    public void onSetActiveMenuItem() {
        this.setActiveTrial(true);
    }

    @Override
    public void onNewTrialMenuItem() {
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (!(mode instanceof AbstractSimulationMode)) {
            System.out.println("onNewTrialMenuItem: Not in a Simulation Module.");
            return;
        }
        AbstractSimulationMode simMode = (AbstractSimulationMode)mode;
        CreateTrialRunDialog dialog = new CreateTrialRunDialog((Frame)((Object)ClientApp.frame()), true);
        if (this.m_tree != null) {
            SimulationTreeNode root = (SimulationTreeNode)this._tree.getModel().getRoot();
            dialog.setSimulation(root.getSimulation());
        }
        dialog.setBaseTrial(this.getTrialSimulationRun());
        dialog.fillForm();
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        TrialRun newTrial = dialog.getNewTrialRun();
        if (newTrial == null) {
            return;
        }
        SimulationRunTreeNode parent = (SimulationRunTreeNode)this.getParent();
        SimulationRunTreeNode trialNode = simMode.newSimulationRunTreeNode((SimulationTrialRun)newTrial, this._tree);
        parent.add(trialNode);
        ((DefaultTreeModel)this.m_tree.getModel()).nodeStructureChanged(this.getParent());
        this.orderNodeNumbers();
        ((SimTrialRunTreeNode)trialNode).setActiveTrial(true);
        trialNode.setSelected(true);
        this.expand();
    }

    @Override
    public void onReplaceFromBaseMenuItem() {
        this.replaceFromSimRunFromBase(this.getTrialSimulationRun());
    }

    public void onRestoreFromOriginalMenuItem() {
        this.replaceFromSimRunFromBase(this.getTrialSimulationRun());
    }

    public void onDeleteTrialMenuItem() {
        int opt = JOptionPane.showConfirmDialog(this._tree, "Ok to Delete Trial " + this.toString(), "Confirm Deletetion", 0);
        if (opt == 1) {
            return;
        }
        boolean resetComputeButton = false;
        SimulationRun run = this.getSimulationRun();
        if (this.getTrialSimulationRun().isActiveRun()) {
            resetComputeButton = true;
        }
        if (run.removeTrial(this.getTrialSimulationRun())) {
            SimulationRunTreeNode parent = (SimulationRunTreeNode)this.getParent();
            int index = parent.getIndex(this);
            int[] i = new int[]{index};
            Object[] obj = new Object[]{this};
            parent.remove(this);
            ((DefaultTreeModel)this._tree.getModel()).nodesWereRemoved(parent, i, obj);
            if (resetComputeButton) {
                parent.setActiveRun(true);
                ClientMode mode = ClientApp.frame().getCurrentMode();
                if (mode instanceof AbstractSimulationMode) {
                    ((AbstractSimulationMode)mode).updateComputeButton();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this._tree, "Deletion of Trial " + this.toString() + " Failed.", "Error on Deletion", 0);
        }
    }

    private void copyToWorking() {
    }

    private void refreshData() {
    }

    public void renameTrial() {
        SimulationTrialRun run = this.getTrialSimulationRun();
        RenameDlg renameDlg = new RenameDlg((Frame)((Object)ClientApp.frame()), "Rename Simulation Trial Run", true);
        renameDlg.setName(run.getUserName());
        renameDlg.setDescription(run.getDescription());
        renameDlg.setFileNameVisible(false);
        renameDlg.setVisible(true);
        if (renameDlg.getCanceled()) {
            return;
        }
        run.setUserName(renameDlg.getName());
        run.setDescription(renameDlg.getDescription());
        ((DefaultTreeModel)this._tree.getModel()).nodeChanged(this);
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (mode instanceof AbstractSimulationMode) {
            ((AbstractSimulationMode)mode).updateComputeButton();
        }
    }

    public void acceptTrial() {
        SimulationTrialRun trial = this.getTrialSimulationRun();
        String trialInfo = trial.getName();
        String model = RMAIO.getType((String)trialInfo, (String)" ");
        String tmp = RMAIO.getParam((String)trialInfo, (String)" ");
        String trialKey = RMAIO.getParam((String)tmp, (String)" ");
        int pos = trial.getTrialPosition();
        Vector<AltItem> v = trial.getAltList();
        if (pos < 0 || pos > v.size() - 1) {
            return;
        }
        AltItem altItem = v.get(pos);
        if (altItem == null) {
            return;
        }
        int opt = JOptionPane.showConfirmDialog(this.m_tree, "Are you sure you want to accept Trial " + this.toString() + "?", "Confirm Trial Acceptance", 0);
        if (opt != 0) {
            return;
        }
        AbstractSimulationMode simMode = (AbstractSimulationMode)ClientApp.frame().getCurrentMode();
        simMode.saveSimulation();
        SimulationRunTreeNode parentNode = (SimulationRunTreeNode)this.getParent();
        System.out.println("accepting trial " + altItem + " pos=" + pos + " trialKey=" + trialKey);
        if (!parentNode.getSimulationRun().acceptTrial(altItem, pos, trialKey, true)) {
            JOptionPane.showMessageDialog(this.m_tree, "Failed to accept " + trial.getUserName());
        } else {
            JOptionPane.showMessageDialog(this.m_tree, "Trial " + trial.getUserName() + " accepted", "Trial Accepted", 1);
            if (simMode.getActiveRun() == parentNode.getSimulationRun()) {
                parentNode.getSimulationRun().unloading();
                simMode.updateManagerMaps();
            }
            this.getTrialSimulationRun().setAccepted(true);
            int[] index = new int[]{this.getParent().getIndex(this)};
            System.out.println("acceptTrial:index =" + index[0]);
            Object[] node = new Object[]{this};
            ((DefaultTreeModel)this.m_tree.getModel()).nodesWereRemoved(this.getParent(), index, node);
            ((SimulationRunTreeNode)this.getParent()).remove(this);
            this.m_tree.revalidate();
        }
    }
}

