/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.AbstractSimRunTreeNode;
import hec.clientapp.client.AbstractSimulationMode;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.CopySimulationRunDataDialog;
import hec.clientapp.client.CreateTrialRunDialog;
import hec.clientapp.client.SimTrialRunTreeNode;
import hec.clientapp.client.SimulationMode;
import hec.clientapp.client.SimulationTreeNode;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListManager;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.clientapp.supplemental.client.SupplementalAltArgsJDialog;
import hec.clientapp.supplemental.model.SupplementalProgramAlt;
import hec.lang.LockFailedException;
import hec.lang.ModelReference;
import hec.lang.WorkspaceNameFactory;
import hec.model.AltItem;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import rma.swing.RmaJMenuLabel;
import rma.swing.event.ReflectMultiListener;
import rma.swing.tree.CheckBoxNode;
import rma.swing.tree.PopupTreeNode;
import rma.util.RMAIO;

public class SimulationRunTreeNode
extends AbstractSimRunTreeNode
implements CheckBoxNode,
PopupTreeNode,
ActionListener {
    protected static final String RUN_MODEL = "runModel";
    protected static final String EDIT_MODEL = "editModel";
    protected static final String VIEW_MODEL = "viewModel";
    protected static final String ACTIVE_TRIAL = "activeTrial";
    protected static final String INACTIVE_TRIAL = "inActiveTrial";
    protected JTree m_tree;
    protected SimulationRun m_simulationRun;
    protected ReflectMultiListener m_rml = new ReflectMultiListener();
    private SimulationRun m_activeRun = null;
    private SimTrialRunTreeNode m_currentTrial;
    private SimTrialRunTreeNode m_activeTrial = null;
    private int _nextPos = 0;

    public SimulationRunTreeNode(SimulationRun simRun, JTree tree) {
        super(tree);
        this.m_tree = tree;
        this.m_simulationRun = simRun;
        this.addTrials();
        this.setUserObject((Object)simRun);
        this.orderNodeNumbers();
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent() == SimulationRunTreeNode.this) {
                    SimulationRunTreeNode.this.setRunExpanded(false);
                }
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent() == SimulationRunTreeNode.this) {
                    SimulationRunTreeNode.this.setRunExpanded(true);
                }
            }
        });
    }

    protected void addTrials() {
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (!(mode instanceof SimulationMode)) {
            return;
        }
        SimulationMode simMode = (SimulationMode)((Object)mode);
        Vector v = this.m_simulationRun.getTrials();
        for (int i = 0; i < v.size(); ++i) {
            SimulationTrialRun trial = (SimulationTrialRun)v.get(i);
            if (trial == null || trial.isAccepted()) continue;
            this.add(simMode.newSimulationRunTreeNode(trial, this._tree));
        }
    }

    public String getModelAltClassName() {
        return "hec.watershed.model.ModelAlt";
    }

    private JPopupMenu createPopupMenu() {
        JMenuItem mitem;
        JPopupMenu popupMenu = new JPopupMenu();
        RmaJMenuLabel label = new RmaJMenuLabel(this.m_simulationRun.getName());
        if (this._models == null) {
            this.getModels();
        }
        ClientMode mode = ClientApp.frame().getCurrentMode();
        popupMenu.add((JMenuItem)label);
        popupMenu.addSeparator();
        if (this._models == null || this._models.size() == 1) {
            mitem = new JMenuItem("Compute");
            mitem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)mitem, "onComputeMenuItem"));
            popupMenu.add(mitem);
        } else {
            JMenu menu = new JMenu("Compute");
            menu.setName(RUN_MODEL);
            menu.addMouseListener(new AbstractSimRunTreeNode.MyMouseAdapter(menu));
            this.buildModelMenus(this.getSimulationRun(), RUN_MODEL, menu, false);
            popupMenu.add(menu);
        }
        if (this.m_simulationRun.isActiveRun()) {
            Vector<AltItem> altList = this.m_simulationRun.getAltList();
            if (altList.size() > 2) {
                JMenu menu = new JMenu(mode.checkModePermission(3) ? "Edit" : "View");
                this.buildModelMenus(this.getSimulationRun(), mode.checkModePermission(3) ? EDIT_MODEL : VIEW_MODEL, menu);
                popupMenu.add(menu);
            } else if (altList.size() > 0) {
                String txt = mode.checkModePermission(3) ? EDIT_MODEL : VIEW_MODEL;
                AltItem ai = altList.get(0);
                AbstractSimRunTreeNode.AltItemJMenuItem aitem = new AbstractSimRunTreeNode.AltItemJMenuItem("Edit Run", ai);
                aitem.setName(txt);
                String programName = ai.getProgram();
                String upperCaseProgramName = programName.toUpperCase();
                if (ProgramOrderItem.isStandardModel((String)programName)) {
                    if ("RSS".equalsIgnoreCase(upperCaseProgramName)) {
                        upperCaseProgramName = "ResSim";
                    } else if (programName.toLowerCase().startsWith("hfp")) {
                        upperCaseProgramName = "HMS";
                    }
                } else {
                    upperCaseProgramName = ai.getProgram();
                }
                aitem.setActionCommand(upperCaseProgramName);
                aitem.setToolTipText(this.getToolTipText(this.getSimulationRun(), aitem));
                aitem.addActionListener(this);
                popupMenu.add(aitem);
            }
        }
        popupMenu.addSeparator();
        if (this.m_simulationRun.isActiveRun()) {
            mitem = new JMenuItem("Set As InActive");
            mitem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)mitem, "onSetUnActiveMenuItem"));
            popupMenu.add(mitem);
        } else {
            mitem = new JMenuItem("Set As Active");
            mitem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)mitem, "onSetActiveMenuItem"));
            popupMenu.add(mitem);
        }
        mitem = new JMenuItem("New Trial...");
        mitem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)mitem, "onNewTrialMenuItem"));
        popupMenu.add(mitem);
        mitem = new JMenuItem("Replace From Base Directory...");
        mitem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)mitem, "onReplaceFromBaseMenuItem"));
        popupMenu.add(mitem);
        mitem = new JMenuItem("Save to Base Directory...");
        mitem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)mitem, "onSaveToBaseMenuItem"));
        popupMenu.add(mitem);
        boolean addedSep = false;
        if (this.getPreviousSibling() != null) {
            popupMenu.addSeparator();
            addedSep = true;
            mitem = new JMenuItem("Move Up");
            mitem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)mitem, "moveUp"));
            popupMenu.add(mitem);
        }
        if (this.getNextSibling() != null) {
            if (!addedSep) {
                popupMenu.addSeparator();
            }
            mitem = new JMenuItem("Move Down");
            mitem.addActionListener((ActionListener)this.m_rml.add((Object)this, (Object)mitem, "moveDown"));
            popupMenu.add(mitem);
        }
        return popupMenu;
    }

    public boolean isSelected() {
        return this.m_simulationRun.isSelected();
    }

    public void setSelected(boolean b) {
        boolean prevSelectedState = this.m_simulationRun.isSelected();
        this.m_simulationRun.setSelected(b);
        if (prevSelectedState != b) {
            this.setRunModifiedIfOptionSet();
        }
    }

    public void setRunExpanded(boolean expanded) {
        boolean prevExpandedState = this.m_simulationRun.isExpanded();
        this.m_simulationRun.setExpanded(expanded);
        if (prevExpandedState != expanded) {
            this.setRunModifiedIfOptionSet();
        }
    }

    protected void setRunModifiedIfOptionSet() {
        AbstractSimulationMode simMode;
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (mode instanceof AbstractSimulationMode && (simMode = (AbstractSimulationMode)mode).getSaveSimTreeState()) {
            this.m_simulationRun.setModified(true);
        }
    }

    public int getSelectionMode() {
        throw new UnsupportedOperationException("Method getSelectionMode() not yet implemented.");
    }

    @Override
    public String toString() {
        return this.m_simulationRun.toString();
    }

    public SimulationRun getSimulationRun() {
        return this.m_simulationRun;
    }

    public SimulationPeriod getSimulation() {
        if (this._tree != null) {
            SimulationTreeNode root = (SimulationTreeNode)this._tree.getModel().getRoot();
            return root.getSimulation();
        }
        return null;
    }

    public SimulationRun getActiveTrial() {
        if (this.hasActiveTrial()) {
            return this.m_activeTrial.getTrialSimulationRun();
        }
        return null;
    }

    public SimTrialRunTreeNode getActiveTrialNode() {
        return this.m_activeTrial;
    }

    public void setActiveTrial(SimTrialRunTreeNode node) {
        System.out.println("setActiveTrial:node=" + node);
        if (this.m_activeTrial != null && this.m_activeTrial != node) {
            this.m_activeTrial.setActiveTrial(false);
        }
        if (this.m_tree != null) {
            ((DefaultTreeModel)this.m_tree.getModel()).nodeChanged(this);
        }
        if (this.isActiveRun()) {
            this.setActiveRun(false);
        }
        this.m_activeTrial = node;
        if (node != null && this.m_tree != null) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getParent();
            Enumeration<TreeNode> e = parent.children();
            while (e.hasMoreElements()) {
                SimulationRunTreeNode sibling = (SimulationRunTreeNode)e.nextElement();
                if (sibling == this) continue;
                sibling.setActiveTrial(null);
            }
            if (parent instanceof SimulationTreeNode) {
                ((SimulationTreeNode)parent).setActiveRun(this.m_activeTrial.getTrialSimulationRun());
            }
        }
    }

    public void setCurrentTrial(SimTrialRunTreeNode node) {
        if (this.m_currentTrial != null && this.m_currentTrial != node) {
            this.m_currentTrial.setCurrentTrial(false);
        }
        this.m_currentTrial = node;
        if (this.m_tree != null) {
            ((DefaultTreeModel)this.m_tree.getModel()).nodeChanged(this);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.createPopupMenu();
    }

    public void onComputeMenuItem() {
        boolean recomputeAll = (this.m_rml.getModifiers() & 2) != 0;
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (!(mode instanceof SimulationMode)) {
            return;
        }
        boolean recompute = ((SimulationMode)((Object)mode)).getForceRecompute();
        if (recomputeAll) {
            recompute = true;
        }
        ((SimulationMode)((Object)mode)).computeRun(this.m_simulationRun, -1, recompute);
    }

    public void onNewTrialMenuItem() {
        CreateTrialRunDialog dialog = new CreateTrialRunDialog((Frame)((Object)ClientApp.frame()), true);
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (!(mode instanceof AbstractSimulationMode)) {
            System.out.println("onNewTrialMenuItem: Not in a Simulation Module.");
            return;
        }
        AbstractSimulationMode simMode = (AbstractSimulationMode)mode;
        SimulationPeriod f = null;
        if (this._tree != null) {
            SimulationTreeNode root = (SimulationTreeNode)this._tree.getModel().getRoot();
            f = root.getSimulation();
            dialog.setSimulation(f);
        }
        if (f == null) {
            if (Boolean.getBoolean("DEBUG")) {
                System.out.println("ERROR <SimulationRunTreeNode.onNewTrialMenuItem()> : Retrieved a NULL Simulation Period from the ROOT");
            }
            return;
        }
        dialog.setSimulationRun(this.getSimulationRun());
        dialog.fillForm();
        if (dialog.getNewTrialName(false) == null) {
            JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), "The maximum number of trials for " + this.getSimulationRun().getUserName() + " has been reached.\nYou will need to delete a trial in order to create another one for this Run.");
            return;
        }
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
        SimulationTrialRun newTrial = (SimulationTrialRun)dialog.getNewTrialRun();
        if (newTrial == null) {
            return;
        }
        SimulationRunTreeNode trialNode = simMode.newSimulationRunTreeNode(newTrial, this._tree);
        this.add(trialNode);
        this.orderNodeNumbers();
        ((DefaultTreeModel)this._tree.getModel()).nodeStructureChanged(this.getParent());
        ((SimTrialRunTreeNode)trialNode).setActiveTrial(true);
        trialNode.setSelected(true);
        this.expand();
    }

    public void add(SimTrialRunTreeNode node) {
        if (node != null) {
            node.setPosition(this.getNextPosition());
        }
        Enumeration<TreeNode> children = this.children();
        String newNodeString = node.getTrialSimulationRun().getTrialKey();
        boolean inserted = false;
        int index = 0;
        while (children.hasMoreElements()) {
            SimTrialRunTreeNode kidNode = (SimTrialRunTreeNode)children.nextElement();
            if (newNodeString.compareTo(kidNode.getTrialSimulationRun().getTrialKey()) < 0) {
                this.insert(node, index);
                inserted = true;
                break;
            }
            ++index;
        }
        if (!inserted) {
            super.add(node);
        }
    }

    public void orderNodeNumbers() {
        Enumeration<TreeNode> kids = this.children();
        int pos = 1;
        while (kids.hasMoreElements()) {
            SimTrialRunTreeNode child = (SimTrialRunTreeNode)kids.nextElement();
            child.setPosition(pos++);
        }
        this._nextPos = pos;
    }

    public void onSetActiveMenuItem() {
        this.setActiveRun(true);
    }

    public void onSetUnActiveMenuItem() {
        this.setActiveRun(false);
    }

    @Override
    public boolean hasActiveTrial() {
        if (this.m_activeTrial != null) {
            return true;
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            SimTrialRunTreeNode kid = (SimTrialRunTreeNode)e.nextElement();
            if (!kid.isActiveTrial()) continue;
            this.m_activeTrial = kid;
            return true;
        }
        return false;
    }

    @Override
    public boolean isActiveRun() {
        return this.m_simulationRun.isActiveRun();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveRun(boolean active) {
        try {
            ClientApp.frame().setWaitCursor();
            if (active) {
                try {
                    if (!this.m_simulationRun.setModelsLocked(4)) {
                        JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), "Failed to get write lock for " + this.toString(), "Set Active Failed", 2);
                        return;
                    }
                }
                catch (LockFailedException lfe) {
                    JOptionPane.showMessageDialog((Component)((Object)ClientApp.frame()), "Failed to get write lock for " + this.toString() + "\n" + lfe.getMessage(), "Set Active Failed", 2);
                }
            } else if (!active && this.m_simulationRun.isActiveRun()) {
                try {
                    this.m_simulationRun.setModelsLocked(5);
                }
                catch (LockFailedException lfe) {
                    System.out.println("setActiveRun:" + lfe);
                }
                this.m_simulationRun.unloading();
            }
            boolean wasActive = this.m_simulationRun.isActiveRun();
            this.m_simulationRun.setActiveRun(active);
            this.setRunModifiedIfOptionSet();
            if (this.m_tree != null) {
                ((DefaultTreeModel)this.m_tree.getModel()).nodeChanged(this);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getParent();
                if (this.hasActiveTrial()) {
                    SimTrialRunTreeNode kidNode = this.getActiveTrialNode();
                    kidNode.setActiveTrial(false);
                }
                int cnt = this.getChildCount();
                for (int i = 0; i < cnt; ++i) {
                    SimTrialRunTreeNode kidNode = (SimTrialRunTreeNode)this.getChildAt(i);
                    kidNode.setActiveTrial(false);
                }
                if (active) {
                    this.setSelected(true);
                    Enumeration<TreeNode> e = parent.children();
                    while (e.hasMoreElements()) {
                        SimulationRunTreeNode sibling = (SimulationRunTreeNode)e.nextElement();
                        if (sibling == this) continue;
                        sibling.setActiveRun(false);
                    }
                    if (parent instanceof SimulationTreeNode) {
                        ((SimulationTreeNode)parent).setActiveRun(this.m_simulationRun);
                    }
                    this.m_activeTrial = null;
                } else if (wasActive) {
                    ((SimulationTreeNode)parent).setActiveRun(null);
                }
            }
        }
        finally {
            ClientApp.frame().setDefaultCursor();
        }
    }

    public void onSaveToBaseMenuItem() {
        CopySimulationRunDataDialog dialog = new CopySimulationRunDataDialog((Frame)((Object)ClientApp.frame()), true);
        if (this._tree != null) {
            SimulationTreeNode root = (SimulationTreeNode)this._tree.getModel().getRoot();
            dialog.setSimulation(root.getSimulation());
        }
        dialog.setSimulationRun(this.getSimulationRun());
        dialog.fillForm();
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
    }

    public void onReplaceFromBaseMenuItem() {
        this.replaceFromSimRunFromBase(this.getSimulationRun());
    }

    protected void replaceFromSimRunFromBase(SimulationRun simRun) {
        CopySimulationRunDataDialog dialog = new CopySimulationRunDataDialog((Frame)((Object)ClientApp.frame()), true);
        if (simRun instanceof SimulationTrialRun) {
            dialog.setForTrialUse();
        }
        dialog.setRefreshData();
        if (this._tree != null) {
            SimulationTreeNode root = (SimulationTreeNode)this._tree.getModel().getRoot();
            dialog.setSimulation(root.getSimulation());
        }
        dialog.setSimulationRun(simRun);
        dialog.fillForm();
        dialog.setVisible(true);
        if (dialog.isCanceled()) {
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ClientMode mode;
        Object obj = e.getSource();
        if (obj instanceof AbstractSimRunTreeNode.AltItemJMenuItem) {
            AbstractSimRunTreeNode.AltItemJMenuItem menuItem = (AbstractSimRunTreeNode.AltItemJMenuItem)obj;
            String mName = menuItem.getName();
            if (mName.startsWith(EDIT_MODEL) || mName.startsWith(VIEW_MODEL)) {
                String mode2 = RMAIO.getType((String)mName, (String)":");
                AltItem altItem = menuItem.getAltItem();
                String model = menuItem.getActionCommand();
                if (model == null) {
                    model = menuItem.getText();
                }
                int index = altItem.getAltIndex();
                if (model.endsWith("")) {
                    model = model.substring(0, model.length() - "".length());
                }
                if ("ResSim".equalsIgnoreCase(model)) {
                    this.editRss(index, mode2);
                } else if ("fia".equalsIgnoreCase(model)) {
                    this.editFIA(index, mode2);
                } else if ("ResPrm".equalsIgnoreCase(model)) {
                    this.editResPrm(index, mode2);
                }
            } else if (mName.startsWith(RUN_MODEL)) {
                String model = menuItem.getText();
                ClientMode mode3 = ClientApp.frame().getCurrentMode();
                if (mode3 instanceof AbstractSimulationMode) {
                    boolean recomputeAll;
                    AbstractSimulationMode simMode = (AbstractSimulationMode)mode3;
                    boolean bl = recomputeAll = (e.getModifiers() & 2) != 0;
                    if (model.equalsIgnoreCase("All")) {
                        simMode.computeRun(this.getSimulationRun(), -1, recomputeAll);
                    } else {
                        AbstractSimRunTreeNode.AltItemJMenuItem amenuItem = menuItem;
                        AltItem altItem = amenuItem.getAltItem();
                        simMode.computeRun(this.getSimulationRun(), altItem.getModelPosition(), recomputeAll);
                    }
                }
            }
        } else if (obj instanceof JMenu && (mode = ClientApp.frame().getCurrentMode()) instanceof AbstractSimulationMode) {
            Container c;
            AbstractSimulationMode simMode = (AbstractSimulationMode)mode;
            JMenu menu = (JMenu)obj;
            String mName = menu.getName();
            for (c = menu.getParent(); c != null && !(c instanceof JPopupMenu); c = c.getParent()) {
            }
            if (c != null) {
                ((JPopupMenu)c).setVisible(false);
            }
            if (mName.startsWith(RUN_MODEL)) {
                boolean recomputeAll = (e.getModifiers() & 2) != 0;
                simMode.computeRun(this.getSimulationRun(), -1, recomputeAll);
            }
        }
    }

    protected void editRss(int index, String mode) {
        System.out.println("editRss: unhandled model ");
    }

    protected void editResPrm(int index, String mode) {
        System.out.println("editResPrm: unhandled model");
    }

    protected void editFIA(int index, String mode) {
        System.out.println("editFia: unhandled model ");
    }

    protected void editSupplemental(int index, String mode) {
        ManagerProxy supAltProxy;
        System.out.println("editSupplemental " + index);
        ManagerProxyListManager simulation = null;
        if (this._tree != null) {
            SimulationTreeNode root = (SimulationTreeNode)this._tree.getModel().getRoot();
            simulation = root.getSimulation();
        }
        if (simulation == null) {
            return;
        }
        ModelAlt alt = (ModelAlt)simulation.openManager(ClientApp.app().getAppType(), "hec.watershed.model.ModelAlt", index);
        if (alt == null) {
            System.out.println("editSupplemental: failed to find Model Alternative with index " + index);
            return;
        }
        ModelReference ref = alt.getModelRef();
        if (ref == null) {
            System.out.println("editSupplemental: failed to find ModelReference in Model Alternative" + alt);
            return;
        }
        String model = WorkspaceNameFactory.getWorkspaceName((String)ref.wkspName, (boolean)true);
        if (model == null) {
            model = "supplemental";
        }
        if ((supAltProxy = simulation.getManagerProxy(model, ref.className, ref.newId)) == null) {
            System.out.println("editSupplemental: failed to find Alternative Proxy for " + ref);
            return;
        }
        if (!supAltProxy.getClassName().equals("hec.watershed.supplemental.model.SupplementalProgramAlt")) {
            System.out.println("editSupplemental: unexpected class found in ManagerProxy " + supAltProxy.getClassName());
            return;
        }
        SupplementalProgramAlt supalt = (SupplementalProgramAlt)supAltProxy.loadManager("hec.watershed.supplemental.model.SupplementalProgramAlt", supAltProxy.getId());
        if (supalt == null) {
            System.out.println("editSupplemental: failed to get Alternative from ManagerProxy");
            return;
        }
        SupplementalAltArgsJDialog dialog = new SupplementalAltArgsJDialog((Frame)((Object)ClientApp.frame()), true);
        dialog.setSupplementalAlt(supalt);
        dialog.setEditable(mode.equals(EDIT_MODEL));
        dialog.setVisible(true);
        dialog.dispose();
    }

    protected void moveUp() {
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        int idx = model.getIndexOfChild(model.getRoot(), this);
        if (Boolean.getBoolean("DEBUG")) {
            System.out.println("moveUp: idx=" + idx);
        }
        if (idx == 0) {
            return;
        }
        SimulationTreeNode root = (SimulationTreeNode)model.getRoot();
        root.remove(this);
        root.insert(this, --idx);
        model.nodeStructureChanged(root);
        if (idx == 0) {
            // empty if block
        }
    }

    protected void moveDown() {
        SimulationTreeNode root;
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        int idx = model.getIndexOfChild(model.getRoot(), this);
        if (idx >= (root = (SimulationTreeNode)model.getRoot()).getChildCount() - 1) {
            return;
        }
        root.remove(this);
        root.insert(this, ++idx);
        model.nodeStructureChanged(root);
    }

    public String getToolTipText() {
        String tip = this.m_simulationRun.getDescription();
        if (tip != null) {
            return RMAIO.toHtmlString((String)tip);
        }
        return null;
    }

    @Override
    public void remove(MutableTreeNode node) {
        super.remove(node);
        this.orderNodeNumbers();
    }
}

