/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.SimTrialRunTreeNode;
import hec.clientapp.client.SimulationRunTreeNode;
import hec.clientapp.client.SimulationTreeNode;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimulationRun;
import hec.event.ActiveRunChangeListener;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import rma.swing.tree.CheckBoxNode;
import rma.util.RMAIO;

public class SimulationTree
extends JTree {
    private SimulationTreeNode _root;
    protected int _iconWidth;
    ChangeEvent _changeEvent;

    public SimulationTree(SimulationTreeNode root) {
        super(root);
        this._root = root;
        this.setToolTipText(root.toString());
        Icon icon = UIManager.getIcon("CheckBox.icon");
        this._iconWidth = icon.getIconWidth();
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        this.setRowHeight(fm.getHeight() + 3);
    }

    public SimulationRun getActiveRun() {
        return this._root.getActiveRun();
    }

    public void activeRunChanged() {
        this.fireActiveRunChanged();
    }

    public void addActiveRunChangeListener(ActiveRunChangeListener e) {
        this.listenerList.add(ActiveRunChangeListener.class, e);
    }

    public void removeActiveRunChangeListener(ActiveRunChangeListener e) {
        this.listenerList.remove(ActiveRunChangeListener.class, e);
    }

    protected void fireActiveRunChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActiveRunChangeListener.class) continue;
            if (this._changeEvent == null) {
                this._changeEvent = new ChangeEvent(this);
            }
            ((ActiveRunChangeListener)listeners[i + 1]).activeRunChanged(this._changeEvent);
        }
    }

    public void updateActiveRunNode() {
        this._root.updateActiveRunNode();
    }

    public Vector getSelectedRuns() {
        return this._root.getSelectedRuns();
    }

    public Vector getSimulationRuns() {
        return this._root.getSimulationRuns();
    }

    public boolean hasTrials() {
        return this._root.hasTrials();
    }

    public void setActiveRun(SimulationRun run) {
        int sizeI = this._root.getChildCount();
        for (int i = 0; i < sizeI; ++i) {
            SimulationRunTreeNode runNode = (SimulationRunTreeNode)this._root.getChildAt(i);
            if (runNode.getSimulationRun() == run) {
                runNode.setActiveRun(true);
                return;
            }
            int sizeK = runNode.getChildCount();
            for (int k = 0; k < sizeK; ++k) {
                SimTrialRunTreeNode trialNode = (SimTrialRunTreeNode)runNode.getChildAt(k);
                if (trialNode.getTrialSimulationRun() != run) continue;
                trialNode.setActiveTrial(true);
                this.expandPath(new TreePath(runNode.getPath()));
                return;
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension d = super.getPreferredScrollableViewportSize();
        d.height = 200;
        d.width = 100;
        return d;
    }

    public boolean isOverCheckBox(Point p, int row) {
        if (p == null) {
            return false;
        }
        if (row > 0) {
            Rectangle r = this.getRowBounds(row);
            return p.x > r.x && p.x < r.x + this._iconWidth;
        }
        return false;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int row = this.getRowForLocation(e.getX(), e.getY());
        if (row > -1 && e.isAltDown() && e.isControlDown() && e.isShiftDown()) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return super.getToolTipText(e);
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getUserObject() != null) {
                return "<html>Node is: " + node.getClass().getName() + "<br>Node Object: " + node.getUserObject().getClass().getName() + "</html>";
            }
            return "<html>Node is: " + node.getClass().getName();
        }
        if (this.isOverCheckBox(e.getPoint(), row)) {
            TreePath path = this.getPathForRow(row);
            if (path == null) {
                return "";
            }
            Object obj = path.getLastPathComponent();
            if (obj instanceof CheckBoxNode) {
                CheckBoxNode node = (CheckBoxNode)obj;
                if (node.isSelected()) {
                    return "Uncheck box to turn off result plots";
                }
                return "Check box to turn on result plots";
            }
        }
        if (row == -1) {
            return super.getToolTipText();
        }
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path == null) {
            return super.getToolTipText();
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node instanceof SimulationRunTreeNode) {
            SimulationRunTreeNode simNode = (SimulationRunTreeNode)node;
            return this.getSimulationRunTreeNodeToolTipText(simNode);
        }
        return super.getToolTipText();
    }

    protected String getSimulationRunTreeNodeToolTipText(SimulationRunTreeNode simNode) {
        SimulationRun simRun = simNode.getSimulationRun();
        if (simRun.getAltList().size() == 1) {
            ModelAlt malt;
            SimTrialRunTreeNode trialnode;
            ModelAlt mAlt = simRun.getModelAlt(simRun.getAltList().get(0));
            if (mAlt == null) {
                return null;
            }
            ManagerProxy managerProxy = mAlt.getManagerProxy();
            if (managerProxy == null) {
                return null;
            }
            if (simNode instanceof SimTrialRunTreeNode && ((Object)((Object)(simRun = (trialnode = (SimTrialRunTreeNode)simNode).getTrialSimulationRun()))).getClass().getName().contains("RssSimTrialRun") && (malt = simRun.getModelAlt("rss")) != null) {
                Manager mgr = malt.getManager();
                String desc = "";
                if (mgr != null) {
                    desc = mgr.getDescription();
                }
                return RMAIO.toHtmlString((String)(simRun.getKey() + "\n" + desc), (int)25);
            }
            String key = simRun.getKey();
            return RMAIO.toHtmlString((String)(key + "\n" + simRun.getDescription()), (int)25);
        }
        return simNode.toString();
    }

    public SimulationRunTreeNode getNodeForRun(SimulationRun run) {
        if (run == null) {
            return null;
        }
        return this.getNodeForRun(this._root, run);
    }

    private SimulationRunTreeNode getNodeForRun(DefaultMutableTreeNode parent, SimulationRun run) {
        if (parent == null || run == null) {
            return null;
        }
        int cnt = parent.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            SimulationRunTreeNode simRunNode;
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            if (child instanceof SimulationRunTreeNode && (simRunNode = (SimulationRunTreeNode)child).getSimulationRun() == run) {
                return simRunNode;
            }
            if (child.getChildCount() <= 0 || (simRunNode = this.getNodeForRun(child, run)) == null) continue;
            return simRunNode;
        }
        return null;
    }

    @Override
    public int getRowHeight() {
        return super.getRowHeight() + 5;
    }
}

