/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.clientapp.client.SimTrialRunTreeNode;
import hec.clientapp.client.SimulationMode;
import hec.clientapp.client.SimulationRunTreeNode;
import hec.clientapp.client.SimulationTree;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.event.ModifiableListener;
import java.awt.EventQueue;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import rma.lang.Modifiable;
import rma.swing.event.ReflectMultiListener;
import rma.swing.tree.CheckBoxNode;
import rma.swing.tree.PopupTreeNode;

public class SimulationTreeNode
extends DefaultMutableTreeNode
implements PopupTreeNode {
    protected SimulationTree m_parentTree = null;
    protected SimulationPeriod m_simulation = null;
    protected SimulationRun m_activeRun = null;
    private JPopupMenu m_popupMenu = null;
    private ReflectMultiListener m_rml = null;
    JMenuItem m_closeMenuItem;
    JMenuItem m_saveMenuItem;
    JMenuItem m_editMenuItem;
    private String _noSimulationString = "No Simulation";
    private String _modifiedFlag = "";

    private JPopupMenu createPopupMenu() {
        if (ClientApp.app() == null || ClientApp.frame() == null) {
            return null;
        }
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (!(mode instanceof SimulationMode)) {
            return null;
        }
        if (this.m_popupMenu == null) {
            this.m_rml = new ReflectMultiListener();
            this.m_popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("New");
            menuItem.addActionListener((ActionListener)this.m_rml.add((Object)mode, (Object)menuItem, "createNewSimulation"));
            this.m_popupMenu.add(menuItem);
            menuItem = new JMenuItem("Open");
            menuItem.addActionListener((ActionListener)this.m_rml.add((Object)mode, (Object)menuItem, "openSimulation"));
            this.m_popupMenu.add(menuItem);
            this.m_closeMenuItem = new JMenuItem("Close");
            this.m_closeMenuItem.addActionListener((ActionListener)this.m_rml.add((Object)mode, (Object)this.m_closeMenuItem, "closeSimulation"));
            this.m_popupMenu.add(this.m_closeMenuItem);
            this.m_saveMenuItem = new JMenuItem("Save");
            this.m_saveMenuItem.addActionListener((ActionListener)this.m_rml.add((Object)mode, (Object)this.m_saveMenuItem, "saveSimulation"));
            this.m_popupMenu.add(this.m_saveMenuItem);
            this.m_editMenuItem = new JMenuItem("Edit");
            this.m_editMenuItem.addActionListener((ActionListener)this.m_rml.add((Object)mode, (Object)this.m_editMenuItem, "editSimulation"));
            this.m_popupMenu.add(this.m_editMenuItem);
        }
        if (this.m_simulation != null) {
            this.m_closeMenuItem.setEnabled(true);
            this.m_saveMenuItem.setEnabled(true);
            this.m_editMenuItem.setEnabled(true);
        } else {
            this.m_closeMenuItem.setEnabled(false);
            this.m_saveMenuItem.setEnabled(false);
            this.m_editMenuItem.setEnabled(false);
        }
        return this.m_popupMenu;
    }

    public void setNoSimulationString(String noSimString) {
        this._noSimulationString = noSimString;
    }

    @Override
    public String toString() {
        if (this.m_simulation == null) {
            return this._noSimulationString;
        }
        return this.m_simulation.toString() + this._modifiedFlag;
    }

    public void setTree(JTree tree) {
        if (tree instanceof SimulationTree) {
            this.m_parentTree = (SimulationTree)tree;
        }
    }

    public void updateActiveRunNode() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            SimulationRunTreeNode node = (SimulationRunTreeNode)e.nextElement();
            if (!node.hasActiveTrial()) continue;
            ((DefaultTreeModel)this.m_parentTree.getModel()).nodeChanged(node);
            break;
        }
    }

    public SimulationRun getActiveRun() {
        if (this.m_activeRun == null) {
            if (this.getChildCount() == 1 && this.getChildAt(0).getChildCount() == 0) {
                ((SimulationRunTreeNode)this.getChildAt(0)).setActiveRun(true);
            }
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                SimulationRunTreeNode node = (SimulationRunTreeNode)e.nextElement();
                if (node.hasActiveTrial()) {
                    this.m_activeRun = node.getActiveTrial();
                    break;
                }
                if (!node.isActiveRun()) continue;
                this.m_activeRun = node.getSimulationRun();
            }
        }
        return this.m_activeRun;
    }

    public SimulationRunTreeNode getActiveNode() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            SimulationRunTreeNode node = (SimulationRunTreeNode)e.nextElement();
            if (node.hasActiveTrial()) {
                return node;
            }
            if (!node.isActiveRun()) continue;
            return node;
        }
        return null;
    }

    public SimulationPeriod getSimulation() {
        return this.m_simulation;
    }

    public void setActiveRun(SimulationRun run) {
        this.m_activeRun = run;
        if (this.m_parentTree != null) {
            this.m_parentTree.activeRunChanged();
        }
    }

    public Vector getSimulationRuns() {
        return this.getSimulationRuns(false);
    }

    public Vector getSelectedRuns() {
        return this.getSimulationRuns(true);
    }

    private Vector getSimulationRuns(boolean selectedOnly) {
        Vector<SimulationRun> v = new Vector<SimulationRun>();
        Enumeration<TreeNode> e = this.children();
        DefaultTreeModel model = (DefaultTreeModel)this.m_parentTree.getModel();
        while (e.hasMoreElements()) {
            TreeNode node = e.nextElement();
            if (!(node instanceof CheckBoxNode)) continue;
            CheckBoxNode cbNode = (CheckBoxNode)node;
            if (!this.m_parentTree.isVisible(new TreePath(model.getPathToRoot(node))) || cbNode instanceof SimTrialRunTreeNode || !(cbNode instanceof SimulationRunTreeNode)) continue;
            SimulationRunTreeNode runNode = (SimulationRunTreeNode)cbNode;
            if (cbNode.isSelected() || !selectedOnly) {
                v.add(runNode.getSimulationRun());
            }
            v.addAll(this.getTrialRuns(selectedOnly, runNode));
        }
        return v;
    }

    public Vector getTrialRuns(boolean selectedOnly, SimulationRunTreeNode node) {
        Vector<SimulationTrialRun> trials = new Vector<SimulationTrialRun>();
        if (node == null) {
            return trials;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.m_parentTree.getModel();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode kidnode = e.nextElement();
            if (!(kidnode instanceof CheckBoxNode)) continue;
            CheckBoxNode cbNode = (CheckBoxNode)kidnode;
            if (selectedOnly && (!cbNode.isSelected() || !this.m_parentTree.isExpanded(new TreePath(model.getPathToRoot(node)))) || !(cbNode instanceof SimTrialRunTreeNode)) continue;
            SimTrialRunTreeNode runNode = (SimTrialRunTreeNode)cbNode;
            trials.add(runNode.getTrialSimulationRun());
        }
        return trials;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void setSimulation(SimulationPeriod sim) {
        this.m_simulation = sim;
        this.m_activeRun = null;
        this.removeAllChildren();
        ClientMode mode = ClientApp.frame().getCurrentMode();
        if (!(mode instanceof SimulationMode)) {
            return;
        }
        SimulationMode simMode = (SimulationMode)((Object)mode);
        if (this.m_simulation == null) {
            return;
        }
        Vector<SimulationRun> list = this.m_simulation.getSimulationRuns();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            this.add(simMode.newSimulationRunTreeNode(list.elementAt(i), this.m_parentTree));
        }
        ((DefaultTreeModel)this.m_parentTree.getModel()).nodeChanged(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < SimulationTreeNode.this.getChildCount(); ++i) {
                            SimulationRunTreeNode child = (SimulationRunTreeNode)SimulationTreeNode.this.getChildAt(i);
                            if (!child.getSimulationRun().isExpanded()) continue;
                            child.expand();
                        }
                    }
                });
            }
        });
        this.m_simulation.addModifiableListener(new ModifiableListener(){

            public void modifiedStateChanged(Modifiable obj, boolean modified) {
                SimulationTreeNode.this.simulationModified(modified);
            }
        });
        this.m_parentTree.setToolTipText(sim.toString());
    }

    private void simulationModified(boolean modified) {
        this._modifiedFlag = modified ? "*" : "";
        ((DefaultTreeModel)this.m_parentTree.getModel()).nodeChanged(this);
    }

    public JPopupMenu getPopupMenu() {
        return this.createPopupMenu();
    }

    public boolean hasTrials() {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            SimulationRunTreeNode runNode;
            CheckBoxNode cbNode;
            TreeNode node = e.nextElement();
            if (!(node instanceof CheckBoxNode) || (cbNode = (CheckBoxNode)node) instanceof SimTrialRunTreeNode || !(cbNode instanceof SimulationRunTreeNode) || (runNode = (SimulationRunTreeNode)cbNode).getChildCount() == 0) continue;
            return true;
        }
        return false;
    }
}

