/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientApp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.util.RMAIO;

public class SplashWindow
extends JWindow {
    protected static final Color BACKGROUND_COLOR = new Color(236, 249, 255);
    protected static SplashWindow _splashWindow;
    protected JLabel _urlLabel;

    public SplashWindow(String appName, Frame f, int waitTime, String image, Class clientAppClass) {
        this(appName, f, waitTime, image, clientAppClass, -1, -1);
    }

    public SplashWindow(String appName, Frame f, int waitTime, String image, Class clientAppClass, int width, int height) {
        super(f);
        Properties properties = RMAIO.getAppVersionProperties((Class)clientAppClass);
        if (image == null) {
            image = "Images/heclogo2.gif";
        }
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(BACKGROUND_COLOR);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(BACKGROUND_COLOR);
        LineBorder border = new LineBorder(UIManager.getColor("TextField.foreground"), 3);
        BevelBorder border2 = new BevelBorder(0);
        panel.setBorder(BorderFactory.createCompoundBorder(border2, border));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this.getContentPane().add((Component)panel, gbc);
        JLabel l = new JLabel(RmaImage.getImageIcon((String)image));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)15, (int)10, (int)0, (int)0);
        panel.add((Component)l, gbc);
        JPanel castlePanel = new JPanel(new GridBagLayout());
        castlePanel.setBackground(BACKGROUND_COLOR);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)10, (int)10, (int)0);
        panel.add((Component)castlePanel, gbc);
        l = new JLabel(RmaImage.getImageIcon((String)"Images/castle.gif"));
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        castlePanel.add((Component)l, gbc);
        int fontSize = this.getIntProperty(properties, "splash.corpsFontSize", 12);
        l = new JLabel("US Army Corps");
        Font font = new Font("Arial", 0, fontSize);
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)2, (int)0, (int)0, (int)0);
        castlePanel.add((Component)l, gbc);
        l = new JLabel("of Engineers");
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        castlePanel.add((Component)l, gbc);
        JPanel textPanel = new JPanel(new GridBagLayout());
        textPanel.setBackground(BACKGROUND_COLOR);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)10, (int)25, (int)0, (int)10);
        panel.add((Component)textPanel, gbc);
        fontSize = this.getIntProperty(properties, "splash.appNameFontSize", 40);
        l = new JLabel(appName);
        font = new Font("Arial", 1, fontSize);
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)10, (int)0, (int)10, (int)0);
        textPanel.add((Component)l, gbc);
        String version = this.getVersion(properties);
        String build = this.getBuild(properties);
        fontSize = this.getIntProperty(properties, "splash.versionFontSize", 28);
        font = new Font("Arial", 1, fontSize);
        l = new JLabel("Version " + version);
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        textPanel.add((Component)l, gbc);
        l = new JLabel(build);
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)3, (int)0, (int)45, (int)0);
        textPanel.add((Component)l, gbc);
        fontSize = this.getIntProperty(properties, "splash.hecInfoFontSize", 18);
        font = new Font("Arial", 0, fontSize);
        l = new JLabel("Hydrologic Engineering Center");
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)2, (int)0);
        textPanel.add((Component)l, gbc);
        l = new JLabel("Institute for Water Resources");
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)2, (int)0);
        textPanel.add((Component)l, gbc);
        l = new JLabel("US Army Corps of Engineers");
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)2, (int)0);
        textPanel.add((Component)l, gbc);
        l = new JLabel("609 Second Street");
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)2, (int)0);
        textPanel.add((Component)l, gbc);
        l = new JLabel("Davis, CA 95616");
        l.setFont(font);
        l.setHorizontalAlignment(2);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        textPanel.add((Component)l, gbc);
        this._urlLabel = new JLabel("www.hec.usace.army.mil");
        this._urlLabel.setFont(font);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridheight = 0;
        gbc.weighty = 1.0;
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)23, (int)0, (int)10, (int)5);
        textPanel.add((Component)this._urlLabel, gbc);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Properties props = RMAIO.getAppVersionProperties((Class)clientAppClass);
        if (height <= 0) {
            height = this.getIntProperty(props, "splash.height", 380);
        }
        if (width <= 0) {
            width = this.getIntProperty(props, "splash.width", 420);
        }
        this.setSize(width, height);
        Dimension labelSize = this.getSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        if (this._urlLabel != null && RMAIO.getOSType() == 0) {
            this._urlLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    String[] cmd = new String[]{"cmd.exe", "/c", "start", SplashWindow.this._urlLabel.getText()};
                    try {
                        Runtime.getRuntime().exec(cmd);
                    }
                    catch (IOException ioe) {
                        System.out.println("Exception running " + cmd + " " + e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SplashWindow.this._urlLabel.setForeground(Color.blue);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    SplashWindow.this._urlLabel.setForeground(UIManager.getColor("TextField.foreground"));
                }
            });
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        });
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.setVisible(false);
                SplashWindow.this.dispose();
            }
        };
        Runnable waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SplashWindow.this.toFront();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SplashWindow.this.toFront();
                        SplashWindow.this.repaint();
                    }
                });
            }
        });
        _splashWindow = this;
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.requestFocus();
            }
        });
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.setDaemon(true);
        splashThread.start();
    }

    protected String getVersion(Properties properties) {
        String version = properties == null ? ClientApp.getVersionString() : properties.getProperty("shortVersion", "");
        return version;
    }

    protected String getBuild(Properties properties) {
        String build = properties == null ? RMAIO.getBuildMonthYear() : properties.getProperty("versionDate", "");
        return build;
    }

    protected int getIntProperty(Properties properties, String prop, int defaultVal) {
        String s = this.getProperty(properties, prop);
        if (s == null) {
            return defaultVal;
        }
        return RMAIO.parseInt((String)s, (int)defaultVal);
    }

    protected String getProperty(Properties props, String prop) {
        String prefixProp;
        String foundProp;
        if (props == null || prop == null) {
            return null;
        }
        String prefix = null;
        switch (RMAIO.getOSType()) {
            case 0: 
            case 1: {
                prefix = "windows";
                break;
            }
            case 2: {
                prefix = "solaris";
                break;
            }
            case 3: {
                prefix = "linux";
            }
        }
        if (prefix != null && (foundProp = props.getProperty(prefixProp = prefix.concat(".").concat(prop))) != null) {
            return foundProp;
        }
        foundProp = props.getProperty(prop);
        return foundProp;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public static void closeSplashWindow() {
        if (_splashWindow != null) {
            _splashWindow.setVisible(false);
            _splashWindow = null;
        }
    }
}

