/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import hec.clientapp.client.ClientMode;
import hec.heclib.util.HecTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import rma.swing.RmaJCalendarField;

public class TimeWindowEditor
extends JDialog {
    boolean canceled = false;
    boolean fComponentsAdjusted = false;
    JPanel jPanel1;
    JLabel jLabelStartDate;
    JLabel jLabelStartTime;
    JLabel jLabelEndDate;
    JLabel jLabelEndTime;
    RmaJCalendarField jTextFieldStartDate;
    RmaJCalendarField jTextFieldEndDate;
    JTextField jTextFieldStartTime;
    JTextField jTextFieldEndTime;
    JPanel jPanel2;
    JPanel jPanel3;
    JButton jButtonOK;
    JButton jButtonApply;
    JButton jButtonCancel;
    JCheckBox JCheckBox2 = new JCheckBox();
    String[] intervals = new String[]{"hours", "days"};
    JCheckBox JCheckBox1 = new JCheckBox();
    JLabel JLabel1 = new JLabel();
    JLabel lookAheadLabel = new JLabel();
    JTextField JTextField1 = new JTextField();
    JTextField lookAheadField = new JTextField();
    JComboBox JComboBox1 = new JComboBox<String>(this.intervals);
    JComboBox lookAheadCombo = new JComboBox<String>(this.intervals);
    JLabel jLabelUpdateInteval = new JLabel();
    JTextField JTextFieldUpdateInteval = new JTextField();
    Object _parent = null;
    HecTime _startTime = new HecTime();
    HecTime _endTime = new HecTime();
    public static final int RELATIVE_SELECTION = 0;
    public static final int SPECIFIC_SELECTION = 1;
    public static final int HOURS = 0;
    public static final int DAYS = 1;
    protected int _selectionType = 0;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setLocation(200, 200);
        TimeWindowEditor tws = new TimeWindowEditor((Object)frame, frame);
        tws.setRelativeTime(12, 1, 5);
        tws.setTimes(new HecTime("20JAN2000, 1200"), new HecTime("20MAR2000, 1200"));
        tws.setSelectionType(0);
        tws.setLocation(200, 200);
        tws.setVisible(true);
    }

    public TimeWindowEditor(Object parent, JFrame frame, boolean showIconUpdate) {
        this(parent, frame);
        this.setIconUpdateVisible(showIconUpdate);
    }

    public TimeWindowEditor(Object parent, JFrame frame) {
        super(frame);
        this.setTitle("Set Time Window");
        this._parent = parent;
        this.getContentPane().setLayout(null);
        this.setVisible(false);
        this.setSize(432, 363);
        this.JComboBox1.setSelectedIndex(1);
        this.lookAheadCombo.setSelectedIndex(1);
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(null);
        this.jPanel2.setBorder(new EtchedBorder());
        this.jPanel2.setBounds(24, 16, 384, 148);
        this.jPanel2.setFont(new Font("Dialog", 0, 12));
        this.getContentPane().add(this.jPanel2);
        this.JCheckBox1.setText("Relative to Current Time");
        this.JCheckBox1.setMnemonic('R');
        this.jPanel2.add(this.JCheckBox1);
        this.JCheckBox1.setFont(new Font("Dialog", 0, 12));
        this.JCheckBox1.setBounds(10, 10, 160, 20);
        this.JLabel1.setText("Look Back Time");
        this.JLabel1.setLabelFor(this.JTextField1);
        this.JLabel1.setDisplayedMnemonic('L');
        this.jPanel2.add(this.JLabel1);
        this.JLabel1.setForeground(Color.black);
        this.JLabel1.setFont(new Font("Dialog", 0, 12));
        this.JLabel1.setBounds(10, 40, 108, 25);
        this.jPanel2.add(this.JTextField1);
        this.JTextField1.setBounds(120, 40, 50, 25);
        this.JTextField1.setHorizontalAlignment(4);
        this.jPanel2.add(this.JComboBox1);
        this.JComboBox1.setFont(new Font("Dialog", 0, 12));
        this.JComboBox1.setBackground(Color.white);
        this.JComboBox1.setBounds(180, 40, 80, 25);
        this.lookAheadLabel.setText("Look Ahead Time");
        this.lookAheadLabel.setLabelFor(this.lookAheadField);
        this.jPanel2.add(this.lookAheadLabel);
        this.lookAheadLabel.setForeground(Color.black);
        this.lookAheadLabel.setFont(new Font("Dialog", 0, 12));
        this.lookAheadLabel.setBounds(10, 78, 108, 25);
        this.jPanel2.add(this.lookAheadField);
        this.lookAheadField.setBounds(120, 78, 50, 25);
        this.lookAheadField.setHorizontalAlignment(4);
        this.jPanel2.add(this.lookAheadCombo);
        this.lookAheadCombo.setFont(new Font("Dialog", 0, 12));
        this.lookAheadCombo.setBackground(Color.white);
        this.lookAheadCombo.setBounds(180, 78, 80, 25);
        this.jLabelUpdateInteval.setText("Update interval for plot icons (minutes)");
        this.jLabelUpdateInteval.setLabelFor(this.JTextFieldUpdateInteval);
        this.jLabelUpdateInteval.setDisplayedMnemonic('U');
        this.jPanel2.add(this.jLabelUpdateInteval);
        this.jLabelUpdateInteval.setForeground(Color.black);
        this.jLabelUpdateInteval.setFont(new Font("Dialog", 0, 12));
        this.jLabelUpdateInteval.setBounds(10, 116, 230, 20);
        this.JTextFieldUpdateInteval.setMargin(new Insets(0, 4, 0, 0));
        this.JTextFieldUpdateInteval.setBounds(240, 113, 40, 25);
        this.JTextFieldUpdateInteval.setFont(new Font("Dialog", 0, 12));
        this.JTextFieldUpdateInteval.setHorizontalAlignment(4);
        this.jPanel2.add(this.JTextFieldUpdateInteval);
        this.jPanel1 = new JPanel();
        this.jPanel1.setBorder(new EtchedBorder());
        this.jPanel1.setLayout(null);
        this.jPanel1.setBounds(24, 188, 384, 120);
        this.jPanel1.setFont(new Font("Dialog", 0, 12));
        this.getContentPane().add(this.jPanel1);
        this.JCheckBox2.setText("Specific Time Window");
        this.JCheckBox2.setMnemonic('S');
        this.jPanel1.add(this.JCheckBox2);
        this.JCheckBox2.setFont(new Font("Dialog", 0, 12));
        this.JCheckBox2.setBounds(10, 10, 160, 20);
        this.jLabelStartDate = new JLabel();
        this.jLabelStartDate.setText("Start Date:");
        this.jLabelStartDate.setDisplayedMnemonic('D');
        this.jLabelStartDate.setBounds(24, 40, 60, 28);
        this.jLabelStartDate.setFont(new Font("Dialog", 0, 12));
        this.jLabelStartDate.setForeground(Color.black);
        this.jPanel1.add(this.jLabelStartDate);
        this.jLabelStartTime = new JLabel();
        this.jLabelStartTime.setText("Start Time:");
        this.jLabelStartTime.setDisplayedMnemonic('T');
        this.jLabelStartTime.setBounds(216, 40, 60, 28);
        this.jLabelStartTime.setFont(new Font("Dialog", 0, 12));
        this.jLabelStartTime.setForeground(Color.black);
        this.jPanel1.add(this.jLabelStartTime);
        this.jLabelEndDate = new JLabel();
        this.jLabelEndDate.setText("End Date:");
        this.jLabelEndDate.setDisplayedMnemonic('E');
        this.jLabelEndDate.setBounds(24, 80, 60, 28);
        this.jLabelEndDate.setFont(new Font("Dialog", 0, 12));
        this.jLabelEndDate.setForeground(Color.black);
        this.jPanel1.add(this.jLabelEndDate);
        this.jLabelEndTime = new JLabel();
        this.jLabelEndTime.setText("End Time:");
        this.jLabelEndTime.setDisplayedMnemonic('n');
        this.jLabelEndTime.setBounds(216, 80, 60, 28);
        this.jLabelEndTime.setFont(new Font("Dialog", 0, 12));
        this.jLabelEndTime.setForeground(Color.black);
        this.jPanel1.add(this.jLabelEndTime);
        this.jTextFieldStartDate = new RmaJCalendarField();
        this.jTextFieldStartDate.setMargin(new Insets(0, 4, 0, 0));
        this.jTextFieldStartDate.setBounds(96, 40, 108, 24);
        this.jTextFieldStartDate.setFont(new Font("Dialog", 0, 12));
        this.jTextFieldStartDate.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent event) {
                TimeWindowEditor.this.startDateUpdated();
            }
        });
        this.jPanel1.add((Component)this.jTextFieldStartDate);
        this.jTextFieldStartTime = new JTextField();
        this.jTextFieldStartTime.setMargin(new Insets(0, 4, 0, 0));
        this.jTextFieldStartTime.setBounds(288, 40, 60, 24);
        this.jTextFieldStartTime.setFont(new Font("Dialog", 0, 12));
        this.jPanel1.add(this.jTextFieldStartTime);
        this.jTextFieldEndDate = new RmaJCalendarField();
        this.jTextFieldEndDate.setMargin(new Insets(0, 4, 0, 0));
        this.jTextFieldEndDate.setBounds(96, 80, 108, 24);
        this.jTextFieldEndDate.setFont(new Font("Dialog", 0, 12));
        this.jPanel1.add((Component)this.jTextFieldEndDate);
        this.jTextFieldEndTime = new JTextField();
        this.jTextFieldEndTime.setMargin(new Insets(0, 4, 0, 0));
        this.jTextFieldEndTime.setBounds(288, 80, 60, 24);
        this.jTextFieldEndTime.setFont(new Font("Dialog", 0, 12));
        this.jPanel1.add(this.jTextFieldEndTime);
        this.jLabelStartTime.setLabelFor(this.jTextFieldStartTime);
        this.jLabelStartDate.setLabelFor((Component)this.jTextFieldStartDate);
        this.jLabelEndDate.setLabelFor((Component)this.jTextFieldEndDate);
        this.jLabelEndTime.setLabelFor(this.jTextFieldEndTime);
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(null);
        this.jPanel3.setBounds(0, 313, 432, 50);
        this.jPanel3.setFont(new Font("Dialog", 0, 12));
        this.getContentPane().add(this.jPanel3);
        this.jButtonOK = new JButton();
        this.jButtonOK.setText("OK");
        this.jButtonOK.setActionCommand("OK");
        this.jButtonOK.setBounds(36, 12, 84, 24);
        this.jButtonOK.setFont(new Font("Dialog", 0, 12));
        this.jPanel3.add(this.jButtonOK);
        this.jButtonApply = new JButton();
        this.jButtonApply.setText("Apply");
        this.jButtonApply.setActionCommand("Apply");
        this.jButtonApply.setBounds(156, 12, 97, 25);
        this.jButtonApply.setFont(new Font("Dialog", 0, 12));
        this.jPanel3.add(this.jButtonApply);
        this.jButtonCancel = new JButton();
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setActionCommand("Cancel");
        this.jButtonCancel.setBounds(288, 12, 97, 25);
        this.jButtonCancel.setFont(new Font("Dialog", 0, 12));
        this.jButtonCancel.setVerifyInputWhenFocusTarget(false);
        this.jPanel3.add(this.jButtonCancel);
        this.setTitle("Set Time Window");
        this.setResizable(false);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.jButtonOK.addActionListener(lSymAction);
        this.jButtonApply.addActionListener(lSymAction);
        this.jButtonCancel.addActionListener(lSymAction);
        SymItem lSymItem = new SymItem();
        this.JCheckBox1.addItemListener(lSymItem);
        this.JCheckBox2.addItemListener(lSymItem);
        this.setSelectionType(0);
        this.registerEnterKey();
        this.getRootPane().registerKeyboardAction(new SymAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindowEditor.this.jButtonCancel_actionPerformed(e);
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
    }

    protected void startDateUpdated() {
        String date = this.jTextFieldStartDate.getText().trim();
        if (date.length() > 4) {
            if (this.jTextFieldStartTime.getText().trim().length() == 0) {
                this.jTextFieldStartTime.setText("2400");
            }
            if (this.jTextFieldEndDate.getText().trim().length() == 0) {
                this.jTextFieldEndDate.setText(this.jTextFieldStartDate.getText());
            }
            if (this.jTextFieldEndTime.getText().trim().length() == 0) {
                this.jTextFieldEndTime.setText("2400");
            }
        }
    }

    private void registerEnterKey() {
        this.getRootPane().registerKeyboardAction(new SymAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindowEditor.this.jButtonOK_actionPerformed(e);
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 1);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.insets().left + this.insets().right + d.width, this.insets().top + this.insets().bottom + d.height);
        this.fComponentsAdjusted = true;
    }

    @Override
    public synchronized void show() {
        Rectangle bounds = this.getParent().bounds();
        Rectangle abounds = this.bounds();
        this.move(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
        this.canceled = false;
        super.show();
    }

    void TimeWindowEditor_WindowClosing(WindowEvent event) {
        this.dispose();
    }

    void jButtonOK_actionPerformed(ActionEvent event) {
        int status = this.applyTimes();
        if (status == 0) {
            this.setVisible(false);
            this.dispose();
        }
    }

    void jButtonApply_actionPerformed(ActionEvent event) {
        this.applyTimes();
    }

    protected int applyTimes() {
        int status = 0;
        if (this._selectionType == 0) {
            int lookbackValue = 0;
            String lookback = this.JTextField1.getText().trim();
            if (lookback.length() > 0) {
                try {
                    Integer val = new Integer(lookback);
                    lookbackValue = val;
                }
                catch (Exception e) {
                    status = -1;
                }
                if (status != 0) {
                    JOptionPane.showMessageDialog(this, "Invalid Look Back Time: " + lookback, "Time Window", 2);
                    return status;
                }
            }
            int lookaheadValue = 0;
            String lookahead = this.lookAheadField.getText().trim();
            if (lookahead.length() > 0) {
                try {
                    Integer val = new Integer(lookahead);
                    lookaheadValue = val;
                }
                catch (Exception e) {
                    status = -1;
                }
                if (status != 0) {
                    JOptionPane.showMessageDialog(this, "Invalid Look Ahead Time: " + lookahead, "Time Window", 2);
                    return status;
                }
            }
            int updateInterval = 0;
            try {
                Integer val;
                String update = this.JTextFieldUpdateInteval.getText().trim();
                if (update.length() > 0 && (updateInterval = (val = new Integer(update)).intValue()) < 0) {
                    status = -1;
                }
            }
            catch (Exception e) {
                status = -1;
            }
            if (status != 0) {
                JOptionPane.showMessageDialog(this, "Invalid Update Interval: " + this.JTextFieldUpdateInteval.getText(), "Time Window", 2);
                return status;
            }
            int hoursback = lookbackValue;
            if (this.JComboBox1.getSelectedIndex() == 1) {
                hoursback *= 24;
            }
            int hoursahead = lookaheadValue;
            if (this.lookAheadCombo.getSelectedIndex() == 1) {
                hoursahead *= 24;
            }
            if (hoursback + hoursahead < 0) {
                JOptionPane.showMessageDialog(this, "Start date/time does not occur before end.", "Invalid Time Window", 2);
                return -1;
            }
            if (this._parent != null && this._parent instanceof ClientMode) {
                ((ClientMode)this._parent).setLookbackTime(lookbackValue, this.JComboBox1.getSelectedIndex(), updateInterval);
                ((ClientMode)this._parent).setLookaheadTime(lookaheadValue, this.lookAheadCombo.getSelectedIndex());
                ((ClientMode)this._parent).setUseRelativeTime(true);
            }
        } else if (this._selectionType == 1 && (status = this.getTimes()) == 0 && this._parent != null && this._parent instanceof ClientMode) {
            ((ClientMode)this._parent).setTimeWindow(this._startTime, this._endTime);
            ((ClientMode)this._parent).setUseRelativeTime(false);
        }
        return status;
    }

    void jButtonCancel_actionPerformed(ActionEvent event) {
        this.canceled = true;
        this.dispose();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    void JCheckBox1_ItemStateChanged(ItemEvent event) {
        int previousState = this._selectionType;
        if (event.getStateChange() == 2) {
            if (this._selectionType == 0) {
                this.JCheckBox1.setSelected(true);
            }
            return;
        }
        if (event.getStateChange() != 1) {
            return;
        }
        if (this._selectionType == 0) {
            return;
        }
        this.setSelectionType(0);
    }

    void JCheckBox2_ItemStateChanged(ItemEvent event) {
        int previousState = this._selectionType;
        if (event.getStateChange() == 2) {
            if (this._selectionType == 1) {
                this.JCheckBox2.setSelected(true);
            }
            return;
        }
        if (event.getStateChange() != 1) {
            return;
        }
        if (this._selectionType == 1) {
            return;
        }
        this.setSelectionType(1);
    }

    public int getSelectionType() {
        return this._selectionType;
    }

    public void setSelectionType(int selection) {
        this._selectionType = selection;
        if (this._selectionType == 0) {
            this.JCheckBox1.setSelected(true);
            this.JCheckBox2.setSelected(false);
            this.JTextField1.setEnabled(true);
            this.lookAheadField.setEnabled(true);
            this.JComboBox1.setEnabled(true);
            this.lookAheadCombo.setEnabled(true);
            this.JTextFieldUpdateInteval.setEnabled(true);
            this.jTextFieldStartDate.setEnabled(false);
            this.jTextFieldStartTime.setEnabled(false);
            this.jTextFieldEndDate.setEnabled(false);
            this.jTextFieldEndTime.setEnabled(false);
        } else if (this._selectionType == 1) {
            this.JCheckBox2.setSelected(true);
            this.JCheckBox1.setSelected(false);
            this.JTextField1.setEnabled(false);
            this.lookAheadField.setEnabled(false);
            this.JComboBox1.setEnabled(false);
            this.lookAheadCombo.setEnabled(false);
            this.JTextFieldUpdateInteval.setEnabled(false);
            this.jTextFieldStartDate.setEnabled(true);
            this.jTextFieldStartTime.setEnabled(true);
            this.jTextFieldEndDate.setEnabled(true);
            this.jTextFieldEndTime.setEnabled(true);
        }
    }

    public HecTime getRelativeTime() {
        HecTime rel = new HecTime();
        if (this.JComboBox1.getSelectedIndex() == 0) {
            rel.setTimeIncrement(2);
        } else if (this.JComboBox1.getSelectedIndex() == 1) {
            rel.setTimeIncrement(3);
        }
        Integer value = new Integer(this.JTextField1.getText());
        rel.set(value.intValue());
        return rel;
    }

    public HecTime getLookAheadTime() {
        HecTime ahead = new HecTime();
        if (this.lookAheadCombo.getSelectedIndex() == 0) {
            ahead.setTimeIncrement(2);
        } else if (this.lookAheadCombo.getSelectedIndex() == 1) {
            ahead.setTimeIncrement(3);
        }
        Integer value = new Integer(this.lookAheadField.getText());
        ahead.set(value.intValue());
        return ahead;
    }

    public void setRelativeTime(int number, int interval, int iconUpdateInterval) {
        this.JTextField1.setText(new Integer(number).toString());
        if (interval == 0) {
            this.JComboBox1.setSelectedIndex(0);
        } else if (interval == 1) {
            this.JComboBox1.setSelectedIndex(1);
        }
        if (iconUpdateInterval > 0) {
            this.JTextFieldUpdateInteval.setText(new Integer(iconUpdateInterval).toString());
        }
    }

    public void setLookAheadTime(int number, int interval) {
        if (number != 0) {
            this.lookAheadField.setText(new Integer(number).toString());
        }
        if (interval == 0) {
            this.lookAheadCombo.setSelectedIndex(0);
        } else if (interval == 1) {
            this.lookAheadCombo.setSelectedIndex(1);
        }
    }

    public int getTimes() {
        String startDate = this.jTextFieldStartDate.getText();
        if (startDate.length() < 3) {
            this._startTime.setUndefined();
            this._endTime.setUndefined();
            JOptionPane.showMessageDialog(this, "No times set.", "Invalid Time Window", 2);
            return -1;
        }
        if (this.jTextFieldStartTime.getText().length() == 0) {
            this.jTextFieldStartTime.setText("0001");
        }
        if (this.jTextFieldEndTime.getText().length() == 0) {
            this.jTextFieldEndTime.setText("2400");
        }
        HecTime start = new HecTime();
        int statusStartDate = start.setDate(this.jTextFieldStartDate.getText());
        int statusStartTime = start.setTime(this.jTextFieldStartTime.getText());
        HecTime end = new HecTime();
        int statusEndDate = end.setDate(this.jTextFieldEndDate.getText());
        int statusEndTime = end.setTime(this.jTextFieldEndTime.getText());
        if (statusStartDate != 0 || statusStartTime != 0 || statusEndDate != 0 || statusEndTime != 0) {
            Object errors = new String();
            if (statusStartDate != 0) {
                errors = (String)errors + "Invalid Start Date.\n";
            }
            if (statusStartTime != 0) {
                errors = (String)errors + "Invalid Start Time.\n";
            }
            if (statusEndDate != 0) {
                errors = (String)errors + "Invalid End Date.\n";
            }
            if (statusEndTime != 0) {
                errors = (String)errors + "Invalid End Time.";
            }
            JOptionPane.showMessageDialog(this, errors, "Invalid Time Window", 2);
            return -1;
        }
        if (!start.lessThan(end)) {
            JOptionPane.showMessageDialog(this, "Start date/time does not occur before end.", "Invalid Time Window", 2);
            return -1;
        }
        this._startTime = start;
        this._endTime = end;
        return 0;
    }

    public void setTimes(HecTime start, HecTime end) {
        if (!start.isDefined()) {
            this.jTextFieldStartDate.setText("");
            this.jTextFieldStartTime.setText("");
        } else {
            this.jTextFieldStartDate.setText(start.date(4));
            this.jTextFieldStartTime.setText(start.time());
        }
        if (!end.isDefined()) {
            this.jTextFieldEndDate.setText("");
            this.jTextFieldEndTime.setText("");
        } else {
            this.jTextFieldEndDate.setText(end.date(4));
            this.jTextFieldEndTime.setText(end.time());
        }
    }

    public void setIconUpdateVisible(boolean show) {
        this.jLabelUpdateInteval.setVisible(show);
        this.JTextFieldUpdateInteval.setVisible(show);
    }

    public boolean isIconUpdateVisible() {
        return this.JTextFieldUpdateInteval.isVisible();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == TimeWindowEditor.this) {
                TimeWindowEditor.this.TimeWindowEditor_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == TimeWindowEditor.this.jButtonOK) {
                TimeWindowEditor.this.jButtonOK_actionPerformed(event);
            } else if (object == TimeWindowEditor.this.jButtonApply) {
                TimeWindowEditor.this.jButtonApply_actionPerformed(event);
            } else if (object == TimeWindowEditor.this.jButtonCancel) {
                TimeWindowEditor.this.jButtonCancel_actionPerformed(event);
            }
        }
    }

    class SymItem
    implements ItemListener {
        SymItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            ItemSelectable object = event.getItemSelectable();
            if (object == TimeWindowEditor.this.JCheckBox1) {
                TimeWindowEditor.this.JCheckBox1_ItemStateChanged(event);
            } else if (object == TimeWindowEditor.this.JCheckBox2) {
                TimeWindowEditor.this.JCheckBox2_ItemStateChanged(event);
            }
        }
    }
}

