/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.client;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.server.AppVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class WkspVersionChecker {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String UPGRADE_URL = "https://www.hec.usace.army.mil/confluence/ResSimDocs/upgrading-to-a-new-version-of-hec-ressim";
    private final Identifier _wkspId;

    public WkspVersionChecker(Identifier id) {
        this._wkspId = id;
    }

    public boolean shouldOpenWorkspace() {
        if (this._wkspId == null) {
            return true;
        }
        Identifier openedId = this._wkspId;
        if (this._wkspId.getFile() == null) {
            RmiFileManager rmiFm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
            Identifier openId = null;
            try {
                openId = rmiFm.openFile(UserId.getUserId(), this._wkspId);
            }
            catch (RemoteException e) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Unable to open workspace file %s, Error:%s", (Object)this._wkspId.getPath(), (Object)e.getMessage());
                return true;
            }
            if (openId != null) {
                openedId = openId;
            } else {
                return true;
            }
        }
        BufferedReader reader = openedId.getFile().getBufferedReader();
        String wkspVersion = null;
        String wkspName = "unknown";
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("WorkspaceName")) {
                    wkspName = RMAIO.getParam((String)line, (String)"=");
                    continue;
                }
                if (!line.startsWith("AppVersion")) continue;
                wkspVersion = RMAIO.getParam((String)line, (String)"=");
                break;
            }
            return this.checkWkspVersion(wkspName, wkspVersion);
        }
        catch (IOException ioe) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("Error reading workspace file %s, Error:%s", (Object)this._wkspId.getPath(), (Object)ioe.getMessage());
            return true;
        }
    }

    private boolean checkWkspVersion(String wkspName, String wkspVersion) {
        String appVersion = AppVersion.getAppVersion();
        int[] appVersionArray = WkspVersionChecker.getVersionArray(appVersion);
        int[] wkspVersionArray = WkspVersionChecker.getVersionArray(wkspVersion);
        int octets = Integer.getInteger("OldWkspVersionCheckIndex", 1);
        if (appVersionArray != null && wkspVersionArray != null) {
            if (wkspVersionArray.length >= octets) {
                for (int i = 0; i < octets; ++i) {
                    if (appVersionArray[i] > wkspVersionArray[i]) {
                        return this.displayOlderWatershedMsg(wkspName, appVersion, wkspVersion);
                    }
                    if (appVersionArray[i] >= wkspVersionArray[i]) {
                        continue;
                    }
                    break;
                }
            }
        } else if (appVersionArray != null) {
            return this.displayOlderWatershedMsg(wkspName, appVersion, wkspVersion);
        }
        return true;
    }

    private boolean displayOlderWatershedMsg(String wkspName, String appVersion, String wkspVersion) {
        if (Boolean.getBoolean("NoOldWkspVersionCheck")) {
            return true;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("<html>The watershed <b>");
        msg.append(wkspName);
        msg.append("</b> was last saved in ");
        if (wkspVersion == null || wkspVersion.isEmpty()) {
            msg.append("a version of HEC-ResSim prior to v3.5");
        } else {
            msg.append("HEC-ResSim <b>");
            msg.append(wkspVersion);
            msg.append("</b>.");
        }
        msg.append("<br>Opening it in the current HEC-ResSim version <b>");
        msg.append(appVersion);
        msg.append("</b> may cause the watershed to be auto-saved and upgraded, making it incompatible with older ResSim versions.<br>Before proceeding, please make a backup copy of this watershed.<br><br><b>Proceed with caution.</b><br>");
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            msg.append("<a href=\"https://www.hec.usace.army.mil/confluence/ResSimDocs/upgrading-to-a-new-version-of-hec-ressim\">For More Information</a> ");
        }
        Object[] options = new Object[]{"Continue", "Don't Open Watershed"};
        int opt = JOptionPane.showOptionDialog((Component)((Object)ClientApp.frame()), new MessageWithLink(msg.toString()), "Watershed Version Incompatibility Warning", 0, 2, null, options, options[1]);
        return 0 == opt;
    }

    private static int[] getVersionArray(String versionString) {
        if (versionString == null) {
            return null;
        }
        String[] versionArray = versionString.split("\\.");
        if (versionArray == null) {
            return null;
        }
        int[] intVersionArray = new int[versionArray.length];
        for (int i = 0; i < versionArray.length; ++i) {
            intVersionArray[i] = RMAIO.parseInt((String)versionArray[i], (int)-1);
        }
        return intVersionArray;
    }

    public static class MessageWithLink
    extends JEditorPane {
        private static final long serialVersionUID = 1L;

        public MessageWithLink(String htmlBody) {
            super("text/html", "<html><body style=\"" + MessageWithLink.getStyle() + "\">" + htmlBody + "</body></html>");
            this.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        try {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        }
                        catch (IOException | URISyntaxException ex) {
                            ((FluentLogger.Api)LOGGER.atWarning()).log("Unable to open link %s, Error %s", (Object)e.getURL(), (Object)ex.getMessage());
                        }
                    }
                }
            });
            this.setEditable(false);
            this.setBorder(null);
        }

        static StringBuffer getStyle() {
            JLabel label = new JLabel();
            Font font = label.getFont();
            Color color = label.getBackground();
            StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
            style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
            style.append("font-size:" + font.getSize() + "pt;");
            style.append("background-color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");");
            return style;
        }
    }
}

