/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.gui;

import hec.clientapp.client.ClientApp;
import hec.util.StringComparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;
import rma.swing.EnabledJPanel;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.swing.RmaJTable;
import rma.swing.RmaJTextArea;
import rma.swing.table.RmaTableModel;
import rma.swing.table.SimpleRowFilter;
import rma.util.Compare;
import rma.util.RMAIO;
import rma.util.RMASort;

public class MoverDialog2<T>
extends RmaJDialog {
    public static final int SELECTION_0_TO_1 = 1;
    public static final int SELECTION_0_TO_MANY = 100;
    public static final int MOVER_DIALOG = 0;
    public static final int COPY_DIALOG = 1;
    private static final int PREF_WIDTH = 350;
    private boolean _caseInsensitiveSort = false;
    private String _dialogName = null;
    private Component _owner = null;
    private int _dialogType = 0;
    private int _selectionType = 100;
    private boolean _canceled = false;
    private JPanel _topPanel;
    private JPanel _textAreaPanel;
    private RmaJTextArea jTextArea1;
    protected JPanel _tablePanel;
    protected RmaJTable _availableTable;
    protected RmaJTable _selectedTable;
    protected JTextField _filterAvailableTxt;
    protected JTextField _filterSelectedTxt;
    private JPanel _addRemovePanel;
    private JButton _addButton;
    private JButton _removeButton;
    protected JButton _addAllButton;
    private JButton _removeAllButton;
    private JPanel _upDownPanel;
    private JButton _upButton;
    private JButton _downButton;
    protected RmaTableModel _availableTableModel;
    protected RmaTableModel _selectedTableModel;
    private StringComparator _availableComparator;
    private StringComparator _selectedComparator;
    private ButtonCmdPanel _cmdPanel;

    public MoverDialog2(JDialog owner, boolean modal) {
        super((Dialog)owner, modal);
        this._owner = owner;
        this.buildControls();
        this.addListeners();
    }

    public MoverDialog2(JDialog owner, boolean modal, String title) {
        this(owner, modal);
        this.setTitle(title);
    }

    public MoverDialog2(Frame owner, boolean model) {
        super(owner, model);
        this._owner = owner;
        this.buildControls();
        this.addListeners();
    }

    public MoverDialog2(Frame owner, boolean modal, String title) {
        this(owner, modal);
        this.setTitle(title);
    }

    protected void buildControls() {
        this.setTitle("Selection Editor");
        this.setSize(460, 380);
        this.setDefaultSize(470, 410);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this._topPanel = new JPanel(new BorderLayout());
        this._topPanel.setBackground(Color.red);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)10, (int)0, (int)10);
        this.getContentPane().add((Component)this._topPanel, gbc);
        this._textAreaPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)this._textAreaPanel, gbc);
        this.jTextArea1 = new RmaJTextArea();
        this.jTextArea1.setText("");
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setEditable(false);
        gbc.gridx = -1;
        gbc.gridy = -1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)10, (int)10, (int)10, (int)10);
        this._textAreaPanel.add((Component)this.jTextArea1, gbc);
        this._tablePanel = new EnabledJPanel((LayoutManager)new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = RmaInsets.INSETS0000;
        this.getContentPane().add((Component)this._tablePanel, gbc);
        this._filterAvailableTxt = new JTextField();
        this._filterAvailableTxt.setToolTipText("Filter Available Entries");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this._tablePanel.add((Component)this._filterAvailableTxt, gbc);
        this._availableTable = new RmaJTable((Component)((Object)this), new String[]{"Available"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = 350;
                return d;
            }
        };
        this._availableTable.setEditable(false);
        this._availableTable.setPopupMenuEnabled(false);
        this._availableTable.setShowGrid(false);
        this._availableTableModel = (RmaTableModel)this._availableTable.getModel();
        TableRowSorter<RmaTableModel> sorter = new TableRowSorter<RmaTableModel>(this._availableTableModel);
        this._availableComparator = new StringComparator();
        sorter.setComparator(0, (Comparator<?>)this._availableComparator);
        this._availableTable.setRowSorter(sorter);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)0, (int)0);
        this._tablePanel.add((Component)this._availableTable.getScrollPane(), gbc);
        this._addRemovePanel = new JPanel(new GridBagLayout());
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 10;
        gbc.fill = 3;
        gbc.insets = RmaInsets.INSETS0000;
        this._tablePanel.add((Component)this._addRemovePanel, gbc);
        this._filterSelectedTxt = new JTextField();
        this._filterSelectedTxt.setToolTipText("Filter Selected Entries");
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        this._tablePanel.add((Component)this._filterSelectedTxt, gbc);
        this._selectedTable = new RmaJTable((Component)((Object)this), new String[]{"Selected"}){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.width = 350;
                return d;
            }
        };
        this._selectedTable.setShowGrid(false);
        this._selectedTable.setEditable(false);
        this._selectedTable.setPopupMenuEnabled(false);
        this._selectedComparator = new StringComparator();
        this._selectedTableModel = (RmaTableModel)this._selectedTable.getModel();
        sorter = new TableRowSorter<RmaTableModel>(this._selectedTableModel);
        sorter.setComparator(0, (Comparator<?>)this._selectedComparator);
        this._selectedTable.setRowSorter(sorter);
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 10;
        gbc.fill = 1;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        this._tablePanel.add((Component)this._selectedTable.getScrollPane(), gbc);
        this._upDownPanel = new JPanel(new GridBagLayout());
        this._upDownPanel.setVisible(false);
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 2;
        gbc.anchor = 10;
        gbc.fill = 3;
        gbc.insets = RmaInsets.INSETS0000;
        this._tablePanel.add((Component)this._upDownPanel, gbc);
        this._addButton = new JButton("Add", RmaImage.getImageIcon((String)"Images/forwardbutton.gif"));
        this._addButton.setHorizontalTextPosition(2);
        this._addButton.setHorizontalAlignment(4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridheight = 1;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)10, (int)5, (int)10);
        this._addRemovePanel.add((Component)this._addButton, gbc);
        this._removeButton = new JButton("Remove", RmaImage.getImageIcon((String)"Images/backbutton.gif"));
        this._removeButton.setHorizontalTextPosition(4);
        this._removeButton.setHorizontalAlignment(2);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)10, (int)5, (int)10);
        this._addRemovePanel.add((Component)this._removeButton, gbc);
        this._addAllButton = new JButton("Add All", RmaImage.getImageIcon((String)"Images/forwardbutton.gif"));
        this._addAllButton.setHorizontalTextPosition(2);
        this._addAllButton.setHorizontalAlignment(4);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)10, (int)5, (int)10);
        this._addRemovePanel.add((Component)this._addAllButton, gbc);
        this._removeAllButton = new JButton("Remove All", RmaImage.getImageIcon((String)"Images/backbutton.gif"));
        this._removeAllButton.setHorizontalTextPosition(4);
        this._removeAllButton.setHorizontalAlignment(2);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 0.0;
        gbc.weighty = 0.01;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)0, (int)10, (int)5, (int)10);
        this._addRemovePanel.add((Component)this._removeAllButton, gbc);
        this._upButton = new JButton("Up", RmaImage.getImageIcon((String)"Images/spinUp.gif"));
        this._upButton.setEnabled(false);
        this._upButton.setHorizontalAlignment(2);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 15;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS5555;
        this._upDownPanel.add((Component)this._upButton, gbc);
        this._downButton = new JButton("Down", RmaImage.getImageIcon((String)"Images/spinDown.gif"));
        this._downButton.setEnabled(false);
        this._downButton.setHorizontalAlignment(2);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = RmaInsets.INSETS0555;
        this._upDownPanel.add((Component)this._downButton, gbc);
        this._cmdPanel = new ButtonCmdPanel(12);
        gbc.gridx = 0;
        gbc.gridy = 30;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 16;
        gbc.fill = 2;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)5, (int)5);
        this.getContentPane().add((Component)this._cmdPanel, gbc);
    }

    protected void addListeners() {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    if (e.getSource() == MoverDialog2.this._availableTable) {
                        MoverDialog2.this.actionAdd();
                    } else if (e.getSource() == MoverDialog2.this._selectedTable) {
                        MoverDialog2.this.actionRemove();
                    }
                }
            }
        };
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoverDialog2.this.actionPerformed(e);
            }
        };
        ButtonCmdPanelListener buttonListener = new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent e) {
                MoverDialog2.this.buttonCmdActionPerformed(e);
            }
        };
        this._addButton.addActionListener(actionListener);
        this._removeButton.addActionListener(actionListener);
        this._addAllButton.addActionListener(actionListener);
        this._removeAllButton.addActionListener(actionListener);
        this._cmdPanel.addCmdPanelListener(buttonListener);
        this._upButton.addActionListener(actionListener);
        this._downButton.addActionListener(actionListener);
        this._availableTable.addMouseListener((MouseListener)mouseListener);
        this._selectedTable.addMouseListener((MouseListener)mouseListener);
        ListSelectionListener availLsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MoverDialog2.this._addButton.setEnabled(MoverDialog2.this._availableTable.getSelectedRow() != -1);
            }
        };
        this._availableTable.getSelectionModel().addListSelectionListener(availLsl);
        ListSelectionListener selectedLsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MoverDialog2.this._removeButton.setEnabled(MoverDialog2.this._selectedTable.getSelectedRow() != -1);
                MoverDialog2.this.updateMoverButtons();
            }
        };
        this._selectedTable.getSelectionModel().addListSelectionListener(selectedLsl);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
        this._addButton.setEnabled(false);
        this._removeButton.setEnabled(false);
        this._filterAvailableTxt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MoverDialog2.this.filterTable(MoverDialog2.this._availableTable, MoverDialog2.this._filterAvailableTxt.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MoverDialog2.this.filterTable(MoverDialog2.this._availableTable, MoverDialog2.this._filterAvailableTxt.getText());
            }
        });
        this._filterSelectedTxt.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MoverDialog2.this.filterTable(MoverDialog2.this._selectedTable, MoverDialog2.this._filterSelectedTxt.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MoverDialog2.this.filterTable(MoverDialog2.this._selectedTable, MoverDialog2.this._filterSelectedTxt.getText());
            }
        });
    }

    protected void updateMoverButtons() {
        int row = this._selectedTable.getSelectedRow();
        int rowCnt = this._selectedTable.getRowCount();
        if (row == -1) {
            this._upButton.setEnabled(false);
            this._downButton.setEnabled(false);
            return;
        }
        if (row == 0) {
            this._upButton.setEnabled(false);
            this._downButton.setEnabled(rowCnt > 1);
            return;
        }
        if (row == rowCnt - 1) {
            this._downButton.setEnabled(false);
            this._upButton.setEnabled(rowCnt > 1);
            return;
        }
        this._downButton.setEnabled(true);
        this._upButton.setEnabled(true);
    }

    protected void filterTable(RmaJTable table, String filter) {
        TableRowSorter sorter = (TableRowSorter)table.getRowSorter();
        if (sorter == null) {
            return;
        }
        SimpleRowFilter f = new SimpleRowFilter(filter, 0);
        sorter.setRowFilter(f);
    }

    public void clearForm() {
        this._availableTable.deleteCells();
        this._selectedTable.deleteCells();
    }

    public void setSelectionType(int type) {
        if (type == 1) {
            this._selectionType = type;
            this._addAllButton.setEnabled(false);
            this._removeAllButton.setEnabled(false);
            if (this.getSelectedObjectsList().size() > 0) {
                this._addButton.setEnabled(false);
            } else {
                this._addButton.setEnabled(true);
            }
        } else if (type == 100) {
            this._selectionType = type;
            this._addAllButton.setEnabled(true);
            this._removeAllButton.setEnabled(true);
        } else {
            throw new RuntimeException("Illegal Selection Type: " + type);
        }
    }

    public void setDesc(String txt) {
        this.jTextArea1.setText(txt);
    }

    public void setDescVisible(boolean b) {
        this.jTextArea1.setVisible(b);
    }

    public void setMoveUpDownVisible(boolean b) {
        this._upDownPanel.setVisible(b);
        if (b) {
            this._selectedTable.setRowSorter(null);
            this._filterSelectedTxt.setEnabled(false);
        } else {
            TableRowSorter<RmaTableModel> sorter = new TableRowSorter<RmaTableModel>(this._selectedTableModel);
            sorter.setComparator(0, (Comparator<?>)this._selectedComparator);
            this._selectedTable.setRowSorter(sorter);
            this._filterSelectedTxt.setEnabled(true);
        }
    }

    public void setData(List<T> avail, List<T> selected) {
        T obj;
        Vector<T> row;
        int i;
        this._availableTable.deleteCells();
        this._selectedTable.deleteCells();
        for (i = 0; i < avail.size(); ++i) {
            row = new Vector<T>(1);
            obj = avail.get(i);
            if (selected.contains(obj)) continue;
            row.add(obj);
            this._availableTable.appendRow(row);
        }
        for (i = 0; i < selected.size(); ++i) {
            row = new Vector(1);
            obj = selected.get(i);
            row.add(obj);
            this._selectedTable.appendRow(row);
        }
        if (this._selectionType == 1) {
            this._availableTable.getSelectionModel().setSelectionMode(0);
        } else {
            this._availableTable.getSelectionModel().setSelectionMode(2);
        }
        if (this._selectionType == 1) {
            if (this.getSelectedObjectsList().size() > 0) {
                this._addButton.setEnabled(false);
            } else {
                this._addButton.setEnabled(true);
            }
        }
        this._addAllButton.setEnabled(this._availableTable.getRowCount() > 0);
        this._removeAllButton.setEnabled(this._selectedTable.getRowCount() > 0);
        this.setModified(false);
    }

    public void setSelectedListLabel(String label) {
        this._selectedTable.getColumnModel().getColumn(0).setHeaderValue(label);
    }

    public void setAvailableListLabel(String label) {
        this._availableTable.getColumnModel().getColumn(0).setHeaderValue(label);
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public Object[] getSelectedObjects() {
        int[] rows = this._selectedTable.getSelectedRows();
        Object[] objArray = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            objArray[i] = this._selectedTable.getValueAt(rows[i], 0);
        }
        return objArray;
    }

    public List<T> getSelectedObjectsList() {
        return this.getObjectList(this._selectedTable);
    }

    public T[] getAvailableObjects() {
        return this.getObjects(this._availableTable);
    }

    private T[] getObjects(RmaJTable table) {
        int rowCnt = table.getRowCount();
        ArrayList<Object> list = new ArrayList<Object>(rowCnt);
        for (int i = 0; i < rowCnt; ++i) {
            list.add(table.getValueAt(i, 0));
        }
        return list.toArray();
    }

    public List<T> getAvailableObjectsList() {
        return this.getObjectList(this._availableTable);
    }

    private List<T> getObjectList(RmaJTable table) {
        int rowCnt = table.getRowCount();
        ArrayList<Object> list = new ArrayList<Object>(rowCnt);
        for (int i = 0; i < rowCnt; ++i) {
            list.add(table.getValueAt(i, 0));
        }
        return list;
    }

    private void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._addButton) {
            this.actionAdd();
        } else if (e.getSource() == this._removeButton) {
            this.actionRemove();
        } else if (e.getSource() == this._addAllButton) {
            this.actionAddAll();
        } else if (e.getSource() == this._removeAllButton) {
            this.actionRemoveAll();
        } else if (e.getSource() == this._upButton) {
            this.actionMoveUp();
        } else if (e.getSource() == this._downButton) {
            this.actionMoveDown();
        }
    }

    private void buttonCmdActionPerformed(ActionEvent event) {
        if (event.getID() == 8) {
            this.cmdOK_Action();
        } else if (event.getID() == 4) {
            this.cmdCancel_Action();
        }
    }

    public boolean saveForm() {
        boolean valid = this.validateComponents(this.getContentPane());
        if (!valid) {
            return false;
        }
        boolean save_ok = true;
        if (save_ok) {
            this.setModified(false);
        }
        return true;
    }

    public void addTopPanel(JPanel panel) {
        if (panel == null) {
            return;
        }
        this._topPanel.add(panel);
    }

    void MoverDialogJDialog_WindowClosing() {
        int retValue;
        this._canceled = true;
        if (this.isModified() && (retValue = RMAIO.postYesNoWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?")) == 0) {
            this.saveForm();
            this._canceled = false;
        }
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionAdd() {
        Cursor oldCursor = this.getCursor();
        long debugTiming1 = System.currentTimeMillis();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object[] o = this.getSelectedValues(this._availableTable);
            if (o != null && o.length > 0) {
                if (this._selectionType == 1) {
                    this._addButton.setEnabled(false);
                    if (this.getSelectedObjectsList().size() > 0) {
                        return;
                    }
                }
                this._selectedTable.clearSelection();
                this._availableTable.clearSelection();
                this.addToTable(this._selectedTable, o);
                if (this._dialogType == 0) {
                    this.removeElements(this._availableTable, o);
                }
                int[] selectedIndexes = new int[o.length];
                int start = this._selectedTable.getRowSorter() != null ? 0 : this._selectedTable.getRowCount() - o.length;
                int index = 0;
                for (int ii = start; ii < this._selectedTable.getRowCount() && index < o.length; ++ii) {
                    if (o[index] != this._selectedTable.getValueAt(ii, 0)) continue;
                    selectedIndexes[index] = ii;
                    ++index;
                }
                this._selectedTable.setSelectedIndices(selectedIndexes);
                if (this._selectionType == 1 && this.getSelectedObjectsList().size() > 0) {
                    this._addButton.setSelected(false);
                }
                boolean addEnabled = this._availableTable.getRowCount() > 0;
                this._addButton.setEnabled(addEnabled);
                this._addAllButton.setEnabled(addEnabled);
                this._removeAllButton.setEnabled(this._selectedTable.getRowCount() > 0);
            }
        }
        finally {
            if (Boolean.getBoolean("DEBUG")) {
                long t2 = System.currentTimeMillis();
                System.out.println("Time to run ADD = " + Long.toString(t2 - debugTiming1) + " ms.");
            }
            this.setCursor(oldCursor);
        }
    }

    private void removeElements(RmaJTable table, Object[] o) {
        block0: for (int i = 0; i < o.length; ++i) {
            for (int r = table.getRowCount() - 1; r >= 0; --r) {
                Object obj = table.getValueAt(r, 0);
                if (!obj.toString().toLowerCase().equals(o[i].toString().toLowerCase())) continue;
                table.deleteRow(r);
                continue block0;
            }
        }
    }

    private Object[] getSelectedValues(RmaJTable table) {
        int[] rows = table.getSelectedRows();
        Object[] objs = new Object[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            objs[i] = table.getValueAt(rows[i], 0);
        }
        return objs;
    }

    private void actionAddAll() {
        int size = this._availableTable.getRowCount();
        if (size > 0) {
            this._availableTable.getSelectionModel().setSelectionInterval(0, size - 1);
            this.actionAdd();
        }
    }

    public boolean getCaseInsensitiveSort() {
        return this._caseInsensitiveSort;
    }

    public void setCaseInsensitiveSort(boolean caseInsensitiveSort) {
        this._caseInsensitiveSort = caseInsensitiveSort;
        if (this._availableComparator != null) {
            this._availableComparator.setCaseInsensitiveSort(caseInsensitiveSort);
        }
    }

    private void sort(Object[] a) {
        if (a == null) {
            return;
        }
        boolean allComparable = true;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] instanceof Comparable) continue;
            allComparable = false;
            break;
        }
        if (allComparable) {
            if (this._caseInsensitiveSort) {
                Comparator comparator = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String so1 = o1.toString().toUpperCase();
                        String so2 = o2.toString().toUpperCase();
                        return so1.compareTo(so2);
                    }

                    @Override
                    public boolean equals(Object obj) {
                        return this.toString().equalsIgnoreCase(obj.toString());
                    }
                };
                Arrays.sort(a, comparator);
            } else {
                Arrays.sort(a);
            }
        } else if (this._caseInsensitiveSort) {
            Compare compare = new Compare(){

                public int compare(Object a, Object b, boolean ascending) {
                    String so1 = a.toString().toUpperCase();
                    String so2 = b.toString().toUpperCase();
                    return so1.compareTo(so2);
                }
            };
            RMASort.quickSort((Object[])a, (boolean)true, (Compare)compare);
        } else {
            RMASort.quickSort((Object[])a, (boolean)true);
        }
    }

    public void setPosition(String dialogName, int defaultWidth, int defaultHeight) {
        int h;
        int w;
        this._dialogName = dialogName;
        if (ClientApp.app() == null) {
            this._dialogName = null;
        }
        if (this._dialogName == null) {
            this.setSize(defaultWidth, defaultHeight);
            if (this._owner != null) {
                this.setLocationRelativeTo(this._owner);
            }
            return;
        }
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle screenSize = new Rectangle(size);
        String loc = ClientApp.app().getAppProp(this._dialogName + ".position");
        if (loc != null) {
            int y;
            int x = RMAIO.parseInt((String)RMAIO.getType((String)loc, (String)","), (int)0);
            if (screenSize.contains(x, y = RMAIO.parseInt((String)RMAIO.getParam((String)loc, (String)","), (int)0))) {
                this.setLocation(x, y);
            } else if (this._owner != null) {
                this.setLocationRelativeTo(this._owner);
            }
        } else if (this._owner != null) {
            this.setLocationRelativeTo(this._owner);
        }
        int width = defaultWidth;
        int height = defaultHeight;
        String windowSize = ClientApp.app().getAppProp(this._dialogName + ".size");
        if (windowSize != null && screenSize.contains(new Rectangle(w = (int)RMAIO.parseDouble((String)RMAIO.getType((String)windowSize, (String)","), (double)-1.0), h = (int)RMAIO.parseDouble((String)RMAIO.getParam((String)windowSize, (String)","), (double)-1.0))) && w > 100 && h > 100) {
            width = w;
            height = h;
        }
        this.setSize(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionRemove() {
        Cursor oldCursor = this.getCursor();
        long debugTiming1 = System.currentTimeMillis();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object[] o = this.getSelectedObjects();
            if (o != null && o.length > 0) {
                this._selectedTable.clearSelection();
                this.removeElements(this._selectedTable, o);
                this._availableTable.clearSelection();
                this.addToTable(this._availableTable, o);
                int[] selectedIndexes = new int[o.length];
                this.sort(o);
                int start = 0;
                int index = 0;
                for (int ii = start; ii < this._availableTable.getRowCount() && index < o.length; ++ii) {
                    if (o[index] != this._availableTable.getValueAt(ii, 0)) continue;
                    selectedIndexes[index] = ii;
                    ++index;
                }
                if (this._selectionType == 1) {
                    if (this.getAvailableObjectsList().size() > 0) {
                        this._addButton.setEnabled(true);
                    } else {
                        this._addButton.setEnabled(false);
                    }
                }
                boolean removeEnabled = this._selectedTable.getRowCount() > 0;
                this._removeButton.setEnabled(removeEnabled);
                this._removeAllButton.setEnabled(removeEnabled);
                this._addAllButton.setEnabled(this._availableTable.getRowCount() > 0);
            }
        }
        finally {
            if (Boolean.getBoolean("DEBUG")) {
                long t2 = System.currentTimeMillis();
                System.out.println("Time to run ADD = " + Long.toString(t2 - debugTiming1) + " ms.");
            }
            this.setCursor(oldCursor);
        }
    }

    private void addToTable(RmaJTable table, Object[] o) {
        if (o == null) {
            return;
        }
        for (int i = 0; i < o.length; ++i) {
            Vector<Object> row = new Vector<Object>(1);
            row.add(o[i]);
            table.appendRow(row);
        }
    }

    private void actionRemoveAll() {
        int size = this._selectedTable.getRowCount();
        if (size > 0) {
            this._selectedTable.getSelectionModel().setSelectionInterval(0, size - 1);
            this.actionRemove();
        }
    }

    private void actionMoveUp() {
        Object[] objs = this.getSelectedObjects();
        if (objs != null && objs.length > 0) {
            for (int ii = 0; ii < objs.length; ++ii) {
                int idx = this.findObjectInTable(this._selectedTable, objs[ii]);
                if (idx < 1 || ii > 0 && idx - 1 == this.findObjectInTable(this._selectedTable, objs[ii - 1])) continue;
                Object tmp = this._selectedTable.getValueAt(idx - 1, 0);
                this._selectedTable.setValueAt(tmp, idx, 0);
                this._selectedTable.setValueAt(objs[ii], idx - 1, 0);
            }
            int[] idxs = new int[objs.length];
            for (int ii = 0; ii < objs.length; ++ii) {
                idxs[ii] = this.findObjectInTable(this._selectedTable, objs[ii]);
            }
            this._selectedTable.setSelectedIndices(idxs);
        }
    }

    private void actionMoveDown() {
        Object[] objs = this.getSelectedObjects();
        if (objs != null && objs.length > 0) {
            for (int ii = objs.length - 1; ii >= 0; --ii) {
                int idx = this.findObjectInTable(this._selectedTable, objs[ii]);
                if (idx >= this._selectedTable.getRowCount() - 1 || ii < objs.length - 1 && idx + 1 == this.findObjectInTable(this._selectedTable, objs[ii + 1])) continue;
                Object tmp = this._selectedTable.getValueAt(idx + 1, 0);
                this._selectedTable.setValueAt(tmp, idx, 0);
                this._selectedTable.setValueAt(objs[ii], idx + 1, 0);
            }
            int[] idxs = new int[objs.length];
            for (int ii = 0; ii < objs.length; ++ii) {
                idxs[ii] = this.findObjectInTable(this._selectedTable, objs[ii]);
            }
            this._selectedTable.setSelectedIndices(idxs);
        }
    }

    private int findObjectInTable(RmaJTable table, Object object) {
        int rowCnt = table.getRowCount();
        for (int i = 0; i < rowCnt; ++i) {
            if (table.getValueAt(i, 0) != object) continue;
            return i;
        }
        return -1;
    }

    private void cmdOK_Action() {
        boolean closeForm = this.saveForm();
        if (!closeForm) {
            return;
        }
        if (this._dialogName != null && ClientApp.app() != null) {
            Point p = this.getLocation();
            Dimension d = this.getSize();
            ClientApp.app().getProperties().setProp(this._dialogName + ".position", p.x + "," + p.y);
            ClientApp.app().getProperties().setProp(this._dialogName + ".size", d.getWidth() + "," + d.getHeight());
        }
        this.setVisible(false);
        this.dispose();
        this._canceled = false;
    }

    private void cmdCancel_Action() {
        boolean closeForm = true;
        if (this.isModified()) {
            int retValue = RMAIO.postYesNoCancelWarning((Component)((Object)this), (String)"Data Has Changed! Save before closing?");
            if (retValue == 2) {
                return;
            }
            if (retValue == 0) {
                closeForm = this.saveForm();
                if (closeForm) {
                    this._canceled = false;
                }
            } else if (retValue == 1) {
                this._canceled = true;
            }
        } else {
            this._canceled = true;
        }
        if (!closeForm) {
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    public void setSortEnabled(boolean sorted) {
        if (!sorted) {
            this._availableTable.setRowSorter(null);
            this._selectedTable.setRowSorter(null);
        } else {
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this._availableTable.getModel());
            sorter.setComparator(0, (Comparator<?>)this._availableComparator);
            this._availableTable.setRowSorter(sorter);
            sorter = new TableRowSorter<TableModel>(this._selectedTable.getModel());
            sorter.setComparator(0, (Comparator<?>)this._selectedComparator);
            this._selectedTable.setRowSorter(sorter);
        }
    }

    public void setDialogType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Invalid dialog type " + type);
        }
        this._dialogType = type;
    }

    public int getDialogType() {
        return this._dialogType;
    }

    public static void main(String[] args) {
        MoverDialog2 mDlg = new MoverDialog2(new Frame(), true);
        mDlg.setLocation(100, 100);
        mDlg.pack();
        Vector<Object> v1 = new Vector<Object>();
        Vector v2 = new Vector();
        if (args.length > 0 && "numbers".equals(args[0])) {
            Random random = new Random();
            for (int i = 0; i < 50000; ++i) {
                String value = Double.toString(random.nextDouble() * 1.0E7);
                v1.addElement(value);
                if (i % 5000 != 0) continue;
                System.out.println("Index " + i);
            }
        } else {
            String ab = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            for (int i = 0; i < ab.length(); ++i) {
                v1.addElement(Character.valueOf(ab.charAt(i)));
            }
        }
        mDlg.setData(v1, v2);
        mDlg.setDefaultCloseOperation(2);
        mDlg.setVisible(true);
    }

    public void setListsEnabled(boolean enabled) {
        this._tablePanel.setEnabled(enabled);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == MoverDialog2.this) {
                MoverDialog2.this.MoverDialogJDialog_WindowClosing();
            }
        }
    }
}

