/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.io;

import hec.clientapp.client.ClientApp;
import hec.io.HecFile;
import hec.lang.ClientAppCheck;
import hec.lang.HtmlAttributes;
import hec.properties.HECProperties;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.StringTokenizer;

public class RmiProgessLogFileWriter {
    public static final String SEP = "--------------------------------------------------------------------------------";
    HecFile _logfile;
    BufferedWriter _logWriter;
    boolean _useHtmlForLogging = false;
    HtmlAttributes _htmlAttributes = new HtmlAttributes();
    StringBuffer _htmlbuf;
    boolean _lastWasTable = false;

    public RmiProgessLogFileWriter(HecFile logfile, String backgroundColor) {
        this._logfile = logfile;
        this._logWriter = this._logfile.getBufferedWriter();
        this.checkForHtmlFlag();
        if (this._useHtmlForLogging) {
            try {
                this._logWriter.write("<HTML><HEAD></HEAD><BODY BGCOLOR=" + backgroundColor + ">");
                this._logWriter.newLine();
                this._htmlbuf = new StringBuffer();
            }
            catch (IOException ioe) {
                this._useHtmlForLogging = false;
            }
        }
    }

    public void close() {
        try {
            if (this._logWriter != null) {
                if (this._useHtmlForLogging) {
                    this._logWriter.write("</BODY></HTML>");
                }
                this._logWriter.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkForHtmlFlag() {
        HECProperties props = null;
        if (ClientAppCheck.haveClientApp()) {
            props = ClientApp.app().getProperties();
        }
        if (props == null) {
            return;
        }
        this._useHtmlForLogging = Boolean.valueOf(props.getProp("client.useHtmlForLogs", "false"));
        if (this._useHtmlForLogging) {
            this._htmlbuf = new StringBuffer();
        }
    }

    public boolean usingHtmlForLogging() {
        return this._useHtmlForLogging;
    }

    public HtmlAttributes getLineAttributes() {
        return this._htmlAttributes;
    }

    public void setLineAttributes(HtmlAttributes a) {
        this._htmlAttributes = a == null ? new HtmlAttributes() : a;
    }

    public void printSeparator() {
        if (this._useHtmlForLogging) {
            this.write("<HR>");
        } else {
            this.write(SEP);
        }
    }

    public void printTableRow(boolean isHeader, String tableRow) {
        if (this._useHtmlForLogging) {
            String cellEnd;
            String cellStart;
            this._htmlbuf.setLength(0);
            if (isHeader) {
                this._htmlbuf.append("<TABLE>\n");
            }
            this._htmlbuf.append("<TR>");
            if (isHeader) {
                cellStart = "<TH>";
                cellEnd = "</TH>";
            } else {
                cellStart = "<TD>";
                cellEnd = "</TD>";
            }
            StringTokenizer token = new StringTokenizer(tableRow, "\t");
            while (token.hasMoreTokens()) {
                this._htmlbuf.append(cellStart);
                this._htmlbuf.append(token.nextToken());
                this._htmlbuf.append(cellEnd);
            }
            this._htmlbuf.append("</TR>");
            this._write(this._htmlbuf.toString());
            this._lastWasTable = true;
        }
    }

    public void write(String msg) {
        if (this._lastWasTable) {
            this._write("</TABLE>");
            this._lastWasTable = false;
        }
        this._write(msg);
    }

    private void _write(String msg) {
        if (this._logWriter != null) {
            try {
                if (this._useHtmlForLogging) {
                    this._htmlbuf.setLength(0);
                    if (this._htmlAttributes != null) {
                        int size;
                        int style = this._htmlAttributes.getLineStyle();
                        this._htmlbuf.append("<P ALIGN=" + this._htmlAttributes.getAlignmentString() + ">");
                        if ((style & 1) > 0) {
                            this._htmlbuf.append("<B>");
                        }
                        if ((style & 2) > 0) {
                            this._htmlbuf.append("<I>");
                        }
                        if ((size = this._htmlAttributes.getFontSize()) > -1) {
                            this._htmlbuf.append("<FONT SIZE=+" + size + " COLOR=\"" + this._htmlAttributes.getLineColor() + "\">");
                        }
                        this._htmlbuf.append(msg);
                        if (size > -1) {
                            this._htmlbuf.append("</FONT>");
                        }
                        if ((style & 2) > 0) {
                            this._htmlbuf.append("</I>");
                        }
                        if ((style & 1) > 0) {
                            this._htmlbuf.append("</B>");
                        }
                        this._htmlbuf.append("</P>");
                        this._logWriter.write(this._htmlbuf.toString());
                    } else {
                        this._logWriter.write(msg);
                    }
                } else {
                    this._logWriter.write(msg);
                }
                this._logWriter.newLine();
            }
            catch (IOException ioe) {
                System.out.println("write2log: IO error writing to log file " + ioe);
            }
        }
    }
}

