/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.io;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.heclib.util.HecTime;
import hec.io.Identifier;
import hec.lang.UserId;
import java.io.BufferedWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class WatershedInfoFile {
    public static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static final String WATERSHED_INFO_FILE = "WatershedInfo.md";
    public static final String START_OF_RECORD = "# ";
    public static final String FIELD_SEPARATOR = " | ";
    public static final String COMMENT = "#";
    private Identifier _openId;
    private HecTime _time = new HecTime();
    private String _version = this.getVersion();

    public void close() {
    }

    private String getVersion() {
        Properties props = RMAIO.getAppVersionProperties(ClientApp.app().getClass());
        if (props != null) {
            return props.getProperty("fullVersion");
        }
        return "unknown";
    }

    public Identifier getWatershedInfoIdentifier() {
        if (this._openId != null) {
            return this._openId;
        }
        String mdPath = WatershedInfoFile.getWatershedInfoFilename();
        Identifier id = new Identifier(mdPath);
        RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
        try {
            this._openId = fm.openFile(UserId.getUserId(), id);
            if (this._openId == null) {
                this._openId = fm.newFile(UserId.getUserId(), id);
                this.addRecord("Created", "Watershed Info File Created", false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (this._openId == null) {
            return null;
        }
        return this._openId;
    }

    private BufferedWriter getWriter() {
        if (this._openId == null) {
            return null;
        }
        if (!this._openId.getFile().exists() || this._openId.getFile().length() == 0L) {
            return this._openId.getFile().getBufferedWriter();
        }
        return this._openId.getFile().getAppendedBufferedWriter();
    }

    public String addRecord(String action, String comment) {
        return this.addRecord(action, comment, true);
    }

    public String addRecord(String action, String comment, boolean prefixNewLine) {
        if (comment == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (prefixNewLine) {
            builder.append(System.getProperty("line.separator"));
        }
        builder.append(START_OF_RECORD);
        builder.append(ClientApp.Workspace().getName());
        builder.append(FIELD_SEPARATOR);
        this._time.setCurrent();
        builder.append(RMAIO.removeChar((String)this._time.dateAndTime(4), (char)','));
        builder.append(FIELD_SEPARATOR);
        builder.append(UserId.getUserId());
        builder.append(FIELD_SEPARATOR);
        builder.append(this._version);
        builder.append(FIELD_SEPARATOR);
        builder.append(action);
        builder.append(FIELD_SEPARATOR);
        builder.append(System.getProperty("line.separator"));
        builder.append(comment);
        String record = builder.toString();
        if (this.writeRecord(record)) {
            return record;
        }
        return "";
    }

    private boolean writeRecord(String record) {
        BufferedWriter writer = this.getWriter();
        if (writer != null) {
            try {
                writer.write(record);
                writer.newLine();
                writer.close();
                return true;
            }
            catch (IOException e) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("Failed to write WatershedInfo Record. Error %s" + e);
            }
        }
        return false;
    }

    public static String getWatershedInfoFilename() {
        if (ClientApp.Workspace() == null) {
            return null;
        }
        String wkspPath = ClientApp.Workspace().getWorkspacePath();
        String mdPath = RMAIO.concatPath((String)wkspPath, (String)WATERSHED_INFO_FILE);
        return mdPath;
    }
}

