/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.map.impactArea;

import hec.map.WorldRect;
import hec.map.WorldRegion;
import hec.map.aishape.ShapeImport;
import hec.map.importer.ImportPolygon;
import hec.model.StreamElement;
import java.util.List;

public class ImpactAreaShapeImport
extends ShapeImport {
    private static final String MULTIPLE_POLYGONS_DEFINED = "Multiple polygons have identical text in the attribute you chose to use for \"Name\".\nThese cannot be imported as impact areas. Use the Impact Area tool to draw in the \nimpact areas that cannot be imported.";
    private static final String MULTIPLE_POLYGONS_PER_ATTRIBUTE = "Multiple regions are defined for the given polygon.\nThese cannot be imported as impact areas. Use the Impact Area tool to draw in the \nimpact areas that cannot be imported.";
    WorldRegion largestClockwiseRegion = null;
    StreamElement _stream;

    public ImpactAreaShapeImport(String name) {
        super(name);
    }

    public boolean validate() {
        List shapes = this.getShapes();
        this.largestClockwiseRegion = null;
        WorldRect largestBounds = null;
        ImportPolygon largestShapePolygon = null;
        for (int ii = 0; ii < shapes.size(); ++ii) {
            ImportPolygon poly = (ImportPolygon)shapes.get(ii);
            List regions = poly.getRegions();
            for (int jj = 0; jj < regions.size(); ++jj) {
                WorldRegion region = (WorldRegion)regions.get(jj);
                if (!region.isClockwise()) continue;
                WorldRect regionBounds = region.getWorldRectBounds();
                if (this.largestClockwiseRegion == null) {
                    this.largestClockwiseRegion = region;
                    largestBounds = regionBounds;
                    largestShapePolygon = poly;
                    continue;
                }
                if (regionBounds.contains(largestBounds)) {
                    largestShapePolygon = poly;
                    this.largestClockwiseRegion = region;
                    largestBounds = regionBounds;
                    continue;
                }
                if (largestBounds.contains(regionBounds)) continue;
                if (poly != largestShapePolygon) {
                    this.addError(MULTIPLE_POLYGONS_DEFINED);
                } else {
                    this.addError(MULTIPLE_POLYGONS_PER_ATTRIBUTE);
                }
                return false;
            }
        }
        return true;
    }

    public int getShapeGraphicType() {
        return 0;
    }

    public void removeExistsError() {
        this.removeError("Impact area already exists.");
    }

    public void addExistsError() {
        this.addError("Impact area already exists.");
    }

    public WorldRegion getRegion() {
        if (this.largestClockwiseRegion == null && !this.validate()) {
            return null;
        }
        return this.largestClockwiseRegion;
    }

    public void setStreamElement(StreamElement elem) {
        this._stream = elem;
    }

    public StreamElement getStreamElement() {
        return this._stream;
    }
}

