/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.map.raster.dbf;

import codebase.Code4jni;
import hec.appInterface.AppDaddy;
import hec.appInterface.FileOpener;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.dbf.DBFFieldDescriptor;
import hec.io.dbf.DBaseIIIHeader;
import hec.io.dbf.DbfQueryResultSet;
import hec.io.dbf.DbfRecord;
import hec.io.dbf.DbfRecordQuery;
import hec.io.dbf.DbfRecordSet;
import hec.io.dbf.Tag4infoContainer;
import hec.map.MapIdentifier;
import hec.map.MapObject;
import hec.map.MapObjectFactory;
import hec.map.MapObjectInterface;
import hec.map.aidem.AiDemBaseMap;
import hec.map.aidem.AiDemMap;
import hec.map.appInterface.MapWorkspace;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.raster.RasterMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.io.dbf.DbfFile;
import mil.army.usace.hec.rmi.io.dbf.DbfIdentifier;
import rma.util.RMAIO;

public class RasterDbfMap
extends MapObject
implements Serializable,
MapObjectInterface {
    public static final String RASTER_FILE = "RasterFile";
    public static final String RASTER_CELL_SIZE_UNITS = "RasterCellSizeUnits";
    public static final String DBF_FILE = "DBFFile";
    public static final String DBF_ID = "DBFID";
    public static final String DBF_ID_DESC = "DBFIDDESC";
    public static final String EXTENSION = ".rdbf";
    RasterMap _rasterMap = null;
    DbfIdentifier _dbfFileId = null;
    DBaseIIIHeader _dbfHeader = null;
    String _dbfFieldId = null;
    DBFFieldDescriptor _dbfIdMappingField = null;
    String _dbfFieldIdDesc = null;
    DBFFieldDescriptor _dbfDescMappingField = null;
    String _dbfFilePath = null;
    String _rasterFilePath = null;
    Code4jni code4JniClient = null;
    public static final String[] VALID_CELL_SIZE_UNITS = new String[]{"undef", "ft", "m", "km", "mi"};
    String _cellSizeUnits = "undef";

    public RasterDbfMap(String fileName) {
        super(fileName);
        this.init();
    }

    public RasterDbfMap(MapIdentifier id) {
        super(id);
        this.init();
    }

    public RasterDbfMap() {
        this.init();
    }

    public void setCellSizeUnits(String s) {
        this._cellSizeUnits = s;
    }

    public String getCellSizeUnits() {
        return this._cellSizeUnits;
    }

    public String getDbfIdFieldName() {
        return this._dbfFieldId;
    }

    public String getDbfDescFieldName() {
        return this._dbfFieldIdDesc;
    }

    public String getRasterMapPath() {
        return this._rasterFilePath;
    }

    public String getDbfPath() {
        return this._dbfFilePath;
    }

    public RasterMap getRasterMap() {
        return this._rasterMap;
    }

    void init() {
    }

    public void unload() {
        this.init();
    }

    public void loadHeader() throws IOException {
        HecFile file = this._mapId.getFile();
        this.readHeader(file);
    }

    public void load() throws IOException {
        if (!this._loaded) {
            this.loadHeader();
            this.loadData();
            this._loaded = true;
        }
    }

    public static void createFile(FileOpener fileOpener, HecFile file, String rasterFilePath, String rasterCellSizeUnits, String dbfFilePath, String dbfField, String dbfFieldDesc) throws IOException {
        if (RMAIO.isFullPath((String)rasterFilePath) && fileOpener != null) {
            try {
                rasterFilePath = ((MapWorkspace)fileOpener).getRelativePath(rasterFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (RMAIO.isFullPath((String)dbfFilePath) && fileOpener != null) {
            try {
                dbfFilePath = ((MapWorkspace)fileOpener).getRelativePath(dbfFilePath);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BufferedWriter bw = file.getBufferedWriter();
        StringBuffer sb = new StringBuffer(80);
        sb.append(RASTER_FILE);
        sb.append("=");
        sb.append(rasterFilePath);
        String s = sb.toString();
        bw.write(s);
        bw.newLine();
        sb.setLength(0);
        sb.append(RASTER_CELL_SIZE_UNITS);
        sb.append("=");
        sb.append(rasterCellSizeUnits);
        s = sb.toString();
        bw.write(s);
        bw.newLine();
        sb.setLength(0);
        sb.append(DBF_FILE);
        sb.append("=");
        sb.append(dbfFilePath);
        s = sb.toString();
        bw.write(s);
        bw.newLine();
        sb.setLength(0);
        sb.append(DBF_ID);
        sb.append("=");
        sb.append(dbfField);
        s = sb.toString();
        bw.write(s);
        bw.newLine();
        if (dbfFieldDesc != null) {
            sb.setLength(0);
            sb.append(DBF_ID_DESC);
            sb.append("=");
            sb.append(dbfFieldDesc);
            s = sb.toString();
            bw.write(s);
            bw.newLine();
        }
        bw.close();
    }

    private void readHeader(HecFile file) throws IOException {
        MapIdentifier mapId = this.getMapIdentifier();
        BufferedReader br = file.getBufferedReader();
        String line = br.readLine();
        while (line != null) {
            line = line.trim();
            String param = RMAIO.getParam((String)line, (String)"=");
            String type = RMAIO.getType((String)line, (String)"=");
            if (type.equalsIgnoreCase(RASTER_FILE)) {
                if (AppDaddy.getWorkspace() != null) {
                    this._rasterFilePath = AppDaddy.getWorkspace().getWorkspacePath() + "/" + param;
                } else if (this._fileOpener instanceof MapWorkspace) {
                    this._rasterFilePath = ((MapWorkspace)this._fileOpener).getWorkspacePath() + "/" + param;
                }
            } else if (type.equalsIgnoreCase(DBF_FILE)) {
                if (AppDaddy.getWorkspace() != null) {
                    this._dbfFilePath = AppDaddy.getWorkspace().getWorkspacePath() + "/" + param;
                } else if (this._fileOpener instanceof MapWorkspace) {
                    this._dbfFilePath = ((MapWorkspace)this._fileOpener).getWorkspacePath() + "/" + param;
                }
            } else if (type.equalsIgnoreCase(DBF_ID)) {
                this._dbfFieldId = param;
            } else if (type.equalsIgnoreCase(DBF_ID_DESC)) {
                this._dbfFieldIdDesc = param;
            } else if (type.equalsIgnoreCase(RASTER_CELL_SIZE_UNITS)) {
                this._cellSizeUnits = param;
            }
            line = br.readLine();
        }
    }

    private void loadData() throws IOException {
        StringBuffer sb;
        Identifier pathId;
        Identifier idOut;
        if (this._rasterFilePath != null && (idOut = this.openFile(pathId = new Identifier(this._rasterFilePath))) != null) {
            MapObject map = MapObjectFactory.newMapObject((FileOpener)this._fileOpener, (Identifier)idOut);
            if (map instanceof RasterMap) {
                this._rasterMap = (RasterMap)map;
            } else if (map.getClass().getName().equals("hec.map.aidem.AiDemMap")) {
                this._rasterMap = RasterMap.importMap(null, (FileOpener)this._fileOpener, (int)11, (AiDemBaseMap)((AiDemMap)map));
                this._rasterFilePath = this._rasterMap.getMapIdentifier().getPath();
                RasterDbfMap.createFile(this._fileOpener, this.getMapIdentifier().getFile(), this._rasterFilePath, "undef", this._dbfFilePath, this._dbfFieldId, this._dbfFieldIdDesc);
            }
        }
        if (this._dbfFilePath != null && (idOut = this.openFile(pathId = new DbfIdentifier(this._dbfFilePath))) != null && idOut instanceof DbfIdentifier) {
            this._dbfFileId = (DbfIdentifier)idOut;
        }
        if (this._rasterMap == null) {
            sb = new StringBuffer("Raster File: ");
            sb.append(this._rasterFilePath);
            sb.append(" not found.");
            throw new FileNotFoundException(sb.toString());
        }
        this._rasterMap.load();
        if (this._dbfFileId == null) {
            sb = new StringBuffer("DBF File: ");
            sb.append(this._dbfFilePath);
            sb.append(" not found.");
            throw new FileNotFoundException(sb.toString());
        }
        this.loadDbf();
    }

    private void loadDbf() throws IOException {
        this.checkDbfFieldId();
        this.indexDbf();
    }

    private void checkDbfFieldId() throws IOException {
        this._dbfHeader = new DBaseIIIHeader();
        this._dbfHeader.readHeader(this._dbfFileId.getFile().getEndianInputStream());
        for (int ii = 0; ii < this._dbfHeader.getNumDescriptors(); ++ii) {
            DBFFieldDescriptor field = this._dbfHeader.getFieldDescriptor(ii);
            if (field.fieldName.equalsIgnoreCase(this._dbfFieldId)) {
                this._dbfIdMappingField = field;
                if (this._dbfDescMappingField == null) continue;
                break;
            }
            if (!field.fieldName.equalsIgnoreCase(this._dbfFieldIdDesc)) continue;
            this._dbfDescMappingField = field;
            if (this._dbfIdMappingField != null) break;
        }
        if (this._dbfIdMappingField == null) {
            StringBuffer sb = new StringBuffer("DBF Mapping Field: ");
            sb.append(this._dbfFieldId);
            sb.append(" not contained in DBF File: ");
            sb.append(this._dbfFileId.getPath());
            throw new IOException(sb.toString());
        }
    }

    private DbfRecordSet queryDbfIdDescData() {
        String[] fieldNames;
        if (this._dbfHeader == null) {
            try {
                this.load();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        DbfFile dbfFile = this._dbfFileId.getDbfFile();
        String indexFileName = RMAIO.removeFileExtension((String)dbfFile.getPath());
        DbfRecordQuery query = null;
        if (this._dbfDescMappingField != null) {
            fieldNames = new String[]{this._dbfIdMappingField.fieldName, this._dbfDescMappingField.fieldName};
            query = new DbfRecordQuery(indexFileName, DBF_ID_DESC, fieldNames);
        } else {
            fieldNames = new String[]{this._dbfIdMappingField.fieldName, this._dbfIdMappingField.fieldName};
            query = new DbfRecordQuery(indexFileName, DBF_ID_DESC, fieldNames);
        }
        DbfQueryResultSet data = dbfFile.queryRecords(query);
        return data;
    }

    public HashMap getIdAndDescriptionHashMap() {
        DbfRecordSet data = this.queryDbfIdDescData();
        if (data == null) {
            return null;
        }
        HashMap<Object, Object[]> idDescData = new HashMap<Object, Object[]>(data.size());
        for (int ii = 0; ii < data.size(); ++ii) {
            DbfRecord rec = data.get(ii);
            Vector row = rec.getData();
            Object[] idDesc = new Object[2];
            row.copyInto(idDesc);
            idDescData.put(idDesc[0], idDesc);
        }
        return idDescData;
    }

    public List getIdAndDescriptionList() {
        DbfRecordSet data = this.queryDbfIdDescData();
        if (data == null) {
            return null;
        }
        ArrayList<Object[]> idDescData = new ArrayList<Object[]>(data.size());
        for (int ii = 0; ii < data.size(); ++ii) {
            DbfRecord rec = data.get(ii);
            Vector row = rec.getData();
            Object[] idDesc = new Object[2];
            row.copyInto(idDesc);
            idDescData.add(idDesc);
        }
        return idDescData;
    }

    private void indexDbf() throws IOException {
        DbfFile dbfFile = this._dbfFileId.getDbfFile();
        String indexFileName = RMAIO.removeFileExtension((String)dbfFile.getPath());
        Tag4infoContainer tags = new Tag4infoContainer();
        try {
            tags.add(DBF_ID, this._dbfIdMappingField.fieldName, null, (byte)25, false);
            if (this._dbfDescMappingField != null) {
                tags.add(DBF_ID_DESC, this._dbfDescMappingField.fieldName, null, (byte)25, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dbfFile.createIndex(indexFileName, tags);
    }

    public static void runStaticTest() {
        try {
            String path = "j:/apps/base/raster_dbf2/maps/cb.rdbf";
            HecFileImpl file = new HecFileImpl(new FilePath(path));
            MapIdentifier mi = new MapIdentifier(path, (HecFile)file);
            RasterDbfMap map = new RasterDbfMap(mi);
            map.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List getFilenames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this._mapId.getPath());
        if (!this._loaded) {
            try {
                this.loadHeader();
            }
            catch (IOException e) {
                System.out.println("getFilenames:IOException " + e);
            }
        }
        if (this._rasterFilePath != null) {
            l.add(this._rasterFilePath);
        }
        if (this._dbfFilePath != null) {
            l.add(this._dbfFilePath);
        }
        return l;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }
}

