/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.ComputeInfo;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListManager;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimRunInfo;
import hec.clientapp.model.Simulation;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.TrialRun;
import hec.clientapp.rmi.csinterface.ComputableRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.heclib.util.HecTime;
import hec.io.AsciiSerializable;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.model.AltItem;
import hec.model.RunTimeWindow;
import hec.model.TrialReference;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import mil.army.usace.hec.rmi.client.RMIProgressDisplay;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.lang.NestingException;

public abstract class AbstractSimulation
extends ManagerProxyListManager
implements AsciiSerializable,
Simulation {
    protected String _startTimeString = "";
    protected String _endTimeString = "";
    protected String _startDate = "";
    protected String _endDate = "";
    protected String _lookbackDate = "";
    protected String _lookbackTime = "";
    protected int _timeStep = 1;
    protected int _timeIncrement = 2;
    protected Vector<String> _altComputeTimes = new Vector();
    protected Vector<String> _altFailedComputeTimes = new Vector();
    protected Vector<String> _altCanceledComputeTimes = new Vector();
    protected transient boolean _computeAll = false;
    protected transient RMIProgressDisplay _progressDisplay = null;

    public AbstractSimulation() {
    }

    public AbstractSimulation(String name) {
        super(name);
    }

    public abstract String getOutputDSSFileName();

    public abstract String getOutputDSSFilePath();

    @Override
    public String getStartDateString() {
        return this._startDate;
    }

    @Override
    public void setStartDate(String date) {
        this._startDate = date;
    }

    @Override
    public String getEndDateString() {
        return this._endDate;
    }

    @Override
    public void setEndDate(String date) {
        HecTime newEndDate;
        HecTime currentEndDate;
        if (this._endDate != null && !this._endDate.isEmpty() && !(currentEndDate = new HecTime(this._endDate)).equalTo(newEndDate = new HecTime(date))) {
            this.setAlternativesModified();
        }
        this._endDate = date;
    }

    protected void setAlternativesModified() {
        Vector simRuns = this.getSimulationRuns();
        for (int i = 0; i < simRuns.size(); ++i) {
            SimulationRun simRun = (SimulationRun)((Object)simRuns.get(i));
            Vector<AltItem> altItems = simRun.getAltList();
            for (int a = 0; a < altItems.size(); ++a) {
                Manager alt;
                AltItem altItem = altItems.get(a);
                ModelAlt modelAlt = simRun.getModelAlt(altItem);
                if (modelAlt == null || (alt = modelAlt.getManager()) == null) continue;
                alt.setModified(true);
            }
            Vector trials = simRun.getTrials();
            for (int t = 0; t < trials.size(); ++t) {
                TrialRun trial = (TrialRun)trials.get(t);
                if (!(trial instanceof Manager)) continue;
                ((Manager)((Object)trial)).setModified(true);
            }
        }
    }

    @Override
    public String getLookbackDateString() {
        return this._lookbackDate;
    }

    @Override
    public void setLookbackDate(String date) {
        HecTime newLookbackDate;
        HecTime currentLookbackDate;
        this._lookbackDate = date;
        if (this._lookbackDate != null && !this._lookbackDate.isEmpty() && !(currentLookbackDate = new HecTime(this._lookbackDate)).equalTo(newLookbackDate = new HecTime(date))) {
            this.setAlternativesModified();
        }
    }

    public void setTimestep(int ts) {
        this.setTimeStep(ts, 2);
    }

    public int getTimeIncrementType() {
        return this._timeIncrement;
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        Enumeration e = this._managerGroup.elements();
        while (e.hasMoreElements()) {
            ManagerProxyList list = (ManagerProxyList)e.nextElement();
            for (int j = 0; j < list.size(); ++j) {
                ManagerProxy proxy = (ManagerProxy)list.elementAt(j);
                if (proxy == null || proxy.getManager() == null || !proxy.getManager().isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public abstract void loadWorkspace(String var1, String var2);

    public abstract String[] getAlternatives();

    public boolean isLoaded() {
        return false;
    }

    public void setTimeStep(int timeStep, int increment) {
        this._timeStep = timeStep;
        this._timeIncrement = increment;
    }

    public int getTimestep() {
        return this._timeStep;
    }

    public String getTimeStepString() {
        switch (this._timeIncrement) {
            case 3: {
                return String.valueOf(this._timeStep) + "DAY";
            }
            case 1: {
                return String.valueOf(this._timeStep) + "MINUTE";
            }
        }
        return String.valueOf(this._timeStep) + "HOUR";
    }

    public RunTimeWindow getRunTimeWindow() {
        RunTimeWindow runtimewindow = new RunTimeWindow();
        Object dateandtime = this._lookbackDate + " " + this._lookbackTime;
        dateandtime = ((String)dateandtime).replace(',', ' ');
        runtimewindow.setLookbackTime((String)dateandtime);
        dateandtime = this._startDate + " " + this._startTimeString;
        dateandtime = ((String)dateandtime).replace(',', ' ');
        runtimewindow.setStartTime((String)dateandtime);
        dateandtime = this._endDate + " " + this._endTimeString;
        dateandtime = ((String)dateandtime).replace(',', ' ');
        runtimewindow.setEndTime((String)dateandtime);
        runtimewindow.setTimeStep(this._timeStep, this._timeIncrement);
        return runtimewindow;
    }

    @Override
    public String getTimeWindowString() {
        String twstr = this._lookbackDate + " " + this._endDate;
        return twstr;
    }

    @Override
    public boolean getTimeWindow(HecTime start, HecTime end) {
        start.set(this._lookbackDate);
        end.set(this._endDate);
        return start.isDefined() && end.isDefined();
    }

    public void setComputeDisplay(RMIProgressDisplay dlg) {
        this._progressDisplay = dlg;
    }

    public void setComputeAll(boolean b) {
        this._computeAll = b;
    }

    public boolean getComputeAll() {
        return this._computeAll;
    }

    protected void setAltFailedComputeTime(String altname, String model, long cTime) {
        if (altname == null || model == null) {
            return;
        }
        int index = this.getAltFailedComputeIndex(altname, model);
        String computeTime = model + ":" + altname + ":" + cTime;
        if (index < 0 || index > this._altFailedComputeTimes.size()) {
            this._altFailedComputeTimes.addElement(computeTime);
        } else {
            this._altFailedComputeTimes.setElementAt(computeTime, index);
        }
        this.setModified(true);
    }

    protected void setAltCanceledComputeTime(String altname, String model, long cTime) {
        if (altname == null || model == null) {
            return;
        }
        int index = this.getAltCanceledComputeIndex(altname, model);
        String computeTime = model + ":" + altname + ":" + cTime;
        if (index < 0 || index > this._altCanceledComputeTimes.size()) {
            this._altCanceledComputeTimes.addElement(computeTime);
        } else {
            this._altCanceledComputeTimes.setElementAt(computeTime, index);
        }
        this.setModified(true);
    }

    protected void setAltComputeTime(String altname, String model, long cTime) {
        if (altname == null || model == null) {
            return;
        }
        int index = this.getAltComputeIndex(altname, model);
        String computeTime = model + ":" + altname + ":" + cTime;
        if (index < 0 || index > this._altComputeTimes.size()) {
            this._altComputeTimes.addElement(computeTime);
        } else {
            this._altComputeTimes.setElementAt(computeTime, index);
        }
        this.setModified(true);
    }

    protected int getAltCanceledComputeIndex(String altname, String model) {
        return this.getAltComputeIndex(this._altCanceledComputeTimes, altname, model);
    }

    protected int getAltFailedComputeIndex(String altname, String model) {
        return this.getAltComputeIndex(this._altFailedComputeTimes, altname, model);
    }

    protected int getAltComputeIndex(String altname, String model) {
        return this.getAltComputeIndex(this._altComputeTimes, altname, model);
    }

    private int getAltComputeIndex(Vector<String> altComputeTimes, String altname, String model) {
        if (altComputeTimes.size() == 0 || altname == null || model == null) {
            return -1;
        }
        for (int i = 0; i < altComputeTimes.size(); ++i) {
            String str;
            StringTokenizer tokenizer;
            String obj = altComputeTimes.elementAt(i);
            if (!(obj instanceof String) || !(tokenizer = new StringTokenizer(str = obj, ":")).hasMoreElements()) continue;
            String mod = tokenizer.nextToken();
            String alt = tokenizer.nextToken();
            if (!mod.equals(model) || !alt.equals(altname)) continue;
            return i;
        }
        return -1;
    }

    public long getAltFailedComputeTime(String altname, String model) {
        return this.getComputeTime(this._altFailedComputeTimes, altname, model);
    }

    public long getAltCanceledComputeTime(String altname, String model) {
        return this.getComputeTime(this._altCanceledComputeTimes, altname, model);
    }

    public long getAltComputeTime(String altname, String model) {
        return this.getComputeTime(this._altComputeTimes, altname, model);
    }

    private long getComputeTime(Vector<String> computeTimes, String altname, String model) {
        if (computeTimes.size() == 0) {
            return 0L;
        }
        for (int i = 0; i < computeTimes.size(); ++i) {
            String str;
            StringTokenizer tokenizer;
            String obj = computeTimes.elementAt(i);
            if (!(obj instanceof String) || !(tokenizer = new StringTokenizer(str = obj, ":")).hasMoreElements()) continue;
            String mod = tokenizer.nextToken();
            String alt = tokenizer.nextToken();
            if (!mod.equals(model) || !alt.equals(altname)) continue;
            String mTimeStr = tokenizer.nextToken();
            return new Long(mTimeStr);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(Identifier id) {
        if (id == null) {
            return false;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        try {
            BufferedWriter writer;
            block10: {
                this.setReloadOk(false);
                try {
                    writer = file.getBufferedWriter();
                    if (writer != null) break block10;
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ioe) {
                    System.out.println("writeFile: IOException writing " + file.getPath() + " Error " + ioe);
                    boolean bl = false;
                    this.setReloadOk(true);
                    return bl;
                }
            }
            super.writeFile(id);
            System.out.println("writing: " + file.getPath());
            HecAsciiSerializer as = new HecAsciiSerializer(writer);
            as.serializeObject((Object)this);
            writer.close();
            this.setModified(false);
            this.saveWorkspace(false);
            boolean bl = true;
            return bl;
        }
        finally {
            this.setReloadOk(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readFile(Identifier id) {
        if (id == null) {
            return false;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        BufferedReader reader = null;
        System.out.println("readFile:reading " + file.getPath());
        try {
            reader = file.getBufferedReader();
            HecAsciiDeserializer as = new HecAsciiDeserializer(reader);
            as.addClassMapping("hec.model.SimulationPeriod", this.getClass().getName());
            as.addClassMapping("hec.model.SimRunInfo", SimRunInfo.class.getName());
            as.addClassMapping("hec.model.AltItem", AltItem.class.getName());
            boolean rv = as.deserializeObject((Object)this);
            this.setModified(false);
            boolean bl = rv;
            return bl;
        }
        catch (Exception ioe) {
            System.out.println("readFile: IOException reading " + file.getPath() + " Error " + ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected int computeModel(ComputeInfo ci, String wkspName) {
        String modelUpper = ci.programName.toUpperCase();
        if (modelUpper.equals("RSS")) {
            modelUpper = "ResSim";
        }
        int success = 2;
        if (ci.modelAltname.equals("-NONE-")) {
            this.printMessage("No " + modelUpper + " alternative selected");
            return 1;
        }
        this.printMessage("Running " + modelUpper + " alternative " + ci.modelAltname);
        this.printStatus("Running " + modelUpper);
        System.out.println("getting workspace " + wkspName);
        RmiWorkspace rmiwksp = this.getChildWorkspace(wkspName);
        if (!(rmiwksp instanceof ComputableRmiWorkspace)) {
            this.printErrorMessage("Failed to find " + modelUpper + " Workspace");
            this.printStatus("COMPUTE FAILED");
            return 2;
        }
        ComputableRmiWorkspace childWksp = (ComputableRmiWorkspace)rmiwksp;
        if (childWksp == null) {
            this.printErrorMessage("Failed to load " + modelUpper + " Workspace");
            this.printStatus("COMPUTE FAILED");
            return 2;
        }
        try {
            success = childWksp.computeAlternative(ci);
            switch (success) {
                case 1: {
                    break;
                }
                case 2: {
                    this.printErrorMessage("\nERROR: " + modelUpper + " compute failed!");
                    this.printMessage("\nCheck Compute Log for details");
                    this.printStatus("COMPUTE FAILED");
                    return success;
                }
                case 0: {
                    this.printMessage(modelUpper + " Compute Complete for " + ci.modelAltname);
                }
            }
        }
        catch (NestingException ne) {
            this.printErrorMessage("\nERROR: " + modelUpper + " compute failed!");
            this.printStatus("COMPUTE FAILED");
            System.out.println(modelUpper + " server compute exception " + ne);
            System.out.println(ne.getStackTraceString());
            return 2;
        }
        catch (Exception e) {
            this.printErrorMessage("\nERROR: " + modelUpper + " compute failed!");
            this.printStatus("COMPUTE FAILED");
            System.out.println(modelUpper + " server compute exception " + e);
            e.printStackTrace();
            return 2;
        }
        return success;
    }

    protected String getUserDisplayUrl() {
        String display = System.getProperty("HecDisplay");
        Object stringUrl = null;
        if (display == null || display.equals("")) {
            try {
                stringUrl = InetAddress.getLocalHost().getHostAddress() + ":0";
            }
            catch (UnknownHostException uhe) {
                System.out.println("Can't find my host address " + uhe);
                this.printWarningMessage("Unable to determine client display address");
            }
        } else {
            stringUrl = display;
        }
        return stringUrl;
    }

    public Vector getSimulationRuns() {
        throw new UnsupportedOperationException("getSimulationRuns() not yet implemented");
    }

    @Override
    public boolean removeTrial(AltItem altItem, TrialReference trialRef2Remove) {
        throw new UnsupportedOperationException("removeTrial() not yet implemented");
    }

    public void setTaskNumber(int i) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println("\nTask Number " + i + "%\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).setTaskNumber(i);
                }
                catch (RemoteException re) {
                    System.out.println("\nTask Number " + i + "%\n");
                }
            }
        }
    }

    public abstract String getSimulationPath();

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

