/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.lang.ModelReference;
import hec.model.RunTimeWindow;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import mil.army.usace.hec.rmi.server.RemoteWrapper;

public class ComputeInfo
implements Serializable {
    static final long serialVersionUID = 7186945818329641711L;
    public static final int FORECAST_COMPUTE = 0;
    public static final int SIMULATION_COMPUTE = 1;
    public static final int WAT_COMPUTE = 2;
    public static final int FORECAST_ENSEMBLE_COMPUTE = 3;
    public String modelAltname;
    public RunTimeWindow runTimeWindow;
    public String forecastpath;
    public String altname;
    public RemoteWrapper uiWrapper;
    public long modelAltComputeTime;
    public boolean doCompute;
    public String user;
    public String clientDisplay;
    public int modelPosition;
    public int inputPosition;
    public String programName;
    public int altIndex;
    public ModelReference modelRef;
    public int nameMultiplier = 2;
    public int timeZoneOffset = 0;
    public int computeType = 0;
    public String outputDSSFileName;
    public int ioTimeStep = 1;
    public int ioTimeIncrement = 2;
    public String simRunPath;
    public Object additionalOptions;
    public String variant;

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        out.println("Compute Info:");
        out.println(" Forecast Alternative " + this.altname);
        out.println(" Model Alternative    " + this.modelAltname);
        out.println(" Model Alt Index      " + this.altIndex);
        out.println(" Last Compute Time    " + (this.modelAltComputeTime > 0L ? new Date(this.modelAltComputeTime).toString() : " N/A"));
        out.println(" Forecast Path        " + this.forecastpath);
        out.println(" RunTimeWindow        " + this.runTimeWindow.toString() + " TimeStep:" + this.runTimeWindow.getTimeStepString(1));
        out.println(" Program Name         " + this.programName);
        out.println(" Input Position       " + this.inputPosition);
        out.println(" Model Position       " + this.modelPosition);
        out.println(" Name Multiplier      " + this.nameMultiplier);
        out.println(" User                 " + this.user);
        out.println(" Client Display       " + this.clientDisplay);
        out.println(" Recompute All        " + this.doCompute);
        out.println(" ModelReference       " + this.modelRef);
        out.println(" ComputeType          " + this.getComputeTypeString());
        out.println(" outputDSS File       " + this.outputDSSFileName);
        out.println(" simRunPath           " + this.simRunPath);
        out.println(" variant              " + this.variant);
        out.println(" I/O Time Step        " + this.ioTimeStep + " " + (this.ioTimeIncrement == 3 ? "Days(s)" : (this.ioTimeIncrement == 2 ? "Hour(s)" : (this.ioTimeIncrement == 1 ? "Minute(s)" : (this.ioTimeIncrement == 0 ? "Second(s)" : "Invalid Time Increment")))));
        if (this.additionalOptions != null) {
            out.println(" AdditionalOptions    " + this.additionalOptions);
        }
    }

    private String getComputeTypeString() {
        switch (this.computeType) {
            case 1: {
                return "Simulation";
            }
            case 0: {
                return "Forecast";
            }
            case 2: {
                return "WAT";
            }
            case 3: {
                return "Forecast Ensemble";
            }
        }
        return "unknown";
    }
}

