/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.DataListContainer;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.model.DataList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;

public class DataListFactory {
    static Hashtable _datalistTypes = new Hashtable();

    public static DataList getDataList(String dataListType, RmiDataList rdl, DataListContainer parent) {
        String dataListClassName = (String)_datalistTypes.get(dataListType);
        if (dataListClassName == null) {
            System.out.println("Returning DefaultDataList for " + dataListType);
            dataListClassName = "hec.watershed.model.DefaultDataList";
        }
        DataList dataList = null;
        try {
            Class<?> datalistClass = Class.forName(dataListClassName);
            Constructor<?>[] ctors = datalistClass.getDeclaredConstructors();
            Object[] args = new Object[]{rdl, parent, dataListType};
            for (int i = 0; i < ctors.length; ++i) {
                Class<?>[] c = ctors[i].getParameterTypes();
                if (c.length != 3) continue;
                dataList = (DataList)ctors[i].newInstance(args);
                return dataList;
            }
            System.out.println("ERROR:Failed to find DataList Contructor for " + dataListClassName);
        }
        catch (ClassNotFoundException cfe) {
            System.out.println("ERROR:Failed to find DataList class " + dataListClassName + " " + cfe);
            return null;
        }
        catch (SecurityException se) {
            System.out.println("ERROR:Security Exception on 'getDeclaredConstructors()'. Please update your java.policy file. " + se);
            return null;
        }
        catch (InvocationTargetException ite) {
            Throwable te = ite.getTargetException();
            System.out.println("ERROR:Failed to create DataList " + dataListClassName + " " + te);
            te.printStackTrace();
            return null;
        }
        catch (Exception e) {
            System.out.println("ERROR:Failed to create DataList " + dataListClassName + " " + e + " " + e.getMessage());
            return null;
        }
        return dataList;
    }

    static {
        _datalistTypes.put("hec.fdajni.model.FdaRatingCurve", "hec.fdajni.model.FdaRatingCurveDataList");
        _datalistTypes.put("hec.fdajni.model.FdaWsp", "hec.fdajni.model.FdaWspDataList");
        _datalistTypes.put("hec.fdajni.model.FdaLevee", "hec.fdajni.model.FdaLeveeDataList");
        _datalistTypes.put("hec.fdajni.model.FdaFreqFunction", "hec.fdajni.model.FdaFreqFunctionDataList");
        _datalistTypes.put("hec.fdajni.model.FdaAggDmgFunction", "hec.fdajni.model.FdaAggDmgFunctionDataList");
        _datalistTypes.put("hec.fdajni.FdaPlan", "hec.fdajni.model.FdaPlanDataList");
        _datalistTypes.put("hec.fdajni.FdaStream", "hec.fdajni.model.FdaStreamDataList");
        _datalistTypes.put("hec.fdajni.FdaReach", "hec.fdajni.model.FdaReachDataList");
        _datalistTypes.put("hec.fdajni.FdaDamageCategory", "hec.fdajni.model.FdaDamageCategoryDataList");
        _datalistTypes.put("hec.fdajni.model.FdaDamageFunction", "hec.fdajni.model.FdaDamageFunctionDataList");
        _datalistTypes.put("hec.fdajni.model.FdaStructure", "hec.fdajni.model.FdaStructureDataList");
        _datalistTypes.put("hec.fdajni.FdaModule", "hec.fdajni.model.FdaModuleDataList");
        _datalistTypes.put("hec.sid.model.SidDamageAreaData", "hec.sid.model.SidDamageAreaManager");
        _datalistTypes.put("hec.sid.model.SidLeveeData", "hec.sid.model.SidLeveeManager");
        _datalistTypes.put("hec.sid.model.SidCostFunction", "hec.sid.model.SidCostFunctionDataList");
        _datalistTypes.put("hec.sid.model.SidPlanData", "hec.sid.model.SidPlanManager");
        _datalistTypes.put("hec.fdajni.model.StreamAlignmentDataList", "hec.fdajni.model.StreamAlignmentDataList");
        _datalistTypes.put("hec.rss.model.ReservoirOp", "hec.rss.model.ResOpDataList");
        _datalistTypes.put("hec.rss.model.ReservoirSysOp", "hec.rss.model.ResSysOpDataList");
        _datalistTypes.put("hec.watershed.model.Study", "hec.watershed.model.StudyDataList");
        _datalistTypes.put("hec.watershed.model.Condition", "hec.watershed.model.ConditionDataList");
        _datalistTypes.put("hec.watershed.model.ComputationPoint", "hec.watershed.model.ComputationPointDataList");
        _datalistTypes.put("hec.watershed.model.ImpactArea", "hec.watershed.model.WatershedDataList");
        _datalistTypes.put("hec.watershed.model.Levee", "hec.watershed.model.WatershedDataList");
        _datalistTypes.put("hec.watershed.model.OtherProject", "hec.watershed.model.WatershedDataList");
        _datalistTypes.put("hec.watershed.model.Reservoir", "hec.watershed.model.WatershedDataList");
        _datalistTypes.put("hec.watershed.model.StoragePool", "hec.watershed.model.WatershedDataList");
        _datalistTypes.put("hec.watershed.model.ChannelMod", "hec.watershed.model.WatershedDataList");
        _datalistTypes.put("hec.watershed.model.Diversion", "hec.watershed.model.WatershedDataList");
        _datalistTypes.put("hec.watershed.model.StationSet", "hec.watershed.model.StationSetDataList");
        _datalistTypes.put("hec.watershed.model.ComputationPointLayer", "hec.watershed.model.ComputationPointLayerDataList");
        _datalistTypes.put("hec.fda.model.FdaStudy", "hec.fda.model.FdaStudyDataList");
        _datalistTypes.put("hec.fda.model.Structure", "hec.fda.model.StructureDataList");
        _datalistTypes.put("hec.fda.model.OccupancyType", "hec.fda.model.OccupancyTypeDataList");
        _datalistTypes.put("hec.fda.model.StructureGroup", "hec.fda.model.StructureGroupDataList");
        _datalistTypes.put("hec.fda.model.Inventory", "hec.fda.model.InventoryDataList");
        _datalistTypes.put("hec.fda.model.structDamComp.StructDamage", "hec.fda.model.structDamComp.StructDamageDataList");
        _datalistTypes.put("hec.fda.model.ConstructionType", "hec.watershed.model.UnmodifiableDataList");
        _datalistTypes.put("hec.fda.model.ExteriorWallType", "hec.watershed.model.UnmodifiableDataList");
        _datalistTypes.put("hec.fda.model.FoundationType", "hec.watershed.model.UnmodifiableDataList");
        _datalistTypes.put("hec.fda.model.HeatingCoolingType", "hec.watershed.model.UnmodifiableDataList");
        _datalistTypes.put("hec.fda.model.RoofType", "hec.watershed.model.UnmodifiableDataList");
        _datalistTypes.put("hec.fda.model.StyleType", "hec.watershed.model.UnmodifiableDataList");
        _datalistTypes.put("hec.fda.model.FloorType", "hec.watershed.model.UnmodifiableDataList");
    }
}

