/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.model.DataListFactory;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.rmi.csinterface.RmiDataList;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.model.CommonDataList;
import hec.model.CommonDataListContainer;
import hec.model.DataList;
import hec.model.DataObject;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;

public class DefaultDataListContainer
implements DataListContainer,
Serializable {
    protected RmiDataListContainer _rdlc;
    protected Hashtable _dataLists;
    protected boolean _inited = false;
    protected ManagerProxyListContainer _container = null;
    protected boolean _readOnly = false;

    public DefaultDataListContainer(RmiDataListContainer rdlc) {
        this._rdlc = rdlc;
        this._dataLists = new Hashtable();
        this.init();
    }

    private void init() {
        RmiDataList[] rdlArray = null;
        try {
            rdlArray = this._rdlc.getDataLists();
        }
        catch (RemoteException re) {
            System.out.println("DefaultDataListContainer.init: remote exception getting the DataLists " + re);
            return;
        }
        this.addDataLists(rdlArray, "");
    }

    @Override
    public void setContainer(ManagerProxyListContainer container) {
        this._container = container;
    }

    @Override
    public void addDataLists(RmiDataList[] rdlArray, String model) {
        for (int i = 0; i < rdlArray.length; ++i) {
            if (rdlArray[i] == null) continue;
            try {
                String dataListType = rdlArray[i].getDataListType();
                DataList dl = DataListFactory.getDataList(dataListType, rdlArray[i], this);
                dl.setModelName(model);
                this._dataLists.put(dataListType, dl);
                continue;
            }
            catch (RemoteException re2) {
                System.out.println("DefaultDataListContainer.init: remote exception getting DataListType from RmiDataList " + re2);
            }
        }
    }

    public boolean saveAll(String user) {
        if (this.isReadOnly()) {
            return true;
        }
        Enumeration enumeration = this._dataLists.elements();
        boolean success = true;
        while (enumeration.hasMoreElements()) {
            DataList dl = (DataList)enumeration.nextElement();
            if (dl == null || !dl.isModified() || dl.saveAll(user)) continue;
            success = false;
        }
        return success;
    }

    public DataList getDataList(String objClass) {
        DataList dl = (DataList)this._dataLists.get(objClass);
        if (dl != null) {
            if (!dl.hasBeenInitd()) {
                dl.init();
            }
        } else {
            System.out.println("DefaultDataListContainer: no dataList for " + objClass);
        }
        return dl;
    }

    public DataList getDataList(String objClass, String model) {
        this._container.getChildWorkspace(model);
        DataList dl = (DataList)this._dataLists.get(objClass);
        if (dl == null) {
            System.out.println("DefaultDataListContainer: no datalist for " + objClass);
            System.out.println("getDataList: no. of datalists is " + this._dataLists.size());
            return null;
        }
        if (dl.getModelName().equals(model)) {
            if (!dl.hasBeenInitd()) {
                dl.init();
            }
            return dl;
        }
        System.out.println("DefaultDataListContainer: no datalist for " + objClass + " model " + model);
        return null;
    }

    public DataList getDataListByClass(String dataListClass, String model) {
        Class<?> c;
        ClientApp.app();
        ClientApp.Workspace().getChildWorkspace(model);
        Enumeration e = this._dataLists.elements();
        try {
            c = Class.forName(dataListClass);
        }
        catch (ClassNotFoundException cfe) {
            System.out.println("getDataListByClass: class " + dataListClass + " not found " + cfe);
            return null;
        }
        while (e.hasMoreElements()) {
            DataList dl = (DataList)e.nextElement();
            if (!dl.getClass().equals(c)) continue;
            if (!dl.hasBeenInitd()) {
                dl.init();
            }
            return dl;
        }
        return null;
    }

    public DataObject findObjectById(long id, String objClass) {
        DataList list = (DataList)this._dataLists.get(objClass);
        if (list != null) {
            if (!list.hasBeenInitd()) {
                list.init();
            }
            return list.getObject(id);
        }
        return null;
    }

    public void workspaceClosing() {
        Enumeration enumeration = this._dataLists.elements();
        while (enumeration.hasMoreElements()) {
            DataList dl = (DataList)enumeration.nextElement();
            if (dl == null) continue;
            dl.workspaceClosing();
        }
    }

    public CommonDataList getCommonDataList(String className) {
        return this.getDataList(className);
    }

    public CommonDataList getCommonDataList(String className, String modelName) {
        return this.getDataList(className, modelName);
    }

    public CommonDataListContainer getProxyListContainer() {
        return (CommonDataListContainer)ClientApp.Workspace();
    }

    public boolean checkUser(String user) {
        try {
            return this._rdlc.checkUser(user);
        }
        catch (RemoteException re) {
            System.out.println("DefaultDataListContainer.checkUser: error checking user " + user + " " + re);
            return true;
        }
    }

    public int getUnitSystem() {
        return ClientApp.Workspace().getUnitSystem();
    }

    public int getGmtOffset() {
        return ClientApp.Workspace().getGmtOffset();
    }

    public StreamAlignmentIfc getStreamAlignment() {
        return (StreamAlignmentIfc)ClientApp.Workspace().openManager("main", "stream.align");
    }

    public void setReadOnly(boolean readOnly) {
        this._readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }
}

