/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import com.google.common.flogger.LazyArgs;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordProxy;
import hec.clientapp.rmi.csinterface.HecRmiWorkspace;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.event.ModifiableListener;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.HtmlAttributes;
import hec.lang.LockableObject;
import hec.lang.NamedType;
import hec.lang.UserId;
import hec.lang.annotation.Scriptable;
import hec.model.CommonDataList;
import hec.model.ITSDataSet;
import hec.model.MessagePrinter;
import hec.model.TSLocation;
import hec.model.TSLocation2;
import hec.model.TsRecordContainer;
import hec.model.UserInterface;
import java.io.BufferedWriter;
import java.io.File;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.CallBackInterface;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileCallBackImpl;
import rma.lang.Modifiable;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.FileLockingLoggingMarker;
import rma.util.logging.marking.ManagerFinalizingLoggingMarker;
import rma.util.logging.marking.ManagerLoadingLoggingMarker;

public abstract class Manager
extends NamedType
implements CallBackInterface,
LockableObject,
TsRecordContainer,
MessagePrinter {
    private static final MarkingClassLogger MANAGER_LOADING_LOGGER = MarkingClassLogger.forMarkingClass(ManagerLoadingLoggingMarker.class);
    private static final MarkingClassLogger MANAGER_FINALIZING_LOGGER = MarkingClassLogger.forMarkingClass(ManagerFinalizingLoggingMarker.class);
    private static final MarkingClassLogger FILE_LOCKING_LOGGER = MarkingClassLogger.forMarkingClass(FileLockingLoggingMarker.class);
    String _path = "";
    public static final String LASTMODIFIED_STRING = "ModifiedTime";
    int _nextTSRecordProxyIndex = 0;
    protected long _lastModifiedTime = Long.MAX_VALUE;
    protected transient RemoteWrapper _dssFileManagerWrapper = null;
    protected transient UserInterface _userInterface = null;
    protected transient Identifier _identifier = null;
    protected transient RemoteWrapper _Workspace = null;
    protected transient RmiFileCallBackImpl _callBack = null;
    protected transient ManagerProxyList _proxyList = null;
    protected transient RemoteWrapper _uiWrapper = null;
    protected transient boolean _reloadOk = true;
    protected transient boolean _readOnly = false;
    private transient RmiFileManager _fileMgr = null;
    protected transient Vector _modifiableListeners;
    protected transient boolean _reloadFailed;
    protected transient String _wkspPath;

    public Manager() {
        this.init();
    }

    public Manager(String name) {
        super(name);
        this.init();
    }

    public CommonDataList getCommonDataList(String theDataObjectClass, String theModel) {
        CommonDataList dl = null;
        if (this._proxyList == null || this._proxyList.getContainer() == null) {
            System.out.println("Error retrieving DataList in Manager.getDataList");
            System.out.println("ManagerProxyContainer is not available");
            System.out.println("Manager: " + this.getName());
            System.out.println("DataObjectClass: " + theDataObjectClass);
            return null;
        }
        dl = this._proxyList.getContainer().getCommonDataList(theDataObjectClass, theModel);
        return dl;
    }

    public int getUnitSystem() {
        return this._proxyList.getUnitSystem();
    }

    public int getGmtOffset() {
        return this._proxyList.getGmtOffset();
    }

    public boolean isForecastManager() {
        Identifier id = this.getIdentifier();
        String filename = RMAIO.getFileFromPath((String)id.getPath());
        if (filename == null || filename.length() == 0) {
            return false;
        }
        return filename.charAt(0) == '_';
    }

    public void loadComplete() {
    }

    public void setIdentifier(Identifier id) {
        this.setName(id.getName());
        this._identifier = id;
        try {
            this._callBack = new RmiFileCallBackImpl((CallBackInterface)this);
        }
        catch (RemoteException e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
        RemoteWrapper wrap = this._callBack.getRemoteReference();
        HecFile file = this._identifier.getFile();
        if (file instanceof HecFileImpl) {
            ((HecFileImpl)file).setCallBack(wrap);
        }
    }

    public RemoteWrapper getCallback() {
        return new RemoteWrapper((Remote)this._callBack);
    }

    public void removeCallBack() {
        if (this._callBack != null && this._identifier != null) {
            HecFile file = this._identifier.getFile();
            if (file instanceof HecFileImpl) {
                RemoteWrapper wrap = new RemoteWrapper((Remote)this._callBack);
                System.out.println("****removeCallBack: removing for " + file.getPath());
                ((HecFileImpl)file).removeCallBack(wrap);
            }
            this._callBack = null;
        }
        try {
            RmiFileManager fm = this.getFileManager();
            if (fm != null) {
                fm.removeReference(this._identifier, UserId.getUserId());
            }
        }
        catch (RemoteException re) {
            System.out.println("unloading: RMI Error removing reference " + re);
        }
    }

    public Identifier getIdentifier() {
        return this._identifier;
    }

    public void setWorkspace(RemoteWrapper Workspace2) {
        this._Workspace = Workspace2;
        if (this._Workspace != null) {
            this._fileMgr = null;
            this.getFileManager();
        }
    }

    public RemoteWrapper getWorkspace() {
        return this._Workspace;
    }

    public String getWorkspacePath() {
        if (this._wkspPath == null) {
            try {
                RemoteWrapper wkspWrapper = this.getWorkspace();
                if (wkspWrapper == null) {
                    return null;
                }
                this._wkspPath = ((RmiWorkspace)wkspWrapper.getRemote()).getWorkspacePath();
            }
            catch (RemoteException re) {
                System.out.println("getWorkspacePath: RMI Error getting workspace path " + re);
            }
        }
        return this._wkspPath;
    }

    public void setProxyList(ManagerProxyList pl) {
        this._proxyList = pl;
    }

    public ManagerProxyList getProxyList() {
        return this._proxyList;
    }

    public DSSManager getDSSFileManager() {
        if (this._Workspace == null) {
            return null;
        }
        RmiWorkspace data = (RmiWorkspace)this._Workspace.getRemote();
        try {
            if (this._dssFileManagerWrapper == null) {
                this._dssFileManagerWrapper = data.getDSSFileManager();
            } else {
                try {
                    ((DSSManager)this._dssFileManagerWrapper.getRemote()).isAlive();
                }
                catch (Exception e) {
                    this._dssFileManagerWrapper = data.getDSSFileManager();
                }
            }
            return (DSSManager)this._dssFileManagerWrapper.getRemote();
        }
        catch (RemoteException re) {
            System.out.println("Error getting DSS File Manager from Work Space  " + re);
            return null;
        }
    }

    public RemoteWrapper getDSSFileManagerWrapper() {
        RmiWorkspace data = (RmiWorkspace)this._Workspace.getRemote();
        try {
            if (this._dssFileManagerWrapper == null || this._dssFileManagerWrapper.getRemote() == null) {
                this._dssFileManagerWrapper = data.getDSSFileManager();
                return this._dssFileManagerWrapper;
            }
            try {
                if (((DSSManager)this._dssFileManagerWrapper.getRemote()).isAlive()) {
                    return this._dssFileManagerWrapper;
                }
            }
            catch (RemoteException re) {
                this._dssFileManagerWrapper = data.getDSSFileManager();
                return this._dssFileManagerWrapper;
            }
        }
        catch (RemoteException re) {
            System.out.println("Error getting DSS File Manager from Work Space  " + re);
            this._dssFileManagerWrapper = null;
            return null;
        }
        return null;
    }

    public abstract void init();

    public boolean readFile(Identifier id) {
        return false;
    }

    public boolean modifiyForSaveAs() {
        return false;
    }

    public boolean loadSaveAsFile(Identifier id) {
        boolean rtn = this.reLoadFile(id);
        if (rtn && this.modifiyForSaveAs()) {
            rtn = this.writeFile(id);
        }
        return rtn;
    }

    public boolean reLoadFile(Identifier id) {
        ((MarkingClassLogger.Api)MANAGER_LOADING_LOGGER.atFine()).log("%s reloadOK=%s", (Object)LazyArgs.lazy(() -> id.getPath()), (Object)LazyArgs.lazy(() -> this.getReloadOk()));
        if (this.getReloadOk()) {
            return this.readFile(id);
        }
        return false;
    }

    public boolean reLoadFile() {
        return this.reLoadFile(this._identifier);
    }

    public boolean reLoadChildManagers() {
        return this.reLoadFile();
    }

    public boolean saveChildManagers() {
        return this._proxyList.saveManager(UserId.getUserId(), this);
    }

    protected void writeLastModTime(BufferedWriter out) {
        if (out == null) {
            return;
        }
        RMAIO.fout((BufferedWriter)out, (String)("ModifiedTime=" + this.getLastModifiedTime()));
    }

    public boolean writeFile(Identifier id) {
        return this.setManagersModifiedTime(id);
    }

    protected boolean setManagersModifiedTime(Identifier id) {
        if (this.isModified() && this._Workspace != null && this._Workspace.getRemote() != null) {
            try {
                ((RmiWorkspace)this._Workspace.getRemote()).setManagersModifiedTime(UserId.getUserId(), this._identifier, this._lastModifiedTime);
            }
            catch (RemoteException re) {
                System.out.println("Error setting managers modified time for " + id.getPath() + " " + re);
            }
        }
        return false;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getPath() {
        return this._path;
    }

    public String getDirectory() {
        if (this._path == null) {
            return null;
        }
        File file = new File(this._path);
        return file.getParent();
    }

    public String getFilename() {
        if (this._path == null) {
            return null;
        }
        File file = new File(this._path);
        return file.getName();
    }

    @Deprecated
    public String makeRelativePath(String s) {
        return this.getRelativePath(s);
    }

    public String getRelativePath(String abspath) {
        if (abspath == null || abspath.length() == 0) {
            return "";
        }
        try {
            return ((RmiWorkspace)this._Workspace.getRemote()).getRelativePath(abspath);
        }
        catch (Exception e) {
            System.out.println("Non-fatal exception converting " + abspath + " to relative path");
            return abspath;
        }
    }

    public String makeAbsolutePath(String relpath) {
        return this.makeAbsolutePath(relpath, false);
    }

    public String makeAbsolutePath(String relpath, boolean relToParent) {
        if (relpath == null || relpath.length() == 0) {
            return "";
        }
        try {
            if (relToParent) {
                RmiWorkspace parent = ((RmiWorkspace)this._Workspace.getRemote()).getChildWorkspace("");
                return parent.makeAbsolutePath(relpath);
            }
            return ((RmiWorkspace)this._Workspace.getRemote()).makeAbsolutePath(relpath);
        }
        catch (Exception e) {
            System.out.println("Non-fatal expection converting " + relpath + " to absolute path");
            return relpath;
        }
    }

    @Scriptable
    public String makeAbsolutePathFromWatershed(String relpath) {
        if (relpath == null || relpath.length() == 0) {
            return "";
        }
        try {
            RmiWorkspace parent = ((RmiWorkspace)this._Workspace.getRemote()).getChildWorkspace("");
            RmiWorkspace baseParent = null;
            if (parent instanceof HecRmiWorkspace) {
                HecRmiWorkspace hecwksp = (HecRmiWorkspace)((Object)parent);
                baseParent = hecwksp.getBaseWorkspace();
            } else {
                baseParent = parent;
            }
            if (baseParent != null) {
                return baseParent.makeAbsolutePath(relpath);
            }
        }
        catch (Exception e) {
            System.out.println("makeAbsolutePathFromWatershed: Non-fatal expection converting " + relpath + " to absolute path");
        }
        return relpath;
    }

    @Scriptable
    public String makeRelativePathFromWatershed(String abspath) {
        if (abspath == null || abspath.length() == 0) {
            return "";
        }
        try {
            RmiWorkspace parent = ((RmiWorkspace)this._Workspace.getRemote()).getChildWorkspace("");
            RmiWorkspace baseParent = null;
            if (parent instanceof HecRmiWorkspace) {
                HecRmiWorkspace hecwksp = (HecRmiWorkspace)((Object)parent);
                baseParent = hecwksp.getBaseWorkspace();
            } else {
                baseParent = parent;
            }
            if (baseParent != null) {
                return baseParent.getRelativePath(abspath);
            }
        }
        catch (Exception e) {
            System.out.println("makeRelativePathFromWatershed: Non-fatal expection converting " + abspath + " to relative path");
        }
        return abspath;
    }

    public UserInterface setUserInterface(UserInterface ui) {
        UserInterface oldUI = this._userInterface;
        this._userInterface = ui;
        this._uiWrapper = null;
        return oldUI;
    }

    public UserInterface getUserInterface() {
        return this._userInterface;
    }

    public RemoteWrapper setUserInterface(RemoteWrapper uiWrap) {
        RemoteWrapper oldUIwrap = this._uiWrapper;
        this._uiWrapper = uiWrap;
        this._userInterface = null;
        return oldUIwrap;
    }

    @Scriptable
    public void printLogMessage(String msg) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println(msg + "\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).printLogMessage(msg);
                }
                catch (RemoteException re) {
                    System.out.println(msg + "\n");
                }
            }
        } else {
            this._userInterface.printMessage(msg + "\n");
        }
    }

    @Scriptable
    public void printErrorMessage(String msg) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println("ERROR " + msg + "\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).printErrorMessage(msg);
                }
                catch (RemoteException re) {
                    System.out.println("ERROR " + msg + "\n");
                }
            }
        } else {
            this._userInterface.printMessage("ERROR " + msg + "\n");
        }
    }

    @Scriptable
    public void printWarningMessage(String msg) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println("WARNING " + msg + "\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).printWarningMessage(msg);
                }
                catch (RemoteException re) {
                    System.out.println("WARNING " + msg + "\n");
                }
            }
        } else {
            this._userInterface.printMessage("WARNING " + msg + "\n");
        }
    }

    @Scriptable
    public void printMessage(String msg) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println(msg + "\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).printMessage(msg);
                }
                catch (RemoteException re) {
                    System.out.println(msg + "\n");
                }
            }
        } else {
            this._userInterface.printMessage(msg + "\n");
        }
    }

    @Scriptable
    public void printStatus(String msg) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println(msg + "\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).printStatus(msg);
                }
                catch (RemoteException re) {
                    System.out.println(msg + "\n");
                }
            }
        } else {
            this._userInterface.printStatus(msg);
        }
    }

    public void setLineAttributes(HtmlAttributes a) {
        if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
            return;
        }
        try {
            ((RmiProgress)this._uiWrapper.getRemote()).setLineAttributes(a);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Scriptable
    public void printTableRow(boolean isHeader, String tableRow) {
        if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
            System.out.println(tableRow);
        } else {
            try {
                ((RmiProgress)this._uiWrapper.getRemote()).printTableRow(isHeader, tableRow);
            }
            catch (RemoteException re) {
                System.out.println(tableRow);
            }
        }
    }

    @Scriptable
    public void printSeparator() {
        if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
            System.out.println("----------------------------------------------------");
        } else {
            try {
                ((RmiProgress)this._uiWrapper.getRemote()).printSeparator();
            }
            catch (RemoteException re) {
                System.out.println("----------------------------------------------------");
            }
        }
    }

    protected void computeComplete(Object obj) {
        if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
            System.out.println(obj + "\n");
        } else {
            try {
                ((RmiProgress)this._uiWrapper.getRemote()).runComplete(obj);
            }
            catch (RemoteException re) {
                System.out.println(obj + "\n");
            }
        }
    }

    public void setProgress(int i) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println("\nProgress " + i + "%\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).setProgress(i);
                }
                catch (RemoteException re) {
                    System.out.println("\nProgress " + i + "%\n");
                }
            }
        } else {
            this._userInterface.setProgress(i);
        }
    }

    public boolean isCanceled() {
        if (this._userInterface == null) {
            return false;
        }
        return this._userInterface.isCanceled();
    }

    public ITSDataSet getInputITSDataSet() {
        return this.getInputTSDataSet();
    }

    public ITSDataSet getOutputITSDataSet() {
        return this.getOutputTSDataSet();
    }

    public TSDataSet getInputTSDataSet() {
        TSDataSet tsdata = null;
        return tsdata;
    }

    public TSDataSet getOutputTSDataSet() {
        TSDataSet tsdata = null;
        return tsdata;
    }

    public void notify(String message) {
        if (message == null) {
            return;
        }
        System.out.println("Call back message: " + message);
        if (!(message.startsWith("Modified") || this._reloadFailed && message.indexOf("|Unlocked|") > 0)) {
            return;
        }
        try {
            this.reLoadFile(this._identifier);
            this._reloadFailed = false;
        }
        catch (Exception e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)MANAGER_LOADING_LOGGER.atWarning()).withCause((Throwable)e)).log("Error on reLoadFile");
            this._reloadFailed = true;
        }
    }

    public TSRecordProxy newTSRecordProxy(TSLocation2 location) {
        TSRecordProxy tsrp = new TSRecordProxy(location);
        tsrp.setIndex(this.nextTSRecordProxyIndex());
        return tsrp;
    }

    public TSRecordProxy newTSRecordProxy(TSLocation loc) {
        TSRecordProxy tsrp = new TSRecordProxy(loc);
        tsrp.setIndex(this.nextTSRecordProxyIndex());
        return tsrp;
    }

    public boolean deleteFile(Identifier deleteFileId) {
        if (deleteFileId == null) {
            return false;
        }
        String user = UserId.getUserId();
        boolean success = false;
        try {
            success = ((RmiWorkspace)this._Workspace.getRemote()).deleteFile(user, deleteFileId);
        }
        catch (Exception e) {
            System.out.println("Exceptin in deleting file " + deleteFileId.getPath());
            return false;
        }
        return success;
    }

    public Identifier openFile(Identifier openFileId) {
        if (this._Workspace == null || openFileId == null) {
            return null;
        }
        String user = UserId.getUserId();
        Identifier id = null;
        try {
            id = ((RmiWorkspace)this._Workspace.getRemote()).openFile(user, openFileId);
        }
        catch (Exception e) {
            System.out.println("Exception opening file " + openFileId.getPath());
            System.out.println(e);
        }
        return id;
    }

    public Identifier newFile(Identifier newFileId) {
        if (this._Workspace == null || newFileId == null) {
            return null;
        }
        String user = UserId.getUserId();
        Identifier id = null;
        try {
            id = ((RmiWorkspace)this._Workspace.getRemote()).newFile(user, newFileId);
        }
        catch (Exception e) {
            System.out.println("Exception creating file " + newFileId.getPath());
            System.out.println(e);
        }
        return id;
    }

    public boolean copyFile(Identifier oldPathId, Identifier newPathId) throws RemoteException {
        if (this._Workspace == null || oldPathId == null || newPathId == null) {
            return false;
        }
        String user = UserId.getUserId();
        boolean rtn = false;
        try {
            rtn = ((RmiWorkspace)this._Workspace.getRemote()).copyFile(user, oldPathId, newPathId);
        }
        catch (Exception e) {
            System.out.println("Exception copying file " + oldPathId.getPath());
            System.out.println(e);
        }
        return rtn;
    }

    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get((Object)this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set((Object)this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    private int nextTSRecordProxyIndex() {
        int i = this._nextTSRecordProxyIndex++;
        return i;
    }

    public void setReloadOk(boolean reloadOk) {
        this._reloadOk = reloadOk;
    }

    public boolean getReloadOk() {
        return this._reloadOk;
    }

    public void finalize() throws Throwable {
        ((MarkingClassLogger.Api)MANAGER_FINALIZING_LOGGER.atFine()).log("**** finalizing Manager %s %s", (Object)LazyArgs.lazy(() -> ((Object)((Object)this)).getClass().getName()), (Object)LazyArgs.lazy(() -> this.getName()));
        super.finalize();
        this.unloading();
    }

    public void unloading() {
        this.removeCallBack();
        if (this._modifiableListeners != null) {
            this._modifiableListeners.clear();
        }
        this.setLocked(2);
        this._fileMgr = null;
    }

    public void renamed(Identifier id) {
        if (id == null) {
            return;
        }
        this.setIgnoreModifiedEvents(true);
        this.setIdentifier(id);
        this.setName(this.getName());
        this.setDescription(this.getDescription());
        this.setIgnoreModifiedEvents(false);
    }

    public void deleting() {
    }

    public void setModifiedFalse() {
        this._modified = false;
    }

    public void setModified(boolean flag) {
        super.setModified(flag);
        if (this.getIgnoreModifiedEvents()) {
            return;
        }
        if (flag) {
            this.setLastModifiedTime();
        }
        this.notifyModifiableListeners(flag);
    }

    public long getLastModifiedTime() {
        return this._lastModifiedTime;
    }

    public String getLastModifiedTimeString() {
        long lastModifiedTime = this.getLastModifiedTime();
        if (lastModifiedTime <= 0L || lastModifiedTime == Long.MAX_VALUE) {
            return "";
        }
        return new Date(lastModifiedTime).toString().substring(4);
    }

    public void setLastModifiedTime(long modTime) {
        if (modTime > 0L) {
            this._lastModifiedTime = modTime;
        }
    }

    public void setLastModifiedTime() {
        if (this._Workspace != null && this._Workspace.getRemote() != null) {
            try {
                this._lastModifiedTime = ((RmiWorkspace)this._Workspace.getRemote()).getCurrentTime();
            }
            catch (RemoteException re) {
                this._lastModifiedTime = System.currentTimeMillis();
            }
        } else {
            this._lastModifiedTime = System.currentTimeMillis();
        }
    }

    protected long getModTime(int index, String cl, long lastModifiedTime) {
        ManagerProxy proxy;
        if (index < 0) {
            return lastModifiedTime;
        }
        try {
            proxy = this._proxyList.getManagerProxy(cl, index);
        }
        catch (Exception re) {
            System.out.println("Error on getManagerProxy(" + cl + " " + index + ") " + re);
            return lastModifiedTime;
        }
        if (proxy != null) {
            long mgrTime = proxy.getLastModifiedTime();
            lastModifiedTime = mgrTime > lastModifiedTime && mgrTime != Long.MAX_VALUE ? mgrTime : lastModifiedTime;
        }
        return lastModifiedTime;
    }

    protected long getModTime(String idPath, String cl, long lastModifiedTime) {
        ManagerProxy proxy;
        if (idPath == null || idPath.trim().equals("")) {
            return lastModifiedTime;
        }
        Identifier id = new Identifier(idPath);
        try {
            proxy = this._proxyList.getManagerProxy(cl, id);
        }
        catch (RemoteException re) {
            System.out.println("error on getManagerProxy(" + cl + " " + id.getPath() + ") " + re);
            return lastModifiedTime;
        }
        if (proxy != null) {
            long mgrTime = proxy.getLastModifiedTime();
            lastModifiedTime = mgrTime > lastModifiedTime && mgrTime != Long.MAX_VALUE ? mgrTime : lastModifiedTime;
        }
        return lastModifiedTime;
    }

    public void setReadOnly(boolean b) {
        this._readOnly = b;
    }

    public boolean getReadOnly() {
        return this._readOnly;
    }

    public boolean backupFile(String backupDir) {
        RmiFileManager fileMgr = this.getFileManager();
        if (fileMgr == null) {
            return false;
        }
        String fileName = null;
        try {
            fileName = RMAIO.getFileFromPath((String)this.getIdentifier().getPath());
            Identifier destId = new Identifier(backupDir + "/" + fileName);
            if (!fileMgr.copyFile(this.getIdentifier(), destId)) {
                System.out.println("Failed to copy configuration to directory " + backupDir);
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("Error copying configuration to directory " + backupDir + " Error " + e);
            return false;
        }
        return true;
    }

    public boolean saveManager() {
        if (this._proxyList == null) {
            return false;
        }
        return this._proxyList.saveManager(UserId.getUserId(), this);
    }

    public Manager saveManagerAs(String directory, String filePrefix) {
        return this.saveManagerAs(directory, filePrefix, this._proxyList.getContainer());
    }

    public Manager saveManagerAs(String directory, String filePrefix, ManagerProxyListContainer container) {
        String model;
        ManagerProxyList proxyList;
        Manager copy;
        Identifier destId;
        if (container == null) {
            container = this._proxyList.getContainer();
        }
        if ((destId = this.getSaveAsId(directory, filePrefix, (copy = (proxyList = container.getManagerProxyList(model = this._proxyList.getModel())).newManager(((Object)((Object)this)).getClass().getName())).getIndex())) == null) {
            return null;
        }
        copy.getIdentifier().copy(destId);
        proxyList.saveManager(UserId.getUserId(), copy);
        if (filePrefix != null) {
            copy.getIdentifier().setName(filePrefix + ":" + this.getName());
        } else {
            copy.getIdentifier().setName(this.getName());
        }
        int idx = copy.getIndex();
        copy.readFile(this.getIdentifier());
        if (filePrefix != null) {
            copy.setName(filePrefix + ":" + this.getName());
        } else {
            copy.setName(this.getName());
        }
        copy.setDescription(this.getDescription());
        copy.setIndex(idx);
        copy.setModified(true);
        proxyList.saveManager(UserId.getUserId(), copy);
        proxyList.unloadManager(copy.getIdentifier());
        if (copy.isModified()) {
            copy.writeFile(copy.getIdentifier());
        }
        return copy;
    }

    public boolean refreshData(Manager origMgr) {
        if (origMgr == null) {
            return false;
        }
        if (!((Object)((Object)origMgr)).getClass().getName().equals(((Object)((Object)this)).getClass().getName())) {
            System.out.println("refreshData: can't refresh from type " + ((Object)((Object)origMgr)).getClass().getName() + " when I'm a " + ((Object)((Object)this)).getClass().getName());
            return false;
        }
        int index = this.getIndex();
        String name = this.getName();
        String description = this.getDescription();
        if (this.readFile(origMgr.getIdentifier())) {
            this.setIndex(index);
            this.setName(name);
            this.setDescription(description);
            return this.writeFile(this.getIdentifier());
        }
        return false;
    }

    protected Identifier getSaveAsId(String directory, String filePrefix, int index) {
        return this.getSaveAsId(directory, filePrefix, index, this.getIdentifier());
    }

    protected Identifier getSaveAsId(String directory, String filePrefix, int index, Identifier srcId) {
        String fileName = RMAIO.getFileFromPath((String)srcId.getPath());
        String ext = RMAIO.getFileExtension((String)fileName);
        fileName = filePrefix != null ? RMAIO.userNameToFileName((String)(filePrefix + "_" + fileName)) : RMAIO.userNameToFileName((String)fileName);
        if (directory != null) {
            if (!RMAIO.isFullPath((String)directory)) {
                RmiWorkspace wksp = (RmiWorkspace)this._Workspace.getRemote();
                try {
                    directory = wksp.makeAbsolutePath(directory);
                }
                catch (RemoteException re) {
                    System.out.println("getSaveAsId: RMI error making absolute path " + re);
                }
            }
        } else {
            directory = RMAIO.getDirectoryFromPath((String)srcId.getPath());
        }
        String newPath = directory + "/" + fileName;
        Identifier destId = new Identifier(newPath);
        destId.setName(this.getName());
        destId.setDescription(this.getDescription());
        return destId;
    }

    public boolean setLocked(int lockType) {
        RmiFileManager fileMgr = this.getFileManager();
        if (fileMgr == null) {
            return false;
        }
        Identifier id = this.getIdentifier();
        if (id == null) {
            return false;
        }
        String user = UserId.getUserId();
        FileLock fLock = new FileLock(user, lockType);
        switch (lockType) {
            case 1: 
            case 2: 
            case 5: {
                try {
                    ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("%s unlocking %s", (Object)LazyArgs.lazy(() -> this.getName()), (Object)fLock);
                    fileMgr.unlockFile(id, fLock);
                    return true;
                }
                catch (RemoteException re) {
                    System.out.println(this.getName() + ".setLocked: RMI error unlocking my file " + re);
                    break;
                }
            }
            default: {
                try {
                    ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("%s locking %s", (Object)LazyArgs.lazy(() -> this.getName()), (Object)fLock);
                    boolean locked = fileMgr.lockFile(id, fLock);
                    ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("%s locked=%s", (Object)LazyArgs.lazy(() -> this.getName()), locked);
                    return locked;
                }
                catch (RemoteException re) {
                    System.out.println(this.getName() + ".setLocked: RMI Error locking my file " + re);
                }
            }
        }
        return false;
    }

    public int hasLock() {
        int lockType = 0;
        RmiFileManager fileMgr = this.getFileManager();
        if (fileMgr == null) {
            return lockType;
        }
        try {
            lockType = fileMgr.getLocked(UserId.getUserId(), this.getIdentifier());
        }
        catch (RemoteException re) {
            System.out.println(this.getIdentifier() + ".hasLock: RMI Error checking lock " + re);
        }
        return lockType;
    }

    public RmiFileManager getFileManager() {
        if (this._fileMgr != null) {
            try {
                this._fileMgr.isAlive();
                return this._fileMgr;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (this._Workspace == null || this._Workspace.getRemote() == null) {
            System.out.println("getFileManager: No Workspace!");
            return null;
        }
        if (this._fileMgr == null) {
            try {
                this._fileMgr = ((RmiWorkspace)this._Workspace.getRemote()).getFileManager();
            }
            catch (RemoteException re) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)MANAGER_FINALIZING_LOGGER.atWarning()).withCause((Throwable)re)).log("Error getting RmiFileManager from workspace");
                return null;
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)MANAGER_FINALIZING_LOGGER.atWarning()).withCause((Throwable)e)).log("Error getting RmiFileManager ");
                return null;
            }
        }
        return this._fileMgr;
    }

    public void addModifiableListener(ModifiableListener listener) {
        if (listener == null) {
            return;
        }
        if (this._modifiableListeners == null) {
            this._modifiableListeners = new Vector(2);
        }
        if (!this._modifiableListeners.contains(listener)) {
            this._modifiableListeners.add(listener);
        }
    }

    public void removeModifiableListener(ModifiableListener listener) {
        if (listener == null) {
            return;
        }
        if (this._modifiableListeners == null) {
            return;
        }
        this._modifiableListeners.remove(listener);
    }

    protected void notifyModifiableListeners(boolean flag) {
        if (this._modifiableListeners == null) {
            return;
        }
        for (int i = this._modifiableListeners.size() - 1; i >= 0; --i) {
            ((ModifiableListener)this._modifiableListeners.get(i)).modifiedStateChanged((Modifiable)this, flag);
        }
    }

    public String toString() {
        return this.getName();
    }
}

