/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.Identifier;
import hec.model.ClassNameMapper;
import hec.model.UserInterface;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.ManagerLoadingLoggingMarker;

public class ManagerProxy
implements Serializable {
    private static final MarkingClassLogger MANAGER_LOADING_LOGGER = MarkingClassLogger.forMarkingClass(ManagerLoadingLoggingMarker.class);
    private static final long serialVersionUID = -704822806920261705L;
    protected String _className = null;
    protected transient WeakReference _managerRef = null;
    protected Identifier _id = new Identifier();
    protected RemoteWrapper _Workspace = null;
    protected transient ManagerProxyList _proxyList = null;
    protected transient int observerCount = 0;
    protected long _lastModifiedTime = Long.MAX_VALUE;
    protected int _index = -1;
    private UserInterface _userInterface;

    public ManagerProxy() {
    }

    public ManagerProxy(Identifier id) {
        this();
        if (id != null) {
            this._id = id;
        }
        this.observerCount = 0;
    }

    public ManagerProxy(String className, Identifier id) {
        this(id);
        this.setClassName(className);
    }

    public ManagerProxy(ManagerProxy proxy) {
        this(proxy._className, proxy._id);
        this._index = proxy._index;
        this._Workspace = proxy._Workspace;
    }

    public void setIndex(int idx) {
        this._index = idx;
    }

    public int getIndex() {
        return this._index;
    }

    public void setClassName(String className) {
        this._className = ClassNameMapper.getNewClassMapping((String)className);
    }

    public String getClassName() {
        return this._className;
    }

    public void setWorkspace(RemoteWrapper wkspWrap) {
        this._Workspace = wkspWrap;
    }

    public RemoteWrapper getWorkspace() {
        return this._Workspace;
    }

    public void setProxyList(ManagerProxyList pl) {
        this._proxyList = pl;
    }

    public ManagerProxyList getProxyList() {
        return this._proxyList;
    }

    public Identifier getId() {
        return this._id;
    }

    public void setId(Identifier id) {
        this._id = id;
    }

    public Object getRun() {
        if (this._managerRef == null && this._id.getClassName() != null) {
            try {
                String obj = this._id.getClassName();
                if (obj instanceof Manager) {
                    this._managerRef = this.createReference((Manager)((Object)obj));
                }
            }
            catch (Exception e) {
                System.out.println("Error Instantiating Run " + e);
                e.printStackTrace();
            }
        }
        return this._managerRef.get();
    }

    public String getName() {
        return this._id.getName();
    }

    public String getDescription() {
        return this._id.getDescription();
    }

    public String getPath() {
        return this._id.getPath();
    }

    public Manager getManager() {
        if (this._managerRef == null) {
            return null;
        }
        return (Manager)((Object)this._managerRef.get());
    }

    public synchronized Manager loadManager(String classname, Identifier id) {
        if (classname == null) {
            classname = this._className;
        } else {
            this._className = classname;
        }
        if (id == null) {
            id = this._id;
        } else {
            this._id = id;
        }
        Manager manager = this.getManager();
        if (manager == null) {
            try {
                Class<?> managerclass = Class.forName(classname);
                Object obj = managerclass.newInstance();
                if (obj instanceof Manager) {
                    manager = (Manager)((Object)obj);
                    this._managerRef = this.createReference(manager);
                    manager.setIgnoreModifiedEvents(true);
                    manager.setIdentifier(id);
                    manager.setWorkspace(this._Workspace);
                    manager.setProxyList(this._proxyList);
                    manager.setLastModifiedTime(this._lastModifiedTime);
                    manager.setUserInterface(this._userInterface);
                    if (id.getFile() != null) {
                        if (!manager.readFile(id)) {
                            manager.setReadOnly(true);
                        }
                    } else {
                        System.out.println("loadManager:" + this.getName() + ": no file to read");
                    }
                    manager.setIndex(this._index);
                    manager.setIgnoreModifiedEvents(false);
                    manager.loadComplete();
                } else {
                    System.out.println("ManagerProxy Error - requested class " + classname + "not a Manager\n");
                }
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)MANAGER_LOADING_LOGGER.atWarning()).withCause((Throwable)e)).log("ManagerProxy Error - can't load class %s", (Object)classname);
                if (manager != null) {
                    manager.removeCallBack();
                }
                manager = null;
                return manager;
            }
        }
        ++this.observerCount;
        if (manager.getProxyList() == null) {
            manager.setProxyList(this._proxyList);
        }
        return manager;
    }

    public void deleteManager() {
        Manager manager = this.getManager();
        if (manager == null) {
            manager = this.loadManager(null, null);
        }
        if (manager != null) {
            manager.deleting();
        }
        this.unloadManager(true);
        manager = null;
    }

    public void renameManager(Identifier id) {
        this._id = id;
        Manager manager = this.getManager();
        if (manager != null) {
            manager.renamed(id);
        }
        manager = null;
    }

    public boolean dropManager() {
        this._managerRef = null;
        this.observerCount = 0;
        return true;
    }

    public void setManager(Manager m) {
        this.observerCount = m != null ? 1 : 0;
        this._managerRef = this.createReference(m);
        Manager manager = (Manager)((Object)this._managerRef.get());
        manager.setIgnoreModifiedEvents(true);
        manager.setIdentifier(this._id);
        manager.setWorkspace(this._Workspace);
        manager.setProxyList(this._proxyList);
        manager.setLastModifiedTime(this._lastModifiedTime);
        manager.setName(this.getName());
        manager.setDescription(this.getDescription());
        manager.setIndex(this._index);
        manager.setIgnoreModifiedEvents(false);
        manager = null;
    }

    public void unloadManager() {
        this.unloadManager(false);
    }

    public void closeWorkspace() {
        Manager manager = this.getManager();
        if (manager == null) {
            return;
        }
        manager.unloading();
        this._managerRef = null;
    }

    void unloadManager(boolean force) {
        Manager manager;
        --this.observerCount;
        if (this._className.equals("hec.rss.model.RssSystem")) {
            System.out.println("unloading ref cnt=" + this.observerCount);
        }
        if ((manager = this.getManager()) == null) {
            return;
        }
        manager = null;
    }

    public boolean saveManager() {
        Manager manager = this.getManager();
        if (manager == null) {
            System.out.println("ManagerProxy.saveManager: no Manager created for " + this.getName());
            return false;
        }
        if (this._id == null || this._id.getFile() == null) {
            System.out.println("ManagerProxy.saveManager: no Identifier to save to for " + manager.getName());
            return false;
        }
        boolean b = manager.writeFile(this._id);
        manager = null;
        return b;
    }

    public boolean saveManager(Manager newManager, Identifier id) {
        Manager manager = this.getManager();
        if (newManager != null) {
            this._managerRef = this.createReference(newManager);
            manager = newManager;
        }
        if (id != null) {
            this._id = id;
            if (manager != null) {
                manager.setIdentifier(id);
            }
        }
        manager = null;
        return this.saveManager();
    }

    public boolean saveAsManager(Manager newManager, Identifier id) {
        Manager manager = this.getManager();
        if (newManager != null) {
            this._managerRef = this.createReference(newManager);
            manager = newManager;
        }
        if (id != null) {
            this._id = id;
            if (manager != null) {
                manager.setIdentifier(id);
            }
        }
        manager.modifiyForSaveAs();
        manager = null;
        return this.saveManager();
    }

    public boolean represents(String className) {
        return this._className.compareTo(className) == 0;
    }

    public void setLastModifiedTime(long lastModifiedTime) {
        this._lastModifiedTime = lastModifiedTime;
        Manager manager = this.getManager();
        if (manager != null) {
            manager.setLastModifiedTime(this._lastModifiedTime);
        }
    }

    public long getLastModifiedTime() {
        Manager manager = this.getManager();
        if (manager != null) {
            return manager.getLastModifiedTime();
        }
        if (this._Workspace != null && this._Workspace.getRemote() != null) {
            try {
                return ((RmiWorkspace)this._Workspace.getRemote()).getManagersModifiedTime(this._id);
            }
            catch (RemoteException re) {
                System.out.println("Error getting modified time for " + this._id.getPath());
            }
        }
        manager = null;
        return this._lastModifiedTime;
    }

    public long getRmiLastModifiedTime() {
        Manager manager = this.getManager();
        if (manager != null) {
            return manager.getLastModifiedTime();
        }
        manager = null;
        return this._lastModifiedTime;
    }

    public void write(BufferedWriter out) throws IOException {
        String relPath;
        RMAIO.fout((BufferedWriter)out, (String)"");
        RMAIO.fout((BufferedWriter)out, (String)"ManagerProxyBegin");
        RMAIO.fout((BufferedWriter)out, (String)("Name=" + this.getName()));
        String desc = this.getDescription();
        if (desc.indexOf("\n") > -1) {
            StringTokenizer tokenizer = new StringTokenizer(desc, "\n");
            while (tokenizer.hasMoreTokens()) {
                RMAIO.fout((BufferedWriter)out, (String)("Description=" + tokenizer.nextToken()));
            }
        } else {
            RMAIO.fout((BufferedWriter)out, (String)("Description=" + desc));
        }
        try {
            relPath = ((RmiWorkspace)this._Workspace.getRemote()).getRelativePath(this.getPath());
        }
        catch (Exception re) {
            System.out.println("Error getting path for " + this.getName());
            relPath = this.getPath();
        }
        RMAIO.fout((BufferedWriter)out, (String)("Path=" + relPath));
        RMAIO.fout((BufferedWriter)out, (String)("Class=" + this.getClassName()));
        RMAIO.fout((BufferedWriter)out, (String)("Index=" + this._index));
        RMAIO.fout((BufferedWriter)out, (String)("ModifiedTime=" + this._lastModifiedTime));
        RMAIO.fout((BufferedWriter)out, (String)"ManagerProxyEnd");
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object that) {
        if (that instanceof ManagerProxy) {
            return this.equals((ManagerProxy)that);
        }
        return false;
    }

    public boolean equals(ManagerProxy that) {
        if (that == null) {
            return false;
        }
        return that.getIndex() == this.getIndex() && (that._className == this._className || that._className.equals(this._className));
    }

    public int hashCode() {
        return this.getIndex();
    }

    public int getObserverCount() {
        return this.observerCount;
    }

    private WeakReference createReference(Manager mgr) {
        return new WeakReference<Manager>(mgr);
    }

    public boolean hasBeenGCd() {
        return this._managerRef != null && this._managerRef.get() == null;
    }

    public void setUserInterface(UserInterface ui) {
        this._userInterface = ui;
    }
}

