/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.io.Identifier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Vector;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.RMAIO;

public class ManagerProxyList
extends Vector {
    private static final long serialVersionUID = 6188070095925059872L;
    private RmiWorkspace _workspace = null;
    private transient ManagerProxyListContainer _managerProxyListContainer = null;
    private String _model;

    public ManagerProxyList(RmiWorkspace workspace) {
        this._workspace = workspace;
    }

    public ManagerProxyList() {
    }

    public String getModel() {
        return this._model;
    }

    public void setModel(String model) {
        this._model = model;
    }

    public ManagerProxyListContainer getContainer() {
        return this._managerProxyListContainer;
    }

    public int getUnitSystem() {
        return this._managerProxyListContainer.getUnitSystem();
    }

    public int getGmtOffset() {
        return this._managerProxyListContainer.getGmtOffset();
    }

    public void setWorkspace(RmiWorkspace workspace) {
        this._workspace = workspace;
    }

    public RmiWorkspace getWorkspace() {
        return this._workspace;
    }

    public void setManagerProxyListContainer(ManagerProxyListContainer mplc) {
        this._managerProxyListContainer = mplc;
    }

    public boolean saveAllManagers(String user) {
        boolean worked = true;
        for (int i = 0; i < this.size(); ++i) {
            Manager manager;
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (proxy == null || (manager = proxy.getManager()) == null) continue;
            boolean mgrWorked = this.saveManager(user, manager);
            if (!mgrWorked) {
                System.out.println("saveAllManagers:failed to save manager " + proxy.getClassName() + " " + manager.getName());
            }
            worked = worked && mgrWorked;
        }
        return worked;
    }

    public boolean saveAllModifiedManagers(String user) {
        boolean worked = true;
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (proxy == null) continue;
            Manager manager = proxy.getManager();
            if (manager != null && manager.isModified()) {
                worked = this.saveManager(user, manager) && worked;
                continue;
            }
            if (manager == null) continue;
            manager.setModifiedFalse();
        }
        return worked;
    }

    public void unloadManager(Identifier id) {
        if (id == null) {
            return;
        }
        boolean found = false;
        ManagerProxy run = null;
        String idPath = id.getPath();
        if (idPath == null) {
            return;
        }
        for (int ii = 0; ii < this.size(); ++ii) {
            run = (ManagerProxy)this.elementAt(ii);
            String runPath = run.getId().getPath();
            if (!RMAIO.pathsEqual((String)idPath, (String)runPath)) continue;
            found = true;
            break;
        }
        if (found) {
            run.unloadManager();
        }
    }

    public void unloadManagers() {
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (proxy == null || proxy.getManager() == null) continue;
            proxy.unloadManager(true);
        }
    }

    public void closeWorkspace() {
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (proxy == null || proxy.getManager() == null) continue;
            proxy.closeWorkspace();
        }
    }

    public Manager loadManager(String classname, Identifier id) throws RemoteException {
        ManagerProxy proxy = null;
        Manager manager = null;
        Object idName = id.getPath();
        if (!RMAIO.isFullPath((String)idName)) {
            idName = this._workspace.getWorkspacePath() + "/" + (String)idName;
        }
        for (int ii = 0; ii < this.size(); ++ii) {
            String proxyPath;
            proxy = (ManagerProxy)this.elementAt(ii);
            if (proxy == null || !proxy.getClassName().equals(classname) || (proxyPath = proxy.getPath()) == null || !RMAIO.pathsEqual((String)proxyPath, (String)idName)) continue;
            manager = proxy.loadManager(null, null);
            return manager;
        }
        return null;
    }

    public Manager loadManagerByName(String classname, String name) throws RemoteException {
        ManagerProxy proxy = null;
        Manager manager = null;
        String idName = name;
        for (int ii = 0; ii < this.size(); ++ii) {
            String proxyName;
            proxy = (ManagerProxy)this.elementAt(ii);
            if (proxy == null || !proxy.getClassName().equals(classname) || !(proxyName = proxy.getName()).equals(idName)) continue;
            manager = proxy.loadManager(null, null);
            if (manager.getProxyList() == null) {
                proxy.setProxyList(this);
                manager.setProxyList(this);
            }
            return manager;
        }
        return null;
    }

    public ManagerProxy getManagerProxy(String classname, Identifier id) throws RemoteException {
        ManagerProxy proxy = null;
        String idName = id.getPath();
        for (int ii = 0; ii < this.size(); ++ii) {
            String proxyPath;
            proxy = (ManagerProxy)this.elementAt(ii);
            if (proxy == null || !proxy.getClassName().equals(classname) || (proxyPath = proxy.getPath()) == null || proxyPath.indexOf(idName) <= -1) continue;
            return proxy;
        }
        return null;
    }

    public ManagerProxy getManagerProxy(String className, int index) {
        if (className == null || index < 0) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (proxy == null || !proxy.represents(className) || proxy.getIndex() != index) continue;
            return proxy;
        }
        return null;
    }

    public ManagerProxy getManagerProxy(String model, String className, int index) {
        if (this._managerProxyListContainer != null) {
            return this._managerProxyListContainer.getManagerProxy(model, className, index);
        }
        return null;
    }

    public ManagerProxy findManager(Identifier id) {
        ManagerProxy run = null;
        String idName = id.getName();
        for (int ii = 0; ii < this.size(); ++ii) {
            run = (ManagerProxy)this.elementAt(ii);
            String runName = run.getName();
            if (!runName.equals(idName)) continue;
            return run;
        }
        return null;
    }

    public ManagerProxy getManager(Identifier id) {
        ManagerProxy run = null;
        String idPath = id.getPath();
        for (int ii = 0; ii < this.size(); ++ii) {
            run = (ManagerProxy)this.elementAt(ii);
            String pathName = run.getPath();
            if (!RMAIO.pathsEqual((String)pathName, (String)idPath)) continue;
            return run;
        }
        return null;
    }

    public ManagerProxy getManagerProxy(Identifier id) {
        if (id == null) {
            return null;
        }
        ManagerProxy mgrProxy = null;
        String idPath = id.getPath();
        for (int ii = 0; ii < this.size(); ++ii) {
            mgrProxy = (ManagerProxy)this.elementAt(ii);
            String pathName = mgrProxy.getPath();
            if (!RMAIO.pathsEqual((String)pathName, (String)idPath)) continue;
            return mgrProxy;
        }
        return null;
    }

    public Manager newManager(String model, String classname) {
        ManagerProxyList proxyList = this._managerProxyListContainer.getManagerProxyList(model);
        if (proxyList == null) {
            return null;
        }
        return proxyList.newManager(classname);
    }

    public Manager newManager(String classname) {
        ManagerProxy proxy;
        Manager mgr = null;
        Object name = "Untitled";
        boolean ifound = false;
        for (int i = 0; i < this.size(); ++i) {
            proxy = (ManagerProxy)this.elementAt(i);
            if (proxy == null || proxy.getName().indexOf("Untitled") < 0) continue;
            ifound = true;
            if (((String)name).compareTo(proxy.getName()) >= 0) continue;
            name = proxy.getName();
        }
        if (ifound) {
            if (((String)name).equals("Untitled")) {
                name = "Untitled1";
            } else {
                String istr = ((String)name).substring(8);
                int i = 0;
                try {
                    i = Integer.parseInt(istr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                name = "Untitled" + Integer.toString(++i);
            }
        }
        proxy = new ManagerProxy(classname, null);
        proxy.setWorkspace(new RemoteWrapper((Remote)this._workspace));
        int idx = -1;
        try {
            idx = this._workspace.getNextManagerIndex();
        }
        catch (RemoteException re) {
            System.out.println("newManager: failed to get Manager Index for new ManagerProxy " + classname + " Error " + re);
        }
        proxy.setIndex(idx);
        proxy.setProxyList(this);
        mgr = proxy.loadManager(classname, null);
        if (mgr != null) {
            this.addElement(proxy);
        }
        return mgr;
    }

    public Manager openManager(String model, Identifier id) {
        if (this._managerProxyListContainer != null) {
            return this._managerProxyListContainer.openManager(model, id);
        }
        return null;
    }

    public Manager openManager(String modelname, String relpath) {
        if (this._managerProxyListContainer != null) {
            return this._managerProxyListContainer.openManager(modelname, relpath);
        }
        return null;
    }

    public Manager openManager(Identifier id) {
        Manager mgr = null;
        if (id == null) {
            return null;
        }
        String path = id.getPath();
        if (path != null && !RMAIO.isFullPath((String)path)) {
            try {
                path = this._workspace.makeAbsolutePath(path);
            }
            catch (RemoteException re) {
                System.out.println("openManager: error making absolute path for " + path + "Error:" + re);
            }
        }
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            String proxyPath = proxy.getPath();
            if (path == null && proxyPath == null) {
                if (!proxy.getName().equals(id.getName())) continue;
                return proxy.loadManager(null, null);
            }
            if (path == null || proxyPath == null || !RMAIO.pathsEqual((String)proxyPath, (String)path)) continue;
            mgr = proxy.loadManager(null, null);
            return mgr;
        }
        return mgr;
    }

    public Manager openManager(String relpath) {
        Manager mgr = null;
        String fullPath = null;
        if (!RMAIO.isFullPath((String)relpath)) {
            try {
                fullPath = this._workspace.makeAbsolutePath(relpath);
            }
            catch (RemoteException re) {
                System.out.println("openManager:Error creating fullpath for " + relpath + " Error:" + re);
                fullPath = relpath;
            }
        } else {
            fullPath = relpath;
        }
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (!RMAIO.pathsEqual((String)proxy.getPath(), (String)fullPath)) continue;
            return proxy.loadManager(null, null);
        }
        return mgr;
    }

    public boolean saveManager(String username, Manager mgr) {
        if (mgr == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (proxy.getManager() != mgr) continue;
            try {
                if (proxy.getPath() != null && proxy.getId().getFile() == null) {
                    Identifier newid;
                    RmiWorkspace data = this._workspace;
                    Identifier mgrId = new Identifier(proxy.getId());
                    if (!RMAIO.isFullPath((String)mgrId.getPath())) {
                        mgrId.setPath(data.getWorkspacePath() + "/" + mgrId.getPath());
                    }
                    if ((newid = data.openFile(username, mgrId)) == null) {
                        newid = data.newFile(username, mgrId);
                    }
                    newid.setName(proxy.getId().getName());
                    newid.setDescription(proxy.getId().getDescription());
                    proxy.setId(newid);
                    data.addManager(username, new ManagerProxy(proxy));
                    if (mgr.getIdentifier().getFile() == null) {
                        mgr.setIdentifier(newid);
                    }
                }
                return proxy.saveManager(mgr, null);
            }
            catch (Exception e) {
                System.out.println("ManagerProxyList error in saveManager(" + proxy.getId().getName() + ")\n  " + e);
                System.out.println("Manager class is " + ((Object)((Object)mgr)).getClass() + " file is " + proxy.getId().getPath());
                e.printStackTrace();
            }
        }
        System.out.println("ManagerProxyList.saveManager(" + this._model + "): failed to find ManagerProxy for " + mgr.getName());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveManagerAs(String username, Manager mgrFrom, Manager mgrTo) {
        if (mgrFrom == null || mgrTo == null) {
            return false;
        }
        Identifier id = mgrTo.getIdentifier();
        if (id == null || id.getPath() == null) {
            return false;
        }
        try {
            for (int i = 0; i < this.size(); ++i) {
                ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
                if (proxy == null || proxy.getManager() != mgrFrom) continue;
                RmiWorkspace data = this._workspace;
                if (id.getFile() == null) {
                    Identifier newid = data.openFile(username, id);
                    if (newid == null) {
                        newid = data.newFile(username, id);
                    }
                    newid.setName(id.getName());
                    newid.setDescription(id.getDescription());
                    id = newid;
                }
                mgrTo.setReloadOk(false);
                mgrFrom.setReloadOk(false);
                int fromIndex = mgrFrom.getIndex();
                mgrFrom.setIndex(mgrTo.getIndex());
                try {
                    mgrFrom.writeFile(id);
                }
                finally {
                    mgrFrom.setIndex(fromIndex);
                }
                String name = mgrTo.getName();
                mgrTo.setReloadOk(true);
                mgrFrom.setReloadOk(true);
                mgrTo.loadSaveAsFile(id);
                mgrTo.setIdentifier(id);
                mgrTo.setName(name);
                for (int j = 0; j < this.size(); ++j) {
                    ManagerProxy tmpProxy = (ManagerProxy)this.elementAt(j);
                    if (tmpProxy == null || tmpProxy.getManager() == null || !tmpProxy.getManager().getName().equals(mgrTo.getName()) || tmpProxy.getId().getFile() != null || !tmpProxy.getClassName().equals(proxy.getClassName())) continue;
                    tmpProxy.setId(id);
                    data.addManager(username, new ManagerProxy(tmpProxy));
                }
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean saveManagerAs(String username, Manager manager, Identifier id) {
        if (manager == null) {
            return false;
        }
        if (id == null || id.getPath() == null) {
            return false;
        }
        try {
            RmiWorkspace data;
            Identifier newid;
            ManagerProxy proxy;
            for (int i = 0; i < this.size(); ++i) {
                proxy = (ManagerProxy)this.elementAt(i);
                if (proxy == null || proxy.getManager() != manager) continue;
                if (proxy.getPath() == null || RMAIO.pathsEqual((String)id.getPath(), (String)proxy.getPath())) {
                    if (id.getFile() == null) {
                        RmiWorkspace data2 = this._workspace;
                        Identifier newid2 = data2.openFile(username, id);
                        if (newid2 == null) {
                            newid2 = data2.newFile(username, id);
                        }
                        newid2.setName(id.getName());
                        newid2.setDescription(id.getDescription());
                        id = newid2;
                        proxy.setId(id);
                        data2.addManager(username, new ManagerProxy(proxy));
                    }
                    return proxy.saveAsManager(manager, id);
                }
                proxy.unloadManager();
                break;
            }
            if ((newid = (data = this._workspace).openFile(username, id)) == null) {
                newid = data.newFile(username, id);
            }
            newid.setName(id.getName());
            newid.setDescription("Copy of" + id.getDescription());
            id = newid;
            proxy = new ManagerProxy(((Object)((Object)manager)).getClass().getName(), id);
            proxy.setWorkspace(new RemoteWrapper((Remote)this._workspace));
            proxy.setProxyList(this);
            this.addElement(proxy);
            data.addManager(username, new ManagerProxy(proxy));
            Identifier tempId = manager.getIdentifier();
            return proxy.saveAsManager(manager, id);
        }
        catch (Exception e) {
            System.out.println("Caught exception on saving new manager " + e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteManager(Identifier id) {
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (!proxy.getId().equals((Object)id)) continue;
            return this.removeElement(proxy);
        }
        return false;
    }

    public Manager openManager(String modelname, String className, int index) {
        if (this._managerProxyListContainer != null) {
            return this._managerProxyListContainer.openManager(modelname, className, index);
        }
        return null;
    }

    public Manager openManager(String className, int index) {
        if (className == null || index < 0) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (proxy == null || !proxy.represents(className) || proxy.getIndex() != index) continue;
            return proxy.loadManager(className, proxy.getId());
        }
        return null;
    }

    public Vector<Identifier> getManagerIDList(String className) {
        Vector<Identifier> idvec = new Vector<Identifier>();
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.elementAt(i);
            if (proxy == null || !proxy.represents(className)) continue;
            idvec.addElement(proxy.getId());
        }
        return idvec;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ManagerProxy proxy = (ManagerProxy)this.get(i);
            if (proxy == null) continue;
            proxy.setProxyList(this);
        }
    }

    public void removeAllManagersCallbacks() {
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.get(i);
            if (proxy == null || proxy.getManager() == null) continue;
            proxy.getManager().removeCallBack();
        }
    }

    public void dropAllManagers() {
        System.out.println("dropAllManagers(" + this._model + ") dropping all manager references");
        for (int i = 0; i < this.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)this.get(i);
            if (proxy == null) continue;
            proxy.dropManager();
        }
    }
}

