/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.WkspCallBack;
import hec.clientapp.model.DataListContainer;
import hec.clientapp.model.DefaultDataListContainer;
import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.rmi.csinterface.RmiDataListContainer;
import hec.clientapp.rmi.csinterface.RmiWkspCallBack;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.server.HecRmiWorkspaceImpl;
import hec.clientapp.server.RmiWkspCallBackImpl;
import hec.io.FileLock;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.map.MapIdentifier;
import hec.model.CommonDataList;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.RMAIO;

public abstract class ManagerProxyListManager
extends Manager
implements ManagerProxyListContainer,
WkspCallBack {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    protected transient RmiWorkspace _managerRmiWorkspace;
    protected transient ManagerProxyList _managerVector = new ManagerProxyList();
    protected transient Hashtable _managerGroup = new Hashtable();
    protected transient DataListContainer _dataListContainer = null;
    protected transient Hashtable _childWorkspaces = new Hashtable();
    private transient RemoteWrapper _callBackWrapper;
    private transient String _wkspName = null;

    public ManagerProxyListManager() {
    }

    public ManagerProxyListManager(String name) {
        super(name);
    }

    public void setManagerRmiWorkspace(RmiWorkspace wksp) {
        this._managerRmiWorkspace = wksp;
        if (this._managerRmiWorkspace != null) {
            this.initCallBack();
            this.getManagerProxies();
            this.setupDataListContainer();
        }
    }

    public RmiWorkspace getManagerRmiWorkspace() {
        return this._managerRmiWorkspace;
    }

    @Override
    public void init() {
    }

    protected void initCallBack() {
        RmiWkspCallBackImpl callBack = null;
        try {
            callBack = new RmiWkspCallBackImpl(this);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this._callBackWrapper = new RemoteWrapper((Remote)callBack);
        if (this.isNetworked()) {
            try {
                this._callBackWrapper.export();
            }
            catch (RemoteException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Callback wrapper not exported: " + this._callBackWrapper);
            }
        }
        this.setCallback(callBack, this._managerRmiWorkspace);
    }

    protected void setCallback(RemoteWrapper callBackWrap, RmiWorkspace wksp) {
        RmiWkspCallBack callBack = (RmiWkspCallBack)callBackWrap.getRemote();
        this.setCallback(callBack, wksp);
    }

    protected void setCallback(RmiWkspCallBack callBack, RmiWorkspace wksp) {
        try {
            if (this.isNetworked()) {
                throw new IllegalStateException("setCallback does not support networked ManagerProxyListManager");
            }
            wksp.addCallBack(callBack);
        }
        catch (Exception e) {
            System.out.println("Error adding callback to RmiWorkspace " + e);
            e.printStackTrace();
        }
    }

    protected void getManagerProxies() {
        RmiWorkspace di;
        if (this._managerRmiWorkspace != null && (di = this._managerRmiWorkspace) != null) {
            try {
                this._managerVector = di.getManagers();
                if (this._managerVector != null) {
                    for (int i = 0; i < this._managerVector.size(); ++i) {
                        ManagerProxy proxy = (ManagerProxy)this._managerVector.elementAt(i);
                        if (proxy == null) continue;
                        proxy.setProxyList(this._managerVector);
                    }
                }
            }
            catch (Exception e) {
                System.out.println(this.getName() + ".getManagerProxies: failed to get manager proxy list!\n");
            }
        }
        this._managerVector.setManagerProxyListContainer(this);
    }

    private void setupDataListContainer() {
        try {
            RmiDataListContainer rdlc = this._managerRmiWorkspace.getDataList();
            if (rdlc != null) {
                this._dataListContainer = this.getDataListContainer(rdlc);
                this._dataListContainer.setContainer(this);
            } else {
                System.out.println("ClientWorkspace: failed to get DataListContainer from " + this._managerRmiWorkspace);
            }
        }
        catch (Exception re) {
            System.out.println("ClientWorkspace: failed to get RmiDataListContainer  " + re);
        }
    }

    @Override
    public Vector getManagerProxyList(String modelname, String className) {
        ManagerProxyList proxyList = this.getManagerProxyList(modelname);
        if (proxyList == null) {
            return null;
        }
        int size = proxyList.size();
        Vector<ManagerProxy> v = new Vector<ManagerProxy>(size);
        for (int i = 0; i < size; ++i) {
            ManagerProxy proxy = (ManagerProxy)proxyList.get(i);
            if (proxy == null || !proxy.getClassName().equals(className)) continue;
            v.add(proxy);
        }
        return v;
    }

    @Override
    public ManagerProxy getManagerProxy(String modelname, String className, int index) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManagerProxy(className, index);
    }

    @Override
    public ManagerProxy getManagerProxy(String modelname, Identifier id) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManager(id);
    }

    @Override
    public CommonDataList getCommonDataList(String theDataObjectClass, String theModel) {
        if (this._dataListContainer == null) {
            System.out.println("Error retrieving DataList in " + this.getClass().getName() + ".getCommonDataList");
            System.out.println("DataListContainer is not available");
            System.out.println("DataObjectClass: " + theDataObjectClass);
            return null;
        }
        return this._dataListContainer.getDataList(theDataObjectClass, theModel);
    }

    @Override
    public int getUnitSystem() {
        return super.getUnitSystem();
    }

    @Override
    public int getGmtOffset() {
        return super.getGmtOffset();
    }

    @Override
    public Manager openManager(Identifier id) {
        return this._managerVector.openManager(id);
    }

    public Manager loadManagerByName(String modelname, String classname, String name) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        try {
            return list.loadManagerByName(classname, name);
        }
        catch (Exception e) {
            System.out.println("Error loading manager " + name + " error " + e);
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Manager openManager(String modelname, Identifier id) {
        if (modelname == null || modelname.equals("main")) {
            return this.openManager(id);
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(id);
    }

    @Override
    public Manager openManager(String modelname, String relpath) {
        if (modelname == null || modelname.equals("main")) {
            return this.openManager(relpath);
        }
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(relpath);
    }

    public Manager openManager(String relpath) {
        return this._managerVector.openManager(relpath);
    }

    @Override
    public Manager openManagerByName(String modelname, String classname, String name) {
        ManagerProxyList list = null;
        list = modelname == null || modelname.equals("main") ? this._managerVector : this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        try {
            return list.loadManagerByName(classname, name);
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    @Override
    public Manager openManager(String modelname, String className, int index) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.openManager(className, index);
    }

    @Override
    public Manager newManager(String modelname, String className) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        this.setModified(true);
        return list.newManager(className);
    }

    public Manager newManager(String classname) {
        return this._managerVector.newManager(classname);
    }

    @Override
    public ManagerProxyList getManagerProxyList(String modelname) {
        ManagerProxyList list = null;
        if (modelname == null) {
            modelname = "";
        }
        if ((list = (ManagerProxyList)this._managerGroup.get(modelname)) != null) {
            return list;
        }
        RmiWorkspace childwksp = this.getChildWorkspace(modelname);
        if (childwksp == null) {
            System.out.println("getManagerProxyList: failed to find child workspace " + modelname);
            return list;
        }
        try {
            list = childwksp.getManagers();
            list.setManagerProxyListContainer(this);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ManagerProxy proxy = (ManagerProxy)list.get(i);
                    if (proxy == null) continue;
                    proxy.setProxyList(list);
                }
                this._managerGroup.put(modelname, list);
            }
        }
        catch (Exception e) {
            System.out.println("Error getting manager list from childworkspace " + modelname);
        }
        return list;
    }

    public Identifier getManagerIdentifier(String type, String classname, String name, String ext) {
        Identifier id = null;
        String filename = RMAIO.userNameToFileName((String)name.trim());
        String sep = "/";
        String path = this.getWorkspacePath() + sep + type + sep + filename + (String)(ext.length() > 0 && ext.charAt(0) == '.' ? ext : "." + ext);
        id = new Identifier(path);
        id.setName(name);
        id.setClassName(classname);
        return id;
    }

    public Vector<Identifier> getManagerIDList(String className) {
        return this._managerVector.getManagerIDList(className);
    }

    @Override
    public Vector<Identifier> getManagerIDList(String modelname, String className) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return null;
        }
        return list.getManagerIDList(className);
    }

    @Override
    public RmiWorkspace getChildWorkspace(String modelname) {
        if (this._managerRmiWorkspace == null || modelname == null) {
            return null;
        }
        RmiWorkspace child = null;
        if (modelname.equals("") || modelname.equals("main")) {
            return this._managerRmiWorkspace;
        }
        child = (RmiWorkspace)this._childWorkspaces.get(modelname);
        if (child != null) {
            return child;
        }
        try {
            child = this._managerRmiWorkspace.getChildWorkspace(modelname);
            if (child == null) {
                System.out.println("getChildWorkspace: failed to get child workspace for " + modelname);
                return null;
            }
            this._childWorkspaces.put(modelname, child);
            this.setCallback(this._callBackWrapper, child);
            RmiDataListContainer rdlc = child.getDataList();
            if (rdlc != null && this._dataListContainer != null) {
                this._dataListContainer.addDataLists(rdlc.getDataLists(), modelname);
            }
            return child;
        }
        catch (Exception e) {
            System.out.println("Error getting childworkspace " + modelname + " " + e);
            e.printStackTrace();
            return child;
        }
    }

    public DataListContainer getDataListContainer(RmiDataListContainer rdlc) {
        System.out.println("returning defaultDataListcontainer");
        return new DefaultDataListContainer(rdlc);
    }

    public boolean saveWorkspace() {
        return this.saveWorkspace(true);
    }

    public boolean saveWorkspace(boolean saveAllManagers) {
        if (this._managerRmiWorkspace == null) {
            return false;
        }
        if (saveAllManagers) {
            this.saveAllManagers();
        } else {
            this.saveAllModifiedManagers();
        }
        try {
            this._managerRmiWorkspace.saveWorkspace(UserId.getUserId());
            this.setModified(false);
            return true;
        }
        catch (RemoteException re) {
            System.out.println("Error with saving in SaveWorkspace  " + re);
            return false;
        }
    }

    public boolean saveManager(Manager mgr) {
        if (this.getWorkspacePath() == null) {
            this.saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return false;
            }
        }
        return this._managerVector.saveManager(UserId.getUserId(), mgr);
    }

    @Override
    public boolean saveManager(String modelname, Manager mgr) {
        ManagerProxyList list;
        if (this.getWorkspacePath() == null) {
            this.saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return false;
            }
        }
        if ((list = this.getManagerProxyList(modelname)) == null) {
            return false;
        }
        return list.saveManager(UserId.getUserId(), mgr);
    }

    public boolean saveManagerAs(Manager mgr, Identifier id) {
        if (this.getWorkspacePath() == null) {
            this.saveWorkspace();
            if (this.getWorkspacePath() == null) {
                return false;
            }
        }
        return this._managerVector.saveManagerAs(UserId.getUserId(), mgr, id);
    }

    @Override
    public boolean saveManagerAs(String modelname, Manager mgr, Identifier id) {
        ManagerProxyList list;
        if (this.getWorkspacePath() == null) {
            this.saveWorkspace();
            if (this.getWorkspacePath() == null) {
                System.out.println("saveManagerAs: Error workspace path is null");
                return false;
            }
        }
        if ((list = this.getManagerProxyList(modelname)) == null) {
            System.out.println("saveManagerAs: no managerProxyList for " + modelname);
            return false;
        }
        return list.saveManagerAs(UserId.getUserId(), mgr, id);
    }

    public void saveAllManagers() {
        String user = UserId.getUserId();
        this._managerVector.saveAllManagers(user);
        Enumeration e = this._managerGroup.elements();
        while (e.hasMoreElements()) {
            ManagerProxyList list = (ManagerProxyList)e.nextElement();
            list.saveAllManagers(user);
        }
        if (this._dataListContainer != null) {
            this._dataListContainer.saveAll(user);
        }
    }

    public void saveAllModifiedManagers() {
        String user = UserId.getUserId();
        this._managerVector.saveAllModifiedManagers(user);
        Enumeration e = this._managerGroup.elements();
        while (e.hasMoreElements()) {
            ManagerProxyList list = (ManagerProxyList)e.nextElement();
            list.saveAllModifiedManagers(user);
        }
        if (this._dataListContainer != null) {
            this._dataListContainer.saveAll(user);
        }
    }

    @Override
    public String getWorkspacePath() {
        RmiWorkspace data = this._managerRmiWorkspace;
        if (data == null) {
            return null;
        }
        try {
            String path = data.getWorkspacePath();
            return path;
        }
        catch (Exception e) {
            System.out.println("ManagerProxyListManager: unable to get Workspace path");
            return null;
        }
    }

    @Override
    public void unloading() {
        System.out.println(this.getName() + ": unloading");
        this.closeWorkspace();
    }

    protected void closeWorkspace() {
        if (this._managerRmiWorkspace != null) {
            Enumeration e = this._managerGroup.elements();
            while (e.hasMoreElements()) {
                ManagerProxyList proxylist = (ManagerProxyList)e.nextElement();
                proxylist.unloadManagers();
                proxylist.closeWorkspace();
            }
            if (this._dataListContainer != null) {
                this._dataListContainer.workspaceClosing();
            }
            try {
                this._managerRmiWorkspace.removeCallBack((RmiWkspCallBack)this._callBackWrapper.getRemote());
            }
            catch (RemoteException re) {
                System.out.println("close: Error removing callback from RmiWorkspace " + re);
            }
            try {
                this._managerRmiWorkspace.closeWorkspace(UserId.getUserId());
            }
            catch (RemoteException re) {
                System.out.println("Error closing Workspace from data interface  " + re);
            }
            this._childWorkspaces.clear();
            this._managerGroup.clear();
        }
        this._managerRmiWorkspace = null;
    }

    @Override
    public void unloadManager(String modelname, Identifier id) {
        ManagerProxyList list = this.getManagerProxyList(modelname);
        if (list == null) {
            return;
        }
        list.unloadManager(id);
    }

    public boolean isNetworked() {
        if (this._managerRmiWorkspace == null) {
            return false;
        }
        return !(this._managerRmiWorkspace instanceof HecRmiWorkspaceImpl);
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void managerChanged(int changeType, ManagerProxy proxy, String model) {
        switch (changeType) {
            case 0: {
                this.managerAdded(proxy, model);
                break;
            }
            case 1: {
                this.managerRemoved(proxy, model);
                break;
            }
            case 2: {
                this.managerRenamed(proxy, model);
            }
        }
    }

    protected void managerAdded(ManagerProxy proxy, String model) {
        if (proxy == null || model == null) {
            return;
        }
        ManagerProxyList proxyList = this.getManagerProxyList(model);
        if (proxyList == null) {
            return;
        }
        System.out.println("managerAdded: got Proxy for '" + proxy + "' model=" + model + " class=" + proxy.getClassName());
        if (!proxyList.contains(proxy) && proxy.getIndex() > -1) {
            proxy.setProxyList(proxyList);
            proxyList.addElement(proxy);
        }
    }

    protected void managerRemoved(ManagerProxy proxy, String model) {
        if (proxy == null || model == null) {
            return;
        }
        ManagerProxyList proxyList = this.getManagerProxyList(model);
        if (proxyList == null) {
            return;
        }
        if (proxyList.contains(proxy)) {
            proxyList.remove(proxy);
        }
    }

    protected void managerRenamed(ManagerProxy proxy, String model) {
        ManagerProxy origProxy;
        if (proxy == null || model == null) {
            return;
        }
        ManagerProxyList proxyList = this.getManagerProxyList(model);
        if (proxyList == null) {
            return;
        }
        System.out.println("managerRenamed: got Proxy for " + proxy + " model " + model);
        if (proxyList.contains(proxy) && proxy.getIndex() > -1 && (origProxy = proxyList.getManagerProxy(model, proxy.getIndex())) != null) {
            origProxy.renameManager(proxy.getId());
        }
    }

    @Override
    public void mapAdded(MapIdentifier mapId) {
    }

    @Override
    public void mapRemoved(MapIdentifier mapId) {
    }

    public String getWorkspaceName() {
        if (this._wkspName != null) {
            return this._wkspName;
        }
        try {
            this._wkspName = this._managerRmiWorkspace.getName();
        }
        catch (RemoteException re) {
            System.out.println(this.getName() + ".getWorkspaceName: RMI error getting RmiWOrkspace Name " + re);
        }
        return this._wkspName;
    }

    public String getTitleName() {
        String name = "Untitled";
        if (this._managerRmiWorkspace != null) {
            try {
                name = this._managerRmiWorkspace.getTitleName();
            }
            catch (Exception e) {
                System.out.println("getTitleName():Error accessing rmi workspace");
            }
        }
        return name;
    }

    public String getWorkspaceConfigFile(String model) {
        RmiWorkspace wksp = null;
        wksp = model == null || model.length() == 0 || model.equalsIgnoreCase("main") ? this._managerRmiWorkspace : this.getChildWorkspace(model);
        try {
            if (wksp != null) {
                return wksp.getWorkspaceFile();
            }
        }
        catch (RemoteException re) {
            System.out.println("getWorkspaceConfigFile: error getting config file " + re);
        }
        return null;
    }

    @Override
    public void userChanged(String user, String changeType) {
        String wkspType = this.getClass().getName();
        int idx = wkspType.lastIndexOf(".");
        wkspType = wkspType.substring(idx + 1);
        ClientApp.app();
        ClientApp.frame().printMessage(user + " has " + changeType + " the " + wkspType + " " + this.getTitleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteManager(String modelname, Identifier id, boolean deleteFile) {
        boolean deleted;
        block19: {
            ManagerProxyList list = this.getManagerProxyList(modelname);
            if (list == null) {
                return false;
            }
            RmiWorkspace childwksp = this.getChildWorkspace(modelname);
            String user = UserId.getUserId();
            RmiFileManager filemgr = this.getFileManager();
            FileLock fileLock = new FileLock(user, 4);
            if (filemgr != null) {
                try {
                    boolean locked;
                    if (filemgr.fileExists(id.getPath()) && !(locked = filemgr.lockFile(id, fileLock))) {
                        ((FluentLogger.Api)LOGGER.atWarning()).log("Failed to lock " + id.getName() + " file for deletion");
                        return false;
                    }
                }
                catch (RemoteException re) {
                    ((FluentLogger.Api)LOGGER.atWarning()).log("deleteManager: RMI Error deleting manager " + re);
                    return false;
                }
            }
            deleted = false;
            try {
                if (!list.deleteManager(id)) break block19;
                try {
                    deleted = childwksp.removeManager(ClientApp.app().getUser(), id);
                    if (deleted && deleteFile) {
                        childwksp.deleteFile(user, id);
                    }
                    boolean bl = deleted;
                    return bl;
                }
                catch (RemoteException re) {
                    ((FluentLogger.Api)LOGGER.atWarning()).log("deleteManager:Caught remoteException on deleteManager(" + id.getName() + ") " + re);
                }
            }
            finally {
                if (filemgr != null) {
                    try {
                        filemgr.unlockFile(id, FileLock.getUnlockForLock((FileLock)fileLock));
                    }
                    catch (RemoteException re) {
                        ((FluentLogger.Api)LOGGER.atWarning()).log("deleteManager:RMI Error unlocking file " + re);
                    }
                }
            }
        }
        return deleted;
    }
}

