/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.io.AsciiSerializable;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ModelReference;
import hec.lang.WorkspaceNameFactory;
import hec.supplemental.model.ProgramOrderItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;

public class ModelAlt
extends Manager
implements Serializable,
AsciiSerializable {
    public static final String FILE_EXT = ".malt";
    private static boolean _showId = false;
    private int _programIndex;
    private String _altId;
    private ModelReference _modelRef;
    private transient Manager _myMgr;

    @Override
    public void init() {
    }

    public void setProgramIndex(ProgramOrderItem poi) {
        this._programIndex = poi == null ? -1 : poi.getIndex();
    }

    public int getProgramIndex() {
        return this._programIndex;
    }

    public void setModelRef(ModelReference mr) {
        this._modelRef = new ModelReference(mr);
    }

    public ModelReference getModelRef() {
        return this._modelRef;
    }

    public void setAltId(String id) {
        this._altId = id;
    }

    public String getAltId() {
        return this._altId;
    }

    @Override
    public boolean readFile(Identifier id) {
        if (id == null) {
            return false;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        System.out.println("opening " + file.getPath());
        try {
            BufferedReader reader = file.getBufferedReader();
            HecAsciiDeserializer as = new HecAsciiDeserializer(reader);
            as.addClassMapping("hec.model.ModelAlt", this.getClass().getName());
            as.addClassMapping("hec.lang.ModelReference", ModelReference.class.getName());
            as.deserializeObject((Object)this);
            reader.close();
        }
        catch (IOException ioe) {
            System.out.println("readFile: IOException reading " + file.getPath() + " Error " + ioe);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(Identifier id) {
        if (id == null) {
            return false;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        try {
            BufferedWriter writer;
            block10: {
                this.setReloadOk(false);
                try {
                    writer = file.getBufferedWriter();
                    if (writer != null) break block10;
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ioe) {
                    System.out.println("writeFile: IOException writing " + file.getPath() + " Error " + ioe);
                    boolean bl = false;
                    this.setReloadOk(true);
                    return bl;
                }
            }
            System.out.println("writing " + file.getPath());
            super.writeFile(id);
            HecAsciiSerializer as = new HecAsciiSerializer(writer);
            as.serializeObject((Object)this);
            writer.close();
            this.setModified(false);
            boolean bl = true;
            return bl;
        }
        finally {
            this.setReloadOk(true);
        }
    }

    public boolean isManagerModified() {
        if (this._myMgr == null) {
            return false;
        }
        return this._myMgr.isModified();
    }

    public boolean saveModelManager() {
        if (this._myMgr == null) {
            return true;
        }
        return this._myMgr.saveChildManagers();
    }

    public boolean reloadModelManager() {
        if (this._myMgr == null) {
            return true;
        }
        return this._myMgr.reLoadChildManagers();
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public Manager createDataFiles(String directory, ManagerProxy baseDataProxy, ManagerProxyListContainer container) {
        String newFilenamePrefix = this._altId;
        if (baseDataProxy == null) {
            return null;
        }
        Manager mgr = baseDataProxy.loadManager(baseDataProxy.getClassName(), baseDataProxy.getId());
        if (mgr == null) {
            return null;
        }
        Manager newMgr = mgr.saveManagerAs(directory, newFilenamePrefix, container);
        baseDataProxy.unloadManager();
        if (newMgr == null) {
            return null;
        }
        return newMgr;
    }

    public boolean refreshDataFile(ManagerProxyListContainer container) {
        Manager origMgr;
        ModelReference ref = this.getModelRef();
        String model = WorkspaceNameFactory.getWorkspaceName((String)ref.wkspName, (boolean)true);
        if (model == null) {
            model = "supplemental";
        }
        if ((origMgr = container.openManager(model, ref.className, ref.id)) == null) {
            System.out.println("refreshDataFiles: failed to find original manager for  " + ref);
            return false;
        }
        Manager mgr = this.getManager();
        if (mgr == null) {
            System.out.println("refreshDataFiles: failed to find my manager for " + ref);
            container.unloadManager(model, origMgr.getIdentifier());
            return false;
        }
        if (origMgr.isModified()) {
            origMgr.writeFile(origMgr.getIdentifier());
        }
        boolean rv = mgr.refreshData(origMgr);
        container.unloadManager(model, origMgr.getIdentifier());
        return rv;
    }

    public static void showId(boolean b) {
        _showId = b;
    }

    public Manager getManager() {
        if (this._myMgr != null) {
            return this._myMgr;
        }
        ModelReference ref = this.getModelRef();
        ManagerProxyListContainer container = this._proxyList.getContainer();
        String model = WorkspaceNameFactory.getWorkspaceName((String)ref.wkspName, (boolean)true);
        if (model == null) {
            model = "supplemental";
        }
        this._myMgr = container.openManager(model, ref.className, ref.newId);
        if (this._myMgr == null) {
            System.out.println("getManager:failed to open " + model + " Manager class " + ref.className + " id=" + ref.newId);
        }
        return this._myMgr;
    }

    public ManagerProxy getManagerProxy() {
        ModelReference ref = this.getModelRef();
        if (ref == null) {
            return null;
        }
        ManagerProxyListContainer container = this._proxyList.getContainer();
        String model = WorkspaceNameFactory.getWorkspaceName((String)ref.wkspName, (boolean)true);
        if (model == null) {
            model = "supplemental";
        }
        return container.getManagerProxy(model, ref.className, ref.newId);
    }

    @Override
    public void unloading() {
        if (this._myMgr == null) {
            return;
        }
        ModelReference ref = this.getModelRef();
        ManagerProxyListContainer container = this._proxyList.getContainer();
        String model = WorkspaceNameFactory.getWorkspaceName((String)ref.wkspName, (boolean)true);
        if (model == null) {
            model = "supplemental";
        }
        container.unloadManager(model, this._myMgr.getIdentifier());
    }

    @Override
    public void deleting() {
        File bakFile;
        HecFile maltFile = this.getIdentifier().getFile();
        String path = maltFile.getPath();
        if (maltFile != null && maltFile.exists()) {
            try {
                if (!this.getFileManager().deleteFile(path)) {
                    this.printWarningMessage(this.getName() + ".deleting: Failed to delete *.rsys file " + path);
                }
            }
            catch (RemoteException re) {
                this.printWarningMessage(this.getName() + ".deleting: Error deleting *.rsys file" + path + " Error:" + re);
            }
        }
        if ((bakFile = new File(path = path.concat(".bak"))) != null && bakFile.exists()) {
            try {
                if (!this.getFileManager().deleteFile(path)) {
                    this.printWarningMessage(this.getName() + ".deleting: Failed to delete *.malt file " + path);
                }
            }
            catch (RemoteException re) {
                this.printWarningMessage(this.getName() + ".deleting: Error deleting *.malt file" + path + " Error:" + re);
            }
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

