/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.client.ClientApp;
import hec.clientapp.model.AbstractSimulation;
import hec.clientapp.model.ComputeInfo;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyList;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimRunInfo;
import hec.clientapp.model.Simulation;
import hec.clientapp.model.SimulationExtract;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.SimulationTrialRun;
import hec.clientapp.model.StreamAlignment;
import hec.clientapp.model.TrialRun;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.supplemental.SupplementalRmiWorkspace;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import hec.lang.LockFailedException;
import hec.lang.ModelReference;
import hec.lang.UserId;
import hec.lang.WorkspaceNameFactory;
import hec.model.AltItem;
import hec.model.RunTimeWindow;
import hec.model.TrialReference;
import hec.properties.HECProperties;
import hec.supplemental.model.ProgramOrderItem;
import java.awt.Component;
import java.lang.reflect.Field;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;

public class SimulationPeriod
extends AbstractSimulation
implements Simulation {
    public static final int MAX_ALTERNATIVE_NAME_LENGTH = 10;
    public static final String SIMULATION_DSS_FILE_NAME = "simulation.dss";
    public static final int DEFAULT_KEY_LENGTH = 11;
    private SimRunInfo[] _alternativeNames = new SimRunInfo[0];
    protected String m_simulationPath = "";
    transient String m_workspacePath;
    Vector _trialList = new Vector();
    private transient StreamAlignment _alignment = null;
    private String m_simulationRunClass = "";
    private String m_appType = "";
    public static String FILE_EXT = ".simperiod";
    private Hashtable _modelTrials = new Hashtable();
    private SimulationExtract _extract;
    private transient Vector _trials = new Vector();
    private Hashtable _currentTrials = new Hashtable();
    private Hashtable _allTrials = new Hashtable();
    protected int _keyLength = 11;
    protected int _maxAlternativeNameLength = 10;
    protected transient boolean m_loaded = false;
    protected String _simulationFileName = "simulation.dss";
    protected transient Vector<SimulationRun> _simRuns = new Vector();
    private String _simType = "Simulation";
    private transient SimulationRun _currentComputingRun;

    @Override
    public String getOutputDSSFilePath() {
        return this.getSimulationPath() + "/" + this.getOutputDSSFileName();
    }

    @Override
    public String getOutputDSSFileName() {
        if (this._simulationFileName == null || this._simulationFileName.length() == 0) {
            return SIMULATION_DSS_FILE_NAME;
        }
        return this._simulationFileName;
    }

    public void setOutputDSSFileName(String fileName) {
        this._simulationFileName = fileName;
        this.setModified(true);
    }

    @Override
    public Vector getTrialRunNames() {
        return (Vector)this._trialList.clone();
    }

    @Override
    public TrialRun createNewTrialRun(String newTrialName, String userName, String trialKey, SimulationRun parent, TrialRun baseTrial, int modelPosition) {
        if (newTrialName == null || parent == null) {
            return null;
        }
        if (this._trialList.contains(newTrialName)) {
            return null;
        }
        ManagerProxyList proxyList = this.getManagerProxyList(this.m_appType);
        System.out.println(this.getName() + "newTrialRun: creating trial " + newTrialName + " for Run " + parent);
        SimulationTrialRun trial = (SimulationTrialRun)this.newManager(this.m_appType, parent.getTrialRunClassName());
        trial.setSimulation(this);
        trial.setConfigurationId(parent.getConfigurationId());
        trial.setRunParent(parent);
        trial.setName(newTrialName);
        trial.setUserName(userName);
        trial.setTrialKey(trialKey);
        trial.setTrialPosition(modelPosition);
        Vector<AltItem> altList = baseTrial != null ? ((SimulationTrialRun)baseTrial).getAltList() : parent.getAltList();
        Vector<AltItem> newAltList = new Vector<AltItem>(altList.size());
        if (altList != null) {
            int size = altList.size();
            int keyLength = this.getKeyLength();
            for (int i = 0; i < size; ++i) {
                AltItem altItem = altList.get(i);
                if (altItem.getAltIndex() != -1) {
                    String modelKey = trialKey.substring(i * keyLength, i * keyLength + keyLength) + ":" + altItem.getModelPosition();
                    AltItem tmpAltItem = (AltItem)this._allTrials.get(modelKey);
                    if (tmpAltItem != null) {
                        altItem = tmpAltItem;
                    } else {
                        ModelAlt alt = (ModelAlt)parent.getProxyList().openManager("hec.watershed.model.ModelAlt", altItem.getAltIndex());
                        if (alt != null) {
                            String program = WorkspaceNameFactory.getWorkspaceName((String)altItem.getProgram());
                            int num = RMAIO.parseInt((String)trialKey.substring(i * keyLength + (keyLength - 1), i * keyLength + keyLength));
                            if (this.addModelTrial(program, alt.getAltId(), num)) {
                                altItem = this.createTrialData(altItem, trial.getProxyList(), "_" + alt.getAltId() + num + "-", true);
                                this._allTrials.put(modelKey, altItem);
                            }
                            parent.getProxyList().unloadManager(alt.getIdentifier());
                        }
                    }
                }
                newAltList.add(altItem);
            }
        }
        Identifier id = trial.getIdentifier();
        id.setName(newTrialName);
        id.setPath(this.getSimulationPath() + "/" + this.m_appType + "/" + trial.getName() + SimulationTrialRun.FILE_EXT);
        trial.setAltList(newAltList);
        int keyLength = this.getKeyLength();
        if (proxyList.saveManager(UserId.getUserId(), trial)) {
            String key = trialKey.substring(modelPosition * keyLength, modelPosition * keyLength + keyLength);
            parent.addTrial(trial.getIndex(), modelPosition, key);
            this.setModified(true);
        }
        return trial;
    }

    public void setSimulationRunClass(String className) {
        if (className == null) {
            throw new IllegalArgumentException("ERROR <SimulationPeriod.setSimulationRunClass()> : Null Class name!");
        }
        if (className.equals("")) {
            throw new IllegalArgumentException("ERROR <SimulationPeriod.setSimulationRunClass()> : Blank Class name!");
        }
        try {
            Class<?> rClass = Class.forName(className);
            this.m_simulationRunClass = className;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("ERROR <SimulationPeriod.setSimulationRunClass()> : Class not found for class name " + className);
        }
    }

    public String getSimulationRunClass() {
        return this.m_simulationRunClass;
    }

    public String getSimulationAppType() {
        return this.m_appType;
    }

    public void setSimulationAppType(String appType) {
        if (appType == null || appType.equals("")) {
            throw new IllegalArgumentException("ERROR <SimulationPeriod.setSimulationAppType()> : Invalid app type parameter. AppType can't be blank or null");
        }
        this.m_appType = appType;
    }

    protected void unloadAlternatives() {
        if (this._simRuns.size() > 0) {
            for (int i = 0; i < this._simRuns.size(); ++i) {
                SimulationRun simRun = this._simRuns.get(i);
                this.unloadManager(this.getSimulationAppType(), simRun.getIdentifier());
            }
        }
        this._simRuns.clear();
    }

    public void setAlternatives(String[] alts) {
        int j;
        int i;
        this.unloadAlternatives();
        this.printMessage("Setting the " + this._simType + " Runs for this " + this._simType);
        if (alts == null || alts.length == 0) {
            System.out.println("An empty list of alternatives is being set");
            return;
        }
        if (this.m_simulationRunClass == null || this.m_simulationRunClass.equals("")) {
            String error = "ERROR <SimulationPeriod.setAlternatives()> : " + this._simType + " Run Class is not Defined";
            this._userInterface.printErrorMessage(error);
            throw new RuntimeException(error);
        }
        if (this.m_appType == null || this.m_appType.equals("")) {
            String error = "ERROR <SimulationPeriod.setAlternatives()> : Application Type is not Defined";
            this._userInterface.printErrorMessage(error);
            throw new RuntimeException(error);
        }
        Vector<Identifier> eSimulationRunIds = this._proxyList.getManagerIDList(this.m_simulationRunClass);
        if (eSimulationRunIds == null || eSimulationRunIds.size() == 0) {
            this._userInterface.printErrorMessage("There are no " + this._simType + " Runs created.  Create one before trying to run a " + this._simType);
            return;
        }
        String[] a = new String[alts.length];
        System.arraycopy(alts, 0, a, 0, alts.length);
        SimRunInfo[] newAlts = new SimRunInfo[alts.length];
        for (i = 0; i < a.length; ++i) {
            for (j = 0; j < this._alternativeNames.length; ++j) {
                if (a[i].equals("") || !a[i].equals(this._alternativeNames[j].getName())) continue;
                newAlts[i] = this._alternativeNames[j];
                a[i] = "";
            }
        }
        for (i = 0; i < a.length; ++i) {
            if (a[i].equals("") || newAlts[i] != null) continue;
            newAlts[i] = new SimRunInfo(a[i]);
            this.setProgress(0);
            this.printMessage("Creating New Base Model Trial for " + a[i]);
            boolean found = false;
            Identifier id = null;
            for (j = 0; j < eSimulationRunIds.size(); ++j) {
                id = eSimulationRunIds.get(j);
                if (id == null || !id.getName().equals(a[i])) continue;
                found = true;
                break;
            }
            if (!found) continue;
            SimulationRun simRun = (SimulationRun)this._proxyList.openManager(id);
            SimulationRun newRun = this.newBaseModelTrial(simRun, 1);
            if (newRun == null) {
                System.out.println("--------------------------------------------------------------------------------");
                System.out.println("Could not create new base mode run!  Check SimulationPeriod.setAlternatives");
                System.out.println("--------------------------------------------------------------------------------");
                continue;
            }
            newAlts[i].setIndex(newRun.getIndex());
            this.saveManagerAs(this.m_appType, newRun, newRun.getIdentifier());
            this._proxyList.unloadManager(id);
        }
        this.writeTrials();
        this._trials.clear();
        this._alternativeNames = new SimRunInfo[newAlts.length];
        System.arraycopy(newAlts, 0, this._alternativeNames, 0, newAlts.length);
        this.setModified(true);
        this.setProgress(4);
        this.saveStreamAlignment();
        try {
            this.printMessage("Copying Program Order...");
            SupplementalRmiWorkspace caviSupRmiWksp = (SupplementalRmiWorkspace)((RmiWorkspace)this._Workspace.getRemote()).getChildWorkspace("supplemental");
            Vector models = caviSupRmiWksp.getModels(this.m_appType);
            SupplementalRmiWorkspace mySupRmiWksp = (SupplementalRmiWorkspace)this._managerRmiWorkspace.getChildWorkspace("supplemental");
            mySupRmiWksp.setModels(models, UserId.getUserId());
        }
        catch (RemoteException re) {
            System.out.println("setAlternatives: RMI Error copying Program Order " + re);
        }
        this.unloadAlternatives();
        this.setModified(true);
    }

    public boolean saveStreamAlignment() {
        this.printMessage("Saving StreamAlignment...");
        String wkspPath = "";
        wkspPath = this.getWorkspacePath();
        wkspPath = wkspPath.concat("/");
        StreamAlignment wkspAlignment = (StreamAlignment)this._proxyList.openManager("main", new Identifier(wkspPath + "stream.align"));
        StreamAlignment ourAlignment = this.getStreamAlignment();
        boolean rv = false;
        if (wkspAlignment != null) {
            if (this._alignment.readFile(wkspAlignment.getIdentifier())) {
                rv = this.saveManager(this._alignment);
            }
            this._proxyList.unloadManager(wkspAlignment.getIdentifier());
        }
        return rv;
    }

    protected SimulationRun newBaseModelTrial(SimulationRun run, int numRuns) {
        AltItem altItem;
        SimulationRun newRun = (SimulationRun)this.newManager(this.m_appType, ((Object)((Object)run)).getClass().getName());
        if (newRun == null) {
            return null;
        }
        newRun.setSimulation(this);
        int indexSave = newRun.getIndex();
        Identifier id = newRun.getIdentifier();
        newRun.readFile(run.getIdentifier());
        newRun.setIndex(indexSave);
        id.setName(this.createBaseTrialName(run));
        id.setPath(this.m_appType + "/" + RMAIO.userNameToFileName((String)id.getName()));
        newRun.setName(id.getName());
        newRun.setUserName(run.getUserName());
        Vector<AltItem> altList = run.getAltList();
        if (altList != null) {
            int size = altList.size();
            for (int i = 0; i < size; ++i) {
                altItem = altList.get(i);
                ModelAlt alt = run.getModelAlt(altItem.getProgram());
                if (alt == null) continue;
                this.addModelTrial(altItem.getProgram(), alt.getAltId(), 0);
            }
        }
        id.setPath(this.getSimulationPath() + "/" + this.m_appType + "/" + RMAIO.userNameToFileName((String)run.getName()) + newRun.getFileExtension());
        if (this.saveManager(this.m_appType, newRun)) {
            if (newRun instanceof TrialRun) {
                this._trialList.add(newRun.getName());
            }
            this.copyTrialDataFiles(newRun, this._proxyList, run.getAltList(), numRuns);
            altList = newRun.getAltList();
            String name = newRun.getName();
            int keyLength = this.getKeyLength();
            int maxKeyLength = this.getMaxAlternativeNameLength();
            for (int i = 0; i < altList.size(); ++i) {
                int end;
                int start;
                String key;
                altItem = altList.get(i);
                if (altItem == null) continue;
                if (altItem.getAltIndex() == -1 || this._allTrials.get(key = name.substring(start = i * maxKeyLength, end = i * maxKeyLength + maxKeyLength) + ":" + altItem.getModelPosition()) != null) continue;
                this._allTrials.put(key, altItem);
            }
            this.setModified(true);
        }
        return newRun;
    }

    @Override
    public Vector getModelTrials(String program, String id) {
        return this.getModelTrials(program, id, false, false);
    }

    @Override
    public Vector getUnusedModelTrials(String program, String id) {
        return this.getModelTrials(program, id, false, true);
    }

    private Vector getModelTrials(String program, String id, boolean create, boolean returnOnlyUnused) {
        Vector v;
        Vector modelTrialList = new Vector();
        if (program == null || id == null) {
            return modelTrialList;
        }
        Hashtable idtable = (Hashtable)this._modelTrials.get(program);
        if (idtable == null) {
            if (create) {
                idtable = new Hashtable();
                this._modelTrials.put(program, idtable);
                this.setModified(true);
            } else {
                return modelTrialList;
            }
        }
        if ((v = (Vector)idtable.get(id)) == null && create) {
            idtable.put(id, new Vector());
            this.setModified(true);
        } else if (v != null) {
            if (returnOnlyUnused) {
                SimulationRun run;
                ArrayList<SimulationRun> runs = new ArrayList<SimulationRun>();
                Vector<SimulationRun> simRuns = this.getSimulationRuns();
                runs.addAll(simRuns);
                for (int i = 0; i < simRuns.size(); ++i) {
                    run = (SimulationRun)((Object)simRuns.get(i));
                    Vector trials = run.getTrials();
                    runs.addAll(trials);
                }
                Vector modelTrials = this.getModelTrials(program, id, create, false);
                for (int i = 0; i < runs.size(); ++i) {
                    run = (SimulationRun)((Object)runs.get(i));
                    String key = run.getKey();
                    modelTrials.remove(key);
                }
                return modelTrials;
            }
            modelTrialList.addAll(v);
        }
        return modelTrialList;
    }

    public boolean addModelTrial(String program, String id, int num) {
        if (program == null || id == null || num < 0) {
            return false;
        }
        this.getModelTrials(program, id, true, false);
        Hashtable idtable = (Hashtable)this._modelTrials.get(program);
        Vector v = (Vector)idtable.get(id);
        Object trial = this.createBaseTrialName(id);
        trial = ((String)trial).substring(0, ((String)trial).length() - 1) + num;
        if (v.contains(trial)) {
            return false;
        }
        v.add(trial);
        this.setModified(true);
        return true;
    }

    private AltItem createTrialData(AltItem altItem, ManagerProxyList proxyList, String modelId, boolean useSimulationWksp) {
        String dir = this.getSimulationPath();
        AltItem newAltItem = (AltItem)altItem.clone();
        if (altItem.getAltIndex() == -1) {
            return newAltItem;
        }
        String program = altItem.getProgram();
        if ((program = WorkspaceNameFactory.getWorkspaceName((String)program, (boolean)true)) == null) {
            program = "supplemental";
        }
        try {
            AltItem returnedAltItem;
            this.getChildWorkspace(program);
            if (program.equals("mfp")) {
                this.getChildWorkspace("hfp");
            }
            if (useSimulationWksp) {
                String path = this.getWorkspacePath();
                returnedAltItem = this._managerRmiWorkspace.copyModelAltTo(this.m_appType, "hec.watershed.model.ModelAlt", dir, altItem, modelId);
            } else {
                returnedAltItem = ((RmiWorkspace)this._Workspace.getRemote()).copyModelAltTo(this.m_appType, "hec.watershed.model.ModelAlt", dir, altItem, modelId);
            }
            newAltItem = new AltItem(returnedAltItem);
            return newAltItem;
        }
        catch (IllegalArgumentException iae) {
            System.out.println("createTrialData: error returned from copyModelAltTo:" + iae);
            return newAltItem;
        }
        catch (RemoteException re) {
            System.out.println("createTrialData: RMI Error on copyModelAltTo:" + re);
            return newAltItem;
        }
    }

    protected void copyTrialDataFiles(SimulationRun run, ManagerProxyList proxyList, Vector altList, int numRuns) {
        if (run == null || altList == null) {
            return;
        }
        String dir = this.getSimulationPath();
        SimulationRun parent = run;
        if (run instanceof SimulationTrialRun) {
            parent = ((SimulationTrialRun)run).getRunParent();
        }
        if (parent == null) {
            return;
        }
        int size = altList.size();
        String name = run.getName();
        Vector<AltItem> newAltList = new Vector<AltItem>(altList.size());
        if (proxyList == null) {
            proxyList = this._proxyList;
        }
        int percent = 80 / numRuns;
        percent /= size;
        boolean current = false;
        int keyLength = this.getKeyLength();
        int maxKeyLength = this.getMaxAlternativeNameLength();
        for (int i = 0; i < size; ++i) {
            AltItem newAltItem;
            AltItem altItem = (AltItem)altList.get(i);
            if (altItem == null) continue;
            if (altItem.getAltIndex() == -1) {
                newAltList.add(altItem);
                continue;
            }
            int start = i * keyLength;
            int end = i * keyLength + keyLength;
            String modelId = name.substring(start, end);
            String trialKey = name.substring(start, end) + ":" + altItem.getModelPosition();
            System.out.println("name = [" + name + "] modelId=[" + modelId + "]");
            TrialReference trialRef = (TrialReference)this._currentTrials.get(trialKey);
            if (trialRef == null) {
                newAltItem = this.createTrialData(altItem, proxyList, modelId, false);
                this.acceptTrial(run, newAltItem, i, modelId);
            } else if (trialRef.modelPosition != i) {
                newAltItem = altItem;
            } else {
                newAltItem = (AltItem)altItem.clone();
                newAltItem.setAltIndex(trialRef.mgrIndex);
            }
            newAltList.add(newAltItem);
            this.setProgress(percent);
        }
        run.setAltList(newAltList);
    }

    private String createBaseTrialName(SimulationRun run) {
        int maxNameLength = this.getMaxAlternativeNameLength();
        int keyLength = this.getKeyLength();
        int multiplier = 1;
        if (run.getAltList().size() > 1) {
            multiplier = run.getAltList().size();
        }
        if (multiplier > 1) {
            keyLength = (maxNameLength *= multiplier) + multiplier;
        }
        return this.createBaseTrialName(run.getName(), maxNameLength, keyLength);
    }

    public String createBaseTrialName(String name) {
        int maxNameLength = this.getMaxAlternativeNameLength();
        int keyLength = this.getKeyLength();
        return this.createBaseTrialName(name, maxNameLength, keyLength);
    }

    private String createBaseTrialName(String name, int maxNameLength, int keyLength) {
        if (name.length() < keyLength) {
            int runPartLength = this.getMaxAlternativeNameLength();
            if (name.length() > runPartLength) {
                int num = name.length() / runPartLength;
                Object newName = "";
                int cnt = 1;
                for (int i = 0; i < num; ++i) {
                    String n = name.substring(i * runPartLength, runPartLength * cnt);
                    StringBuffer strbuf = new StringBuffer(n);
                    for (int j = n.length(); j < runPartLength + 1; ++j) {
                        strbuf.append('-');
                    }
                    strbuf.setCharAt(runPartLength, '0');
                    newName = (String)newName + strbuf.toString();
                    ++cnt;
                }
                return newName;
            }
            StringBuffer strbuf = new StringBuffer(name);
            for (int i = name.length(); i < keyLength; ++i) {
                strbuf.append('-');
            }
            strbuf.setCharAt(keyLength - 1, '0');
            return strbuf.toString();
        }
        int length = name.length() / keyLength;
        char[] newName = new char[length += name.length()];
        char[] runName = name.toCharArray();
        int j = 0;
        for (int i = 0; i < runName.length; i += keyLength) {
            System.arraycopy(runName, i, newName, j * maxNameLength, keyLength);
            int c = runName[i] == '-' ? 45 : 48;
            newName[++j * maxNameLength - 1] = c;
        }
        return new String(newName);
    }

    public String getReferenceResultsPath() {
        Object path = this.getSimulationPath();
        path = ((String)path).concat("/referenceResults/") + this.m_appType;
        return path;
    }

    @Override
    public String getSimulationPath() {
        if (this.m_simulationPath == null || this.m_simulationPath.length() == 0) {
            this.m_simulationPath = this.m_appType.concat("/").concat(RMAIO.userNameToFileName((String)this.getName()));
        }
        if (RMAIO.isFullPath((String)this.m_simulationPath)) {
            return this.m_simulationPath;
        }
        String wPath = this.getWorkspacePath();
        if (wPath == null) {
            return null;
        }
        wPath = wPath.concat("/").concat(this.m_simulationPath);
        return wPath;
    }

    @Override
    public String getWorkspacePath() {
        if (this.m_workspacePath != null && this.m_workspacePath.length() > 0) {
            return this.m_workspacePath;
        }
        RmiWorkspace data = (RmiWorkspace)this._Workspace.getRemote();
        if (data == null) {
            return null;
        }
        try {
            String path = data.getWorkspacePath();
            return path;
        }
        catch (Exception e) {
            System.out.println("SimulationPeriod.getWorkspacePath: unable to get Workspace path" + e);
            return null;
        }
    }

    @Override
    public StreamAlignment getStreamAlignment() {
        if (this._alignment != null) {
            return this._alignment;
        }
        Vector<Identifier> idlist = this.getManagerIDList(StreamAlignment.class.getName());
        if (idlist.size() <= 0) {
            this._alignment = (StreamAlignment)this.newManager(StreamAlignment.class.getName());
            this._alignment.setName("StreamAlignment");
            Identifier id = this._alignment.getIdentifier();
            id.setPath("stream.align");
            this.saveManager(this._alignment);
        } else {
            Identifier id = idlist.elementAt(0);
            if (id != null) {
                this._alignment = (StreamAlignment)this.openManager(id);
                if (this._alignment.getName() == "Untitled") {
                    this._alignment.setName("StreamAlignment");
                }
            }
        }
        return this._alignment;
    }

    public void writeTrials() {
        int size = this._trials.size();
        for (int i = 0; i < size; ++i) {
            TrialRun trial = (TrialRun)this._trials.get(i);
            if (trial == null || !trial.isModified()) continue;
            trial.writeFile(trial.getIdentifier());
        }
    }

    public TrialRun getTrialRunByUserName(String trialUserName) {
        if (trialUserName == null) {
            return null;
        }
        Vector v = this.getTrialRuns();
        int size = v.size();
        if (size == 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            TrialRun trialRun = (TrialRun)v.get(i);
            if (!(trialRun instanceof SimulationTrialRun) || !((SimulationTrialRun)trialRun).getUserName().equals(trialUserName)) continue;
            return trialRun;
        }
        return null;
    }

    public TrialRun getTrialRun(String trialName) {
        if (trialName == null) {
            return null;
        }
        Vector v = this.getTrialRuns();
        int size = v.size();
        if (size == 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            TrialRun trialRun = (TrialRun)v.get(i);
            if (!trialRun.getName().equals(trialName)) continue;
            return trialRun;
        }
        return null;
    }

    public Vector getTrialRuns() {
        ManagerProxyList proxyList = this.getManagerProxyList(this.m_appType);
        SimulationRun simRun = null;
        try {
            Class<?> rClass = Class.forName(this.m_simulationRunClass);
            simRun = (SimulationRun)((Object)rClass.newInstance());
        }
        catch (Exception e) {
            System.out.println("ERROR <SimulationPeriod.getTrialRuns()> : Exception Occured while trying to get the trial run class name");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        Vector<Identifier> idList = proxyList.getManagerIDList(simRun.getTrialRunClassName());
        int size = idList.size();
        if (this._trials.size() == idList.size()) {
            return (Vector)this._trials.clone();
        }
        for (int i = 0; i < size; ++i) {
            Identifier id = idList.get(i);
            TrialRun trialRun = (TrialRun)((Object)proxyList.openManager(id));
            trialRun.setSimulation(this);
            this._trials.add(trialRun);
            if (this._trialList.contains(trialRun)) continue;
            this._trialList.add(trialRun.getName());
            this.setModified(true);
        }
        return (Vector)this._trials.clone();
    }

    Identifier findManagerID2(Vector idlist, String idname) {
        Identifier id = null;
        if (idlist == null) {
            return null;
        }
        for (int i = 0; i < idlist.size(); ++i) {
            id = (Identifier)idlist.elementAt(i);
            if (id == null) continue;
            String name = RMAIO.getFileFromPath((String)id.getPath());
            String ext = RMAIO.getFileExtension((String)name);
            if (!(name = RMAIO.replace((String)name, (String)ext, (String)"")).equals(idname)) continue;
            return id;
        }
        return null;
    }

    public Identifier findManagerID(Vector idlist, String idname) {
        Identifier id = null;
        for (int i = 0; i < idlist.size(); ++i) {
            id = (Identifier)idlist.elementAt(i);
            if (id == null || !id.getName().equals(idname)) continue;
            return id;
        }
        return null;
    }

    @Override
    public void loadWorkspace(String remoteRegistry, String baseDir) {
        RmiWorkspace workspace = (RmiWorkspace)this._Workspace.getRemote();
        if (workspace == null) {
            return;
        }
        try {
            String simName = RMAIO.userNameToFileName((String)this.getName());
            Identifier id = new Identifier(this.getSimulationPath() + "/" + simName + ".wksp");
            id.setName(simName);
            RmiWorkspace simulationWksp = workspace.openWorkspace(id, remoteRegistry);
            boolean writeVer = false;
            if (simulationWksp == null) {
                simulationWksp = workspace.newWorkspace(id, RMAIO.getDirectoryFromPath((String)this.getSimulationPath()));
                writeVer = true;
            }
            this.setManagerRmiWorkspace(simulationWksp);
            this.m_loaded = true;
        }
        catch (RemoteException re) {
            System.out.println("loadWorkspace: RMI Error loading workspace " + re);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.m_loaded;
    }

    @Override
    public void unloading() {
        if (this.m_loaded) {
            super.unloading();
        }
        this.m_loaded = false;
    }

    @Override
    public void acceptTrial(SimulationRun run, AltItem altItem, int modelPos, String trialKey) {
        if (run == null || altItem == null || trialKey == null || modelPos < 0) {
            return;
        }
        String runKey = trialKey + ":" + altItem.getModelPosition();
        TrialReference trialRef = new TrialReference();
        trialRef.mgrIndex = altItem.getAltIndex();
        trialRef.modelPosition = modelPos;
        trialRef.trialKey = trialKey;
        this._currentTrials.put(runKey, trialRef);
        this.setModified(true);
        Vector<SimulationRun> runs = this.getSimulationRuns();
        for (int i = 0; i < runs.size(); ++i) {
            SimulationRun frun = runs.get(i);
            if (frun == null || frun == run) continue;
            frun.acceptTrial(altItem, modelPos, trialKey, false);
        }
    }

    @Override
    public boolean removeTrial(AltItem altItem, TrialReference trialRef2Remove) {
        Vector trialList;
        Hashtable idtable;
        if (trialRef2Remove == null) {
            return false;
        }
        Enumeration trialRefKeys = this._currentTrials.keys();
        Object key = null;
        boolean found = false;
        while (trialRefKeys.hasMoreElements()) {
            key = trialRefKeys.nextElement();
            TrialReference refInList = (TrialReference)this._currentTrials.get(key);
            if (!refInList.equals(trialRef2Remove)) continue;
            found = true;
            break;
        }
        if (!found) {
            key = null;
        }
        if ((idtable = (Hashtable)this._modelTrials.get(altItem.getProgram())) != null && (trialList = (Vector)idtable.get(altItem.getAltName())) != null && trialList.remove(trialRef2Remove.trialKey)) {
            if (key != null) {
                this._currentTrials.remove(key);
            }
            int keyLength = this.getKeyLength();
            String modelKey = trialRef2Remove.trialKey + ":" + altItem.getModelPosition();
            this._allTrials.remove(modelKey);
            this.setModified(true);
            return true;
        }
        System.out.println("removeTrial: failed to remove TrialReference " + trialRef2Remove + " AltItem=" + altItem);
        return false;
    }

    public void setSimulationTypeString(String simType) {
        this._simType = simType;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String[] getAlternatives() {
        String[] alts = new String[this._alternativeNames.length];
        for (int i = 0; i < this._alternativeNames.length; ++i) {
            alts[i] = this._alternativeNames[i].getName();
        }
        return alts;
    }

    public SimRunInfo[] getAlternativeInfo() {
        return this._alternativeNames;
    }

    @Override
    public Vector<SimulationRun> getSimulationRuns() {
        if (this._simRuns.size() > 0 && this._simRuns.size() == this._alternativeNames.length) {
            return this._simRuns;
        }
        if (this._simRuns.size() != this._alternativeNames.length && this._simRuns.size() > 0) {
            this.unloadAlternatives();
        }
        String[] altNames = this.getAlternatives();
        Vector<Identifier> altidlist = this.getManagerIDList(this.m_appType, this.m_simulationRunClass);
        for (String altname : altNames) {
            Identifier altid = this.findManagerID2(altidlist, altname);
            if (altid == null && (altid = this.findManagerID2(altidlist, altname = RMAIO.userNameToFileName((String)altname))) == null) {
                this.printMessage("Error loading alternative " + altname + ". No Identifier");
                continue;
            }
            SimulationRun alt = (SimulationRun)this.openManager(this.m_appType, altid);
            if (alt == null) {
                this.printMessage("Error loading alternative " + altname + " path=" + altid.getPath());
                continue;
            }
            alt.setSimulation(this);
            this._simRuns.add(alt);
        }
        return this._simRuns;
    }

    public SimulationRun getSimulationRun(String simRunName) {
        if (simRunName == null) {
            return null;
        }
        Vector<SimulationRun> simRuns = this.getSimulationRuns();
        for (int i = 0; i < simRuns.size(); ++i) {
            SimulationRun srun = (SimulationRun)((Object)simRuns.get(i));
            if (srun == null || !simRunName.equals(srun.getUserName())) continue;
            return srun;
        }
        return null;
    }

    @Override
    public boolean compute() {
        throw new UnsupportedOperationException("Method compute() not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean computeRun(SimulationRun run, int lastModel) {
        if (run == null) {
            this.printErrorMessage("Compute on Null Run  Attempted");
            return false;
        }
        if (!this.computeInit()) {
            this.printErrorMessage("Initializing compute failed");
            return false;
        }
        try {
            boolean rv = this.computeRunPrivate(run, lastModel);
            if (rv) {
                this.computeComplete("Compute Complete");
                this.printStatus("Compute Complete");
                this.setProgress(100);
            } else {
                this.computeComplete("Compute Failed");
                this.printStatus("Compute Failed");
            }
            boolean bl = rv;
            return bl;
        }
        finally {
            this._currentComputingRun = null;
            this._progressDisplay = null;
        }
    }

    public boolean computeInit() {
        boolean progressFactor = true;
        this.printMessage("Initializing " + this._simType + " Compute.");
        this.printStatus("Initializing");
        Identifier oldid = this.getIdentifier();
        String fileName = RMAIO.getFileFromPath((String)oldid.getPath());
        String simulationPath = this.getSimulationPath() + "/";
        String simulationfilepath = simulationPath + this.m_appType + "/" + fileName;
        this.printMessage("Saving " + this._simType + " Files...");
        Identifier newid = new Identifier(oldid);
        newid.setPath(simulationfilepath);
        String userName = UserId.getUserId();
        RmiWorkspace wksp = (RmiWorkspace)this._Workspace.getRemote();
        try {
            Identifier tmpid = wksp.openFile(userName, newid);
            if (tmpid == null) {
                tmpid = wksp.newFile(userName, newid);
            }
            newid = tmpid;
        }
        catch (Exception e) {
            this.printErrorMessage("Failed to copy " + this._simType + " file");
            this.printStatus("COMPUTE FAILED");
            return false;
        }
        this.writeFile(newid);
        this.setProgress(10);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean computeRunPrivate(SimulationRun run, int lastModel) {
        if (!run.setLocked(3)) {
            this.printErrorMessage("Failed to get Lock for " + run.getUserName());
            return false;
        }
        try {
            if (!run.setModelsLocked(4)) {
                this.printErrorMessage("Failed to Lock models for " + run.getUserName());
                return false;
            }
        }
        catch (LockFailedException lfe) {
            System.out.println("computeRunPrivate: failed to get Lock for " + run.getUserName() + lfe);
            ClientApp.app();
            RMAIO.postError((Component)((Object)ClientApp.frame()), (String)("Failed to lock models for " + run.getUserName() + "\n" + lfe));
            return false;
        }
        try {
            this._currentComputingRun = run;
            RunTimeWindow rtw = new RunTimeWindow(this.getRunTimeWindow());
            String userName = UserId.getUserId();
            String runname = run.getName();
            this.setLogFile(runname);
            this.printMessage("\n\nPerforming " + this._simType + " for " + runname);
            this.printLogMessage("Starting compute at " + new Date().toString());
            this.printLogMessage("");
            this.printStatus("Performing " + this._simType + " for " + runname);
            Vector<AltItem> altList = run.getAltList();
            int size = lastModel == -1 ? altList.size() : (lastModel >= altList.size() ? altList.size() : lastModel);
            String forecastpath = this.getSimulationPath();
            String stringUrl = this.getUserDisplayUrl();
            boolean computeNext = false;
            for (int a = 0; a < size; ++a) {
                long computeTime;
                this.setTaskNumber(a + 1);
                AltItem altItem = altList.elementAt(a);
                if (altItem == null) continue;
                if (altItem.getAltIndex() == -1) {
                    this.printMessage("No " + altItem.getProgram() + " alternative selected");
                    continue;
                }
                ModelAlt modelAlt = run.getModelAlt(altItem);
                if (modelAlt == null) {
                    this.printErrorMessage("Failed to find Model Alternative for " + altItem.getAltName());
                    boolean bl = false;
                    return bl;
                }
                ModelReference modelRef = modelAlt.getModelRef();
                String program = WorkspaceNameFactory.getWorkspaceName((String)altItem.getProgram());
                ComputeInfo ci = new ComputeInfo();
                ci.altname = run.getName();
                ci.simRunPath = run.getIdentifier().getPath();
                ci.modelRef = modelRef;
                ci.doCompute = this._computeAll || computeNext;
                ci.forecastpath = forecastpath;
                ci.modelAltComputeTime = this.getAltComputeTime(altItem.getAltName() + altItem.getAltIndex(), altItem.getProgram());
                ci.modelAltname = run.getKey();
                ci.runTimeWindow = rtw;
                ci.uiWrapper = this._uiWrapper;
                ci.altIndex = run.getIndex();
                ci.user = userName;
                ci.clientDisplay = stringUrl;
                ci.modelPosition = this.getModelPosition(a, ci.altname);
                ci.programName = program;
                ci.nameMultiplier = this.getKeyLength();
                int inputPos = altItem.getInputPosition();
                ci.inputPosition = inputPos == -1 ? a : inputPos;
                ci.timeZoneOffset = this._proxyList.getGmtOffset();
                ci.computeType = 1;
                ci.outputDSSFileName = this.getOutputDSSFileName();
                ci.print();
                String wkspName = ProgramOrderItem.isStandardModel((String)program) ? program : "supplemental";
                int success = this.computeModel(ci, wkspName);
                try {
                    computeTime = ((RmiWorkspace)this._Workspace.getRemote()).getCurrentTime();
                }
                catch (RemoteException re) {
                    computeTime = System.currentTimeMillis();
                }
                switch (success) {
                    case 2: {
                        this.setAltFailedComputeTime(altItem.getAltName() + altItem.getAltIndex(), altItem.getProgram(), computeTime);
                        boolean bl = false;
                        return bl;
                    }
                    case 1: {
                        computeNext = false;
                        break;
                    }
                    case 0: {
                        this.setAltComputeTime(altItem.getAltName() + altItem.getAltIndex(), altItem.getProgram(), computeTime);
                        computeNext = true;
                        break;
                    }
                    case 3: {
                        this.setAltCanceledComputeTime(altItem.getAltName() + altItem.getAltIndex(), altItem.getProgram(), computeTime);
                        this.printErrorMessage("Compute Canceled by User");
                        computeNext = false;
                        boolean bl = false;
                        return bl;
                    }
                }
                this.setLastComputeTime(run.getIndex(), computeTime);
            }
        }
        finally {
            run.setLocked(1);
            try {
                run.setModelsLocked(5);
            }
            catch (LockFailedException lfe) {
                System.out.println("ComputeRunPrivate: lock exception " + lfe);
            }
        }
        return true;
    }

    protected int getModelPosition(int a, String altname) {
        return a + 1;
    }

    public SimulationRun getCurrentComputingRun() {
        return this._currentComputingRun;
    }

    public void setLastComputeTime(int index, long computeTime) {
        for (int i = 0; i < this._alternativeNames.length; ++i) {
            if (this._alternativeNames[i] == null || this._alternativeNames[i].getIndex() != index) continue;
            this._alternativeNames[i].setLastComputeTime(computeTime);
        }
    }

    public long getLastComputeTime(int index) {
        for (int i = 0; i < this._alternativeNames.length; ++i) {
            if (this._alternativeNames[i] == null || this._alternativeNames[i].getIndex() != index) continue;
            return this._alternativeNames[i].getLastComputeTime();
        }
        return 0L;
    }

    public String getLastComputeTimeString(int index) {
        System.out.println("Looking for compute time for " + index);
        long lastComputeTime = this.getLastComputeTime(index);
        if (lastComputeTime <= 0L) {
            return "";
        }
        return new Date(lastComputeTime).toString().substring(4);
    }

    private void setLogFile(String altname) {
        if (this._progressDisplay == null) {
            System.out.println("setLogFile: no progress display");
            return;
        }
        altname = RMAIO.userNameToFileName((String)altname);
        RmiFileManager fileMgr = this.getFileManager();
        if (fileMgr == null) {
            return;
        }
        String ext = this.getLogFileExtension();
        String logFile = this.getSimulationPath() + "/" + this.m_appType + "/" + altname + ext;
        Identifier id = new Identifier(logFile);
        try {
            Identifier id2 = fileMgr.openFile(UserId.getUserId(), id);
            if (id2 == null) {
                id2 = fileMgr.newFile(UserId.getUserId(), id);
            }
            if (id2 == null) {
                this.printWarningMessage("Failed to get log file");
                return;
            }
            System.out.println("setLogFile: logfile now " + logFile);
            this._progressDisplay.setLogFile(id2.getFile());
        }
        catch (RemoteException re) {
            System.out.println("setLogFile: rmi error opening/creating logfile " + re);
            this.printWarningMessage("Error opening/creating logfile");
        }
    }

    private String getLogFileExtension() {
        HECProperties prop = null;
        if (ClientAppCheck.haveClientApp()) {
            prop = ClientApp.app().getProperties();
        }
        if (prop == null) {
            return ".log";
        }
        String s = prop.getProp("client.useHtmlForLogs");
        if (s != null && s.equalsIgnoreCase("true")) {
            return ".html";
        }
        return ".log";
    }

    public boolean runExtract(SimulationExtract extract) {
        this._extract = extract;
        if (this._extract != null) {
            return this._extract.runExtract(this);
        }
        return false;
    }

    public SimulationExtract getSimulationExtract(ManagerProxyListContainer wksp) {
        if (this._extract != null) {
            this._extract.setWorkspace(wksp);
        }
        return this._extract;
    }

    public int getKeyLength() {
        return this._keyLength;
    }

    public void setKeyLength(int length) {
        if (length > 0) {
            this._keyLength = length;
        }
    }

    public int getMaxAlternativeNameLength() {
        return this._maxAlternativeNameLength;
    }

    public void setMaxAlternativeNameLength(int length) {
        if (length > 0) {
            this._maxAlternativeNameLength = length;
        }
    }

    public void reloadManagers() {
        ManagerProxyList managers = this.getManagerProxyList("rss");
        for (int i = 0; managers != null && i < managers.size(); ++i) {
            ManagerProxy proxy = (ManagerProxy)managers.get(i);
            if (proxy == null) continue;
            if (proxy.getManager() != null && proxy.getManager().isModified()) {
                proxy.getManager().reLoadFile();
                continue;
            }
            if (proxy.getManager() == null) continue;
            proxy.getManager().setModified(false);
        }
    }

    @Override
    public void deleting() {
        block9: {
            String simPath = this.getSimulationPath();
            Vector<String> v = new Vector<String>(1);
            v.add("*.dss");
            if (simPath != null) {
                try {
                    if (this.getFileManager().fileExists(simPath)) {
                        System.out.println("deleting:deleting directory " + simPath);
                        this.getFileManager().deleteDirectory(simPath);
                    }
                    if (!this.getFileManager().fileExists(simPath)) break block9;
                    try {
                        Vector dssFileIds = this.getFileManager().getRemoteFileIDList(UserId.getUserId(), simPath, v, true);
                        if (dssFileIds != null && dssFileIds.size() > 0) {
                            Identifier id;
                            Iterator iter = dssFileIds.iterator();
                            while (iter.hasNext()) {
                                id = (Identifier)iter.next();
                                if (id.isDirectory()) continue;
                                this.getDSSFileManager().close(id.getPath());
                                this.getFileManager().deleteFile(id.getPath());
                                iter.remove();
                            }
                            for (int i = 0; i < dssFileIds.size(); ++i) {
                                id = (Identifier)dssFileIds.get(i);
                                this.getFileManager().deleteFile(id.getPath());
                            }
                            this.getFileManager().deleteFile(simPath);
                        }
                    }
                    catch (RemoteException e) {
                        System.out.println("deleting:RMI error trying to delete dss files from simulation directory " + simPath + " Error:" + e);
                    }
                }
                catch (RemoteException re) {
                    System.out.println("deleting:RemoteException while deleting " + this._simType + " directory " + re);
                }
            }
        }
        super.deleting();
    }

    @Override
    protected void closeWorkspace() {
        super.closeWorkspace();
        this._simRuns.clear();
        this._trials.clear();
        this._currentComputingRun = null;
        this.m_loaded = false;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

