/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ManagerProxyListContainer;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.ModelForecastAlt;
import hec.clientapp.model.Simulation;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationTrialRun;
import hec.clientapp.model.TrialRun;
import hec.event.ModifiableListener;
import hec.io.AsciiSerializable;
import hec.io.FileLock;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.LockFailedException;
import hec.lang.ModelReference;
import hec.lang.UserId;
import hec.lang.WorkspaceNameFactory;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldRect;
import hec.map.crs.CoordinateReferenceSystem;
import hec.model.AltItem;
import hec.model.ModelConstants;
import hec.model.TrialReference;
import hec.supplemental.model.ProgramOrderItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.lang.Modifiable;
import rma.util.RMAIO;

public abstract class SimulationRun
extends Manager
implements AsciiSerializable,
MapObjectInterface,
ModifiableListener,
ModelConstants {
    private static int MODEL_NAME_LENGTH = 11;
    public static final String NO_SELECTION = "-NONE-";
    public static final String FILE_EXT = ".simrun";
    private static String DEFAULT_MODEL_ALT_CLASSNAME = ModelAlt.class.getName();
    private String _userName;
    protected transient String _baseRunName;
    protected Vector<AltItem> _altList = new Vector();
    protected Vector _trialList = new Vector();
    protected transient Vector _trials = new Vector();
    private int _version = 3;
    private boolean _computeInundation = false;
    private long _lastComputeTime = 0L;
    private transient String _toString = null;
    protected transient Hashtable _modelForecastAltMgrs = new Hashtable();
    private long _configurationId = -1L;
    private transient boolean _altListInitd = false;
    private boolean _activeRun = false;
    private boolean _selectedRun = false;
    private transient Simulation _simulation = null;
    private transient MapIdentifier _mapId;
    private boolean _expanded;

    @Override
    public void init() {
    }

    @Override
    public String toString() {
        return this.getUserName();
    }

    public int getAlternativeNameLength() {
        if (this._simulation instanceof SimulationPeriod) {
            return ((SimulationPeriod)this._simulation).getMaxAlternativeNameLength();
        }
        return MODEL_NAME_LENGTH;
    }

    public int getModelNameLength() {
        if (this._simulation instanceof SimulationPeriod) {
            return ((SimulationPeriod)this._simulation).getKeyLength();
        }
        return MODEL_NAME_LENGTH;
    }

    public abstract String getModelAltWorkspaceName();

    public String getModelAltClassName() {
        return DEFAULT_MODEL_ALT_CLASSNAME;
    }

    public ModelForecastAlt getRasModelForecastAlt() {
        return (ModelForecastAlt)this.getModelAlt("RAS");
    }

    protected ModelReference getRasModelReference() {
        ModelForecastAlt alt = this.getRasModelForecastAlt();
        if (alt != null) {
            return alt.getModelRef();
        }
        return null;
    }

    public abstract String getTrialRunClassName();

    public void setSimulation(Simulation sim) {
        this._simulation = sim;
    }

    public Simulation getSimulation() {
        return this._simulation;
    }

    public boolean acceptTrial(AltItem altItem, int pos, String newTrialKey, boolean propagate) {
        if (altItem == null || pos < -1 || newTrialKey == null) {
            return false;
        }
        String name = this.getName();
        if (name.length() < pos + 1) {
            return false;
        }
        char[] array = name.toCharArray();
        int idx = pos * this.getModelNameLength();
        for (int i = 0; i < this.getModelNameLength() - 1; ++i) {
            if (array[i + idx] == newTrialKey.charAt(i)) continue;
            return false;
        }
        this._altList.set(pos, altItem);
        this.unloading();
        for (int j = 0; j < newTrialKey.length(); ++j) {
            array[idx + j] = newTrialKey.charAt(j);
        }
        this.setName(new String(array));
        if (propagate && this._simulation != null) {
            this._simulation.acceptTrial(this, altItem, altItem.getModelPosition() - 1, newTrialKey);
        }
        return true;
    }

    public void setName(String forecastName) {
        super.setName(forecastName);
        this._toString = null;
    }

    public void setDescription(String forecastDescription) {
        super.setDescription(forecastDescription);
        this._toString = null;
    }

    public void setConfigurationId(long configId) {
        this._configurationId = configId;
    }

    public long getConfigurationId() {
        return this._configurationId;
    }

    public Vector getTrials() {
        if (this._trials.size() != this._trialList.size()) {
            TrialRun trialRun;
            for (int i = 0; i < this._trials.size(); ++i) {
                trialRun = (TrialRun)this._trials.get(i);
                if (trialRun == null) continue;
                this._proxyList.unloadManager(trialRun.getIdentifier());
            }
            this._trials.clear();
            Iterator iter = this._trialList.iterator();
            while (iter.hasNext()) {
                TrialReference ref = (TrialReference)iter.next();
                if (ref == null) {
                    iter.remove();
                    continue;
                }
                trialRun = (TrialRun)((Object)this._proxyList.openManager(this.getTrialRunClassName(), ref.mgrIndex));
                if (trialRun != null) {
                    trialRun.setRunParent(this);
                    trialRun.setSimulation(this.getSimulation());
                    this._trials.add(trialRun);
                    continue;
                }
                iter.remove();
            }
        }
        return this._trials;
    }

    public void setComputeInundation(boolean compute) {
        this._computeInundation = compute;
        this.setModified(true);
    }

    public boolean getComputeInundation() {
        return this._computeInundation;
    }

    public Vector<AltItem> getAltItems(String programName) {
        if (programName == null) {
            return null;
        }
        Vector<AltItem> v = this.getAltList();
        if (v == null || v.size() < 1) {
            return null;
        }
        Vector<AltItem> items = new Vector<AltItem>();
        for (int i = 0; i < v.size(); ++i) {
            AltItem altItem = v.elementAt(i);
            if (altItem == null || altItem.getProgram() == null || !altItem.getProgram().equalsIgnoreCase(programName)) continue;
            altItem.setModelPosition(i + 1);
            items.addElement(altItem);
        }
        return items;
    }

    public String getModel(String programName) {
        ModelAlt alt = this.getModelAlt(programName);
        if (alt == null) {
            return null;
        }
        ModelReference ref = alt.getModelRef();
        ManagerProxy proxy = this._proxyList.getManagerProxy(WorkspaceNameFactory.getWorkspaceName((String)ref.wkspName), ref.className, ref.newId);
        if (proxy != null) {
            return proxy.getName();
        }
        return null;
    }

    public ModelAlt getModelAlt(String programName) {
        if (programName == null) {
            return null;
        }
        Vector<AltItem> v = this.getAltList();
        if (v == null || v.size() < 1) {
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            AltItem altItem = v.elementAt(i);
            if (altItem == null || !programName.equalsIgnoreCase(altItem.getProgram())) continue;
            Object obj = this._modelForecastAltMgrs.get(altItem);
            if (obj != null) {
                return (ModelAlt)obj;
            }
            Manager mgr = this._proxyList.openManager(this.getModelAltWorkspaceName(), this.getModelAltClassName(), altItem.getAltIndex());
            if (mgr != null) {
                this._modelForecastAltMgrs.put(altItem, mgr);
            }
            return (ModelAlt)mgr;
        }
        return null;
    }

    public boolean usesModeltAlt(ModelAlt malt) {
        if (malt == null) {
            return false;
        }
        for (int i = 0; i < this._altList.size(); ++i) {
            ModelAlt alt;
            AltItem altItem = this._altList.get(i);
            if (altItem == null || !altItem.getProgram().equalsIgnoreCase(malt.getModelRef().wkspName) || (alt = this.getModelAlt(altItem)) == null || !alt.getModelRef().equals(malt.getModelRef())) continue;
            return true;
        }
        return false;
    }

    public boolean hasModelAlt(String program, int index) {
        if (program == null || index < 0) {
            return false;
        }
        for (int i = 0; i < this._altList.size(); ++i) {
            AltItem altItem = this._altList.get(i);
            if (altItem == null || altItem.getAltIndex() != index || !altItem.getProgram().equalsIgnoreCase(program)) continue;
            return true;
        }
        return false;
    }

    public String getIdForModelAlt(ModelAlt alt) {
        ModelReference ref = alt.getModelRef();
        if (ref == null) {
            return null;
        }
        String program = ref.wkspName;
        int idx = alt.getIndex();
        if (!this.hasModelAlt(program, idx)) {
            return null;
        }
        for (int i = 0; i < this._altList.size(); ++i) {
            AltItem altItem = this._altList.get(i);
            if (altItem == null || altItem.getAltIndex() != idx || !altItem.getProgram().equalsIgnoreCase(program)) continue;
            String id = this.getName().substring(0, i * this.getModelNameLength() + this.getModelNameLength());
            return id;
        }
        return null;
    }

    public ModelAlt getModelAlt(AltItem altItem) {
        if (altItem == null) {
            return null;
        }
        if (altItem.getAltIndex() == -1) {
            return null;
        }
        Object obj = this._modelForecastAltMgrs.get(altItem);
        if (obj != null) {
            return (ModelAlt)obj;
        }
        Manager mgr = this._proxyList.openManager(this.getModelAltWorkspaceName(), this.getModelAltClassName(), altItem.getAltIndex());
        if (mgr != null) {
            this._modelForecastAltMgrs.put(altItem, mgr);
        }
        return (ModelAlt)mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(Identifier id) {
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        if (this.getReadOnly()) {
            System.out.println(file.getPath() + " is readonly");
            return true;
        }
        this.setReloadOk(false);
        try {
            BufferedWriter writer = file.getBufferedWriter();
            if (writer == null) {
                boolean bl = false;
                return bl;
            }
            System.out.println("writing " + file.getPath());
            super.writeFile(id);
            HecAsciiSerializer as = new HecAsciiSerializer(writer);
            as.serializeObject((Object)this);
            writer.close();
        }
        catch (Exception e) {
            System.out.println("Unable to write External Alt file -> " + id.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            this.setReloadOk(true);
        }
        this.setModified(false);
        return true;
    }

    @Override
    public boolean reLoadFile(Identifier id) {
        if (this.getReloadOk()) {
            boolean result = this.readFile(id);
            return result;
        }
        return false;
    }

    @Override
    public boolean readFile(Identifier id) {
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        System.out.println("opening " + file.getPath());
        try {
            BufferedReader reader = file.getBufferedReader();
            HecAsciiDeserializer ad = new HecAsciiDeserializer(reader);
            ad.addClassMapping("hec.model.AltItem", AltItem.class.getName());
            ad.deserializeObject((Object)this);
            reader.close();
        }
        catch (Exception e) {
            System.out.println("Error in reading ForecastRun file -> " + id.getPath());
            this.setReadOnly(true);
            return false;
        }
        this.setModified(false);
        return true;
    }

    public String getRunKey(AltItem altItem) {
        if (altItem == null) {
            return null;
        }
        String name = this.getKey();
        int i = this.getAltList().indexOf(altItem);
        if (i < 0) {
            return null;
        }
        return name.substring(0, i * this.getModelNameLength() + this.getModelNameLength());
    }

    public Vector<String> getModelNames(String modelName) {
        Vector<String> names = new Vector<String>();
        if (modelName == null) {
            return names;
        }
        Vector<AltItem> altList = this.getAltList();
        String name = this.getKey();
        modelName = WorkspaceNameFactory.getWorkspaceName((String)modelName);
        for (int i = 0; i < altList.size(); ++i) {
            AltItem altItem = altList.get(i);
            if (altItem == null || altItem.getAltIndex() == -1 || !modelName.equals(altItem.getProgram())) continue;
            names.add(name.substring(0, i * this.getModelNameLength() + this.getModelNameLength()));
        }
        return names;
    }

    protected Manager loadManager(String model, String cls, String name) {
        Manager manager = null;
        try {
            manager = this._proxyList.getContainer().openManagerByName(model, cls, name);
        }
        catch (Exception e) {
            System.out.println("Failed to load manager " + name + "  " + e);
        }
        return manager;
    }

    public void setUserName(String name) {
        this._userName = name;
    }

    public String getUserName() {
        if (this._userName == null) {
            this._userName = this.getName();
        }
        return this._userName;
    }

    public String getBaseRunName() {
        if (this._baseRunName == null) {
            String name = RMAIO.getFileFromPath((String)this.getIdentifier().getPath());
            String ext = RMAIO.getFileExtension((String)name);
            this._baseRunName = RMAIO.replace((String)name, (String)ext, (String)"");
        }
        return this._baseRunName;
    }

    public void setAltList(Vector v) {
        this._altList = v;
        this._altListInitd = false;
        this.setModified(true);
    }

    public Vector<AltItem> getAltList() {
        if (this._altList != null && !this._altListInitd) {
            for (int i = 0; i < this._altList.size(); ++i) {
                this._altList.get(i).setModelPosition(i + 1);
            }
            this._altListInitd = true;
        }
        return this._altList;
    }

    public int getModelCount() {
        if (this._altList == null) {
            return 0;
        }
        int modelCount = 0;
        for (int i = 0; i < this._altList.size(); ++i) {
            AltItem altItem = this._altList.elementAt(i);
            if (altItem.getAltIndex() == -1) continue;
            ++modelCount;
        }
        return modelCount;
    }

    public void setActiveRun(boolean b) {
        this._activeRun = b;
    }

    public boolean isActiveRun() {
        return this._activeRun;
    }

    public void setSelected(boolean b) {
        this._selectedRun = b;
    }

    public boolean isSelected() {
        return this._selectedRun;
    }

    public String getFileExtension() {
        return FILE_EXT;
    }

    public void addTrial(int mgrIndex, int modelPos, String trialKey) {
        TrialReference ref = new TrialReference();
        ref.mgrIndex = mgrIndex;
        ref.modelPosition = modelPos;
        ref.trialKey = trialKey;
        this._trialList.add(ref);
        this.setModified(true);
    }

    public boolean removeTrial(SimulationTrialRun trial2Remove) {
        if (trial2Remove == null) {
            return false;
        }
        Vector trials = this.getTrials();
        for (int i = 0; i < trials.size(); ++i) {
            ManagerProxy altProxy;
            ModelReference mref;
            AltItem altItem;
            TrialRun trial = (TrialRun)trials.get(i);
            if (trial != trial2Remove) continue;
            Simulation sim = this.getSimulation();
            TrialReference tref = (TrialReference)this._trialList.get(i);
            if (sim != null && !sim.removeTrial(altItem = this._altList.get(tref.modelPosition), tref)) {
                return false;
            }
            this._trialList.remove(tref);
            this._proxyList.unloadManager(trial.getIdentifier());
            this._trials.remove(i);
            altItem = trial2Remove.getAltList().get(tref.modelPosition);
            ModelAlt modelAlt = trial2Remove.getModelAlt(altItem);
            if (modelAlt != null) {
                this._proxyList.deleteManager(modelAlt.getIdentifier());
            }
            this._proxyList.deleteManager(trial2Remove.getIdentifier());
            if (modelAlt != null && (mref = modelAlt.getModelRef()) != null && (altProxy = this._proxyList.getManagerProxy(mref.className, mref.newId)) != null && !this._proxyList.deleteManager(altProxy.getId())) {
                System.out.println("removeTrial:failed to delete Alternative " + altProxy.getName());
            }
            this.setModified(true);
            return true;
        }
        System.out.println("removeTrial:Failed to find Trial " + trial2Remove.getUserName() + " in trial list");
        return false;
    }

    public Vector getTrialKeys(int modelPos) {
        Vector<String> keys = new Vector<String>();
        for (int i = 0; i < this._trialList.size(); ++i) {
            TrialReference ref = (TrialReference)this._trialList.get(i);
            if (ref == null || ref.modelPosition != modelPos) continue;
            keys.add(ref.trialKey);
        }
        return keys;
    }

    public boolean areManagersModified() {
        Enumeration e = this._modelForecastAltMgrs.elements();
        while (e.hasMoreElements()) {
            ModelAlt alt = (ModelAlt)e.nextElement();
            if (alt == null || !alt.isManagerModified()) continue;
            return true;
        }
        return false;
    }

    public void saveManagers() {
        Enumeration e = this._modelForecastAltMgrs.elements();
        while (e.hasMoreElements()) {
            ModelAlt alt = (ModelAlt)e.nextElement();
            if (alt == null || !alt.isManagerModified()) continue;
            alt.saveModelManager();
        }
    }

    public boolean setModelsLocked(int lockType) throws LockFailedException {
        int size = this._altList.size();
        for (int i = 0; i < size; ++i) {
            AltItem altItem = this._altList.get(i);
            if (altItem == null || altItem.getAltIndex() == -1) continue;
            ModelAlt alt = this.getModelAlt(altItem);
            if (alt != null) {
                if (alt.setLocked(lockType) || lockType != 4 && lockType != 3 && lockType != 6) continue;
                System.out.println(this.getName() + ".setLocked: Failed to get lock for ModelAlt " + alt.getName());
                System.out.println(this.getName() + ".setLocked: wkspName=" + this.getModelAltWorkspaceName() + " Classname=" + this.getModelAltClassName() + " index=" + altItem.getAltIndex());
                FileLock lock = new FileLock(UserId.getUserId(), lockType);
                FileLock unlock = FileLock.getUnlockForLock((FileLock)lock);
                for (int j = 0; j < i; ++j) {
                    alt = this.getModelAlt(this._altList.get(j));
                    if (alt == null) continue;
                    alt.setLocked(unlock.getLockType());
                }
                if (altItem.getAltName() == null) {
                    throw new LockFailedException("Invalid or blank model alternative at model position " + altItem.getModelPosition());
                }
                throw new LockFailedException("Failed to get Lock for Model Alternative " + alt.getName());
            }
            System.out.println(this.getName() + ".setLocked: Failed to get ModelAlt " + altItem.getAltName());
            System.out.println(this.getName() + ".setLocked: wkspName=" + this.getModelAltWorkspaceName() + " Classname=" + this.getModelAltClassName() + " index=" + altItem.getAltIndex());
            FileLock lock = new FileLock(UserId.getUserId(), lockType);
            FileLock unlock = FileLock.getUnlockForLock((FileLock)lock);
            for (int j = 0; j < i; ++j) {
                alt = this.getModelAlt(this._altList.get(j));
                if (alt == null) continue;
                alt.setLocked(unlock.getLockType());
            }
            if (altItem.getAltName() == null) {
                throw new LockFailedException("Invalid or blank model alternative at model position " + altItem.getModelPosition());
            }
            throw new LockFailedException("Failed to load Model Alternative " + altItem.getAltName());
        }
        return true;
    }

    public String getKey() {
        return this.getName();
    }

    @Override
    public void unloading() {
        ManagerProxyListContainer container = this._proxyList.getContainer();
        if (this._trials.size() > 0) {
            for (int i = 0; i < this._trials.size(); ++i) {
                SimulationRun trial = (SimulationRun)((Object)this._trials.get(i));
                if (trial == null) continue;
                this._proxyList.unloadManager(trial.getIdentifier());
            }
        }
        Enumeration e = this._modelForecastAltMgrs.elements();
        while (e.hasMoreElements()) {
            ModelAlt malt = (ModelAlt)e.nextElement();
            container.unloadManager(this.getModelAltWorkspaceName(), malt.getIdentifier());
        }
        this._modelForecastAltMgrs.clear();
    }

    public void unload() {
    }

    public WorldRect getExtent() {
        WorldRect rc = new WorldRect();
        return rc;
    }

    public void setExtent(WorldRect rect) {
    }

    public MapIdentifier getMapIdentifier() {
        if (this._mapId == null) {
            this._mapId = new MapIdentifier(this.getIdentifier());
            this._mapId.setName("Model Schematic");
            this._mapId.setIsManager(true);
        }
        return this._mapId;
    }

    public void setMapIdentifier(MapIdentifier mapId) {
    }

    public void load() {
        if (this._identifier != null) {
            this.readFile(this._identifier);
        }
    }

    public Vector getProgramOrder() {
        Vector<ProgramOrderItem> v = new Vector<ProgramOrderItem>(this._altList.size());
        for (int i = 0; i < this._altList.size(); ++i) {
            String model;
            ProgramOrderItem poi;
            AltItem altItem = this._altList.get(i);
            if (altItem == null || (poi = "MFP".equalsIgnoreCase(model = altItem.getProgram()) ? (ProgramOrderItem)ProgramOrderItem.MFP_MODEL.clone() : ("HFP".equalsIgnoreCase(model) ? (ProgramOrderItem)ProgramOrderItem.HFP_MODEL.clone() : ("RSS".equalsIgnoreCase(model) ? (ProgramOrderItem)ProgramOrderItem.RSS_MODEL.clone() : ("RAS".equalsIgnoreCase(model) ? (ProgramOrderItem)ProgramOrderItem.RAS_MODEL.clone() : ("FIA".equalsIgnoreCase(model) ? (ProgramOrderItem)ProgramOrderItem.FIA_MODEL.clone() : new ProgramOrderItem(model, false)))))) == null) continue;
            poi.setInputModelNumber(altItem.getInputPosition());
            poi.setIndex(altItem.getModelPosition());
            v.add(poi);
        }
        return v;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get((Object)this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set((Object)this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    public void modifiedStateChanged(Modifiable mgr, boolean modified) {
    }

    protected void notifyModifiableListeners(ModelAlt alt, boolean modified) {
        if (this._modifiableListeners == null) {
            return;
        }
        for (int i = this._modifiableListeners.size() - 1; i >= 0; --i) {
            ((ModifiableListener)this._modifiableListeners.get(i)).modifiedStateChanged((Modifiable)alt, modified);
        }
    }

    public void setExpanded(boolean expanded) {
        this._expanded = expanded;
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public static void setDefaultModelAltClassName(String classname) {
        if (classname == null || classname.trim().isEmpty()) {
            return;
        }
        DEFAULT_MODEL_ALT_CLASSNAME = classname;
    }

    @Override
    public void setModified(boolean modified) {
        super.setModified(modified);
        if (modified && this._simulation != null) {
            this._simulation.setModified(true);
        }
    }
}

