/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.ManagerProxy;
import hec.clientapp.model.ModelAlt;
import hec.clientapp.model.SimulationPeriod;
import hec.clientapp.model.SimulationRun;
import hec.clientapp.model.TrialRun;
import hec.io.Identifier;
import hec.lang.ModelReference;
import java.lang.reflect.Field;

public class SimulationTrialRun
extends SimulationRun
implements TrialRun {
    private int m_parentIndex = -1;
    private transient SimulationRun m_runParent = null;
    private boolean m_isBaseTrial = false;
    private String _trialKey;
    private int _trialPosition = -1;
    private boolean _current = false;
    private String m_simulationRunClassName = "";
    public static String FILE_EXT = ".trun";
    private boolean _accepted;

    public SimulationTrialRun() {
    }

    public void setSimulationRunClassName(String name) {
        this.m_simulationRunClassName = name;
    }

    public SimulationTrialRun(boolean isBaseTrial) {
        this();
        this.m_isBaseTrial = isBaseTrial;
    }

    public void setIsBaseTrial(boolean b) {
        this.m_isBaseTrial = b;
    }

    @Override
    public void setRunParent(SimulationRun run) {
        this.m_runParent = run;
        if (run != null) {
            this.m_parentIndex = run.getIndex();
            this.setSimulationRunClassName(((Object)((Object)run)).getClass().getName());
        } else {
            this.m_parentIndex = -1;
        }
    }

    @Override
    public SimulationRun getRunParent() {
        if (this.m_parentIndex == -1) {
            return null;
        }
        if (this.m_runParent == null) {
            if (this.getSimulation() != null) {
                this.m_runParent = (SimulationRun)((SimulationPeriod)this.getSimulation()).getProxyList().openManager(this.m_simulationRunClassName, this.m_parentIndex);
            }
            if (this.m_runParent == null) {
                System.out.println("getRunParent:failed to get SimulationRun Parent class=" + this.m_simulationRunClassName + " index=" + this.m_parentIndex);
            }
        }
        return this.m_runParent;
    }

    @Override
    public String getModelAltWorkspaceName() {
        SimulationRun parent = this.getRunParent();
        if (parent != null) {
            return parent.getModelAltWorkspaceName();
        }
        return "";
    }

    @Override
    public String getTrialRunClassName() {
        return this.getClass().getName();
    }

    @Override
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    public void setActiveTrial(boolean active) {
        this.setActiveRun(active);
    }

    public void setCurrentTrial(boolean current) {
        this._current = current;
        this.setModified(true);
    }

    @Override
    public void setModified(boolean b) {
        super.setModified(b);
        if (b && this.getSimulation() != null) {
            this.getSimulation().setModified(b);
        }
    }

    public boolean isBaseTrial() {
        return this.m_isBaseTrial;
    }

    public boolean isActiveTrial() {
        return this.isActiveRun();
    }

    public boolean isCurrentTrial() {
        return this._current;
    }

    @Override
    public String toString() {
        return this.getUserName();
    }

    @Override
    public String getKey() {
        return this.getTrialKey();
    }

    @Override
    public String getModel(String programName) {
        ModelAlt alt = this.getModelAlt(programName);
        if (alt == null) {
            return null;
        }
        ModelReference ref = alt.getModelRef();
        ManagerProxy proxy = this._proxyList.getManagerProxy(ref.wkspName.toLowerCase(), ref.className, ref.newId);
        if (proxy != null) {
            return proxy.getName();
        }
        return null;
    }

    @Override
    public String getFileExtension() {
        return FILE_EXT;
    }

    @Override
    public String getTrialKey() {
        return this._trialKey;
    }

    public void setTrialKey(String trialKey) {
        this._trialKey = trialKey;
    }

    public void setTrialPosition(int pos) {
        this._trialPosition = pos;
    }

    @Override
    public int getTrialPosition() {
        return this._trialPosition;
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set(this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get(this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    public void setAccepted(boolean accepted) {
        this._accepted = accepted;
        this.setModified(true);
    }

    public boolean isAccepted() {
        return this._accepted;
    }
}

