/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.appInterface.AppDaddy;
import hec.clientapp.model.Manager;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.map.LocalPt;
import hec.map.MapIdentifier;
import hec.map.MapObjectInterface;
import hec.map.WorldPt;
import hec.map.WorldRect;
import hec.map.appInterface.MapApplicationFrame;
import hec.map.crs.CRS;
import hec.map.crs.CRSException;
import hec.map.crs.CoordinateReferenceSystem;
import hec.map.streamAlignment.StreamAlignmentDrwPro;
import hec.map.streamAlignment.StreamAlignmentIfc;
import hec.map.streamAlignment.StreamAlignmentNodeIfc;
import hec.map.streamAlignment.StreamAlignmentProps;
import hec.model.Node;
import hec.model.StreamElement;
import hec.model.StreamJunction;
import hec.model.StreamNode;
import hec.model.StreamPolyLine;
import hec.model.StreamSegment;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import rma.util.RMAIO;

public class StreamAlignment
extends Manager
implements MapObjectInterface,
StreamAlignmentIfc {
    private static final transient Logger LOGGER = Logger.getLogger(StreamAlignment.class.getName());
    private transient PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport((Object)this);
    public static final String FILE_NAME = "stream.align";
    Vector _nodeVector = new Vector();
    Vector _lineVector = new Vector();
    Vector _juncVector = new Vector();
    StreamAlignmentProps _drawProp = StreamAlignmentDrwPro.getInstance();
    CoordinateReferenceSystem mCrs = null;
    private transient MapIdentifier _mapId = null;
    int _nextLineIndex = 0;
    int _nextNodeIndex = 0;
    int _nextJuncIndex = 0;

    @Override
    public void init() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Vector getElementVector() {
        return this._lineVector;
    }

    public Vector getNodeVector() {
        return this._nodeVector;
    }

    public StreamAlignmentProps getDrawProp() {
        return this._drawProp;
    }

    public Vector getJunctionVector() {
        return this._juncVector;
    }

    public StreamElement newStreamElement() {
        StreamElement reach = new StreamElement((StreamAlignmentNodeIfc)this, this._nextLineIndex);
        reach.setName("Stream " + Integer.toString(this._nextLineIndex));
        this._lineVector.addElement(reach);
        ++this._nextLineIndex;
        this.setModified(true);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "newStreamElement", null, reach);
        this._propertyChangeSupport.firePropertyChange(event);
        return reach;
    }

    public StreamNode newStreamNode(StreamElement reach) {
        StreamNode node = new StreamNode((StreamAlignmentIfc)this, reach);
        node.setIndex(this._nextNodeIndex);
        this._nodeVector.addElement(node);
        ++this._nextNodeIndex;
        this.setModified(true);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "newStreamNode", null, node);
        this._propertyChangeSupport.firePropertyChange(event);
        return node;
    }

    public void deleteStreamNode(StreamNode node) {
        this._nodeVector.removeElement(node);
        this.setModified(true);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "deleteStreamNode", null, node);
        this._propertyChangeSupport.firePropertyChange(event);
    }

    public StreamJunction newStreamJunction() {
        StreamJunction junc = new StreamJunction((StreamAlignmentIfc)this);
        junc.setIndex(this._nextJuncIndex);
        this._juncVector.addElement(junc);
        ++this._nextJuncIndex;
        this.setModified(true);
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "newStreamJunction", null, junc);
        this._propertyChangeSupport.firePropertyChange(event);
        return junc;
    }

    public StreamElement findNearestReach(WorldPt wpt, WorldPt wptbest) {
        StreamElement streambest = null;
        double mindist = Double.MAX_VALUE;
        WorldPt best = new WorldPt();
        int imax = this._lineVector.size();
        for (int i = 0; i < imax; ++i) {
            Object elem = this._lineVector.elementAt(i);
            if (elem == null || !(elem instanceof StreamElement)) continue;
            StreamElement reach = (StreamElement)elem;
            double dist = reach.getLine().getNearestLocation(wpt, best);
            if (dist == Double.NEGATIVE_INFINITY) {
                if (!Boolean.getBoolean("DEBUG")) continue;
                System.out.println("Invalid distance computed for Stream Element " + reach.getName() + " in method StreamAlignment.findNearestReach(WorldPt,WorldPt)");
                continue;
            }
            if (streambest != null && !(dist < mindist)) continue;
            streambest = reach;
            mindist = dist;
            wptbest.init(best);
        }
        return streambest;
    }

    public StreamElement findNearestReach(WorldPt wpt, WorldPt wptbest, double[] mindist) {
        StreamElement streambest = null;
        mindist[0] = Double.MAX_VALUE;
        WorldPt best = new WorldPt();
        int imax = this._lineVector.size();
        for (int i = 0; i < imax; ++i) {
            Object elem = this._lineVector.elementAt(i);
            if (elem == null || !(elem instanceof StreamElement)) continue;
            StreamElement reach = (StreamElement)elem;
            double dist = reach.getLine().getNearestLocationSigned(wpt, best);
            if (streambest != null && !(Math.abs(dist) < Math.abs(mindist[0]))) continue;
            streambest = reach;
            mindist[0] = dist;
            wptbest.init(best);
        }
        return streambest;
    }

    public StreamElement findReach(WorldPt wpt, double tol) {
        return this.findReach(null, wpt, tol);
    }

    public StreamElement findReach(StreamNode node, WorldPt wpt, double tol) {
        int imax = this._lineVector.size();
        for (int i = 1; i <= imax; ++i) {
            StreamElement reach;
            Object elem = this._lineVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof StreamElement) || !(reach = (StreamElement)elem).getLine().nearPt(wpt, tol)) continue;
            if (node == null) {
                return reach;
            }
            if (reach.getNodeVector().contains(node)) continue;
            return reach;
        }
        return null;
    }

    public StreamElement findReach(WorldPt wpt, double tol, StreamElement rch0) {
        double coordbest = 0.0;
        StreamElement rchbest = null;
        int imax = this._lineVector.size();
        for (int i = 1; i <= imax; ++i) {
            StreamElement reach;
            Object elem = this._lineVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof StreamElement) || !(reach = (StreamElement)elem).getLine().nearPt(wpt, tol)) continue;
            if (rch0 != null && reach == rch0) {
                return reach;
            }
            double coord = reach.getCoordByLocation(wpt);
            if (rchbest != null && !(coord > coordbest)) continue;
            rchbest = reach;
            coordbest = coord;
        }
        return rchbest;
    }

    public StreamElement findReach(String name) {
        int imax = this._lineVector.size();
        for (int i = 1; i <= imax; ++i) {
            StreamElement reach;
            Object elem = this._lineVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof StreamElement) || !(reach = (StreamElement)elem).getName().equals(name)) continue;
            return reach;
        }
        return null;
    }

    public StreamElement findReach(int idx) {
        int imax = this._lineVector.size();
        for (int i = 1; i <= imax; ++i) {
            StreamElement reach;
            Object elem = this._lineVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof StreamElement) || (reach = (StreamElement)elem).getIndex() != idx) continue;
            return reach;
        }
        return null;
    }

    public boolean deleteReach(int index) {
        int imax = this._lineVector.size();
        for (int i = 1; i <= imax; ++i) {
            StreamElement reach;
            Object elem = this._lineVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof StreamElement) || (reach = (StreamElement)elem).getIndex() != index) continue;
            this._lineVector.removeElement(reach);
            Vector nvec = reach.getNodeVector();
            for (int j = 0; j < nvec.size(); ++j) {
                StreamJunction junc;
                StreamNode n = (StreamNode)nvec.elementAt(j);
                if (n == null || !this._nodeVector.removeElement(n) || (junc = n.getJunction()) == null) continue;
                junc.removeNode(n);
                if (junc.getNodeVector().size() > 1) continue;
                junc.removeAllNodes();
                this._juncVector.removeElement(junc);
            }
            this._propertyChangeSupport.firePropertyChange("deleteReach", reach, null);
            this.setModified(true);
            return true;
        }
        return false;
    }

    public boolean deleteReach(String name) {
        int imax = this._lineVector.size();
        for (int i = 1; i <= imax; ++i) {
            StreamElement reach;
            Object elem = this._lineVector.elementAt(imax - i);
            if (elem == null || !(elem instanceof StreamElement) || !(reach = (StreamElement)elem).getName().equals(name)) continue;
            this._lineVector.removeElement(reach);
            Vector nvec = reach.getNodeVector();
            for (int j = 0; j < nvec.size(); ++j) {
                StreamJunction junc;
                StreamNode n = (StreamNode)nvec.elementAt(j);
                if (n == null || !this._nodeVector.removeElement(n) || (junc = n.getJunction()) == null) continue;
                junc.removeNode(n);
                if (junc.getNodeVector().size() > 1) continue;
                junc.removeAllNodes();
                this._juncVector.removeElement(junc);
            }
            this._propertyChangeSupport.firePropertyChange("deleteReach", reach, null);
            this.setModified(true);
            return true;
        }
        return false;
    }

    public boolean deleteAll() {
        this._lineVector.clear();
        this._nodeVector.clear();
        this._juncVector.clear();
        this.setModified(true);
        return true;
    }

    public StreamElement getReach(int id) {
        for (int i = 0; i < this._lineVector.size(); ++i) {
            StreamElement reach;
            Object elem = this._lineVector.elementAt(i);
            if (elem == null || !(elem instanceof StreamElement) || (reach = (StreamElement)elem).getIndex() != id) continue;
            return reach;
        }
        return null;
    }

    public StreamJunction getJunction(int id) {
        for (int i = 0; i < this._juncVector.size(); ++i) {
            StreamJunction junc;
            Object elem = this._juncVector.elementAt(i);
            if (elem == null || !(elem instanceof StreamJunction) || (junc = (StreamJunction)elem).getIndex() != id) continue;
            return junc;
        }
        return null;
    }

    public StreamNode getNode(int id) {
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode node;
            Object elem = this._nodeVector.elementAt(i);
            if (elem == null || !(elem instanceof StreamNode) || (node = (StreamNode)elem).getIndex() != id) continue;
            return node;
        }
        return null;
    }

    public StreamElement createReach(StreamPolyLine line, double tol) {
        if (line == null) {
            return null;
        }
        StreamElement reach = this.newStreamElement();
        reach.setLine(line);
        StreamNode node0 = this.newStreamNode(reach);
        node0.setStreamCoord(1.0);
        reach.addNode(node0);
        StreamNode node1 = this.newStreamNode(reach);
        node1.setStreamCoord(0.0);
        reach.addNode(node1);
        WorldPt p0 = node0.getLocation();
        WorldRect rc0 = new WorldRect(p0.e - tol, p0.n + tol, p0.e + tol, p0.n - tol);
        WorldPt p1 = node1.getLocation();
        WorldRect rc1 = new WorldRect(p1.e - tol, p1.n + tol, p1.e + tol, p1.n - tol);
        StreamJunction j = null;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null || n == node0 || n == node1) continue;
            WorldPt p = n.getLocation();
            if (rc0.contains(p)) {
                j = n.getJunction();
                if (j == null) {
                    j = this.newStreamJunction();
                    j.addNode(n);
                }
                j.addNode(node0);
                continue;
            }
            if (!rc1.contains(p)) continue;
            j = n.getJunction();
            if (j == null) {
                j = this.newStreamJunction();
                j.addNode(n);
            }
            j.addNode(node1);
        }
        WorldPt loc = new WorldPt();
        if (node1.getJunction() == null) {
            for (int i = 0; i < this._lineVector.size(); ++i) {
                double coord;
                double dist;
                StreamElement s = (StreamElement)this._lineVector.elementAt(i);
                if (s == null || s == reach || !((dist = s.getLine().getNearestLocation(node1.getLocation(), loc)) <= tol) || (coord = s.getLine().getCoordAtLocation(loc)) == Double.NEGATIVE_INFINITY) continue;
                StreamNode newnode = this.newStreamNode(s);
                newnode.setStreamCoord(coord);
                s.addNode(newnode);
                j = this.newStreamJunction();
                j.addNode(newnode);
                j.addNode(node1);
                j.updateLocation();
                break;
            }
        }
        this.setModified(true);
        return reach;
    }

    public void connectAlignment(double tolerance) {
        this.connectNodes(0.0);
        if (tolerance < 0.0) {
            tolerance = 0.0;
        }
        if (tolerance > 0.0) {
            this.connectNodes(tolerance);
        }
        this.setModified(true);
    }

    private void connectNodes(double tolerance) {
        for (int ii = 0; ii < this._nodeVector.size(); ++ii) {
            double coord;
            StreamNode node = (StreamNode)this._nodeVector.get(ii);
            if (node.getJunction() != null) continue;
            WorldPt nodePt = node.getLocation();
            StreamJunction nearestStreamJunction = this.findNearestStreamJunction(node, nodePt, tolerance);
            StreamNode nearestNode = this.findNearestNodeWithNoJunction(node, nodePt, tolerance);
            if (nearestStreamJunction != null && nearestNode != null) {
                double nodeDist = nodePt.distToPoint(nearestNode.getLocation());
                double juncDist = nodePt.distToPoint(nearestStreamJunction.getLocation());
                if (juncDist <= nodeDist) {
                    nearestNode = null;
                } else {
                    nearestStreamJunction = null;
                }
            }
            if (nearestStreamJunction != null && nearestNode == null) {
                if (!node.getLocation().equals(nearestStreamJunction.getLocation())) {
                    StreamElement reach = node.getStream();
                    if (node.getLocation().equals(reach.getLine().getFirstPt())) {
                        reach.getLine().getFirstPt().init(nearestStreamJunction.getLocation());
                        reach.setReferencePt(node.getStream().getLine().getFirstPt());
                    } else if (node.getLocation().equals(reach.getLine().getLastPt())) {
                        reach.getLine().getLastPt().init(nearestStreamJunction.getLocation());
                    }
                    reach.getLine().invalidate();
                    reach.resetNodeCoord();
                }
                nearestStreamJunction.addNode(node);
                nearestStreamJunction.updateLocation();
                continue;
            }
            if (nearestNode != null && nearestStreamJunction == null) {
                if (!node.getLocation().equals(nearestNode.getLocation())) {
                    StreamElement reach = node.getStream();
                    if (node.getLocation().equals(reach.getLine().getFirstPt())) {
                        reach.getLine().getFirstPt().init(nearestNode.getLocation());
                        reach.setReferencePt(node.getStream().getLine().getFirstPt());
                    } else if (node.getLocation().equals(reach.getLine().getLastPt())) {
                        reach.getLine().getLastPt().init(nearestNode.getLocation());
                    }
                    reach.getLine().invalidate();
                    reach.resetNodeCoord();
                }
                StreamJunction newJunction = this.newStreamJunction();
                newJunction.addNode(node);
                newJunction.addNode(nearestNode);
                newJunction.updateLocation();
                continue;
            }
            StreamElement reach = this.findReach(node, nodePt, tolerance);
            if (reach == null || (coord = reach.getLine().getCoordAtLocation(nodePt)) == Double.NEGATIVE_INFINITY) continue;
            StreamNode newNode = this.newStreamNode(reach);
            newNode.setStreamCoord(coord);
            reach.addNode(newNode);
            StreamJunction j = this.newStreamJunction();
            if (!node.getLocation().equals(newNode.getLocation())) {
                StreamElement movingNodeReach = node.getStream();
                if (node.getLocation().equals(movingNodeReach.getLine().getFirstPt())) {
                    movingNodeReach.getLine().getFirstPt().init(newNode.getLocation());
                    movingNodeReach.setReferencePt(movingNodeReach.getLine().getFirstPt());
                } else if (node.getLocation().equals(movingNodeReach.getLine().getLastPt())) {
                    movingNodeReach.getLine().getLastPt().init(newNode.getLocation());
                }
                movingNodeReach.getLine().invalidate();
                movingNodeReach.resetNodeCoord();
            }
            j.addNode(newNode);
            j.addNode(node);
            j.updateLocation();
        }
    }

    private StreamNode findNearestNodeWithNoJunction(StreamNode node, WorldPt nodePt, double tolerance) {
        StreamNode bestMatchNode = null;
        for (int ii = 0; ii < this._nodeVector.size(); ++ii) {
            double distToPt;
            StreamNode testNode = (StreamNode)this._nodeVector.get(ii);
            if (testNode.equals(node) || testNode.getJunction() != null) continue;
            WorldPt testNodePt = testNode.getLocation();
            if (nodePt.equals(testNodePt)) {
                return testNode;
            }
            if (node.getStream().equals((Object)testNode.getStream()) || !((distToPt = nodePt.distToPoint(testNodePt)) < tolerance)) continue;
            bestMatchNode = testNode;
        }
        return bestMatchNode;
    }

    private StreamJunction findNearestStreamJunction(StreamNode node, WorldPt nodePt, double tolerance) {
        StreamJunction bestMatchJunction = null;
        for (int ii = 0; ii < this._juncVector.size(); ++ii) {
            StreamJunction streamJunction = (StreamJunction)this._juncVector.get(ii);
            WorldPt streamPt = streamJunction.getLocation();
            if (nodePt.equals(streamPt)) {
                return streamJunction;
            }
            if (streamJunction.contains(node.getStream()) || !(nodePt.distToPoint(streamPt) <= tolerance) || (bestMatchJunction = streamJunction) == null) continue;
            tolerance = nodePt.distToPoint(bestMatchJunction.getLocation());
        }
        return bestMatchJunction;
    }

    public void connectReach(StreamElement elem, double tol) {
        if (elem == null) {
            return;
        }
        StreamNode node0 = elem.getUpstreamNode();
        this.connectNode(elem, node0, tol);
        StreamNode node1 = elem.getDownstreamNode();
        this.connectNode(elem, node1, tol);
        this.setModified(true);
    }

    public boolean connectNode(StreamElement elem, StreamNode node, double tol) {
        if (elem == null || node == null) {
            return false;
        }
        if (node.getJunction() != null) {
            return false;
        }
        WorldPt p0 = node.getLocation();
        WorldRect rc0 = new WorldRect(p0.e - tol, p0.n + tol, p0.e + tol, p0.n - tol);
        StreamJunction j = null;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            WorldPt p;
            StreamNode n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null || n.getStream() == elem || !rc0.contains(p = n.getLocation())) continue;
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            int opt = JOptionPane.showConfirmDialog((Component)frame.getMapPanel(), "Ok to connect Stream " + elem.getName() + " to Stream " + n.getStream().getName() + "?", "Connect Stream Reaches", 0);
            if (opt == 0) {
                j = n.getJunction();
                node.setLocation((WorldPt)n.getLocation().clone());
                if (node.getStreamCoord() == 1.0) {
                    node.getStream().getLine().getLastPt().init((WorldPt)n.getLocation().clone());
                } else if (node.getStreamCoord() == 0.0) {
                    node.getStream().getLine().getFirstPt().init((WorldPt)n.getLocation().clone());
                }
                node.setStreamCoord(node.getStreamCoord());
                if (j == null) {
                    j = this.newStreamJunction();
                    j.addNode(n);
                }
                j.addNode(node);
                this.setModified(true);
                return true;
            }
            return false;
        }
        WorldPt loc = new WorldPt();
        for (int i = 0; i < this._lineVector.size(); ++i) {
            double coord;
            double dist;
            StreamElement s = (StreamElement)this._lineVector.elementAt(i);
            if (s == null || s == elem || !((dist = s.getLine().getNearestLocation(node.getLocation(), loc)) <= tol) || (coord = s.getLine().getCoordAtLocation(loc)) == Double.NEGATIVE_INFINITY) continue;
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            int opt = JOptionPane.showConfirmDialog((Component)frame.getMapPanel(), "Ok to connect Stream " + elem.getName() + " to Stream " + s.getName() + "?", "Connect Stream Reaches", 0);
            if (opt == 0) {
                StreamNode newNode = this.newStreamNode(s);
                newNode.setStreamCoord(coord);
                s.addNode(newNode);
                j = this.newStreamJunction();
                j.addNode(newNode);
                j.addNode(node);
                this.setModified(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public void unload() {
    }

    public void load() throws IOException {
        if (this._identifier != null) {
            this.readFile(this._identifier);
        }
    }

    @Override
    public boolean readFile(Identifier id) {
        this._lastModifiedTime = Long.MIN_VALUE;
        this._nodeVector.removeAllElements();
        this._lineVector.removeAllElements();
        this._juncVector.removeAllElements();
        HecFile file = id.getFile();
        if (file == null) {
            return true;
        }
        System.out.println("opening projection file" + file.getPath());
        Object projectionFile = file.getPath();
        int idx2 = ((String)projectionFile).lastIndexOf(46);
        if (idx2 >= 0) {
            projectionFile = ((String)projectionFile).substring(0, idx2);
        }
        projectionFile = (String)projectionFile + ".prj";
        File pFile = new File((String)projectionFile);
        this.mCrs = null;
        if (pFile.exists()) {
            Object projectionString = "";
            try {
                String line;
                BufferedReader projectionReader = new BufferedReader(new FileReader(pFile));
                while ((line = projectionReader.readLine()) != null) {
                    projectionString = (String)projectionString + line;
                }
                try {
                    this.mCrs = CRS.getDefault().parseWkt((String)projectionString);
                }
                catch (CRSException ex) {
                    Logger.getLogger(StreamAlignment.class.getName()).log(Level.SEVERE, null, ex);
                    this.mCrs = null;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(StreamAlignment.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        System.out.println("opening " + file.getPath());
        try {
            BufferedReader input = file.getBufferedReader();
            String line = input.readLine();
            while (line != null) {
                StreamNode elem;
                int idx;
                if (line.length() == 0) {
                    line = input.readLine();
                    continue;
                }
                String type = RMAIO.getType((String)line, (String)"=");
                String param = RMAIO.getParam((String)line, (String)"=");
                if (type.compareTo("Alignment Name") == 0) {
                    this.setName(param);
                } else if (type.compareTo("Description") == 0) {
                    String desc = param.replace('|', '\n');
                    this.setDescription(desc);
                } else if (type.compareTo("ModifiedTime") == 0) {
                    this._lastModifiedTime = RMAIO.parseLong((String)param, (long)Long.MIN_VALUE);
                } else if (type.compareTo("_nextLineIndex") == 0) {
                    this._nextLineIndex = RMAIO.parseInt((String)param);
                } else if (type.compareTo("_nextNodeIndex") == 0) {
                    this._nextNodeIndex = RMAIO.parseInt((String)param);
                } else if (type.compareTo("_nextJuncIndex") == 0) {
                    this._nextJuncIndex = RMAIO.parseInt((String)param);
                } else if ("Node".equals(type) || "StreamNode".equals(type)) {
                    idx = RMAIO.parseInt((String)param);
                    if (idx != Integer.MIN_VALUE) {
                        elem = new StreamNode((StreamAlignmentIfc)this);
                        elem.setIndex(idx);
                        if (elem.readData(input)) {
                            this._nodeVector.addElement(elem);
                            if (idx >= this._nextNodeIndex) {
                                this._nextNodeIndex = idx + 1;
                            }
                        } else {
                            this.printMessage("Error reading data for Node " + idx);
                        }
                    }
                } else if ("Stream".equals(type) || "StreamElement".equals(type)) {
                    idx = RMAIO.parseInt((String)param);
                    if (idx != Integer.MIN_VALUE) {
                        elem = new StreamElement((StreamAlignmentNodeIfc)this, idx);
                        if (elem.readData(input)) {
                            this._lineVector.addElement(elem);
                            if (idx >= this._nextLineIndex) {
                                this._nextLineIndex = idx + 1;
                            }
                        } else {
                            this.printMessage("Error reading data for Element " + idx);
                        }
                    }
                } else if ("Junction".equals(type) || "StreamJunction".equals(type)) {
                    idx = RMAIO.parseInt((String)param);
                    if (idx != Integer.MIN_VALUE) {
                        elem = new StreamJunction((StreamAlignmentIfc)this);
                        elem.setIndex(idx);
                        if (elem.readData(input)) {
                            this._juncVector.addElement(elem);
                            if (idx >= this._nextJuncIndex) {
                                this._nextJuncIndex = idx + 1;
                            }
                        } else {
                            this.printMessage("Error reading data for Junction " + idx);
                        }
                    }
                } else if (type.equals("StreamAlignDrawPropBegin")) {
                    this._drawProp.read(input);
                }
                line = input.readLine();
            }
            input.close();
        }
        catch (IOException e) {
            this.printMessage("Failed to open file " + id.getPath());
            return false;
        }
        this.setModified(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(Identifier id) {
        File pFile;
        if (this.getReadOnly()) {
            return true;
        }
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        Object projectionFile = file.getPath();
        int idx2 = ((String)projectionFile).lastIndexOf(46);
        if (idx2 >= 0) {
            projectionFile = ((String)projectionFile).substring(0, idx2);
        }
        if ((pFile = new File((String)(projectionFile = (String)projectionFile + ".prj"))).exists()) {
            pFile.delete();
        }
        if (this.mCrs != null) {
            try (BufferedWriter projectionWriter = new BufferedWriter(new FileWriter(pFile));){
                projectionWriter.write(this.mCrs.toWKT());
            }
            catch (IOException ex) {
                Logger.getLogger(StreamAlignment.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        try {
            int i;
            this.setReloadOk(false);
            BufferedWriter out = file.getBufferedWriter();
            if (out == null) {
                boolean ex = false;
                return ex;
            }
            System.out.println("writing " + file.getPath());
            out.write("Alignment Name=" + this.getName());
            out.newLine();
            out.newLine();
            String desc = this.getDescription().replace('\n', '|');
            out.write("Description=" + desc);
            out.newLine();
            RMAIO.fout((BufferedWriter)out, (String)("ModifiedTime=" + this._lastModifiedTime));
            out.write("_nextLineIndex=" + this._nextLineIndex);
            out.newLine();
            out.write("_nextNodeIndex=" + this._nextNodeIndex);
            out.newLine();
            out.write("_nextJuncIndex=" + this._nextJuncIndex);
            out.newLine();
            for (i = 0; i < this._nodeVector.size(); ++i) {
                StreamNode node = (StreamNode)this._nodeVector.elementAt(i);
                if (node == null) continue;
                node.writeData(out);
            }
            for (i = 0; i < this._lineVector.size(); ++i) {
                StreamElement element = (StreamElement)this._lineVector.elementAt(i);
                if (element == null) continue;
                System.out.println("writing stream:" + element.getName());
                element.writeData(out);
            }
            for (i = 0; i < this._juncVector.size(); ++i) {
                StreamJunction junc = (StreamJunction)this._juncVector.elementAt(i);
                if (junc == null) continue;
                junc.writeData(out);
            }
            this._drawProp.write(out);
            out.close();
            file.save();
        }
        catch (IOException e) {
            this.printMessage("Failed to open file " + id.getPath());
            boolean bl = false;
            return bl;
        }
        finally {
            this.setReloadOk(true);
        }
        this.setModified(false);
        return true;
    }

    public void setMapIdentifier(MapIdentifier id) {
    }

    public MapIdentifier getMapIdentifier() {
        if (this._mapId == null) {
            this._mapId = new MapIdentifier(this.getIdentifier());
            this._mapId.setName("Stream Alignment");
            this._mapId.setIsManager(true);
        }
        return this._mapId;
    }

    public void setExtent(WorldRect rc) {
    }

    public WorldRect getExtent() {
        WorldRect rc = new WorldRect();
        return rc;
    }

    public void updateJunctionLocations() {
        int i;
        for (i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null) continue;
            n.setLocation(null);
        }
        for (i = 0; i < this._juncVector.size(); ++i) {
            StreamJunction j = (StreamJunction)this._juncVector.elementAt(i);
            if (j == null) continue;
            j.updateLocation();
        }
        this.setModified(true);
    }

    public StreamJunction findStreamJunction(StreamElement stream, WorldPt wpt, double tol) {
        WorldRect rc = new WorldRect(wpt, tol);
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null || n.getStream() != stream || !rc.contains(n.getLocation()) || n.getJunction() == null) continue;
            return n.getJunction();
        }
        return null;
    }

    public StreamNode findStreamNode(StreamElement stream, WorldPt wpt, double tol) {
        WorldRect rc = new WorldRect(wpt, tol);
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null || n.getStream() != stream || !rc.contains(n.getLocation())) continue;
            return n;
        }
        return null;
    }

    public StreamNode findNearestStreamNode(StreamElement stream, WorldPt wpt) {
        StreamNode node = null;
        double mindist = Double.MAX_VALUE;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            StreamNode n = (StreamNode)this._nodeVector.elementAt(i);
            if (n == null || n.getStream() != stream) continue;
            if (node == null) {
                node = n;
                mindist = wpt.distToPoint(n.getLocation());
                continue;
            }
            double d = wpt.distToPoint(n.getLocation());
            if (!(d < mindist)) continue;
            node = n;
            mindist = d;
        }
        return node;
    }

    public StreamNode findDownstreamNode(StreamElement stream, double coord) {
        StreamNode dnode = null;
        StreamNode node = null;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            node = (StreamNode)this._nodeVector.elementAt(i);
            if (node == null || stream != node.getStream() || !(node.getStreamCoord() < coord) || dnode != null && !(dnode.getStreamCoord() < node.getStreamCoord())) continue;
            dnode = node;
        }
        return dnode;
    }

    public StreamNode findUpstreamNode(StreamElement stream, double coord) {
        StreamNode dnode = null;
        StreamNode node = null;
        for (int i = 0; i < this._nodeVector.size(); ++i) {
            node = (StreamNode)this._nodeVector.elementAt(i);
            if (node == null || stream != node.getStream() || !(node.getStreamCoord() > coord) || dnode != null && !(dnode.getStreamCoord() > node.getStreamCoord())) continue;
            dnode = node;
        }
        return dnode;
    }

    public boolean removeReachFromJunction(String name, boolean upStream) {
        Enumeration e = this._lineVector.elements();
        while (e.hasMoreElements()) {
            StreamElement reach;
            Object elem = e.nextElement();
            if (elem == null || !(elem instanceof StreamElement) || !(reach = (StreamElement)elem).getName().equals(name)) continue;
            StreamNode node = upStream ? reach.getUpstreamNode() : reach.getDownstreamNode();
            if (node == null) {
                return false;
            }
            StreamJunction junc = node.getJunction();
            if (junc == null) continue;
            junc.removeNode(node);
            WorldPt wpt = null;
            wpt = upStream ? reach.getLine().getLastPt() : reach.getLine().getFirstPt();
            LocalPt lpt = new LocalPt();
            MapApplicationFrame frame = (MapApplicationFrame)AppDaddy.getFrame();
            frame.getMapPanel().scale().wp2lp(wpt, lpt);
            lpt.x -= 20;
            lpt.y -= 20;
            frame.getMapPanel().scale().lp2wp(lpt, wpt);
            reach.resetNodeCoord();
            if (junc.getNodeVector().size() <= 1) {
                junc.removeAllNodes();
                this._juncVector.removeElement(junc);
            }
            this.updateJunctionLocations();
            this.setModified(true);
            return true;
        }
        return false;
    }

    public String getStreamSegmentsByNodes(Vector nodeVec, Vector ndirVec, Vector segVec) {
        int i;
        if (nodeVec == null || ndirVec == null || segVec == null) {
            return "Input vectors are null";
        }
        if (nodeVec.size() < 2) {
            return "Must specify at least two nodes";
        }
        segVec.removeAllElements();
        Vector<StreamSegment> streamVec = new Vector<StreamSegment>();
        Stack<StreamSegment> streamStack = new Stack<StreamSegment>();
        Vector svec = new Vector();
        int numnodes = nodeVec.size();
        int[] ndirArray = new int[numnodes];
        for (i = 0; i < numnodes; ++i) {
            ndirArray[i] = Integer.MIN_VALUE;
        }
        boolean[] closedArray = new boolean[numnodes];
        for (i = 0; i < numnodes; ++i) {
            closedArray[i] = false;
        }
        for (int ii = 0; ii < numnodes; ++ii) {
            StreamElement strmelem;
            if (ndirArray[ii] != Integer.MIN_VALUE) continue;
            Node node = (Node)nodeVec.elementAt(ii);
            ndirArray[ii] = 0;
            streamVec.removeAllElements();
            streamStack.removeAllElements();
            StreamSegment sseg = new StreamSegment();
            sseg.streamIndex = node.getStreamIndex();
            sseg.upstreamStation = node.getStreamStation();
            sseg.downstreamCoord = 0.0;
            sseg.stream = strmelem = this.getReach(node.getStreamIndex());
            if (strmelem != null) {
                streamStack.push(sseg);
            }
            while (!streamStack.isEmpty()) {
                StreamSegment s = (StreamSegment)streamStack.pop();
                if (s.upstreamStation != Double.NEGATIVE_INFINITY) {
                    s.upstreamCoord = s.stream.getCoordByStation(s.upstreamStation);
                }
                streamVec.addElement(s);
                boolean ifound = false;
                for (int jj = 0; jj < numnodes; ++jj) {
                    double coord;
                    Node nj = (Node)nodeVec.elementAt(jj);
                    if (nj == null || nj == node || nj.getStreamIndex() != s.streamIndex || !((coord = s.stream.getCoordByStation(nj.getStreamStation())) < s.upstreamCoord)) continue;
                    ndirArray[ii] = 1;
                    closedArray[ii] = true;
                    ndirArray[jj] = 0;
                    closedArray[jj] = true;
                    s.downstreamStation = nj.getStreamStation();
                    s.downstreamCoord = coord;
                    for (i = 0; i < streamVec.size(); ++i) {
                        StreamSegment tmpseg = (StreamSegment)streamVec.elementAt(i);
                        if (segVec.contains(tmpseg)) continue;
                        segVec.addElement(tmpseg);
                    }
                    streamVec.removeAllElements();
                    ifound = true;
                    break;
                }
                Vector nv = s.stream.getNodeVector();
                boolean segmentHasDownstreamElements = false;
                for (int kk = 0; kk < nv.size(); ++kk) {
                    StreamJunction strmjunc;
                    StreamNode strmnode = (StreamNode)nv.elementAt(kk);
                    if (strmnode.getStreamCoord() >= s.upstreamCoord || ifound && strmnode.getStreamCoord() < s.downstreamCoord || (strmjunc = strmnode.getJunction()) == null) continue;
                    svec.removeAllElements();
                    strmjunc.getOutflowingStreamSegments(svec);
                    for (int j = 0; j < svec.size(); ++j) {
                        StreamSegment sss = (StreamSegment)svec.elementAt(j);
                        if (sss.streamIndex == s.streamIndex) continue;
                        streamStack.push(sss);
                        segmentHasDownstreamElements = true;
                    }
                }
                if (segmentHasDownstreamElements || ifound) continue;
                String errmsg = "The set of outflow locations does not form a closed pool, please try again.";
                return errmsg;
            }
        }
        ndirVec.removeAllElements();
        for (i = 0; i < ndirArray.length; ++i) {
            ndirVec.addElement(new Integer(ndirArray[i]));
        }
        for (i = 0; i < closedArray.length; ++i) {
            if (closedArray[i]) continue;
            String errmsg = "The set of inflow and outflow locations does not form a closed pool, please try again.";
            return errmsg;
        }
        return null;
    }

    public double findDistanceBetween(StreamElement upstreamElement, double upstreamCoordinateLoc, StreamElement downstreamElement, double downstreamCoordinateLoc) {
        Vector elementVector = this.getElementVector();
        if (upstreamElement == null || downstreamElement == null || !elementVector.contains(upstreamElement) || !elementVector.contains(downstreamElement) || upstreamCoordinateLoc > 1.0 || upstreamCoordinateLoc < 0.0 || downstreamCoordinateLoc > 1.0 || downstreamCoordinateLoc < 0.0) {
            return -3.4028234663852886E38;
        }
        List<StreamPolyLine> pathBetween = this.findPolyLinePathBetween(upstreamElement, upstreamCoordinateLoc, downstreamElement, downstreamCoordinateLoc);
        int elementsInPath = pathBetween.size();
        if (elementsInPath < 1) {
            return -3.4028234663852886E38;
        }
        double distance = 0.0;
        for (int i = 0; i < elementsInPath; ++i) {
            distance += pathBetween.get(i).getLength();
        }
        return distance;
    }

    private List<StreamPolyLine> findPolyLinePathBetween(StreamElement upstream, double upstreamCoord, StreamElement downstream, double downstreamCoord) {
        ArrayList<StreamPolyLine> path = new ArrayList<StreamPolyLine>();
        if (upstream == null || downstream == null) {
            return path;
        }
        if (upstream.equals((Object)downstream)) {
            if (downstreamCoord < upstreamCoord) {
                path.add(upstream.getLineSegment(downstreamCoord, upstreamCoord));
            } else {
                LOGGER.warning("Provided downstream coordinate that is upstream of upstream coordinate! Cannot calculate path.");
            }
            return path;
        }
        Map<StreamElement, List<StreamJunction>> streamToOutflowJunctions = this.getOutflowStreamJunctionsByElement();
        LOGGER.log(Level.FINE, "Outflow stream junctions: {0}", streamToOutflowJunctions);
        List<StreamElement> streamElementPathBetween = StreamAlignment.findStreamElementPathBetween(upstream, downstream, streamToOutflowJunctions);
        int streamElementsOnPath = streamElementPathBetween.size();
        StreamJunction currentJunction = null;
        for (int i = 0; i < streamElementsOnPath; ++i) {
            double downstreamLocation;
            double upstreamLocation;
            StreamElement streamElement = streamElementPathBetween.get(i);
            if (currentJunction != null) {
                StreamNode nodeOnStream = currentJunction.getNodeOnStream(streamElement);
                if (nodeOnStream == null) {
                    LOGGER.severe("Junction " + currentJunction + " is not on Stream " + streamElement + ". Cannot calculate path for " + streamElementPathBetween);
                    path.clear();
                    return path;
                }
                upstreamLocation = nodeOnStream.getStreamCoord();
            } else if (streamElement.equals((Object)upstream)) {
                upstreamLocation = upstreamCoord;
            } else {
                LOGGER.severe("No path to Stream " + streamElement + " from previous element found! Cannot calculate path for: " + streamElementPathBetween);
                path.clear();
                return path;
            }
            if (streamElement.equals((Object)downstream)) {
                downstreamLocation = downstreamCoord;
            } else {
                currentJunction = null;
                StreamElement next = streamElementPathBetween.get(i + 1);
                for (StreamJunction junction : streamToOutflowJunctions.get(streamElement)) {
                    if (junction.getNodeOnStream(next) == null) continue;
                    currentJunction = junction;
                    break;
                }
                if (currentJunction == null) {
                    LOGGER.severe("No path from Stream " + streamElement + " to next element found! Cannot calculate path for: " + streamElementPathBetween);
                    path.clear();
                    return path;
                }
                StreamNode outflowNodeOnStream = currentJunction.getNodeOnStream(streamElement);
                if (outflowNodeOnStream == null) {
                    LOGGER.severe("No path from Stream " + streamElement + " to next element found! (Missing outflow node) Cannot calculate path for: " + streamElementPathBetween);
                    path.clear();
                    return path;
                }
                downstreamLocation = outflowNodeOnStream.getStreamCoord();
            }
            path.add(streamElement.getLineSegment(downstreamLocation, upstreamLocation));
        }
        return path;
    }

    private Map<StreamElement, List<StreamJunction>> getOutflowStreamJunctionsByElement() {
        HashMap<StreamElement, List<StreamJunction>> streamToOutflowJunctions = new HashMap<StreamElement, List<StreamJunction>>();
        Vector junctions = this.getJunctionVector();
        for (Object ojunction : junctions) {
            if (!(ojunction instanceof StreamJunction)) continue;
            StreamJunction junction = (StreamJunction)ojunction;
            Vector inflowStreams = new Vector();
            junction.getInflowingStreams(inflowStreams);
            int numInflowingStreams = inflowStreams.size();
            for (int i = 0; i < numInflowingStreams; ++i) {
                List junctionsForStream = streamToOutflowJunctions.computeIfAbsent((StreamElement)inflowStreams.get(i), element -> new ArrayList());
                junctionsForStream.add(junction);
            }
        }
        return streamToOutflowJunctions;
    }

    private static List<StreamElement> findStreamElementPathBetween(StreamElement upstream, StreamElement downstream, Map<StreamElement, List<StreamJunction>> streamToOutflowJunctions) {
        ArrayList<StreamElement> elementPath = new ArrayList<StreamElement>();
        elementPath.add(upstream);
        LOGGER.log(Level.FINE, "Starting with path: {0}", upstream);
        ArrayList<StreamElement> elementsThatDontLeadToDownstream = new ArrayList<StreamElement>();
        while (!elementPath.isEmpty()) {
            LOGGER.log(Level.FINER, "Looking down path: {0}", elementPath);
            StreamElement farthestElementSoFar = (StreamElement)elementPath.get(elementPath.size() - 1);
            LOGGER.log(Level.FINER, "Looking downstream of element {0}", farthestElementSoFar);
            if (farthestElementSoFar.equals((Object)downstream)) {
                LOGGER.log(Level.FINER, "Found path successfully!");
                break;
            }
            List<StreamJunction> outflows = streamToOutflowJunctions.get(farthestElementSoFar);
            LOGGER.log(Level.FINER, "Found the following outflow junctions: {0}", outflows);
            if (outflows == null || outflows.isEmpty()) {
                LOGGER.log(Level.FINER, "Going back, no outflows!");
                elementPath.remove(farthestElementSoFar);
                elementsThatDontLeadToDownstream.add(farthestElementSoFar);
                continue;
            }
            boolean goDownstreamOneMoreElement = false;
            for (StreamJunction junction : outflows) {
                LOGGER.log(Level.FINEST, "Searching junction: {0}", junction);
                Vector downstreams = new Vector();
                junction.getOutflowingStreams(downstreams);
                LOGGER.log(Level.FINEST, "Found downstream elements: {0}", downstreams);
                for (StreamElement downstreamSearch : downstreams) {
                    LOGGER.log(Level.FINEST, "Searching element: {0}", downstreamSearch);
                    if (elementsThatDontLeadToDownstream.contains(downstreamSearch)) {
                        LOGGER.log(Level.FINEST, "Already searched element {0}! Skipping.", downstreamSearch);
                        continue;
                    }
                    elementPath.add(downstreamSearch);
                    LOGGER.log(Level.FINEST, "Going farther downstream.");
                    goDownstreamOneMoreElement = true;
                    break;
                }
                if (!goDownstreamOneMoreElement) continue;
                break;
            }
            if (goDownstreamOneMoreElement) continue;
            LOGGER.log(Level.FINER, "Searched all downstream of {0}, going backwards one element.", farthestElementSoFar);
            elementPath.remove(farthestElementSoFar);
            elementsThatDontLeadToDownstream.add(farthestElementSoFar);
        }
        LOGGER.log(Level.FINE, "Found element path: {0}", elementPath);
        return elementPath;
    }

    public int getNextLineIndex() {
        return this._nextLineIndex++;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.mCrs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        this.mCrs = crs;
    }

    public String getNextDefaultElementName() {
        return "Stream " + this._nextLineIndex;
    }

    @Override
    public Object getFieldObject(Field fld) {
        try {
            Object obj = fld.get((Object)this);
            return obj;
        }
        catch (IllegalAccessException e) {
            return super.getFieldObject(fld);
        }
    }

    @Override
    public boolean setFieldObject(Field fld, Object fobj) {
        try {
            fld.set((Object)this, fobj);
            return true;
        }
        catch (IllegalAccessException e) {
            return super.setFieldObject(fld, fobj);
        }
        catch (IllegalArgumentException e) {
            return super.setFieldObject(fld, fobj);
        }
    }
}

