/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.Manager;
import hec.clientapp.model.TSRecordImplFactory;
import hec.clientapp.model.TSRecordProxy;
import hec.heclib.util.HecTime;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.model.BaseTSDataSet;
import hec.model.ITSDataSet;
import hec.model.RunTimeWindow;
import hec.model.TSManager;
import hec.model.TSRecord;
import hec.model.TSRecordCreator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.io.HecFileFactory;
import mil.army.usace.hec.rmi.server.RemoteWrapper;

public class TSDataSet
extends Manager
implements TSRecordCreator,
ITSDataSet {
    public static final int INST = 0;
    public static final int PER_AVG = 1;
    public static final int PER_CUM = 2;
    public static final String SUMMARY_DELIM = "|";
    BaseTSDataSet _baseTSDataSet = new BaseTSDataSet();

    public TSDataSet() {
        this._baseTSDataSet.setTSRecordCreator((TSRecordCreator)this);
    }

    public TSRecord createTSRecord() {
        return TSRecordImplFactory.createTSRecord(this, 0);
    }

    public void setAltName(String name) {
        this._baseTSDataSet.setAltName(name);
    }

    public String getAltName() {
        return this._baseTSDataSet.getAltName();
    }

    public int getTSRecordCount() {
        return this._baseTSDataSet.getTSRecordCount();
    }

    public void setCompressData(boolean comp) {
        this._baseTSDataSet.setCompressData(comp);
    }

    public Hashtable getTSRecordSummaryTable(String typestr) {
        return this._baseTSDataSet.getTSRecordSummaryTable(typestr);
    }

    public void setParentPath(String path, String classname) {
        this._baseTSDataSet.setParentPath(this.makeRelativePath(path), classname);
    }

    public String getParentPath() {
        return this.makeAbsolutePath(this._baseTSDataSet.getParentPath());
    }

    public String getParentClassName() {
        return this._baseTSDataSet.getParentClassName();
    }

    public void shiftDataSet(HecTime newStartTime) {
        this._baseTSDataSet.shiftDataSet(newStartTime);
    }

    public void shiftDataSet(RunTimeWindow rtw) {
        this._baseTSDataSet.shiftDataSet(rtw);
    }

    public int getType() {
        return this._baseTSDataSet.getType();
    }

    public boolean setType(int t) {
        return this._baseTSDataSet.setType(t);
    }

    public boolean appendTSRecords(ITSDataSet tsdataset) {
        return this._baseTSDataSet.appendTSRecords(((TSDataSet)tsdataset)._baseTSDataSet);
    }

    public void compressData(boolean comp) {
        this._baseTSDataSet.setCompressData(true);
    }

    @Override
    public void init() {
    }

    public Vector getTSRecords() {
        return this._baseTSDataSet.getTSRecords();
    }

    public Vector getFilteredTSRecords(Vector list) {
        Vector tmplist = (Vector)list.clone();
        Vector<TSRecord> filteredList = new Vector<TSRecord>();
        List tsRecordVector = this._baseTSDataSet.getTSRecordList();
        block0: for (int i = 0; i < tsRecordVector.size(); ++i) {
            TSRecord rec = (TSRecord)tsRecordVector.get(i);
            if (rec == null || rec.getName() == null || rec.getParamName() == null) continue;
            for (int j = 0; j < tmplist.size(); ++j) {
                TSRecordProxy p = (TSRecordProxy)((Object)tmplist.elementAt(j));
                if (p == null || p.getName() == null || p.getParamName() == null || !p.getName().equals(rec.getName()) || !p.getParamName().equals(rec.getParamName())) continue;
                rec.setInterpUnitsType(p.getInterpUnitsType());
                filteredList.addElement(rec);
                tmplist.removeElementAt(j);
                continue block0;
            }
        }
        return filteredList;
    }

    public void updateTSRecordVector(TSManager manager) {
        if (manager == null) {
            return;
        }
        Vector prxyvec = manager.getTSRecordProxies();
        if (prxyvec == null) {
            return;
        }
        List tsRecordVector = this._baseTSDataSet.getTSRecordList();
        for (int i = 0; i < prxyvec.size(); ++i) {
            TSRecord rec;
            TSRecordProxy prxy = (TSRecordProxy)((Object)prxyvec.elementAt(i));
            if (prxy == null || (rec = this._baseTSDataSet.getTSRecord(prxy.getName(), prxy.getParamName())) != null) continue;
            int idx = tsRecordVector.size();
            rec = TSRecordImplFactory.createTSRecord(this, idx);
            rec.setName(prxy.getName());
            rec.setVariableId(prxy.getVariableId());
            rec.setParamName(prxy.getParamName());
            tsRecordVector.add(rec);
            this.setModified(true);
        }
    }

    public boolean writeTSRecords() {
        return this._baseTSDataSet.writeTSRecords();
    }

    public boolean loadFilteredTSRecords(Vector tsproxyFilterList) {
        if (tsproxyFilterList == null) {
            return this.loadTSRecords();
        }
        Vector tsvec = this.getFilteredTSRecords(tsproxyFilterList);
        return this.loadTSRecords(tsvec);
    }

    public boolean loadTSRecords() {
        return this._baseTSDataSet.loadTSRecords();
    }

    public boolean loadTSRecords(Vector tsrecVec) {
        block4: {
            try {
                DSSManager dssManager = null;
                if (this._dssFileManagerWrapper == null || (dssManager = (DSSManager)this._dssFileManagerWrapper.getRemote()) == null || !dssManager.isAlive()) {
                    this.printLogMessage("TSDataSet.loadTSRecords: attempting to get DSSFileManager wrapper");
                    if (this.getDSSFileManagerWrapper() == null) {
                        this.printErrorMessage("TSDataSet ERROR: failed to get DSSFileManager wrapper!");
                        return false;
                    }
                }
            }
            catch (RemoteException re) {
                System.out.println("TSDataSet.loadTSRecords: rmi error on _dssFileManagerWrapper.isAlive() " + re);
                System.out.println("TSDataSet.loadTSRecords: attempting to reconnect to DssFileManager");
                this._dssFileManagerWrapper = null;
                if (this.getDSSFileManagerWrapper() != null) break block4;
                this.printErrorMessage("TSDataSet ERROR: failed to get DSSFileManager wrapper!");
                return false;
            }
        }
        return this._baseTSDataSet.loadTSRecords(tsrecVec);
    }

    public TSRecord loadTSRecord(String name, int varId, String timewinstr) {
        if (this._dssFileManagerWrapper == null && this.getDSSFileManagerWrapper() == null) {
            return null;
        }
        return this._baseTSDataSet.loadTSRecord(name, varId, timewinstr);
    }

    public TSRecord loadTSRecord(String name, String param, String timewinstr) {
        if (this._dssFileManagerWrapper == null && this.getDSSFileManagerWrapper() == null) {
            return null;
        }
        return this._baseTSDataSet.loadTSRecord(name, param, timewinstr);
    }

    public void unloadTSRecord() {
        this._baseTSDataSet.unloadTSRecord();
    }

    public boolean checkFilteredTSRecords(Vector tsproxyFilterList) {
        if (tsproxyFilterList == null) {
            return this.loadTSRecords();
        }
        Vector tsvec = this.getFilteredTSRecords(tsproxyFilterList);
        return this.checkTSRecords(tsvec);
    }

    public boolean checkTSRecords(Vector tsrecVec) {
        block4: {
            try {
                DSSManager dssManager = null;
                if (this._dssFileManagerWrapper == null || (dssManager = (DSSManager)this._dssFileManagerWrapper.getRemote()) == null || !dssManager.isAlive()) {
                    this.printLogMessage("TSDataSet.checkTSRecords: attempting to get DSSFileManager wrapper");
                    if (this.getDSSFileManagerWrapper() == null) {
                        this.printErrorMessage("TSDataSet ERROR: failed to get DSSFileManager wrapper!");
                        return false;
                    }
                }
            }
            catch (RemoteException re) {
                System.out.println("TSDataSet.checkTSRecords: rmi error on _dssFileManagerWrapper.isAlive() " + re);
                System.out.println("TSDataSet.checkTSRecords: attempting to reconnect to DssFileManager");
                this._dssFileManagerWrapper = null;
                if (this.getDSSFileManagerWrapper() != null) break block4;
                this.printErrorMessage("TSDataSet ERROR: failed to get DSSFileManager wrapper!");
                return false;
            }
        }
        return this._baseTSDataSet.checkTSRecords(tsrecVec);
    }

    public boolean initialize(int beginDate, int beginTime, int timeStepMin, int numSteps, String timeWindow) {
        return this._baseTSDataSet.initialize(beginDate, beginTime, timeStepMin, numSteps, timeWindow);
    }

    public boolean initialize(RunTimeWindow rtw) {
        return this._baseTSDataSet.initialize(rtw);
    }

    public boolean reinitialize(RunTimeWindow rtw) {
        return this._baseTSDataSet.reinitialize(rtw);
    }

    public TSRecord getTSRecord(String name, int varid) {
        return this._baseTSDataSet.getTSRecord(name, varid);
    }

    public TSRecord getTSRecord(String name, String param) {
        return this._baseTSDataSet.getTSRecord(name, param);
    }

    public TSRecord getTSRecordByPathParts(String bPart, String cPart) {
        return this._baseTSDataSet.getTSRecordByPathParts(bPart, cPart);
    }

    public TSRecord createTSRecord(String name, int varid, String param) {
        return this._baseTSDataSet.createTSRecord(name, varid, param);
    }

    public TSRecord createTSRecord(String name, String param) {
        return this._baseTSDataSet.createTSRecord(name, param);
    }

    public void clearTSRecordList() {
        this._baseTSDataSet.clearTSRecordList();
    }

    public void setDSSFileManagerWrapper(RemoteWrapper dssFileManagerWrapper) {
        this._dssFileManagerWrapper = dssFileManagerWrapper;
    }

    @Override
    public boolean reLoadFile(Identifier id) {
        if (this.getReloadOk()) {
            if (id.getFile() == null) {
                return false;
            }
            boolean b = this._baseTSDataSet.reLoadFile(id.getFile().getBufferedReader());
            this.setLastModifiedTime(this._baseTSDataSet.getLastModifiedTime());
            return b;
        }
        return false;
    }

    @Override
    public boolean reLoadFile() {
        return this.reLoadFile(this._identifier);
    }

    public boolean readFile(String path) {
        if (path != null) {
            this.setPath(path);
        }
        HecFileFactory fileFactory = new HecFileFactory(path, this._identifier);
        return this.readFile(this._identifier);
    }

    @Override
    public boolean readFile(Identifier id) {
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        System.out.println("opening " + file.getPath());
        BufferedReader input = file.getBufferedReader();
        boolean success = this._baseTSDataSet.readFile(input);
        if (success) {
            this.setName(this._baseTSDataSet.getName());
            this.setDescription(this._baseTSDataSet.getDescription());
            this.setLastModifiedTime(this._baseTSDataSet.getLastModifiedTime());
            this.setModified(false);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeFile(Identifier id) {
        this.setReloadOk(false);
        HecFile file = id.getFile();
        if (file == null) {
            return false;
        }
        boolean b = false;
        try {
            BufferedWriter buffWriter = file.getBufferedWriter();
            if (buffWriter != null) {
                this.writeLastModTime(buffWriter);
                b = this._baseTSDataSet.writeFile(file.getBufferedWriter());
            }
        }
        finally {
            file.save();
            this.setReloadOk(true);
        }
        if (b) {
            this.setModified(false);
        }
        return b;
    }

    public boolean writeData(BufferedWriter out) {
        boolean b = false;
        if (out != null) {
            this.writeLastModTime(out);
            b = this.writeData(out);
            if (b) {
                this.setModified(false);
            }
        }
        return b;
    }

    public boolean readData(BufferedReader input) {
        boolean b = this._baseTSDataSet.readData(input);
        if (b) {
            this.setName(this._baseTSDataSet.getName());
            this.setDescription(this._baseTSDataSet.getDescription());
            this.setLastModifiedTime(this._baseTSDataSet.getLastModifiedTime());
            this.setModified(false);
        }
        return b;
    }

    public boolean readDataFromRas(BufferedReader input) {
        boolean b = this._baseTSDataSet.readDataFromRas(input);
        if (b) {
            this.setName(this._baseTSDataSet.getName());
            this.setDescription(this._baseTSDataSet.getDescription());
            this.setModified(false);
        }
        return b;
    }

    public boolean writeDataToRas(BufferedWriter out) {
        boolean b = this._baseTSDataSet.writeDataToRas(out);
        if (b) {
            this.setName(this._baseTSDataSet.getName());
            this.setDescription(this._baseTSDataSet.getDescription());
            this.setModified(false);
        }
        return b;
    }

    public void setDescription(String s) {
        super.setDescription(s);
        if (this._baseTSDataSet == null) {
            this._baseTSDataSet = new BaseTSDataSet();
        }
        this._baseTSDataSet.setDescription(s);
    }

    public void setName(String s) {
        super.setName(s);
        if (this._baseTSDataSet == null) {
            this._baseTSDataSet = new BaseTSDataSet();
        }
        this._baseTSDataSet.setName(s);
    }
}

