/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import com.google.common.flogger.FluentLogger;
import hec.clientapp.model.Manager;
import hec.clientapp.model.TSDataSet;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.data.IVerticalDatum;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.dss.HecTimeSeriesBase;
import hec.heclib.util.HecTime;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intArrayContainer;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.hecmath.TimeSeriesMath;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.lang.DSSPathString;
import hec.model.AbstractTSRecord;
import hec.model.RunTimeWindow;
import java.io.FileNotFoundException;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import rma.util.RMAConst;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.InterpolationMessageLoggingMarker;

public class TSRecordImpl
extends AbstractTSRecord {
    private static final MarkingClassLogger INTERPOLATION_MESSAGE_LOGGER = MarkingClassLogger.forMarkingClass(InterpolationMessageLoggingMarker.class);
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    protected TSDataSet _tsDataSet;

    protected TSRecordImpl() {
    }

    public TSRecordImpl(int index) {
        super(index);
    }

    public TSRecordImpl(TSDataSet tsData, int index) {
        super(index);
        this._tsDataSet = tsData;
    }

    public TSRecordImpl(TSDataSet tsData, Integer index) {
        super(index.intValue());
        this._tsDataSet = tsData;
    }

    public TSRecordImpl(TSRecordImpl tsRecord) {
        super((AbstractTSRecord)tsRecord);
        this._tsDataSet = tsRecord._tsDataSet;
    }

    public String getRelativePath(String pathName) {
        return this.getDataSet().getRelativePath(pathName);
    }

    public boolean writeTSDataAs(String pathname, String interpUnitsType) {
        return this.writeTSData(this.getDataSet().getDSSFileManager(), pathname, this._timeArray, this._dataArray, interpUnitsType);
    }

    public boolean writeTSData(DSSManager dssManager) {
        return this.writeTSData(dssManager, this._dssPathname, this._timeArray, this._dataArray, this._unitsType);
    }

    protected boolean writeTSData(DSSManager dssManager, String dssPathname, intArrayContainer timeArray, doubleArrayContainer dataArray, String unitsType) {
        if (dssPathname == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("writeTSData: received a null dssPathname.  No write to occur");
            return false;
        }
        if (dssManager == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("writeTSData: received a null DSSManager.  No write to occur");
            return false;
        }
        String fullPathname = this._dssFilename + "::" + dssPathname;
        if (this._dataArray.array == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("writeTSData: for " + fullPathname + " no data to write");
            return false;
        }
        DSSIdentifier dssId = new DSSIdentifier();
        dssId.setFileName(this._dssFilename);
        dssId.setDSSPath(dssPathname);
        dssId.setUnits(this._units);
        if (unitsType != null) {
            dssId.setType(unitsType);
        }
        if (this._timeWindow != null && this._timeWindow.length() > 0) {
            if (this._startTime != null && this._endTime != null) {
                dssId.setTimeWindow(this._startTime, this._endTime);
            } else {
                dssId.setTimeWindow(this._timeWindow);
            }
        } else if (this._startTime != null && this._endTime != null) {
            RunTimeWindow rtw = new RunTimeWindow(this._startTime, this._endTime, this._startTime);
            this._timeWindow = rtw.getStartTimeString() + " " + rtw.getEndTimeString();
            dssId.setTimeWindow(this._startTime, this._endTime);
        }
        if (this.hasVerticalDatum()) {
            try {
                dssId.setVerticalDatumInfo(this.getVerticalDatumInfo());
                dssId.setCurrentVerticalDatum(this.getCurrentVerticalDatum());
            }
            catch (Exception e) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Error setting vertical datum info:", (Object)e);
            }
        }
        int numberRead = -1;
        int maxRetry = Integer.getInteger("TsRecord.RetryCount", 1);
        try {
            int retry = 0;
            if (timeArray == null || timeArray.array == null || timeArray.array.length < 1 || timeArray.array[0] == Integer.MIN_VALUE) {
                while ((numberRead = dssManager.write(dssId, dataArray.array, dataArray.array.length, true, this._compressData)) < 0 && ++retry <= maxRetry) {
                }
            } else {
                TimeSeriesContainer tsc = this.getTimeSeriesContainer();
                if (tsc instanceof IVerticalDatum) {
                    tsc = ((TimeSeriesContainerVertDatum)tsc).collapseVerticalDatum();
                }
                if (!dssPathname.equalsIgnoreCase(tsc.fullName)) {
                    tsc = (TimeSeriesContainer)tsc.clone();
                    tsc.fullName = dssPathname;
                    DSSPathString pathName = new DSSPathString();
                    pathName.setPathname(dssPathname);
                    String fPart = pathName.getFPart();
                    String timeStep = pathName.getEPart();
                    tsc.interval = HecTimeSeriesBase.getIntervalFromEPart((String)timeStep);
                    tsc.type = unitsType;
                    tsc.version = fPart;
                    System.arraycopy(dataArray.array, 0, tsc.values, 0, dataArray.array.length);
                    System.arraycopy(timeArray.array, 0, tsc.times, 0, timeArray.array.length);
                }
                tsc.storedAsdoubles = true;
                tsc.setCompressData(this._compressData);
                while ((numberRead = dssManager.write((DataContainer)tsc)) < 0 && ++retry <= maxRetry) {
                }
            }
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Error in TSRecord with DSSManager  " + re);
            this.getDataSet().printErrorMessage("TSRecord.writeTSData: Error accessing remote DSS File Manager." + re);
            return false;
        }
        if (numberRead != 0) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("TSRecord.writeTSData:error writing " + this.getDSSFilename() + ":" + dssPathname + " status=" + numberRead);
        }
        return numberRead == 0;
    }

    public boolean writeTSData() {
        return this.writeTSData(this.getDataSet().getDSSFileManager());
    }

    public boolean loadTSData(HecTime startTime, HecTime endTime) {
        return this.loadTSData(this.getDataSet().getDSSFileManager(), startTime, endTime);
    }

    public boolean loadTSData(DSSManager dssManager, HecTime startTime, HecTime endTime) {
        if (this._dssFilename == null || this._dssFilename.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no dssfilename specified for rec " + this.getName());
            return false;
        }
        String fullPathname = this._dssFilename + "::" + this._dssPathname;
        DSSIdentifier dssId = new DSSIdentifier();
        dssId.setFileName(this._dssFilename);
        dssId.setDSSPath(this._dssPathname);
        dssId.setTimeWindow(startTime, endTime);
        this._dssArray = null;
        try {
            this._dssArray = dssManager.read(dssId);
            if (this._dssArray != null) {
                this._units = this._dssArray.getUnits();
                this._unitsType = this._dssArray.getType();
                String vdi = this._dssArray.getVerticalDatumInfo();
                if (vdi != null) {
                    this.setVerticalDatumInfo(vdi);
                    String cvd = this._dssArray.getCurrentVerticalDatum();
                    if (cvd != null) {
                        this.forceVerticalDatum(cvd);
                    }
                }
            }
        }
        catch (Exception re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Error in TSRecord with DSSManager  " + re);
            this.getDataSet().printErrorMessage("TSRecord.loadTSData: Error loading " + dssId + " for " + this.getName());
            return false;
        }
        if (this._dssArray == null) {
            this.getDataSet().printErrorMessage("Error in TSRecord. Empty record. " + this.getName());
            return false;
        }
        if (this._dssArray.numberRead == -1) {
            this._dssArray.numberRead = this._dssArray.numberValues;
        }
        this.getDataSet().printLogMessage(fullPathname + " Number Read " + this._dssArray.numberRead);
        if (this._dssArray.numberRead <= 0) {
            this.getDataSet().printMessage("Data Set " + fullPathname + " is empty?");
            return false;
        }
        this._timeArray.array = this._dssArray.timeArray;
        this._dataArray.array = this._dssArray.dataArray;
        this._startTime = new HecTime(startTime);
        this._endTime = new HecTime(endTime);
        this._beginDate = this._startTime.julian();
        this._beginTime = this._startTime.minute();
        this._timeWindow = "";
        return true;
    }

    public boolean loadTSData() {
        return this.loadTSData(this.getDataSet().getDSSFileManager());
    }

    protected boolean loadTSData(DSSManager dssManager) {
        int dataUnitSys;
        TimeSeriesMath tsMathGuy;
        Boolean dailyDataRunningDaily = false;
        if (this._dssFilename == null || this._dssFilename.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no dssfilename specified for rec " + this.getName());
            return false;
        }
        if (this._timeWindow == null || this._timeWindow.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no Time Window specified for rec " + this.getName());
            this.getDataSet().printMessage("Make sure one of the initialize() methods has been called first");
            return false;
        }
        if (this._startTime == null || this._endTime == null) {
            this._startTime = new HecTime(1);
            this._endTime = new HecTime(1);
            HecTime.getTimeWindow((String)this._timeWindow, (HecTime)this._startTime, (HecTime)this._endTime);
        }
        String fullPathname = this._dssFilename + "::" + this._dssPathname;
        DSSIdentifier dssId = new DSSIdentifier();
        dssId.setFileName(this._dssFilename);
        dssId.setDSSPath(this._dssPathname);
        if (((MarkingClassLogger.Api)INTERPOLATION_MESSAGE_LOGGER.atFine()).isEnabled()) {
            this.getDataSet().printLogMessage("Original Timewindow for " + this._dssPathname + " is " + this._timeWindow);
        }
        HecTime newEnd = new HecTime();
        newEnd.set(this._endTime);
        newEnd.increment(4, this._timeStepMin);
        DSSPathString pathName = new DSSPathString();
        pathName.setPathname(this._dssPathname);
        String ePart = pathName.getEPart();
        int intervalMin = HecTimeSeriesBase.getIntervalFromEPart((String)ePart);
        HecTime newStart = new HecTime();
        newStart.set(this._startTime);
        HecTime originalStart = new HecTime(newStart);
        if (this._timeStepMin < intervalMin && this._unitsType != null && !this._unitsType.toLowerCase().startsWith("per")) {
            newStart.subtract(intervalMin);
        } else if (intervalMin == 0) {
            newStart.subtract(this._timeStepMin);
            HecTimeSeries tS = new HecTimeSeries();
            tS.setPathname(this._dssPathname);
            tS.setDSSFileName(this._dssFilename);
            tS.setTimeWindow(newStart, newEnd);
            tS.setReadPreviousSubsquent(true, true);
            intArrayContainer times = new intArrayContainer();
            int numRead = tS.getTimes(times);
            if (times.array == null) {
                this.getDataSet().printErrorMessage("TSRecord.loadTSData: Error retrieving irregular data.");
                return false;
            }
            newStart = new HecTime(times.array[0], 1);
            newEnd = new HecTime(times.array[times.array.length - 1], 1);
        } else {
            if (this._timeStepMin == 1440 && intervalMin == 1440) {
                dailyDataRunningDaily = true;
            }
            if (!dailyDataRunningDaily.booleanValue()) {
                newStart.subtract(this._timeStepMin);
            }
        }
        this._timeWindow = newStart.toString(104) + " " + newEnd.toString(104);
        this._timeWindow = this._timeWindow.replaceAll(",", "");
        this._timeWindow = this._timeWindow.replaceAll(":", "");
        dssId.setTimeWindow(this._timeWindow);
        this._startTime = dssId.getStartTime();
        this._endTime = dssId.getEndTime();
        if (((MarkingClassLogger.Api)INTERPOLATION_MESSAGE_LOGGER.atFine()).isEnabled()) {
            this.getDataSet().printLogMessage("New Timewindow for " + this._dssPathname + " is " + this._timeWindow);
        }
        this._dssArray = null;
        try {
            this._dssArray = dssManager.read(dssId);
            if (this._dssArray != null) {
                this._units = this._dssArray.getUnits();
                this._unitsType = this._dssArray.getType();
            }
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Error in TSRecord with DSSManager  " + re);
            this.getDataSet().printErrorMessage("TSRecord.loadTSData: Error accessing remote DSS File Manager.");
            return false;
        }
        catch (FileNotFoundException e) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("TSRecord.loadTSData: DSS File not found " + dssId.getFileName());
            this.getDataSet().printErrorMessage("TSRecord.loadTSData: DSS File not found " + dssId.getFileName());
            return false;
        }
        if (this._dssArray == null) {
            this.getDataSet().printErrorMessage("Error in TSRecord. Empty record. " + this.getName());
            return false;
        }
        if (this._dssArray.numberRead == -1) {
            this._dssArray.numberRead = this._dssArray.numberValues;
        }
        this.getDataSet().printLogMessage(fullPathname + " Number Read " + this._dssArray.numberRead);
        if (this._dssArray.numberRead <= 0) {
            this.getDataSet().printMessage("Data Set " + fullPathname + " is empty?");
            return false;
        }
        if (this._timeStepMin < 1 || this._timeStepMin == Integer.MIN_VALUE) {
            this.getDataSet().printErrorMessage("TSRecord.loadTSData: Time Step size not set.");
        }
        if (!this.doInterpolations()) {
            String dssPath = this._dssPathname;
            DSSPathString pathN = new DSSPathString();
            pathN.setPathname(dssPath);
            if (this.getAltName() != null) {
                pathN.setFPart(pathN.getFPart() + "-" + this.getAltName());
            } else {
                pathN.setFPart(pathN.getFPart() + "-INPUT");
            }
            this.getDataSet().printMessage("TSRecord.loadTSData: Skipping interpolation of dss data for record - " + pathN.toString());
            this.writeTSDataAs(pathN.toString(), this._unitsType);
            this.loadTSData(dssManager, this._startTime, this._endTime);
            return true;
        }
        if (this._unitsType.toLowerCase().indexOf("per") != -1 && this._unitsType.toLowerCase().indexOf("cum") == -1) {
            this._unitsType = "PER-AVER";
        }
        if (this._interpUnitsType == null) {
            this._interpUnitsType = this._unitsType;
        }
        boolean instToPer = false;
        if ("PER-AVER".equals(this._interpUnitsType) && "INST-VAL".equals(this._unitsType) && RMAConst.isUndefinedValue((double)this._dssArray.dataArray[0])) {
            instToPer = true;
            this._timeWindow = originalStart.toString(104) + " " + newEnd.toString(104);
            this._timeWindow = this._timeWindow.replaceAll(",", "");
            this._timeWindow = this._timeWindow.replaceAll(":", "");
            dssId.setTimeWindow(this._timeWindow);
            this._startTime = dssId.getStartTime();
            this._endTime = dssId.getEndTime();
            if (((MarkingClassLogger.Api)INTERPOLATION_MESSAGE_LOGGER.atFine()).isEnabled()) {
                this.getDataSet().printLogMessage("New Timewindow for " + this._dssPathname + " is " + this._timeWindow);
            }
            this._dssArray = null;
            try {
                this._dssArray = dssManager.read(dssId);
            }
            catch (FileNotFoundException e) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("TSRecord.loadTSData: DSS File not found " + dssId.getFileName());
                this.getDataSet().printErrorMessage("TSRecord.loadTSData: DSS File not found " + dssId.getFileName());
                return false;
            }
            catch (RemoteException re) {
                ((FluentLogger.Api)LOGGER.atInfo()).log("Error in TSRecord with DSSManager  " + re);
                this.getDataSet().printErrorMessage("TSRecord.loadTSData: Error accessing remote DSS File Manager.");
                return false;
            }
            ((FluentLogger.Api)LOGGER.atInfo()).log("Warning in TSRecord Data Set " + fullPathname + ".  Original data must extend at least one time step outside the timewindow.  Data is needed at or before: " + originalStart.dateAndTime() + " in order for the interpolation of INST-VAL to PER-AVER to be successful.  Otherwise, the second calculated PER-AVE value will be used for the first timestep value.");
            this.getDataSet().printLogMessage("Warning in TSRecord Data Set " + fullPathname + ".  Original data must extend at least one time step outside the timewindow.  Data is needed at or before: " + originalStart.dateAndTime() + " in order for the interpolation of INST-VAL to PER-AVER to be successful. Otherwise, the second calculated PER-AVE value will be used for the first timestep value.");
        }
        if (this._unitsType == null || this._unitsType.length() == 0) {
            this._unitsType = this._interpUnitsType;
            this.getDataSet().printErrorMessage("Input timeseries " + this._dssPathname + " did not have a data type and will be used as " + this._interpUnitsType + " data in the compute.");
        }
        if (!"INST-VAL".equals(this._unitsType) && !"PER-AVER".equals(this._unitsType)) {
            if (!this.isEvapData()) {
                return false;
            }
        } else if ("PER-AVER".equals(this._unitsType) && "INST-VAL".equals(this._interpUnitsType)) {
            this.getDataSet().printErrorMessage("Error in TSRecord.loadTSData.  Input timeseries " + this._dssPathname + ".  Period Average Data can not be interpolated as Instantaneous data");
            return false;
        }
        HecTime startTime = new HecTime(1);
        HecTime endTime = new HecTime(1);
        HecTime.getTimeWindow((String)this._timeWindow, (HecTime)startTime, (HecTime)endTime);
        int startMinutes = startTime.value();
        this._startTime = startTime;
        this._endTime = endTime;
        this._timeArray.setSize(this._dssArray.dataArray.length);
        this._dataArray.setSize(this._dssArray.dataArray.length);
        System.arraycopy(this._dssArray.dataArray, 0, this._dataArray.array, 0, this._dssArray.dataArray.length);
        System.arraycopy(this._dssArray.timeArray, 0, this._timeArray.array, 0, this._dssArray.timeArray.length);
        int simOffSet = startTime.getIntervalOffset(2);
        String simOffSetString = Integer.toString(simOffSet) + "Minute";
        TimeSeriesContainer outputDc = null;
        TimeSeriesMath mathGuy = null;
        HecMath outputMath = null;
        TimeSeriesContainer dc = this.getTimeSeriesContainer();
        if (this._unitsType.equals("PER-AVER")) {
            dc.type = this._unitsType;
        }
        int offSet = startMinutes - this._dssArray.timeArray[0];
        int timeStep = 0;
        if (this._dssArray.timeArray.length >= 2) {
            timeStep = this._dssArray.timeArray[1] - this._dssArray.timeArray[0];
        }
        HecTime stim = new HecTime(this._dssArray.timeArray[0], 1);
        int tsOffSet = stim.getIntervalOffset(60);
        if (timeStep == 1440 && offSet != 0 && ((MarkingClassLogger.Api)INTERPOLATION_MESSAGE_LOGGER.atInfo()).isEnabled()) {
            this.getDataSet().printMessage(" Input timeseries " + this._dssPathname + ".  Daily time step offset will be ignored and assumed as the 2400 hour in the compute.");
        }
        if (this.shouldInterpEvapData() || this.isInputData()) {
            if (!dailyDataRunningDaily.booleanValue()) {
                tsMathGuy = new TimeSeriesMath();
                outputDc = new TimeSeriesContainer();
                try {
                    dc.startTime = startMinutes;
                    dc.interval = intervalMin;
                    tsMathGuy.setData((DataContainer)dc);
                    outputMath = tsMathGuy.interpolateDataAtRegularInterval(this._timeIncrString, simOffSetString);
                    outputDc = outputMath.getData();
                }
                catch (HecMathException e) {
                    this.getDataSet().printErrorMessage("Interpolate: Exception : Unable to process Input timeseries " + this._dssPathname + " in TSRecord.loadTSData" + e);
                    return false;
                }
                if (RMAConst.isUndefinedValue((double)outputDc.values[0])) {
                    this._dataArray.resize(outputDc.values.length - 1);
                    this._timeArray.resize(outputDc.values.length - 1);
                    System.arraycopy(outputDc.values, 1, this._dataArray.array, 0, outputDc.values.length - 1);
                    System.arraycopy(outputDc.times, 1, this._timeArray.array, 0, outputDc.times.length - 1);
                } else {
                    this._dataArray.resize(outputDc.values.length);
                    this._timeArray.resize(outputDc.values.length);
                    System.arraycopy(outputDc.values, 0, this._dataArray.array, 0, outputDc.values.length);
                    System.arraycopy(outputDc.times, 0, this._timeArray.array, 0, outputDc.times.length);
                }
                if (((MarkingClassLogger.Api)INTERPOLATION_MESSAGE_LOGGER.atInfo()).isEnabled()) {
                    if (intervalMin != 0 && timeStep != this._timeStepMin) {
                        this.getDataSet().printMessage("Changing input timeseries " + this._dssPathname + " time interval. Was " + timeStep + " minutes.  Converted to " + this._timeStepMin + " minute interval. ");
                    }
                    if (intervalMin == 0) {
                        this.getDataSet().printMessage("Changing input timeseries " + this._dssPathname + " data from irregular to regular. Converted to " + this._timeStepMin + " minute interval. ");
                    }
                    if (offSet > 0) {
                        this.getDataSet().printMessage("Interpolating input timeseries " + this._dssPathname + " data from offset of " + tsOffSet + " minutes to " + simOffSet + " minutes.");
                    }
                }
            }
        } else if (!(offSet == 0 && timeStep == this._timeStepMin && intervalMin != 0 && this._unitsType.equals(this._interpUnitsType) || timeStep == this._timeStepMin && timeStep == 1440 && this._unitsType.equals(this._interpUnitsType))) {
            if (this._unitsType.equals(this._interpUnitsType)) {
                mathGuy = tsMathGuy = new TimeSeriesMath();
                outputDc = new TimeSeriesContainer();
                try {
                    dc.startTime = startMinutes;
                    dc.interval = intervalMin;
                    mathGuy.setData((DataContainer)dc);
                    outputMath = tsMathGuy.interpolateDataAtRegularInterval(this._timeIncrString, simOffSetString);
                    outputDc = outputMath.getData();
                }
                catch (HecMathException e) {
                    this.getDataSet().printErrorMessage("Interpolate: Exception : Unable to process Input timeseries " + this._dssPathname + " in TSRecord.loadTSData" + e);
                    return false;
                }
                if (RMAConst.isUndefinedValue((double)outputDc.values[0])) {
                    this._dataArray.resize(outputDc.values.length - 1);
                    this._timeArray.resize(outputDc.values.length - 1);
                    System.arraycopy(outputDc.values, 1, this._dataArray.array, 0, outputDc.values.length - 1);
                    System.arraycopy(outputDc.times, 1, this._timeArray.array, 0, outputDc.times.length - 1);
                } else {
                    this._dataArray.resize(outputDc.values.length);
                    this._timeArray.resize(outputDc.values.length);
                    System.arraycopy(outputDc.values, 0, this._dataArray.array, 0, outputDc.values.length);
                    System.arraycopy(outputDc.times, 0, this._timeArray.array, 0, outputDc.times.length);
                }
                if (((MarkingClassLogger.Api)INTERPOLATION_MESSAGE_LOGGER.atInfo()).isEnabled()) {
                    if (intervalMin != 0 && timeStep != this._timeStepMin) {
                        this.getDataSet().printMessage("Changing input timeseries " + this._dssPathname + " time interval. Was " + timeStep + " minutes.  Converted to " + this._timeStepMin + " minute interval. ");
                    }
                    if (intervalMin == 0) {
                        this.getDataSet().printMessage("Changing input timeseries " + this._dssPathname + " data from irregular to regular. Converted to " + this._timeStepMin + " minute interval. ");
                    }
                    if (offSet > 0) {
                        this.getDataSet().printMessage("Interpolating input timeseries " + this._dssPathname + " data from offset of " + tsOffSet + " minutes to " + simOffSet + " minutes.");
                    }
                }
            } else {
                mathGuy = tsMathGuy = new TimeSeriesMath();
                outputDc = new TimeSeriesContainer();
                try {
                    mathGuy.setData((DataContainer)dc);
                    outputMath = tsMathGuy.transformTimeSeries(this._timeIncrString, simOffSetString, "AVE", false);
                    outputDc = outputMath.getData();
                    if (RMAConst.isUndefinedValue((double)outputDc.values[0])) {
                        if (instToPer) {
                            this._dataArray.resize(outputDc.values.length);
                            this._timeArray.resize(outputDc.values.length);
                            System.arraycopy(outputDc.values, 0, this._dataArray.array, 0, outputDc.values.length);
                            this._dataArray.array[0] = outputDc.values[1];
                            System.arraycopy(outputDc.times, 0, this._timeArray.array, 0, outputDc.times.length);
                        } else {
                            this._dataArray.resize(outputDc.values.length - 1);
                            this._timeArray.resize(outputDc.values.length - 1);
                            System.arraycopy(outputDc.values, 1, this._dataArray.array, 0, outputDc.values.length - 1);
                            System.arraycopy(outputDc.times, 1, this._timeArray.array, 0, outputDc.times.length - 1);
                        }
                    } else {
                        this._dataArray.resize(outputDc.values.length);
                        this._timeArray.resize(outputDc.values.length);
                        System.arraycopy(outputDc.values, 0, this._dataArray.array, 0, outputDc.values.length);
                        System.arraycopy(outputDc.times, 0, this._timeArray.array, 0, outputDc.times.length);
                    }
                }
                catch (HecMathException e) {
                    this.getDataSet().printErrorMessage("Interpolate: Exception : Unable to process input timeseries " + this._dssPathname + " in TSRecord.loadTSData" + e);
                    return false;
                }
                if (((MarkingClassLogger.Api)INTERPOLATION_MESSAGE_LOGGER.atInfo()).isEnabled()) {
                    if (intervalMin != 0) {
                        this.getDataSet().printMessage("Converting input timeseries " + this._dssPathname + " data type from INST-VAL to PER-AVER.");
                    } else {
                        this.getDataSet().printMessage("Changing input timeseries " + this._dssPathname + " data from irregular to regular. Converted to PER-AVER data at a " + this._timeStepMin + " minute interval. ");
                    }
                    if (timeStep != this._timeStepMin) {
                        this.getDataSet().printMessage("Time interval was " + timeStep + " minutes.  Converted to " + this._timeStepMin + " minute interval. ");
                    }
                }
            }
        }
        if (!dailyDataRunningDaily.booleanValue()) {
            for (int i = 0; i < this._timeArray.array.length; ++i) {
                HecTime checkStart = new HecTime(this._timeArray.array[i], 1);
                if (originalStart.compareTimes(checkStart) != 0) continue;
                System.arraycopy(this._dataArray.array, i, this._dataArray.array, 0, this._dataArray.array.length - i);
                System.arraycopy(this._timeArray.array, i, this._timeArray.array, 0, this._timeArray.array.length - i);
                this._dataArray.resize(this._dataArray.array.length - i);
                this._timeArray.resize(this._timeArray.array.length - i);
            }
        }
        this._units = this._units.toLowerCase();
        int unitSys = dataUnitSys = Units.getUnitSystemForUnits((String)this._units);
        try {
            RmiWorkspace wksp = (RmiWorkspace)this.getDataSet().getWorkspace().getRemote();
            unitSys = wksp.getUnitSystem();
        }
        catch (RemoteException wksp) {
            // empty catch block
        }
        if (unitSys != dataUnitSys && dataUnitSys != 0 || this.shouldInterpEvapData()) {
            mathGuy = new TimeSeriesMath();
            outputDc = new TimeSeriesContainer();
            dc = this.getTimeSeriesContainer();
            try {
                String toUnits;
                String fromUnits;
                mathGuy.setData((DataContainer)dc);
                if (unitSys == 1) {
                    outputMath = mathGuy.convertToEnglishUnits();
                    outputDc = outputMath.getData();
                    if (this.shouldInterpEvapData()) {
                        fromUnits = outputDc.units;
                        toUnits = "ft";
                        try {
                            Units.convertUnits((double[])outputDc.values, (String)fromUnits, (String)toUnits);
                            outputDc.units = toUnits;
                        }
                        catch (UnitsConversionException e) {
                            this.getDataSet().printMessage("Unable to convert Evaporation data units from " + fromUnits + " to " + toUnits + ". ");
                            return false;
                        }
                    }
                } else {
                    outputMath = mathGuy.convertToMetricUnits();
                    outputDc = outputMath.getData();
                    if (this.shouldInterpEvapData()) {
                        fromUnits = outputDc.units;
                        fromUnits = fromUnits.toLowerCase();
                        toUnits = "meter";
                        try {
                            Units.convertUnits((double[])outputDc.values, (String)fromUnits, (String)toUnits);
                            outputDc.units = toUnits;
                        }
                        catch (UnitsConversionException e) {
                            this.getDataSet().printMessage("Unable to convert Evaporation data units from " + fromUnits + " to " + toUnits + ". ");
                            return false;
                        }
                    }
                }
                this._units = outputDc.units;
            }
            catch (HecMathException e) {
                this.getDataSet().printErrorMessage("Interpolate: Exception : Unable to process Input timeseries " + this._dssPathname + " in TSRecord.loadTSData" + e);
                return false;
            }
            if (RMAConst.isUndefinedValue((double)outputDc.values[0])) {
                this._dataArray.resize(outputDc.values.length - 1);
                this._timeArray.resize(outputDc.values.length - 1);
                System.arraycopy(outputDc.values, 1, this._dataArray.array, 0, outputDc.values.length - 1);
                System.arraycopy(outputDc.times, 1, this._timeArray.array, 0, outputDc.times.length - 1);
            } else {
                this._dataArray.resize(outputDc.values.length);
                this._timeArray.resize(outputDc.values.length);
                System.arraycopy(outputDc.values, 0, this._dataArray.array, 0, outputDc.values.length);
                System.arraycopy(outputDc.times, 0, this._timeArray.array, 0, outputDc.times.length);
            }
        }
        if (this.writeInterpolatedInputData()) {
            String dssPath = this._dssPathname;
            DSSPathString pathN = new DSSPathString();
            pathN.setPathname(dssPath);
            if (this.getAltName() != null) {
                pathN.setFPart(pathN.getFPart() + "-" + this.getAltName());
            } else {
                pathN.setFPart(pathN.getFPart() + "-INPUT");
            }
            pathN.setEPart(this._timeIncrString);
            if (this.shouldInterpEvapData() || this.isInputData()) {
                this.writeTSDataAs(pathN.toString(), this._unitsType);
            } else {
                this.writeTSDataAs(pathN.toString(), this._interpUnitsType);
            }
        }
        this._timeWindow = originalStart.toString(104) + " " + this._endTime.toString(104);
        this._timeWindow = this._timeWindow.replaceAll(",", "");
        this._timeWindow = this._timeWindow.replaceAll(":", "");
        dssId.setTimeWindow(this._timeWindow);
        this._startTime = dssId.getStartTime();
        this._endTime = dssId.getEndTime();
        return true;
    }

    protected boolean shouldInterpEvapData() {
        return false;
    }

    protected boolean isEvapData() {
        return true;
    }

    protected boolean isInputData() {
        return false;
    }

    protected boolean writeInterpolatedInputData() {
        return true;
    }

    protected boolean doInterpolations() {
        return true;
    }

    public boolean loadRawTSData() {
        return this.loadRawTSData(this.getDataSet().getDSSFileManager());
    }

    public boolean loadRawTSData(DSSManager dssManager) {
        if (this._dssFilename == null || this._dssFilename.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no dssfilename specified for rec " + this.getName());
            return false;
        }
        if (this._timeWindow == null || this._timeWindow.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no Time Window specified for rec " + this.getName());
            this.getDataSet().printMessage("Make sure one of the initialize() methods has been called first");
            return false;
        }
        String fullPathname = this._dssFilename + "::" + this._dssPathname;
        DSSIdentifier dssId = new DSSIdentifier();
        dssId.setFileName(this._dssFilename);
        dssId.setDSSPath(this._dssPathname);
        HecTime lookbackTime = new HecTime(1);
        HecTime endTime = new HecTime(1);
        HecTime.getTimeWindow((String)this._timeWindow, (HecTime)lookbackTime, (HecTime)endTime);
        HecTime startTime = new HecTime(lookbackTime);
        startTime.add(60);
        RunTimeWindow rtwTmp = new RunTimeWindow();
        rtwTmp.setLookbackTime(lookbackTime);
        rtwTmp.setStartTime(startTime);
        endTime.add(this._timeStepMin);
        rtwTmp.setEndTime(endTime);
        rtwTmp.setTimeStep(1, 2);
        String timeWindow = rtwTmp.getTimeWindowString();
        dssId.setTimeWindow(timeWindow);
        this._dssArray = null;
        int maxRetry = Integer.getInteger("TsRecord.RetryCount", 1);
        int retryCnt = 0;
        boolean loaded = false;
        do {
            block9: {
                try {
                    this._dssArray = dssManager.read(dssId);
                    if (this._dssArray != null) {
                        this._units = this._dssArray.getUnits();
                        this._unitsType = this._dssArray.getType();
                    }
                    loaded = true;
                }
                catch (FileNotFoundException e) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("TSRecord.loadRawTSData: DSS File not found " + dssId.getFileName());
                    this.getDataSet().printErrorMessage("TSRecord.loadRawTSData: DSS File not found " + dssId.getFileName());
                }
                catch (RemoteException re) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("Error in TSRecord with DSSManager  " + re);
                    this.getDataSet().printErrorMessage("TSRecord.checkTSData: Error accessing remote DSS File Manager.");
                    if (retryCnt <= 0) break block9;
                    re.printStackTrace();
                }
            }
            if (this._dssArray != null) break;
            this.getDataSet().printErrorMessage("Error in TSRecord. Empty record. " + this.getName());
            loaded = false;
        } while (++retryCnt <= maxRetry && !loaded);
        if (!loaded) {
            return false;
        }
        if (this._dssArray.numberRead == -1) {
            this._dssArray.numberRead = this._dssArray.numberValues;
        }
        this._startTime = new HecTime(rtwTmp.getLookbackTime());
        this._endTime = new HecTime(rtwTmp.getEndTime());
        this._beginDate = this._startTime.julian();
        this._beginTime = this._startTime.minute();
        this._dataArray.array = this._dssArray.dataArray;
        this._timeArray.array = this._dssArray.timeArray;
        return true;
    }

    public boolean isValidValue() {
        return this.isValidValue(this.getDataSet().getDSSFileManager());
    }

    public boolean isValidValue(DSSManager dssManager) {
        if (this._dssFilename == null || this._dssFilename.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no dssfilename specified for rec " + this.getName());
            return false;
        }
        if (this._timeWindow == null || this._timeWindow.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no Time Window specified for rec " + this.getName());
            this.getDataSet().printMessage("Make sure one of the initialize() methods has been called first");
            return false;
        }
        String fullPathname = this._dssFilename + "::" + this._dssPathname;
        DSSIdentifier dssId = new DSSIdentifier();
        dssId.setFileName(this._dssFilename);
        dssId.setDSSPath(this._dssPathname);
        dssId.setTimeWindow(this._timeWindow);
        this._dssArray = null;
        try {
            this._dssArray = dssManager.read(dssId);
        }
        catch (FileNotFoundException e) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("TSRecord.isValidValue: DSS File not found " + dssId.getFileName());
            this.getDataSet().printErrorMessage("TSRecord.isValidValue: DSS File not found " + dssId.getFileName());
            return false;
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Error in TSRecord with DSSManager  " + re);
            this.getDataSet().printErrorMessage("TSRecord.checkTSData: Error accessing remote DSS File Manager.");
            return false;
        }
        return this._dataArray.isValidValue();
    }

    public boolean checkTSData() {
        return this.checkTSData(this.getDataSet().getDSSFileManager());
    }

    private boolean checkTSData(DSSManager dssManager) {
        if (this._dssFilename == null || this._dssFilename.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no dssfilename specified for rec " + this.getName());
            return false;
        }
        if (this._timeWindow == null || this._timeWindow.length() == 0) {
            this.getDataSet().printMessage("TSRecord ERROR: no Time Window specified for rec " + this.getName());
            this.getDataSet().printMessage("Make sure one of the initialize() methods has been called first");
            return false;
        }
        String fullPathname = this._dssFilename + "::" + this._dssPathname;
        DSSIdentifier dssId = new DSSIdentifier();
        dssId.setFileName(this._dssFilename);
        dssId.setDSSPath(this._dssPathname);
        dssId.setTimeWindow(this._timeWindow);
        this._dssArray = null;
        try {
            this._dssArray = dssManager.read(dssId);
            if (this._dssArray != null) {
                this._units = this._dssArray.getUnits();
                this._unitsType = this._dssArray.getType();
            }
        }
        catch (FileNotFoundException e) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("TSRecord.checkTSData: DSS File not found " + dssId.getFileName());
            this.getDataSet().printErrorMessage("TSRecord.checkTSData: DSS File not found " + dssId.getFileName());
            return false;
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Error in TSRecord with DSSManager  " + re);
            this.getDataSet().printErrorMessage("TSRecord.checkTSData: Error accessing remote DSS File Manager.");
            return false;
        }
        if (this._dssArray == null) {
            this.getDataSet().printErrorMessage("Error in TSRecord. Empty record. " + this.getName());
            return false;
        }
        if (this._dssArray.numberRead == -1) {
            this._dssArray.numberRead = this._dssArray.numberValues;
        }
        this.getDataSet().printLogMessage(fullPathname + " Number Read " + this._dssArray.numberRead);
        if (this._dssArray.numberRead <= 0 || this._dssArray.dataArray == null || this._dssArray.timeArray == null) {
            this.getDataSet().printErrorMessage("Data Set " + fullPathname + " is empty?");
            return false;
        }
        if (this._timeStepMin < 1 || this._timeStepMin == Integer.MIN_VALUE) {
            this.getDataSet().printErrorMessage("TSRecord.checkTSData: Time Step size not set.");
        }
        HecTime startTime = new HecTime(1);
        HecTime endTime = new HecTime(1);
        HecTime.getTimeWindow((String)this._timeWindow, (HecTime)startTime, (HecTime)endTime);
        int startMinutes = startTime.value();
        for (int i = 0; i < this._dssArray.numberRead; ++i) {
            if (this._dssArray.timeArray[i] == Integer.MIN_VALUE) {
                this.getDataSet().printErrorMessage("Undefined data for  " + fullPathname);
                return false;
            }
            if (this._dssArray.dataArray[i] != -3.4028234663852886E38) continue;
            this.getDataSet().printErrorMessage("Undefined data for  " + fullPathname);
            return false;
        }
        return true;
    }

    public void setTSDataSet(TSDataSet tsds) {
        this._tsDataSet = tsds;
    }

    public void unloadTSData() {
        this._dataArray = null;
        this._dssArray = null;
        this._timeArray = null;
        if (this._tsDataSet != null) {
            this._tsDataSet.clearTSRecordList();
            this._tsDataSet = null;
        }
    }

    public Manager getDataSet() {
        return this._tsDataSet;
    }

    public String getAltName() {
        return this._tsDataSet.getAltName();
    }
}

