/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.clientapp.model.TSDataSet;
import hec.clientapp.model.TSRecordImpl;
import hec.model.TSRecord;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class TSRecordImplFactory {
    private static String _tsRecordCls;

    private TSRecordImplFactory() {
    }

    public static TSRecord createTSRecord(TSDataSet parent, int idx) {
        TSRecord tsRecord;
        Constructor<?> ctor;
        Class<?> cls;
        if (_tsRecordCls == null) {
            return new TSRecordImpl(parent, idx);
        }
        try {
            cls = Class.forName(_tsRecordCls);
        }
        catch (ClassNotFoundException e) {
            System.out.println("createTSRecord: ClassNotFoundException " + e);
            return new TSRecordImpl(parent, idx);
        }
        Class[] parameterTypes = new Class[]{TSDataSet.class, Integer.class};
        try {
            ctor = cls.getConstructor(parameterTypes);
        }
        catch (SecurityException e) {
            System.out.println("createTSRecord: SecurityException " + e);
            return new TSRecordImpl(parent, idx);
        }
        catch (NoSuchMethodException e) {
            System.out.println("createTSRecord: NoSuchMethodException " + e);
            return new TSRecordImpl(parent, idx);
        }
        Object[] initargs = new Object[]{parent, idx};
        try {
            tsRecord = (TSRecord)ctor.newInstance(initargs);
        }
        catch (IllegalArgumentException e) {
            System.out.println("createTSRecord:IllegalArgumentException " + e);
            return new TSRecordImpl(parent, idx);
        }
        catch (InstantiationException e) {
            System.out.println("createTSRecord:InstantiationException " + e);
            return new TSRecordImpl(parent, idx);
        }
        catch (IllegalAccessException e) {
            System.out.println("createTSRecord: IllegalAccessException " + e);
            return new TSRecordImpl(parent, idx);
        }
        catch (InvocationTargetException e) {
            System.out.println("createTsRecord: InvocationTargetException " + e);
            e.getTargetException().printStackTrace();
            return new TSRecordImpl(parent, idx);
        }
        return tsRecord;
    }

    public static void setTSRecordClass(String classname) {
        _tsRecordCls = classname;
    }

    public static String getTSRecordClass() {
        if (_tsRecordCls == null) {
            return TSRecordImpl.class.getName();
        }
        return _tsRecordCls;
    }
}

