/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.model;

import hec.appInterface.IToolBarButtonItem;
import hec.appInterface.ToolBarButtonManager;
import hec.clientapp.client.ClientApp;
import hec.clientapp.client.ClientMode;
import hec.io.Identifier;
import hec.lang.PreferencesConstants;
import hec.map.MapGlyph;
import hec.map.MapPanel;
import hec.map.ModeDrawingAttributeSet;
import hec.map.ModelDrawingAttributeSet;
import hec.map.ToolBarButtonItem;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JPanel;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import rma.swing.RmaGlyphButtonInfo;
import rma.swing.RmaJAttributeToolbarButton;
import rma.swing.RmaJToolbarButton;
import rma.util.RMAIO;

public class ToolBarButtonManagerImpl
implements ToolBarButtonManager,
PreferencesConstants {
    private ClientMode _module;
    private Vector _toolBarItems;
    private boolean _defaultButtons = true;
    private int _location = -1;

    public ToolBarButtonManagerImpl(ClientMode module) {
        this._module = module;
        this._toolBarItems = new Vector();
    }

    public void addToolBarButton(IToolBarButtonItem item) {
        if (item == null) {
            return;
        }
        if (this._defaultButtons) {
            this.clearToolbarButtons();
            this._defaultButtons = false;
        }
        this._toolBarItems.add(item);
        this.addItem(item);
        JPanel panel = this._module.getToolBarItems();
        panel.revalidate();
        panel.repaint();
        this.save();
    }

    public void resetDefaultToolbars() {
        this.clearToolbarButtons();
        String fileName = this.getFileName();
        int loc = PreferencesManager.getLocationForFile((String)fileName);
        switch (loc) {
            case 0: 
            case 1: {
                String fullPath = PreferencesManager.getFileName((String)fileName);
                RmiFileManager fm = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
                try {
                    fm.deleteFile(fullPath);
                    break;
                }
                catch (RemoteException re) {
                    System.out.println("resetDefaultToolbars: RMI Error with RmiFileManager removing file. Error " + re);
                }
            }
        }
        BufferedReader reader = PreferencesManager.getBufferedReader((int)2, (String)fileName);
        if (reader == null) {
            reader = PreferencesManager.getBufferedReader((int)3, (String)fileName);
        }
        if (reader != null) {
            this._defaultButtons = false;
            this.load(reader);
            try {
                reader.close();
            }
            catch (IOException fm) {
                // empty catch block
            }
        }
        JPanel panel = this._module.getToolBarItems();
        panel.revalidate();
        panel.repaint();
    }

    public void removeToolBarButton(IToolBarButtonItem item) {
        if (item == null) {
            return;
        }
        JPanel panel = this._module.getToolBarItems();
        Component[] comps = panel.getComponents();
        for (int i = comps.length - 1; i >= 0; --i) {
            RmaJToolbarButton button;
            RmaGlyphButtonInfo info;
            if (!(comps[i] instanceof RmaJToolbarButton) || !(info = (button = (RmaJToolbarButton)comps[i]).getGlyphButtonInfo()).getAttributeSetName().equalsIgnoreCase(item.getName()) || !info.getGlyphElement().equals(item.getAttributeName())) continue;
            panel.remove((Component)button);
            this._toolBarItems.remove(item);
            button.removeActionListener((ActionListener)ClientApp.frame().getMapPanel());
            if (button instanceof RmaJAttributeToolbarButton) {
                ((RmaJAttributeToolbarButton)button).removeListeners();
            }
            panel.revalidate();
            panel.repaint();
            this.save();
            return;
        }
    }

    public boolean contains(IToolBarButtonItem item) {
        if (item == null) {
            return false;
        }
        return this._toolBarItems.contains(item);
    }

    public void save() {
        BufferedWriter writer = PreferencesManager.getBufferedWriter((int)0, (String)(RMAIO.userNameToFileName((String)this._module.toString()) + ".tbb"));
        if (writer != null) {
            try {
                this.save(writer);
            }
            catch (IOException ioe) {
                System.out.println("ToolBarButtonManager.save: error writing file " + ioe);
            }
        }
    }

    public void save(BufferedWriter writer) throws IOException {
        if (writer == null) {
            return;
        }
        for (int i = 0; i < this._toolBarItems.size(); ++i) {
            ToolBarButtonItem item = (ToolBarButtonItem)this._toolBarItems.get(i);
            item.write(writer);
        }
        writer.close();
    }

    public void load() {
        BufferedReader reader = PreferencesManager.getBufferedReader((String)this.getFileName());
        if (reader != null) {
            this._defaultButtons = false;
            this.load(reader);
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void load(BufferedReader reader) {
        ToolBarButtonItem item;
        this._toolBarItems.clear();
        this.clearToolbarButtons();
        if (reader == null) {
            return;
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("ToolBarButtonItemBegin")) continue;
                item = new ToolBarButtonItem();
                item.read(reader);
                this._toolBarItems.add(item);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (int i = 0; i < this._toolBarItems.size(); ++i) {
            item = (ToolBarButtonItem)this._toolBarItems.get(i);
            this.addItem((IToolBarButtonItem)item);
        }
    }

    private void clearToolbarButtons() {
        JPanel panel = this._module.getToolBarItems();
        Component[] comps = panel.getComponents();
        if (ClientApp.frame() == null) {
            return;
        }
        MapPanel mapPanel = ClientApp.frame().getMapPanel();
        for (int i = comps.length - 1; i >= 0; --i) {
            if (!(comps[i] instanceof RmaJToolbarButton)) continue;
            ((RmaJToolbarButton)comps[i]).removeActionListener((ActionListener)mapPanel);
            if (comps[i] instanceof RmaJAttributeToolbarButton) {
                ((RmaJAttributeToolbarButton)comps[i]).removeListeners();
            }
            panel.remove(i);
        }
    }

    private void addItem(IToolBarButtonItem item) {
        ModeDrawingAttributeSet mdas;
        ModelDrawingAttributeSet aset = null;
        MapPanel mapPanel = this._module.getFrame().getMapPanel();
        if (item.getGlyphId() == null) {
            return;
        }
        Identifier glyphId = item.getGlyphId();
        MapGlyph glyph = mapPanel.findGlyphOfClass(glyphId.getClassName());
        if (item.getChildGlyphId() != null) {
            glyphId = item.getChildGlyphId();
            if (glyph != null) {
                glyph = glyph.findGlyphOfClass(glyphId.getClassName());
            }
        }
        if ((mdas = ModeDrawingAttributeSet.getModeAttributeSet((String)this._module.toString())) != null) {
            aset = mdas.getModelAttributeSet(item.getName());
        }
        if (aset == null && glyph != null && item.getAttributeName() != null) {
            aset = glyph.getAttributeSet();
        }
        RmaGlyphButtonInfo glyphInfo = new RmaGlyphButtonInfo(item.getUnselectedIconName(), item.getSelectedIconName(), glyphId.getClassName(), item.getAttributeName(), "Tool Tip Text");
        glyphInfo.setNeedsBorder(true);
        if (aset != null) {
            glyphInfo.setAttributeSetName(aset.getName());
            glyphInfo.setSelected(aset.isAttributeShown(item.getAttributeName()));
        } else if (item.getAttributeName() != null) {
            glyphInfo.setAttributeSetName(item.getName());
        }
        glyphInfo.setToolTip(item.getToolTipText());
        this._module.addToolBarButton(glyphInfo);
    }

    private String getFileName() {
        return RMAIO.userNameToFileName((String)this._module.toString()) + ".tbb";
    }
}

