/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.properties;

import hec.clientapp.client.ClientApp;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.UserId;
import hec.properties.HECProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.model.PreferencesManager;
import rma.lang.Modifiable;

public abstract class HECRemoteProperties
extends HECProperties
implements Serializable,
Modifiable {
    private HecFile _hecFile;
    RmiFileManager _fileManager = (RmiFileManager)ClientApp.app().getFileManager().getRemote();
    protected static boolean _debug = Boolean.getBoolean("HECRemoteProperties.debug");
    protected int _propsLocation;
    private String _relativeFileName;
    protected boolean _newFile;

    public HECRemoteProperties() {
    }

    public HECRemoteProperties(String fileName) {
        this(fileName, 1);
    }

    public HECRemoteProperties(String filename, int propsLocation) {
        this();
        this._relativeFileName = filename;
        this._propsLocation = propsLocation;
        this.initializeProperties();
    }

    protected void initializeProperties() {
        String dFileName;
        if (PreferencesManager.getFileManager() == null) {
            PreferencesManager.setFileManager((RmiFileManager)this._fileManager);
        }
        if ((dFileName = PreferencesManager.getFileName((String)this._relativeFileName)) == null) {
            dFileName = PreferencesManager.getFileName((int)this._propsLocation, (String)this._relativeFileName);
        }
        if (_debug) {
            System.out.println("HECRemoteProperties: filename " + this._relativeFileName + "->" + dFileName);
        }
        this.openFile(dFileName);
    }

    boolean openFile(String dFileName) {
        this._newFile = false;
        if (dFileName == null || dFileName.isEmpty()) {
            return false;
        }
        Identifier id = new Identifier(dFileName);
        Identifier openId = null;
        if (this._fileManager == null) {
            return false;
        }
        try {
            openId = this._fileManager.openFile(UserId.getUserId(), id);
            if (openId == null) {
                openId = this._fileManager.newFile(UserId.getUserId(), id);
                if (_debug) {
                    System.out.println("openFile:created new file " + openId.getPath());
                }
                this._newFile = true;
            } else if (_debug) {
                System.out.println("openFile:opened existing file " + openId.getPath());
            }
        }
        catch (RemoteException re) {
            System.out.println("HECRMIProperties: RMI Error opening " + id + " with RmiFileManager " + re);
        }
        this._hecFile = openId.getFile();
        if (!this._newFile) {
            this.loadProperties();
        } else {
            this.saveProperties();
        }
        int loc = PreferencesManager.getLocationForFile((String)this._hecFile.getPath());
        if (PreferencesManager.isValidLocation((int)loc)) {
            this._propsLocation = loc;
        }
        return this._hecFile != null;
    }

    public void loadProperties() {
        if (this._hecFile == null) {
            return;
        }
        try {
            ByteArrayInputStream bais = this._hecFile.getByteArrayInputStream();
            this.properties.load(bais);
            bais.close();
            this._loaded = true;
        }
        catch (Exception ioe) {
            System.out.println("Properties file " + this._hecFile.getPath() + " not found " + ioe);
            System.out.println("using default properties");
        }
    }

    public void saveProperties(int propsLocation) {
        if (propsLocation == this._propsLocation && PreferencesManager.getLocationForFile((String)this._hecFile.getPath()) == propsLocation) {
            this.saveProperties();
            return;
        }
        String dFileName = PreferencesManager.getFileName((int)propsLocation, (String)this._relativeFileName);
        if (_debug) {
            System.out.println("saveProperties: filename " + this._relativeFileName + "->" + dFileName);
        }
        Identifier id = new Identifier(dFileName);
        Identifier openId = null;
        try {
            openId = this._fileManager.openFile(UserId.getUserId(), id);
            if (openId == null) {
                openId = this._fileManager.newFile(UserId.getUserId(), id);
                if (_debug) {
                    System.out.println("saveProperties:created new file " + openId);
                }
            } else if (_debug) {
                System.out.println("saveProperties:opened existing file " + openId);
            }
        }
        catch (RemoteException re) {
            System.out.println("saveProperties: RMI Error opening " + id + " with RmiFileManager " + re);
        }
        HecFile hecFile = openId.getFile();
        this.saveProperties(hecFile);
    }

    public void saveProperties() {
        this.saveProperties(this._hecFile);
    }

    private void saveProperties(HecFile hecFile) {
        if (hecFile == null) {
            return;
        }
        if (_debug) {
            System.out.println("saveProperties:saving to " + hecFile.getPath());
        }
        try {
            ByteArrayOutputStream baos = hecFile.getByteArrayOutputStream();
            this.properties.save(baos, this.getHeader());
            baos.close();
        }
        catch (Exception ioe) {
            System.out.println("savePropertiesProperties file " + hecFile.getPath() + " not found " + ioe);
            System.out.println("saveProperties using default properties");
        }
    }

    public void setProp(String prop, String value) {
        this.properties.put(prop, value);
        this.setModified(true);
    }
}

