/*
 * Decompiled with CFR 0.152.
 */
package hec.clientapp.rmi.admin;

import hec.clientapp.rmi.admin.WatershedLocationDialog;
import hec.clientapp.rmi.admin.WorkspaceInfoJDialog;
import hec.clientapp.rmi.csinterface.RmiApp;
import hec.clientapp.rmi.csinterface.RmiWorkspace;
import hec.clientapp.script.ScriptJobStatusJFrame;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.admin.InfoJDialog;
import mil.army.usace.hec.rmi.csinterface.RMIScheduler;
import rma.swing.RmaInsets;
import rma.swing.RmaJTable;

public class RmiAppInfoJDialog
extends InfoJDialog {
    private RmaJTable wkspTable;
    private RmiApp _ra;
    private JLabel totalWksp;
    private JLabel startTime;
    private JButton moreInfoButton;
    private JButton schedulerInfoButton;
    private JButton locationsButton;
    private List wkspList = new ArrayList();
    private int _total;

    public RmiAppInfoJDialog(Frame parent) {
        super(parent);
    }

    protected void buildControls() {
        super.buildControls();
        this.setTitle("Application Server Information");
        Insets insets5555 = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
        JLabel label = new JLabel("Start Time:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets5555;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.startTime = new JLabel("Unknown");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets5555;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.startTime, gbc);
        Object[] headers = new String[]{"Watershed Name", "Description"};
        this.wkspTable = new RmaJTable((Component)((Object)this), headers){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension d = super.getPreferredScrollableViewportSize();
                d.height = 100;
                return d;
            }
        };
        this.wkspTable.setEnabled(false);
        this.wkspTable.setCellSelectionEnabled(false);
        this.wkspTable.setRowSelectionAllowed(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 2.0;
        gbc.weighty = 2.0;
        gbc.insets = insets5555;
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.wkspTable.getScrollPane(), gbc);
        label = new JLabel("Total Watersheds: ");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.insets = insets5555;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.getContentPane().add((Component)label, gbc);
        this.totalWksp = new JLabel("");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.insets = insets5555;
        gbc.anchor = 10;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.totalWksp, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = insets5555;
        gbc.anchor = 10;
        gbc.fill = 2;
        this.getContentPane().add((Component)buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets5555;
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)this.okButton, gbc);
        this.schedulerInfoButton = new JButton("Scheduler Status");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = insets5555;
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)this.schedulerInfoButton, gbc);
        this.moreInfoButton = new JButton("More Info");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = insets5555;
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)this.moreInfoButton, gbc);
        this.locationsButton = new JButton("Watershed Locations");
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.insets = insets5555;
        gbc.anchor = 10;
        gbc.fill = 0;
        buttonPanel.add((Component)this.locationsButton, gbc);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiAppInfoJDialog.this.setVisible(false);
                RmiAppInfoJDialog.this.dispose();
            }
        });
        this.moreInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiAppInfoJDialog.this.moreInfo();
            }
        });
        this.schedulerInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiAppInfoJDialog.this.schedulerStatus();
            }
        });
        this.locationsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RmiAppInfoJDialog.this.locations();
            }
        });
        this.wkspTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    RmiAppInfoJDialog.this.moreInfo();
                }
            }
        });
        ((JPanel)this.getContentPane()).registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RmiAppInfoJDialog.this.reload();
                    }
                });
            }
        }, KeyStroke.getKeyStroke(116, 0, true), 1);
    }

    public void setRmiApp(RmiApp ra) {
        this._ra = ra;
    }

    private void locations() {
        if (this._ra == null) {
            System.out.println("locations: no RmiApp");
            return;
        }
        WatershedLocationDialog dialog = new WatershedLocationDialog((Dialog)((Object)this), true);
        dialog.fillForm(this._ra);
        dialog.setVisible(true);
    }

    private void moreInfo() {
        int[] rows = this.wkspTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            Object obj;
            String wkspName = (String)this.wkspTable.getCell(rows[i], 0);
            if (wkspName == null || wkspName.trim().equals("") || !((obj = this.wkspList.get(rows[i])) instanceof RmiWorkspace)) continue;
            RmiWorkspace wksp = (RmiWorkspace)obj;
            System.out.println("more info for " + wkspName);
            this.moreInfo(wksp);
        }
    }

    protected void moreInfo(RmiWorkspace wksp) {
        WorkspaceInfoJDialog wid = new WorkspaceInfoJDialog((Frame)this.getParent());
        wid.setWorkspace(wksp);
        wid.setVisible(true);
    }

    public void setStartTime(String sTime) {
        this.startTime.setText(sTime);
    }

    public void setWkspList(Vector list) {
        final Vector table = new Vector();
        this._total = 0;
        this.wkspList.clear();
        for (int i = 0; i < list.size(); ++i) {
            Vector<String> row = new Vector<String>();
            Object obj = list.elementAt(i);
            if (!(obj instanceof RmiWorkspace)) continue;
            RmiWorkspace wksp = (RmiWorkspace)obj;
            try {
                row.add(wksp.getTitleName());
                row.add(wksp.getDescription());
                this.wkspList.add(wksp);
                table.addElement(row);
                ++this._total;
                continue;
            }
            catch (RemoteException re) {
                System.out.println("error getting wksp name for " + obj + " error " + re);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RmiAppInfoJDialog.this.wkspTable.deleteCells();
                RmiAppInfoJDialog.this.wkspTable.setCells(table);
                RmiAppInfoJDialog.this.totalWksp.setText("" + RmiAppInfoJDialog.this._total);
                if (RmiAppInfoJDialog.this._total == 0) {
                    RmiAppInfoJDialog.this.moreInfoButton.setEnabled(false);
                } else {
                    RmiAppInfoJDialog.this.moreInfoButton.setEnabled(true);
                }
                RmiAppInfoJDialog.this.wkspTable.removeLastRow();
            }
        });
    }

    public void schedulerStatus() {
        if (this._ra == null) {
            return;
        }
        RMIScheduler scheduler = null;
        try {
            scheduler = this._ra.getScheduler();
        }
        catch (RemoteException re) {
            System.out.println("schedulerStatus: RMI error getting RMIScheduler from RMIApp " + re);
            return;
        }
        if (scheduler == null) {
            System.out.println("schedulerStatus: failed to get scheduler from RMIApp");
            return;
        }
        ScriptJobStatusJFrame statusFrame = new ScriptJobStatusJFrame();
        statusFrame.setRMIScheduler(scheduler);
        statusFrame.fillForm();
        statusFrame.setVisible(true);
    }

    protected void reload() {
        if (this._ra == null) {
            return;
        }
        try {
            Vector v = this._ra.getWorkspaceList();
            this.setWkspList(v);
        }
        catch (RemoteException re) {
            System.out.println("reload: RMI Error with Server " + re);
        }
    }
}

